/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;

public class HttpMessageConverterExtractor<T>
implements ResponseExtractor<T> {
    private static final String TAG = "RestTemplate";
    private final Type responseType;
    private final Class<T> responseClass;
    private final List<HttpMessageConverter<?>> messageConverters;

    public HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters) {
        this((Type)responseType, messageConverters);
    }

    public HttpMessageConverterExtractor(Type responseType, List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull((Object)responseType, (String)"'responseType' must not be null");
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.responseType = responseType;
        this.responseClass = responseType instanceof Class ? (Class)responseType : null;
        this.messageConverters = messageConverters;
    }

    @Override
    public T extractData(ClientHttpResponse response) throws IOException {
        if (!this.hasMessageBody(response)) {
            return null;
        }
        MediaType contentType = this.getContentType(response);
        for (HttpMessageConverter<T> httpMessageConverter : this.messageConverters) {
            GenericHttpMessageConverter genericMessageConverter;
            if (httpMessageConverter instanceof GenericHttpMessageConverter && (genericMessageConverter = (GenericHttpMessageConverter)httpMessageConverter).canRead(this.responseType, null, contentType)) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Reading [" + this.responseType + "] as \"" + contentType + "\" using [" + httpMessageConverter + "]"));
                }
                return genericMessageConverter.read(this.responseType, null, response);
            }
            if (this.responseClass == null || !httpMessageConverter.canRead(this.responseClass, contentType)) continue;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Reading [" + this.responseClass.getName() + "] as \"" + contentType + "\" using [" + httpMessageConverter + "]"));
            }
            return (T)httpMessageConverter.read(this.responseClass, response);
        }
        throw new RestClientException("Could not extract response: no suitable HttpMessageConverter found for response type [" + this.responseType + "] and content type [" + contentType + "]");
    }

    private MediaType getContentType(ClientHttpResponse response) {
        MediaType contentType = response.getHeaders().getContentType();
        if (contentType == null) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"No Content-Type header found, defaulting to application/octet-stream");
            }
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return contentType;
    }

    protected boolean hasMessageBody(ClientHttpResponse response) throws IOException {
        HttpStatus responseStatus = response.getStatusCode();
        if (responseStatus == HttpStatus.NO_CONTENT || responseStatus == HttpStatus.NOT_MODIFIED) {
            return false;
        }
        long contentLength = response.getHeaders().getContentLength();
        return contentLength != 0L;
    }
}

