/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class OidcBackChannelLogoutWebFilter
implements WebFilter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ServerAuthenticationConverter authenticationConverter;
    private final ReactiveAuthenticationManager authenticationManager;
    private final ServerLogoutHandler logoutHandler;

    OidcBackChannelLogoutWebFilter(ServerAuthenticationConverter authenticationConverter, ReactiveAuthenticationManager authenticationManager, ServerLogoutHandler logoutHandler) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
        this.authenticationConverter = authenticationConverter;
        this.authenticationManager = authenticationManager;
        this.logoutHandler = logoutHandler;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.authenticationConverter.convert(exchange).onErrorResume(AuthenticationException.class, ex -> {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
            if (ex instanceof AuthenticationServiceException) {
                return Mono.error((Throwable)ex);
            }
            return this.handleAuthenticationFailure(exchange.getResponse(), (Exception)((Object)ex)).then(Mono.empty());
        }).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(arg_0 -> ((ReactiveAuthenticationManager)this.authenticationManager).authenticate(arg_0)).onErrorResume(AuthenticationException.class, ex -> {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
            if (ex instanceof AuthenticationServiceException) {
                return Mono.error((Throwable)ex);
            }
            return this.handleAuthenticationFailure(exchange.getResponse(), (Exception)((Object)ex)).then(Mono.empty());
        }).flatMap(authentication -> {
            WebFilterExchange webFilterExchange = new WebFilterExchange(exchange, chain);
            return this.logoutHandler.logout(webFilterExchange, authentication);
        });
    }

    private Mono<Void> handleAuthenticationFailure(ServerHttpResponse response, Exception ex) {
        this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
        response.setRawStatusCode(Integer.valueOf(400));
        OAuth2Error error = this.oauth2Error(ex);
        byte[] bytes = String.format("{\n\t\"error_code\": \"%s\",\n\t\"error_description\": \"%s\",\n\t\"error_uri: \"%s\"\n}\n", error.getErrorCode(), error.getDescription(), error.getUri()).getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = response.bufferFactory().wrap(bytes);
        return response.writeWith((Publisher)Flux.just((Object)buffer));
    }

    private OAuth2Error oauth2Error(Exception ex) {
        if (ex instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oauth2 = (OAuth2AuthenticationException)((Object)ex);
            return oauth2.getError();
        }
        return new OAuth2Error("invalid_request", ex.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }
}

