/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.RequestMatcherClientHttpRequest;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.support.RestGatewaySupport;

public class MockRestServiceServer {
    private final List<RequestMatcherClientHttpRequest> expectedRequests = new LinkedList<RequestMatcherClientHttpRequest>();
    private final List<RequestMatcherClientHttpRequest> actualRequests = new LinkedList<RequestMatcherClientHttpRequest>();

    private MockRestServiceServer() {
    }

    public static MockRestServiceServer createServer(RestTemplate restTemplate) {
        MockRestServiceServer mockServer;
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' must not be null");
        MockRestServiceServer mockRestServiceServer = mockServer = new MockRestServiceServer();
        mockRestServiceServer.getClass();
        RequestMatcherClientHttpRequestFactory factory = mockRestServiceServer.new RequestMatcherClientHttpRequestFactory();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        return mockServer;
    }

    public static MockRestServiceServer createServer(RestGatewaySupport restGateway) {
        Assert.notNull((Object)restGateway, (String)"'gatewaySupport' must not be null");
        return MockRestServiceServer.createServer(restGateway.getRestTemplate());
    }

    public ResponseActions expect(RequestMatcher requestMatcher) {
        Assert.state((boolean)this.actualRequests.isEmpty(), (String)"Can't add more expected requests with test already underway");
        RequestMatcherClientHttpRequest request = new RequestMatcherClientHttpRequest(requestMatcher);
        this.expectedRequests.add(request);
        return request;
    }

    public void verify() {
        if (this.expectedRequests.isEmpty() || this.expectedRequests.equals(this.actualRequests)) {
            return;
        }
        throw new AssertionError((Object)this.getVerifyMessage());
    }

    private String getVerifyMessage() {
        StringBuilder sb = new StringBuilder("Further request(s) expected\n");
        if (this.actualRequests.size() > 0) {
            sb.append("The following ");
        }
        sb.append(this.actualRequests.size()).append(" out of ");
        sb.append(this.expectedRequests.size()).append(" were executed");
        if (this.actualRequests.size() > 0) {
            sb.append(":\n");
            for (RequestMatcherClientHttpRequest request : this.actualRequests) {
                sb.append(request.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    private class RequestMatcherClientHttpRequestFactory
    implements ClientHttpRequestFactory {
        private Iterator<RequestMatcherClientHttpRequest> requestIterator;

        private RequestMatcherClientHttpRequestFactory() {
        }

        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
            Assert.notNull((Object)uri, (String)"'uri' must not be null");
            Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
            if (this.requestIterator == null) {
                this.requestIterator = MockRestServiceServer.this.expectedRequests.iterator();
            }
            if (!this.requestIterator.hasNext()) {
                throw new AssertionError((Object)("No further requests expected: HTTP " + httpMethod + " " + uri));
            }
            RequestMatcherClientHttpRequest request = this.requestIterator.next();
            request.setURI(uri);
            request.setMethod(httpMethod);
            MockRestServiceServer.this.actualRequests.add(request);
            return request;
        }
    }
}

