/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.ContextCacheUtils;
import org.springframework.util.Assert;

public class DefaultContextCache
implements ContextCache {
    private static final Log statsLogger = LogFactory.getLog((String)"org.springframework.test.context.cache");
    private final Map<MergedContextConfiguration, ApplicationContext> contextMap = Collections.synchronizedMap(new LinkedHashMap(32, 0.75f, true));
    private final Map<MergedContextConfiguration, Set<MergedContextConfiguration>> hierarchyMap = new ConcurrentHashMap<MergedContextConfiguration, Set<MergedContextConfiguration>>(32);
    private final Map<MergedContextConfiguration, Set<Class<?>>> contextUsageMap = new ConcurrentHashMap(32);
    private final Map<MergedContextConfiguration, Integer> failureCounts = new ConcurrentHashMap<MergedContextConfiguration, Integer>(32);
    private final AtomicInteger totalFailureCount = new AtomicInteger();
    private final int maxSize;
    private final AtomicInteger hitCount = new AtomicInteger();
    private final AtomicInteger missCount = new AtomicInteger();

    public DefaultContextCache() {
        this(ContextCacheUtils.retrieveMaxCacheSize());
    }

    public DefaultContextCache(int maxSize) {
        Assert.isTrue((maxSize > 0 ? 1 : 0) != 0, (String)"'maxSize' must be positive");
        this.maxSize = maxSize;
    }

    @Override
    public boolean contains(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.contextMap.containsKey(key);
    }

    @Override
    public @Nullable ApplicationContext get(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        ApplicationContext context = this.contextMap.get(key);
        if (context == null) {
            this.missCount.incrementAndGet();
        } else {
            this.hitCount.incrementAndGet();
            this.restartContextIfNecessary(context);
        }
        return context;
    }

    private void restartContextIfNecessary(ApplicationContext context) {
        ConfigurableApplicationContext cac;
        ApplicationContext parent = context.getParent();
        if (parent != null) {
            this.restartContextIfNecessary(parent);
        }
        if (context instanceof ConfigurableApplicationContext && !(cac = (ConfigurableApplicationContext)context).isRunning()) {
            cac.restart();
        }
    }

    @Override
    @Deprecated(since="7.0")
    public void put(MergedContextConfiguration key, ApplicationContext context) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.evictLruContextIfNecessary();
        this.putInternal(key, context);
    }

    @Override
    public ApplicationContext put(MergedContextConfiguration key, ContextCache.LoadFunction loadFunction) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)loadFunction, (String)"LoadFunction must not be null");
        this.evictLruContextIfNecessary();
        ApplicationContext context = loadFunction.loadContext(key);
        Assert.state((context != null ? 1 : 0) != 0, (String)"LoadFunction must return a non-null ApplicationContext");
        this.putInternal(key, context);
        return context;
    }

    private void evictLruContextIfNecessary() {
        if (this.contextMap.size() >= this.maxSize) {
            Iterator<MergedContextConfiguration> iterator = this.contextMap.keySet().iterator();
            Assert.state((boolean)iterator.hasNext(), (String)"Failed to retrieve LRU context");
            MergedContextConfiguration lruKey = iterator.next();
            this.remove(lruKey, DirtiesContext.HierarchyMode.CURRENT_LEVEL);
        }
    }

    private void putInternal(MergedContextConfiguration key, ApplicationContext context) {
        this.contextMap.put(key, context);
        MergedContextConfiguration child = key;
        MergedContextConfiguration parent = child.getParent();
        while (parent != null) {
            Set list = this.hierarchyMap.computeIfAbsent(parent, k -> new HashSet());
            list.add(child);
            child = parent;
            parent = child.getParent();
        }
    }

    @Override
    public void registerContextUsage(MergedContextConfiguration mergedConfig, Class<?> testClass) {
        MergedContextConfiguration parent = mergedConfig.getParent();
        if (parent != null) {
            this.registerContextUsage(parent, testClass);
        }
        this.getActiveTestClasses(mergedConfig).add(testClass);
    }

    @Override
    public void unregisterContextUsage(MergedContextConfiguration mergedConfig, Class<?> testClass) {
        MergedContextConfiguration parent;
        ApplicationContext context = this.contextMap.get(mergedConfig);
        Assert.state((context != null ? 1 : 0) != 0, (String)("ApplicationContext must not be null for: " + String.valueOf(mergedConfig)));
        Set<Class<?>> activeTestClasses = this.getActiveTestClasses(mergedConfig);
        activeTestClasses.remove(testClass);
        if (activeTestClasses.isEmpty()) {
            ConfigurableApplicationContext cac;
            if (context instanceof ConfigurableApplicationContext && (cac = (ConfigurableApplicationContext)context).isRunning()) {
                cac.pause();
            }
            this.contextUsageMap.remove(mergedConfig);
        }
        if ((parent = mergedConfig.getParent()) != null) {
            this.unregisterContextUsage(parent, testClass);
        }
    }

    private Set<Class<?>> getActiveTestClasses(MergedContextConfiguration mergedConfig) {
        return this.contextUsageMap.computeIfAbsent(mergedConfig, mcc -> new HashSet());
    }

    @Override
    public void remove(MergedContextConfiguration key, @Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        MergedContextConfiguration startKey = key;
        if (hierarchyMode == DirtiesContext.HierarchyMode.EXHAUSTIVE) {
            MergedContextConfiguration parent = startKey.getParent();
            while (parent != null) {
                startKey = parent;
                parent = startKey.getParent();
            }
        }
        ArrayList<MergedContextConfiguration> removedContexts = new ArrayList<MergedContextConfiguration>();
        this.remove(removedContexts, startKey);
        for (MergedContextConfiguration mergedContextConfiguration : removedContexts) {
            for (Set<MergedContextConfiguration> children : this.hierarchyMap.values()) {
                children.remove(mergedContextConfiguration);
            }
        }
        for (Map.Entry entry : this.hierarchyMap.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            this.hierarchyMap.remove(entry.getKey());
        }
    }

    private void remove(List<MergedContextConfiguration> removedContexts, MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Set<MergedContextConfiguration> children = this.hierarchyMap.get(key);
        if (children != null) {
            for (MergedContextConfiguration child : children) {
                this.remove(removedContexts, child);
            }
            this.hierarchyMap.remove(key);
        }
        ApplicationContext context = this.contextMap.remove(key);
        this.contextUsageMap.remove(key);
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)context;
            cac.close();
        }
        removedContexts.add(key);
    }

    @Override
    public int getFailureCount(MergedContextConfiguration key) {
        return this.failureCounts.getOrDefault(key, 0);
    }

    @Override
    public void incrementFailureCount(MergedContextConfiguration key) {
        this.totalFailureCount.incrementAndGet();
        this.failureCounts.merge(key, 1, Integer::sum);
    }

    @Override
    public int size() {
        return this.contextMap.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getContextUsageCount() {
        return this.contextUsageMap.size();
    }

    @Override
    public int getParentContextCount() {
        return this.hierarchyMap.size();
    }

    @Override
    public int getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public int getMissCount() {
        return this.missCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.clear();
            this.clearStatistics();
            this.totalFailureCount.set(0);
            this.failureCounts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.contextMap.clear();
            this.hierarchyMap.clear();
            this.contextUsageMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStatistics() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.hitCount.set(0);
            this.missCount.set(0);
        }
    }

    @Override
    public void logStatistics() {
        if (statsLogger.isDebugEnabled()) {
            statsLogger.debug((Object)("Spring test ApplicationContext cache statistics: " + String.valueOf(this)));
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("size", this.size()).append("maxSize", this.getMaxSize()).append("contextUsageCount", this.getContextUsageCount()).append("parentContextCount", this.getParentContextCount()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).append("failureCount", (Object)this.totalFailureCount).toString();
    }
}

