/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.WebUtils;

public class ServletForwardingController
extends AbstractController
implements BeanNameAware {
    private @Nullable String servletName;
    private @Nullable String beanName;

    public ServletForwardingController() {
        super(false);
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
        if (this.servletName == null) {
            this.servletName = name;
        }
    }

    @Override
    protected @Nullable ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext();
        Assert.state((servletContext != null ? 1 : 0) != 0, (String)"No ServletContext");
        RequestDispatcher rd = servletContext.getNamedDispatcher(this.servletName);
        if (rd == null) {
            throw new ServletException("No servlet with name '" + this.servletName + "' defined in web.xml");
        }
        if (this.useInclude(request, response)) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Included servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Forwarded to servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        }
        return null;
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }
}

