/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class HasGenericEntityWithValueMatcher<T>
extends TypeSafeDiagnosingMatcher<Response> {
    private final GenericType<T> entityType;
    private final Matcher<? super T> entityMatcher;

    public HasGenericEntityWithValueMatcher(GenericType<T> genericType, Matcher matcher) {
        this.entityType = genericType;
        this.entityMatcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("has Entity ").appendDescriptionOf(this.entityMatcher);
    }

    protected boolean matchesSafely(Response response, Description description) {
        response.bufferEntity();
        Object object = response.readEntity(this.entityType);
        if (!this.entityMatcher.matches(object)) {
            description.appendText("Entity ");
            this.entityMatcher.describeMismatch(object, description);
            return false;
        }
        return true;
    }
}

