/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class HasHeaderWithValuesMatcher
extends TypeSafeDiagnosingMatcher<Response> {
    private final String headerName;
    private final Matcher<? extends Iterable<?>> valuesMatcher;

    public HasHeaderWithValuesMatcher(String string, Matcher<? extends Iterable<?>> matcher) {
        this.headerName = string;
        this.valuesMatcher = matcher;
    }

    protected boolean matchesSafely(Response response, Description description) {
        MultivaluedMap multivaluedMap = response.getHeaders();
        if (multivaluedMap.containsKey((Object)this.headerName)) {
            List list = (List)multivaluedMap.get((Object)this.headerName);
            if (!this.valuesMatcher.matches((Object)list)) {
                description.appendText("header ").appendValue((Object)this.headerName).appendText(" was ").appendValueList("", ",", "", (Iterable)list);
                return false;
            }
            return true;
        }
        description.appendText("header ").appendValue((Object)this.headerName).appendText(" was missing");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("has header ").appendValue((Object)this.headerName).appendText(" with ").appendDescriptionOf(this.valuesMatcher);
    }
}

