/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.wicket.util.parse.metapattern.Group;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.resource.urlsegments.ParamSegment;
import org.wicketstuff.rest.resource.urlsegments.visitor.ISegmentVisitor;

public class MultiParamSegment
extends AbstractURLSegment {
    private static final long serialVersionUID = 1L;
    private volatile List<AbstractURLSegment> subSegments;

    MultiParamSegment(String text) {
        super(text);
    }

    private List<AbstractURLSegment> loadSubSegments(String text) {
        Matcher matcher = SEGMENT_PARAMETER.matcher((CharSequence)text);
        ArrayList<AbstractURLSegment> subSegments = new ArrayList<AbstractURLSegment>();
        int fixedTextIndex = 0;
        while (matcher.find()) {
            String group = matcher.group();
            AbstractURLSegment segment = AbstractURLSegment.newSegment(group);
            String fixedText = text.substring(fixedTextIndex, matcher.start());
            fixedTextIndex = matcher.end();
            if (!fixedText.isEmpty()) {
                subSegments.add(AbstractURLSegment.newSegment(fixedText));
            }
            subSegments.add(segment);
        }
        if (fixedTextIndex < text.length()) {
            String fixedText = text.substring(fixedTextIndex, text.length());
            subSegments.add(AbstractURLSegment.newSegment(fixedText));
        }
        return subSegments;
    }

    @Override
    protected MetaPattern loadMetaPattern() {
        ArrayList<MetaPattern> patterns = new ArrayList<MetaPattern>();
        this.subSegments = Collections.unmodifiableList(this.loadSubSegments(this.toString()));
        for (AbstractURLSegment segment : this.subSegments) {
            patterns.add(segment.getMetaPattern());
        }
        return new MetaPattern(patterns);
    }

    public MetaPattern getMetaPatternWithGroups() {
        ArrayList<MetaPattern> patterns = new ArrayList<MetaPattern>();
        for (AbstractURLSegment segment : this.subSegments) {
            MetaPattern metaPattern = segment.getMetaPattern();
            if (segment instanceof ParamSegment) {
                metaPattern = new Group(metaPattern);
            }
            patterns.add(metaPattern);
        }
        return new MetaPattern(patterns);
    }

    public List<AbstractURLSegment> getSubSegments() {
        return this.subSegments;
    }

    @Override
    public void accept(ISegmentVisitor visitor) {
        visitor.visit(this);
    }
}

