/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.contenthandling.webserialdeserial;

import java.io.IOException;
import javax.servlet.ServletResponse;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.wicketstuff.rest.contenthandling.IObjectSerialDeserial;
import org.wicketstuff.rest.contenthandling.IWebSerialDeserial;
import org.wicketstuff.restutils.http.HttpUtils;

public class TextualWebSerialDeserial
implements IWebSerialDeserial {
    private final String charset;
    private final String mimeType;
    private final IObjectSerialDeserial<String> objectSerialDeserial;

    public TextualWebSerialDeserial(String charset, String mimeType, IObjectSerialDeserial<String> objectSerialDeserial) {
        this.charset = charset;
        this.mimeType = mimeType;
        this.objectSerialDeserial = objectSerialDeserial;
    }

    @Override
    public void objectToResponse(Object targetObject, WebResponse response, String mimeType) throws WicketRuntimeException {
        this.setCharsetResponse(response);
        String strOutput = "text/plain".equals(mimeType) ? (targetObject == null ? "" : targetObject.toString()) : this.objectSerialDeserial.serializeObject(targetObject, mimeType);
        response.write((CharSequence)strOutput);
    }

    @Override
    public <T> T requestToObject(WebRequest request, Class<T> argClass, String mimeType) throws WicketRuntimeException {
        try {
            return this.objectSerialDeserial.deserializeObject(HttpUtils.readStringFromRequest((WebRequest)request), argClass, mimeType);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("An error occurred during request reading.", (Throwable)e);
        }
    }

    @Override
    public final boolean isMimeTypeSupported(String mimeType) {
        return "text/plain".equals(mimeType) || this.mimeType.equals(mimeType);
    }

    private void setCharsetResponse(WebResponse response) {
        if (response.getContainerResponse() instanceof ServletResponse) {
            ServletResponse sResponse = (ServletResponse)response.getContainerResponse();
            sResponse.setCharacterEncoding(this.charset);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public IObjectSerialDeserial<String> getObjectSerialDeserial() {
        return this.objectSerialDeserial;
    }
}

