/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.reflection;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.rest.annotations.parameters.CookieParam;
import org.wicketstuff.rest.annotations.parameters.HeaderParam;
import org.wicketstuff.rest.annotations.parameters.MatrixParam;
import org.wicketstuff.rest.annotations.parameters.PathParam;
import org.wicketstuff.rest.annotations.parameters.RequestBody;
import org.wicketstuff.rest.annotations.parameters.RequestParam;
import org.wicketstuff.rest.annotations.parameters.ValidatorKey;
import org.wicketstuff.rest.contenthandling.IWebSerialDeserial;
import org.wicketstuff.rest.resource.AbstractRestResource;
import org.wicketstuff.rest.resource.MethodMappingInfo;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.utils.reflection.ReflectionUtils;
import org.wicketstuff.rest.utils.wicket.MethodParameterContext;

public class MethodParameter<T> {
    private final Class<? extends T> parameterClass;
    private final MethodMappingInfo ownerMethod;
    private final int paramIndex;
    private final boolean required;
    private final String deaultValue;
    private final String valdatorKey;
    private final Annotation annotationParam;
    private final Supplier<Locale> supplier;

    public MethodParameter(Class<? extends T> type, MethodMappingInfo ownerMethod, int paramIndex, Supplier<Locale> supplier) {
        Args.notNull(type, (String)"type");
        Args.notNull((Object)ownerMethod, (String)"ownerMethod");
        Args.notNull(supplier, (String)"supplier");
        this.parameterClass = type;
        this.ownerMethod = ownerMethod;
        this.paramIndex = paramIndex;
        this.supplier = supplier;
        this.annotationParam = ReflectionUtils.getAnnotationParam(paramIndex, ownerMethod.getMethod());
        this.required = ReflectionUtils.getAnnotationField(this.annotationParam, "required", true);
        this.deaultValue = ReflectionUtils.getAnnotationField(this.annotationParam, "defaultValue", "");
        ValidatorKey validatorAnnotation = ReflectionUtils.findMethodParameterAnnotation(ownerMethod.getMethod(), paramIndex, ValidatorKey.class);
        this.valdatorKey = ReflectionUtils.getAnnotationField(validatorAnnotation, "value", "");
    }

    public Object extractParameterValue(MethodParameterContext context) {
        Object paramValue = null;
        paramValue = this.annotationParam == null ? this.extractParameterFromUrl(context) : this.extractParameterFromAnnotation(context);
        if (paramValue == null && !this.deaultValue.isEmpty()) {
            paramValue = AbstractRestResource.toObject(this.parameterClass, this.deaultValue, this.supplier);
        }
        return paramValue;
    }

    private Object extractParameterFromUrl(MethodParameterContext context) {
        Map<String, String> parameters = context.getPathParameters();
        Iterator<String> paramIterator = parameters.values().iterator();
        List<MethodParameter<?>> methodParameters = this.ownerMethod.getMethodParameters();
        for (int i = 0; i < this.paramIndex; ++i) {
            MethodParameter<?> parameter = methodParameters.get(i);
            if (parameter.getAnnotationParam() != null) continue;
            paramIterator.next();
        }
        if (paramIterator.hasNext()) {
            return AbstractRestResource.toObject(this.parameterClass, paramIterator.next(), this.supplier);
        }
        return null;
    }

    private Object extractParameterFromAnnotation(MethodParameterContext context) {
        Object paramValue = null;
        String mimeInputFormat = this.ownerMethod.getInputFormat();
        PageParameters pageParameters = context.getAttributesWrapper().getPageParameters();
        if (this.annotationParam instanceof RequestBody) {
            paramValue = this.deserializeObjectFromRequest(mimeInputFormat, context.getSerialDeserial());
        } else if (this.annotationParam instanceof PathParam) {
            paramValue = AbstractRestResource.toObject(this.parameterClass, context.getPathParameters().get(((PathParam)this.annotationParam).value()), this.supplier);
        } else if (this.annotationParam instanceof RequestParam) {
            paramValue = this.extractParameterFromQuery(pageParameters, (RequestParam)this.annotationParam);
        } else if (this.annotationParam instanceof HeaderParam) {
            paramValue = this.extractParameterFromHeader((HeaderParam)this.annotationParam);
        } else if (this.annotationParam instanceof CookieParam) {
            paramValue = this.extractParameterFromCookies((CookieParam)this.annotationParam);
        } else if (this.annotationParam instanceof MatrixParam) {
            paramValue = this.extractParameterFromMatrixParams(pageParameters, (MatrixParam)this.annotationParam);
        }
        return paramValue;
    }

    private Object extractParameterFromMatrixParams(PageParameters pageParameters, MatrixParam matrixParam) {
        int segmentIndex = matrixParam.segmentIndex();
        String variableName = matrixParam.parameterName();
        String rawsSegment = pageParameters.get(segmentIndex).toString();
        Map<String, String> matrixParameters = AbstractURLSegment.getSegmentMatrixParameters(rawsSegment);
        if (matrixParameters.get(variableName) == null) {
            return null;
        }
        return AbstractRestResource.toObject(this.parameterClass, matrixParameters.get(variableName), this.supplier);
    }

    private Object extractParameterFromHeader(HeaderParam headerParam) {
        String value = headerParam.value();
        WebRequest webRequest = AbstractRestResource.getCurrentWebRequest();
        return AbstractRestResource.toObject(this.parameterClass, webRequest.getHeader(value), this.supplier);
    }

    private Object extractParameterFromQuery(PageParameters pageParameters, RequestParam requestParam) {
        String value = requestParam.value();
        if (pageParameters.get(value) == null) {
            return null;
        }
        return AbstractRestResource.toObject(this.parameterClass, pageParameters.get(value).toString(), this.supplier);
    }

    private Object extractParameterFromCookies(CookieParam cookieParam) {
        String value = cookieParam.value();
        WebRequest webRequest = AbstractRestResource.getCurrentWebRequest();
        if (webRequest.getCookie(value) == null) {
            return null;
        }
        return AbstractRestResource.toObject(this.parameterClass, webRequest.getCookie(value).getValue(), this.supplier);
    }

    private Object deserializeObjectFromRequest(String mimeInputFormat, IWebSerialDeserial serialDeserial) {
        WebRequest servletRequest = AbstractRestResource.getCurrentWebRequest();
        return serialDeserial.requestToObject(servletRequest, this.parameterClass, mimeInputFormat);
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public MethodMappingInfo getOwnerMethod() {
        return this.ownerMethod;
    }

    public int getParamIndex() {
        return this.paramIndex;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDeaultValue() {
        return this.deaultValue;
    }

    public String getValdatorKey() {
        return this.valdatorKey;
    }

    public Annotation getAnnotationParam() {
        return this.annotationParam;
    }
}

