/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.wicket.bundle;

import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;

public class StringConverterInterpolator
extends MapVariableInterpolator {
    private static final long serialVersionUID = 1L;
    private final Locale locale;

    public StringConverterInterpolator(String string, Map<?, ?> variables, boolean exceptionOnNullVarValue, Locale locale) {
        super(string, variables, exceptionOnNullVarValue);
        this.locale = locale;
    }

    protected String getValue(String variableName) {
        String value = super.getValue(variableName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        IConverter<?> converter = this.getConverter(value.getClass());
        if (converter == null) {
            return Strings.toString((Object)value);
        }
        return converter.convertToString((Object)value, this.getLocale());
    }

    private IConverter<?> getConverter(Class<? extends Object> clazz) {
        return Application.get().getConverterLocator().getConverter(clazz);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

