/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Map;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;

public class Client
extends Connection {
    private boolean isInMulti;

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public Client(String host) {
        super(host);
    }

    public Client(String host, int port) {
        super(host, port);
    }

    public void ping() {
        this.sendCommand("PING", new String[0]);
    }

    public void set(String key, String value) {
        this.sendCommand("SET", key, value);
    }

    public void get(String key) {
        this.sendCommand("GET", key);
    }

    public void quit() {
        this.sendCommand("QUIT", new String[0]);
    }

    public void exists(String key) {
        this.sendCommand("EXISTS", key);
    }

    public void del(String ... keys) {
        this.sendCommand("DEL", keys);
    }

    public void type(String key) {
        this.sendCommand("TYPE", key);
    }

    public void flushDB() {
        this.sendCommand("FLUSHDB", new String[0]);
    }

    public void keys(String pattern) {
        this.sendCommand("KEYS", pattern);
    }

    public void randomKey() {
        this.sendCommand("RANDOMKEY", new String[0]);
    }

    public void rename(String oldkey, String newkey) {
        this.sendCommand("RENAME", oldkey, newkey);
    }

    public void renamenx(String oldkey, String newkey) {
        this.sendCommand("RENAMENX", oldkey, newkey);
    }

    public void dbSize() {
        this.sendCommand("DBSIZE", new String[0]);
    }

    public void expire(String key, int seconds) {
        this.sendCommand("EXPIRE", key, String.valueOf(seconds));
    }

    public void expireAt(String key, long unixTime) {
        this.sendCommand("EXPIREAT", key, String.valueOf(unixTime));
    }

    public void ttl(String key) {
        this.sendCommand("TTL", key);
    }

    public void select(int index) {
        this.sendCommand("SELECT", String.valueOf(index));
    }

    public void move(String key, int dbIndex) {
        this.sendCommand("MOVE", key, String.valueOf(dbIndex));
    }

    public void flushAll() {
        this.sendCommand("FLUSHALL", new String[0]);
    }

    public void getSet(String key, String value) {
        this.sendCommand("GETSET", key, value);
    }

    public void mget(String ... keys) {
        this.sendCommand("MGET", keys);
    }

    public void setnx(String key, String value) {
        this.sendCommand("SETNX", key, value);
    }

    public void setex(String key, int seconds, String value) {
        this.sendCommand("SETEX", key, String.valueOf(seconds), value);
    }

    public void mset(String ... keysvalues) {
        this.sendCommand("MSET", keysvalues);
    }

    public void msetnx(String ... keysvalues) {
        this.sendCommand("MSETNX", keysvalues);
    }

    public void decrBy(String key, int integer) {
        this.sendCommand("DECRBY", key, String.valueOf(integer));
    }

    public void decr(String key) {
        this.sendCommand("DECR", key);
    }

    public void incrBy(String key, int integer) {
        this.sendCommand("INCRBY", key, String.valueOf(integer));
    }

    public void incr(String key) {
        this.sendCommand("INCR", key);
    }

    public void append(String key, String value) {
        this.sendCommand("APPEND", key, value);
    }

    public void substr(String key, int start, int end) {
        this.sendCommand("SUBSTR", key, String.valueOf(start), String.valueOf(end));
    }

    public void hset(String key, String field, String value) {
        this.sendCommand("HSET", key, field, value);
    }

    public void hget(String key, String field) {
        this.sendCommand("HGET", key, field);
    }

    public void hsetnx(String key, String field, String value) {
        this.sendCommand("HSETNX", key, field, value);
    }

    public void hmset(String key, Map<String, String> hash) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(key);
        for (String field : hash.keySet()) {
            params.add(field);
            params.add(hash.get(field));
        }
        this.sendCommand("HMSET", params.toArray(new String[params.size()]));
    }

    public void hmget(String key, String ... fields) {
        String[] params = new String[fields.length + 1];
        params[0] = key;
        System.arraycopy(fields, 0, params, 1, fields.length);
        this.sendCommand("HMGET", params);
    }

    public void hincrBy(String key, String field, int value) {
        this.sendCommand("HINCRBY", key, field, String.valueOf(value));
    }

    public void hexists(String key, String field) {
        this.sendCommand("HEXISTS", key, field);
    }

    public void hdel(String key, String field) {
        this.sendCommand("HDEL", key, field);
    }

    public void hlen(String key) {
        this.sendCommand("HLEN", key);
    }

    public void hkeys(String key) {
        this.sendCommand("HKEYS", key);
    }

    public void hvals(String key) {
        this.sendCommand("HVALS", key);
    }

    public void hgetAll(String key) {
        this.sendCommand("HGETALL", key);
    }

    public void rpush(String key, String string) {
        this.sendCommand("RPUSH", key, string);
    }

    public void lpush(String key, String string) {
        this.sendCommand("LPUSH", key, string);
    }

    public void llen(String key) {
        this.sendCommand("LLEN", key);
    }

    public void lrange(String key, int start, int end) {
        this.sendCommand("LRANGE", key, String.valueOf(start), String.valueOf(end));
    }

    public void ltrim(String key, int start, int end) {
        this.sendCommand("LTRIM", key, String.valueOf(start), String.valueOf(end));
    }

    public void lindex(String key, int index) {
        this.sendCommand("LINDEX", key, String.valueOf(index));
    }

    public void lset(String key, int index, String value) {
        this.sendCommand("LSET", key, String.valueOf(index), value);
    }

    public void lrem(String key, int count, String value) {
        this.sendCommand("LREM", key, String.valueOf(count), value);
    }

    public void lpop(String key) {
        this.sendCommand("LPOP", key);
    }

    public void rpop(String key) {
        this.sendCommand("RPOP", key);
    }

    public void rpoplpush(String srckey, String dstkey) {
        this.sendCommand("RPOPLPUSH", srckey, dstkey);
    }

    public void sadd(String key, String member) {
        this.sendCommand("SADD", key, member);
    }

    public void smembers(String key) {
        this.sendCommand("SMEMBERS", key);
    }

    public void srem(String key, String member) {
        this.sendCommand("SREM", key, member);
    }

    public void spop(String key) {
        this.sendCommand("SPOP", key);
    }

    public void smove(String srckey, String dstkey, String member) {
        this.sendCommand("SMOVE", srckey, dstkey, member);
    }

    public void scard(String key) {
        this.sendCommand("SCARD", key);
    }

    public void sismember(String key, String member) {
        this.sendCommand("SISMEMBER", key, member);
    }

    public void sinter(String ... keys) {
        this.sendCommand("SINTER", keys);
    }

    public void sinterstore(String dstkey, String ... keys) {
        String[] params = new String[keys.length + 1];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand("SINTERSTORE", params);
    }

    public void sunion(String ... keys) {
        this.sendCommand("SUNION", keys);
    }

    public void sunionstore(String dstkey, String ... keys) {
        String[] params = new String[keys.length + 1];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand("SUNIONSTORE", params);
    }

    public void sdiff(String ... keys) {
        this.sendCommand("SDIFF", keys);
    }

    public void sdiffstore(String dstkey, String ... keys) {
        String[] params = new String[keys.length + 1];
        params[0] = dstkey;
        System.arraycopy(keys, 0, params, 1, keys.length);
        this.sendCommand("SDIFFSTORE", params);
    }

    public void srandmember(String key) {
        this.sendCommand("SRANDMEMBER", key);
    }

    public void zadd(String key, double score, String member) {
        this.sendCommand("ZADD", key, String.valueOf(score), member);
    }

    public void zrange(String key, int start, int end) {
        this.sendCommand("ZRANGE", key, String.valueOf(start), String.valueOf(end));
    }

    public void zrem(String key, String member) {
        this.sendCommand("ZREM", key, member);
    }

    public void zincrby(String key, double score, String member) {
        this.sendCommand("ZINCRBY", key, String.valueOf(score), member);
    }

    public void zrank(String key, String member) {
        this.sendCommand("ZRANK", key, member);
    }

    public void zrevrank(String key, String member) {
        this.sendCommand("ZREVRANK", key, member);
    }

    public void zrevrange(String key, int start, int end) {
        this.sendCommand("ZREVRANGE", key, String.valueOf(start), String.valueOf(end));
    }

    public void zrangeWithScores(String key, int start, int end) {
        this.sendCommand("ZRANGE", key, String.valueOf(start), String.valueOf(end), "WITHSCORES");
    }

    public void zrevrangeWithScores(String key, int start, int end) {
        this.sendCommand("ZREVRANGE", key, String.valueOf(start), String.valueOf(end), "WITHSCORES");
    }

    public void zcard(String key) {
        this.sendCommand("ZCARD", key);
    }

    public void zscore(String key, String member) {
        this.sendCommand("ZSCORE", key, member);
    }

    public void multi() {
        this.sendCommand("MULTI", new String[0]);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand("DISCARD", new String[0]);
        this.isInMulti = false;
    }

    public void exec() {
        this.sendCommand("EXEC", new String[0]);
        this.isInMulti = false;
    }

    public void watch(String key) {
        this.sendCommand("WATCH", key);
    }

    public void unwatch() {
        this.sendCommand("UNWATCH", new String[0]);
    }

    public void sort(String key) {
        this.sendCommand("SORT", key);
    }

    public void sort(String key, SortingParams sortingParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand("SORT", args.toArray(new String[args.size()]));
    }

    public void blpop(String[] args) {
        this.sendCommand("BLPOP", args);
    }

    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add("STORE");
        args.add(dstkey);
        this.sendCommand("SORT", args.toArray(new String[args.size()]));
    }

    public void sort(String key, String dstkey) {
        this.sendCommand("SORT", key, "STORE", dstkey);
    }

    public void brpop(String[] args) {
        this.sendCommand("BRPOP", args);
    }

    public void auth(String password) {
        this.sendCommand("AUTH", password);
    }

    public void subscribe(String ... channels) {
        this.sendCommand("SUBSCRIBE", channels);
    }

    public void publish(String channel, String message) {
        this.sendCommand("PUBLISH", channel, message);
    }

    public void unsubscribe() {
        this.sendCommand("UNSUBSCRIBE", new String[0]);
    }

    public void unsubscribe(String ... channels) {
        this.sendCommand("UNSUBSCRIBE", channels);
    }

    public void psubscribe(String[] patterns) {
        this.sendCommand("PSUBSCRIBE", patterns);
    }

    public void punsubscribe() {
        this.sendCommand("PUNSUBSCRIBE", new String[0]);
    }

    public void punsubscribe(String ... patterns) {
        this.sendCommand("PUNSUBSCRIBE", patterns);
    }

    public void zcount(String key, double min, double max) {
        this.sendCommand("ZCOUNT", key, String.valueOf(min), String.valueOf(max));
    }

    public void zrangeByScore(String key, double min, double max) {
        this.sendCommand("ZRANGEBYSCORE", key, String.valueOf(min), String.valueOf(max));
    }

    public void zrangeByScore(String key, double min, double max, int offset, int count) {
        this.sendCommand("ZRANGEBYSCORE", key, String.valueOf(min), String.valueOf(max), "LIMIT", String.valueOf(offset), String.valueOf(count));
    }

    public void zrangeByScoreWithScores(String key, double min, double max) {
        this.sendCommand("ZRANGEBYSCORE", key, String.valueOf(min), String.valueOf(max), "WITHSCORES");
    }

    public void zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.sendCommand("ZRANGEBYSCORE", key, String.valueOf(min), String.valueOf(max), "LIMIT", String.valueOf(offset), String.valueOf(count), "WITHSCORES");
    }

    public void zremrangeByRank(String key, int start, int end) {
        this.sendCommand("ZREMRANGEBYRANK", key, String.valueOf(start), String.valueOf(end));
    }

    public void zremrangeByScore(String key, double start, double end) {
        this.sendCommand("ZREMRANGEBYSCORE", key, String.valueOf(start), String.valueOf(end));
    }

    public void zunionstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand("ZUNIONSTORE", params);
    }

    public void zunionstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        for (String set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand("ZUNIONSTORE", args.toArray(new String[args.size()]));
    }

    public void zinterstore(String dstkey, String ... sets) {
        String[] params = new String[sets.length + 2];
        params[0] = dstkey;
        params[1] = String.valueOf(sets.length);
        System.arraycopy(sets, 0, params, 2, sets.length);
        this.sendCommand("ZINTERSTORE", params);
    }

    public void zinterstore(String dstkey, ZParams params, String ... sets) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(dstkey);
        args.add(String.valueOf(sets.length));
        for (String set : sets) {
            args.add(set);
        }
        args.addAll(params.getParams());
        this.sendCommand("ZINTERSTORE", args.toArray(new String[args.size()]));
    }

    public void save() {
        this.sendCommand("SAVE", new String[0]);
    }

    public void bgsave() {
        this.sendCommand("BGSAVE", new String[0]);
    }

    public void bgrewriteaof() {
        this.sendCommand("BGREWRITEAOF", new String[0]);
    }

    public void lastsave() {
        this.sendCommand("LASTSAVE", new String[0]);
    }

    public void shutdown() {
        this.sendCommand("SHUTDOWN", new String[0]);
    }

    public void info() {
        this.sendCommand("INFO", new String[0]);
    }

    public void monitor() {
        this.sendCommand("MONITOR", new String[0]);
    }

    public void slaveof(String host, int port) {
        this.sendCommand("SLAVEOF", host, String.valueOf(port));
    }

    public void slaveofNoOne() {
        this.sendCommand("SLAVEOF", "no", "one");
    }

    public void configGet(String pattern) {
        this.sendCommand("CONFIG", "GET", pattern);
    }

    public void configSet(String parameter, String value) {
        this.sendCommand("CONFIG", "SET", parameter, value);
    }

    public void strlen(String key) {
        this.sendCommand("STRLEN", key);
    }

    public void sync() {
        this.sendCommand("SYNC", new String[0]);
    }

    public void lpushx(String key, String string) {
        this.sendCommand("LPUSHX", key, string);
    }

    public void persist(String key) {
        this.sendCommand("PERSIST", key);
    }

    public void rpushx(String key, String string) {
        this.sendCommand("RPUSHX", key, string);
    }

    public void echo(String string) {
        this.sendCommand("ECHO", string);
    }

    public void linsert(String key, LIST_POSITION where, String pivot, String value) {
        this.sendCommand("LINSERT", key, where.toString(), pivot, value);
    }

    public void debug(DebugParams params) {
        this.sendCommand("DEBUG", params.getCommand());
    }

    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

    }
}

