/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import redis.clients.jedis.Client;
import redis.clients.jedis.JedisException;

public abstract class JedisPubSub {
    private int subscribedChannels = 0;
    private Client client;

    public abstract void onMessage(String var1, String var2);

    public abstract void onPMessage(String var1, String var2, String var3);

    public abstract void onSubscribe(String var1, int var2);

    public abstract void onUnsubscribe(String var1, int var2);

    public abstract void onPUnsubscribe(String var1, int var2);

    public abstract void onPSubscribe(String var1, int var2);

    protected void unsubscribe() {
        this.client.unsubscribe();
    }

    protected void unsubscribe(String ... channels) {
        this.client.unsubscribe(channels);
    }

    protected void subscribe(String ... channels) {
        this.client.subscribe(channels);
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Client client, String ... patterns) {
        this.client = client;
        client.psubscribe(patterns);
        this.process(client);
    }

    public void proceed(Client client, String ... channels) {
        this.client = client;
        client.subscribe(channels);
        this.process(client);
    }

    private void process(Client client) {
        do {
            List<Object> reply;
            if ((reply = client.getObjectMultiBulkReply()).get(0).equals("subscribe")) {
                this.subscribedChannels = (Integer)reply.get(2);
                this.onSubscribe((String)reply.get(1), this.subscribedChannels);
                continue;
            }
            if (reply.get(0).equals("unsubscribe")) {
                this.subscribedChannels = (Integer)reply.get(2);
                this.onUnsubscribe((String)reply.get(1), this.subscribedChannels);
                continue;
            }
            if (reply.get(0).equals("message")) {
                this.onMessage((String)reply.get(1), (String)reply.get(2));
                continue;
            }
            if (reply.get(0).equals("pmessage")) {
                this.onPMessage((String)reply.get(1), (String)reply.get(2), (String)reply.get(3));
                continue;
            }
            if (reply.get(0).equals("psubscribe")) {
                this.subscribedChannels = (Integer)reply.get(2);
                this.onPSubscribe((String)reply.get(1), this.subscribedChannels);
                continue;
            }
            if (reply.get(0).equals("punsubscribe")) {
                this.subscribedChannels = (Integer)reply.get(2);
                this.onPUnsubscribe((String)reply.get(1), this.subscribedChannels);
                continue;
            }
            throw new JedisException("Unknown message type: " + reply.get(0));
        } while (this.isSubscribed());
    }

    protected void punsubscribe() {
        this.client.punsubscribe();
    }

    protected void punsubscribe(String ... patterns) {
        this.client.punsubscribe(patterns);
    }
}

