/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericInfoUtils;

public final class GenericsInfoFactory {
    public static final String CACHE_PROPERTY = GenericsInfoFactory.class.getName() + ".cache";
    private static final Map<Class<?>, GenericsInfo> CACHE = new WeakHashMap();
    private static final ReentrantLock LOCK = new ReentrantLock();

    private GenericsInfoFactory() {
    }

    public static GenericsInfo create(Class<?> type, Class<?> ... ignoreClasses) {
        GenericsInfo descriptor;
        GenericsInfo genericsInfo = descriptor = ignoreClasses.length > 0 ? GenericInfoUtils.create(type, ignoreClasses) : CACHE.get(type);
        if (descriptor == null) {
            LOCK.lock();
            try {
                if (CACHE.get(type) != null) {
                    descriptor = CACHE.get(type);
                } else {
                    descriptor = GenericInfoUtils.create(type, new Class[0]);
                    if (GenericsInfoFactory.isCacheEnabled()) {
                        if (CACHE.get(type) != null) {
                            throw new IllegalStateException("Bad concurrency: descriptor already present in cache");
                        }
                        CACHE.put(type, descriptor);
                    }
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return descriptor;
    }

    public static void clearCache() {
        LOCK.lock();
        try {
            CACHE.clear();
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void disableCache() {
        System.setProperty(CACHE_PROPERTY, Boolean.FALSE.toString());
    }

    public static boolean isCacheEnabled() {
        String no = Boolean.FALSE.toString();
        return !no.equals(System.getenv(CACHE_PROPERTY)) && !no.equals(System.getProperty(CACHE_PROPERTY));
    }
}

