/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.NoGenericException;

public class MethodGenericsContext
extends GenericsContext {
    private final Method method;
    private Map<String, Type> methodGenerics;
    private Map<String, Type> allGenerics;

    public MethodGenericsContext(GenericsInfo genericsInfo, Class<?> type, Method method) {
        super(genericsInfo, type);
        Class<?> declaringType = method.getDeclaringClass();
        if (!declaringType.equals(type)) {
            throw new IllegalArgumentException(String.format("Method '%s' should be resolved on type %s and not %s", method.getName(), declaringType.getSimpleName(), type.getSimpleName()));
        }
        this.method = method;
        this.initGenerics();
    }

    public Method currentMethod() {
        return this.method;
    }

    public List<Type> methodGenericTypes() {
        return new ArrayList<Type>(this.methodGenerics.values());
    }

    public Map<String, Type> methodGenericsMap() {
        return new LinkedHashMap<String, Type>(this.methodGenerics);
    }

    public Class<?> resolveReturnClass() {
        return GenericsUtils.getReturnClass(this.method, this.contextGenerics());
    }

    public List<Class<?>> resolveParameters() {
        return GenericsUtils.getMethodParameters(this.method, this.contextGenerics());
    }

    public List<Class<?>> resolveReturnTypeGenerics() throws NoGenericException {
        return GenericsUtils.resolveGenericsOf(this.method.getGenericReturnType(), this.contextGenerics());
    }

    public Class<?> resolveReturnTypeGeneric() throws NoGenericException {
        return this.resolveReturnTypeGenerics().get(0);
    }

    @Override
    protected Map<String, Type> contextGenerics() {
        return this.allGenerics;
    }

    private void initGenerics() {
        TypeVariable<Method>[] methodGenerics = this.method.getTypeParameters();
        boolean hasMethodGenerics = methodGenerics.length > 0;
        this.methodGenerics = hasMethodGenerics ? new LinkedHashMap() : Collections.emptyMap();
        this.allGenerics = hasMethodGenerics ? new LinkedHashMap(this.typeGenerics) : this.typeGenerics;
        for (TypeVariable<Method> generic : methodGenerics) {
            Class<?> value = this.resolveClass(generic.getBounds()[0]);
            this.methodGenerics.put(generic.getName(), value);
            this.allGenerics.put(generic.getName(), value);
        }
    }
}

