/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.UnknownGenericException;

public final class TypeToStringUtils {
    private TypeToStringUtils() {
    }

    public static String toStringType(Type type, Map<String, Type> generics) {
        String res = type instanceof Class ? ((Class)type).getSimpleName() : (type instanceof ParameterizedType ? TypeToStringUtils.processParametrizedType((ParameterizedType)type, generics) : (type instanceof GenericArrayType ? TypeToStringUtils.toStringType(((GenericArrayType)type).getGenericComponentType(), generics) + "[]" : (type instanceof WildcardType ? TypeToStringUtils.processWildcardType((WildcardType)type, generics) : TypeToStringUtils.toStringType(TypeToStringUtils.declaredGeneric((TypeVariable)type, generics), generics))));
        return res;
    }

    private static String processParametrizedType(ParameterizedType parametrized, Map<String, Type> generics) {
        String res = TypeToStringUtils.toStringType(parametrized.getRawType(), generics);
        ArrayList<String> args = new ArrayList<String>();
        for (Type t : parametrized.getActualTypeArguments()) {
            args.add(TypeToStringUtils.toStringType(t, generics));
        }
        if (!args.isEmpty()) {
            res = res + "<" + TypeToStringUtils.join(args) + ">";
        }
        return res;
    }

    private static String processWildcardType(WildcardType wildcard, Map<String, Type> generics) {
        String res = wildcard.getLowerBounds().length == 0 ? "? extends " + TypeToStringUtils.toStringType(GenericsUtils.resolveClass(wildcard.getUpperBounds()[0], generics), generics) : "? super " + TypeToStringUtils.toStringType(GenericsUtils.resolveClass(wildcard.getLowerBounds()[0], generics), generics);
        return res;
    }

    private static String join(List<?> args) {
        String res;
        Iterator<?> iterator = args.iterator();
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            res = String.valueOf(first);
        } else {
            StringBuilder buf = new StringBuilder(256);
            if (first != null) {
                buf.append(first);
            }
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                buf.append(", ").append(obj);
            }
            res = buf.toString();
        }
        return res;
    }

    private static Type declaredGeneric(TypeVariable generic, Map<String, Type> declarations) {
        String name = generic.getName();
        Type result = declarations.get(name);
        if (result == null) {
            throw new UnknownGenericException(name);
        }
        return result;
    }
}

