package software.amazon.awscdk.services.apigateway;

/**
 * Defines a {proxy+} greedy resource and an ANY method on a route.
 * <p>
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-set-up-simple-proxy.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:36.664Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ProxyResource")
public class ProxyResource extends software.amazon.awscdk.services.apigateway.Resource {

    protected ProxyResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProxyResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProxyResource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ProxyResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Defines a new method for this resource.
     * <p>
     * @param httpMethod This parameter is required.
     * @param integration
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method addMethod(final @org.jetbrains.annotations.NotNull java.lang.String httpMethod, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Integration integration, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.MethodOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class), new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required"), integration, options });
    }

    /**
     * Defines a new method for this resource.
     * <p>
     * @param httpMethod This parameter is required.
     * @param integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method addMethod(final @org.jetbrains.annotations.NotNull java.lang.String httpMethod, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Integration integration) {
        return software.amazon.jsii.Kernel.call(this, "addMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class), new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required"), integration });
    }

    /**
     * Defines a new method for this resource.
     * <p>
     * @param httpMethod This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method addMethod(final @org.jetbrains.annotations.NotNull java.lang.String httpMethod) {
        return software.amazon.jsii.Kernel.call(this, "addMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class), new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required") });
    }

    /**
     * If `props.anyMethod` is `true`, this will be the reference to the 'ANY' method associated with this proxy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Method getAnyMethod() {
        return software.amazon.jsii.Kernel.get(this, "anyMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.ProxyResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.ProxyResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.ProxyResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.ProxyResourceProps.Builder();
        }

        /**
         * Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * <p>
         * You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * <p>
         * Default: - CORS is disabled
         * <p>
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * Adds an "ANY" method to this resource.
         * <p>
         * If set to <code>false</code>, you will have to explicitly
         * add methods to this resource after it's created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param anyMethod Adds an "ANY" method to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anyMethod(final java.lang.Boolean anyMethod) {
            this.props.anyMethod(anyMethod);
            return this;
        }

        /**
         * The parent resource of this resource.
         * <p>
         * You can either pass another
         * <code>Resource</code> object or a <code>RestApi</code> object here.
         * <p>
         * @return {@code this}
         * @param parent The parent resource of this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parent(final software.amazon.awscdk.services.apigateway.IResource parent) {
            this.props.parent(parent);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.ProxyResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.ProxyResource build() {
            return new software.amazon.awscdk.services.apigateway.ProxyResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
