/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.budgets;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.budgets.;
import software.amazon.awscdk.services.budgets.CfnBudget;
import software.amazon.awscdk.services.budgets.CfnBudgetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget")
public class CfnBudget
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBudget.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnBudget(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBudget(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBudget(@NotNull Construct scope, @NotNull String id, @NotNull CfnBudgetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getBudget() {
        return Kernel.get((Object)((Object)this), (String)"budget", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBudget(@NotNull BudgetDataProperty value) {
        Kernel.set((Object)((Object)this), (String)"budget", (Object)Objects.requireNonNull(value, "budget is required"));
    }

    public void setBudget(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"budget", (Object)Objects.requireNonNull(value, "budget is required"));
    }

    @Nullable
    public Object getNotificationsWithSubscribers() {
        return Kernel.get((Object)((Object)this), (String)"notificationsWithSubscribers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNotificationsWithSubscribers(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"notificationsWithSubscribers", (Object)value);
    }

    public void setNotificationsWithSubscribers(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"notificationsWithSubscribers", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnBudget> {
        private final Construct scope;
        private final String id;
        private final CfnBudgetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnBudgetProps.Builder();
        }

        public Builder budget(BudgetDataProperty budget) {
            this.props.budget(budget);
            return this;
        }

        public Builder budget(IResolvable budget) {
            this.props.budget(budget);
            return this;
        }

        public Builder notificationsWithSubscribers(IResolvable notificationsWithSubscribers) {
            this.props.notificationsWithSubscribers(notificationsWithSubscribers);
            return this;
        }

        public Builder notificationsWithSubscribers(List<? extends Object> notificationsWithSubscribers) {
            this.props.notificationsWithSubscribers(notificationsWithSubscribers);
            return this;
        }

        public CfnBudget build() {
            return new CfnBudget(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.TimePeriodProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimePeriodProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEnd() {
            return null;
        }

        @Nullable
        default public String getStart() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimePeriodProperty> {
            private String end;
            private String start;

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public Builder start(String start) {
                this.start = start;
                return this;
            }

            public TimePeriodProperty build() {
                return new Jsii.Proxy(this.end, this.start);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.SubscriberProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubscriberProperty
    extends JsiiSerializable {
        @NotNull
        public String getAddress();

        @NotNull
        public String getSubscriptionType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubscriberProperty> {
            private String address;
            private String subscriptionType;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder subscriptionType(String subscriptionType) {
                this.subscriptionType = subscriptionType;
                return this;
            }

            public SubscriberProperty build() {
                return new Jsii.Proxy(this.address, this.subscriptionType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.SpendProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpendProperty
    extends JsiiSerializable {
        @NotNull
        public Number getAmount();

        @NotNull
        public String getUnit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpendProperty> {
            private Number amount;
            private String unit;

            public Builder amount(Number amount) {
                this.amount = amount;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public SpendProperty build() {
                return new Jsii.Proxy(this.amount, this.unit);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.NotificationWithSubscribersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationWithSubscribersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getNotification();

        @NotNull
        public Object getSubscribers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationWithSubscribersProperty> {
            private Object notification;
            private Object subscribers;

            public Builder notification(IResolvable notification) {
                this.notification = notification;
                return this;
            }

            public Builder notification(NotificationProperty notification) {
                this.notification = notification;
                return this;
            }

            public Builder subscribers(IResolvable subscribers) {
                this.subscribers = subscribers;
                return this;
            }

            public Builder subscribers(List<? extends Object> subscribers) {
                this.subscribers = subscribers;
                return this;
            }

            public NotificationWithSubscribersProperty build() {
                return new Jsii.Proxy(this.notification, this.subscribers);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.NotificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparisonOperator();

        @NotNull
        public String getNotificationType();

        @NotNull
        public Number getThreshold();

        @Nullable
        default public String getThresholdType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationProperty> {
            private String comparisonOperator;
            private String notificationType;
            private Number threshold;
            private String thresholdType;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder notificationType(String notificationType) {
                this.notificationType = notificationType;
                return this;
            }

            public Builder threshold(Number threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder thresholdType(String thresholdType) {
                this.thresholdType = thresholdType;
                return this;
            }

            public NotificationProperty build() {
                return new Jsii.Proxy(this.comparisonOperator, this.notificationType, this.threshold, this.thresholdType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.CostTypesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CostTypesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIncludeCredit() {
            return null;
        }

        @Nullable
        default public Object getIncludeDiscount() {
            return null;
        }

        @Nullable
        default public Object getIncludeOtherSubscription() {
            return null;
        }

        @Nullable
        default public Object getIncludeRecurring() {
            return null;
        }

        @Nullable
        default public Object getIncludeRefund() {
            return null;
        }

        @Nullable
        default public Object getIncludeSubscription() {
            return null;
        }

        @Nullable
        default public Object getIncludeSupport() {
            return null;
        }

        @Nullable
        default public Object getIncludeTax() {
            return null;
        }

        @Nullable
        default public Object getIncludeUpfront() {
            return null;
        }

        @Nullable
        default public Object getUseAmortized() {
            return null;
        }

        @Nullable
        default public Object getUseBlended() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CostTypesProperty> {
            private Object includeCredit;
            private Object includeDiscount;
            private Object includeOtherSubscription;
            private Object includeRecurring;
            private Object includeRefund;
            private Object includeSubscription;
            private Object includeSupport;
            private Object includeTax;
            private Object includeUpfront;
            private Object useAmortized;
            private Object useBlended;

            public Builder includeCredit(Boolean includeCredit) {
                this.includeCredit = includeCredit;
                return this;
            }

            public Builder includeCredit(IResolvable includeCredit) {
                this.includeCredit = includeCredit;
                return this;
            }

            public Builder includeDiscount(Boolean includeDiscount) {
                this.includeDiscount = includeDiscount;
                return this;
            }

            public Builder includeDiscount(IResolvable includeDiscount) {
                this.includeDiscount = includeDiscount;
                return this;
            }

            public Builder includeOtherSubscription(Boolean includeOtherSubscription) {
                this.includeOtherSubscription = includeOtherSubscription;
                return this;
            }

            public Builder includeOtherSubscription(IResolvable includeOtherSubscription) {
                this.includeOtherSubscription = includeOtherSubscription;
                return this;
            }

            public Builder includeRecurring(Boolean includeRecurring) {
                this.includeRecurring = includeRecurring;
                return this;
            }

            public Builder includeRecurring(IResolvable includeRecurring) {
                this.includeRecurring = includeRecurring;
                return this;
            }

            public Builder includeRefund(Boolean includeRefund) {
                this.includeRefund = includeRefund;
                return this;
            }

            public Builder includeRefund(IResolvable includeRefund) {
                this.includeRefund = includeRefund;
                return this;
            }

            public Builder includeSubscription(Boolean includeSubscription) {
                this.includeSubscription = includeSubscription;
                return this;
            }

            public Builder includeSubscription(IResolvable includeSubscription) {
                this.includeSubscription = includeSubscription;
                return this;
            }

            public Builder includeSupport(Boolean includeSupport) {
                this.includeSupport = includeSupport;
                return this;
            }

            public Builder includeSupport(IResolvable includeSupport) {
                this.includeSupport = includeSupport;
                return this;
            }

            public Builder includeTax(Boolean includeTax) {
                this.includeTax = includeTax;
                return this;
            }

            public Builder includeTax(IResolvable includeTax) {
                this.includeTax = includeTax;
                return this;
            }

            public Builder includeUpfront(Boolean includeUpfront) {
                this.includeUpfront = includeUpfront;
                return this;
            }

            public Builder includeUpfront(IResolvable includeUpfront) {
                this.includeUpfront = includeUpfront;
                return this;
            }

            public Builder useAmortized(Boolean useAmortized) {
                this.useAmortized = useAmortized;
                return this;
            }

            public Builder useAmortized(IResolvable useAmortized) {
                this.useAmortized = useAmortized;
                return this;
            }

            public Builder useBlended(Boolean useBlended) {
                this.useBlended = useBlended;
                return this;
            }

            public Builder useBlended(IResolvable useBlended) {
                this.useBlended = useBlended;
                return this;
            }

            public CostTypesProperty build() {
                return new Jsii.Proxy(this.includeCredit, this.includeDiscount, this.includeOtherSubscription, this.includeRecurring, this.includeRefund, this.includeSubscription, this.includeSupport, this.includeTax, this.includeUpfront, this.useAmortized, this.useBlended);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-budgets.CfnBudget.BudgetDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BudgetDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getBudgetType();

        @NotNull
        public String getTimeUnit();

        @Nullable
        default public Object getBudgetLimit() {
            return null;
        }

        @Nullable
        default public String getBudgetName() {
            return null;
        }

        @Nullable
        default public Object getCostFilters() {
            return null;
        }

        @Nullable
        default public Object getCostTypes() {
            return null;
        }

        @Nullable
        default public Object getPlannedBudgetLimits() {
            return null;
        }

        @Nullable
        default public Object getTimePeriod() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BudgetDataProperty> {
            private String budgetType;
            private String timeUnit;
            private Object budgetLimit;
            private String budgetName;
            private Object costFilters;
            private Object costTypes;
            private Object plannedBudgetLimits;
            private Object timePeriod;

            public Builder budgetType(String budgetType) {
                this.budgetType = budgetType;
                return this;
            }

            public Builder timeUnit(String timeUnit) {
                this.timeUnit = timeUnit;
                return this;
            }

            public Builder budgetLimit(IResolvable budgetLimit) {
                this.budgetLimit = budgetLimit;
                return this;
            }

            public Builder budgetLimit(SpendProperty budgetLimit) {
                this.budgetLimit = budgetLimit;
                return this;
            }

            public Builder budgetName(String budgetName) {
                this.budgetName = budgetName;
                return this;
            }

            public Builder costFilters(Object costFilters) {
                this.costFilters = costFilters;
                return this;
            }

            public Builder costTypes(IResolvable costTypes) {
                this.costTypes = costTypes;
                return this;
            }

            public Builder costTypes(CostTypesProperty costTypes) {
                this.costTypes = costTypes;
                return this;
            }

            public Builder plannedBudgetLimits(Object plannedBudgetLimits) {
                this.plannedBudgetLimits = plannedBudgetLimits;
                return this;
            }

            public Builder timePeriod(IResolvable timePeriod) {
                this.timePeriod = timePeriod;
                return this;
            }

            public Builder timePeriod(TimePeriodProperty timePeriod) {
                this.timePeriod = timePeriod;
                return this;
            }

            public BudgetDataProperty build() {
                return new Jsii.Proxy(this.budgetType, this.timeUnit, this.budgetLimit, this.budgetName, this.costFilters, this.costTypes, this.plannedBudgetLimits, this.timePeriod);
            }
        }
    }
}

