package software.amazon.awscdk.cloudassembly.schema;

/**
 * Properties for how to produce a Docker image from a source.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2020-12-12T01:54:58.050Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.DockerImageSource")
@software.amazon.jsii.Jsii.Proxy(DockerImageSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * The directory containing the Docker image build instructions.
     * <p>
     * This path is relative to the asset manifest location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectory();

    /**
     * Additional build arguments.
     * <p>
     * Default: - No additional build arguments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
        return null;
    }

    /**
     * Target build stage in a Dockerfile with multiple build stages.
     * <p>
     * Default: - The last stage in the Dockerfile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerBuildTarget() {
        return null;
    }

    /**
     * The name of the file with build instructions.
     * <p>
     * Default: "Dockerfile"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerFile() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageSource> {
        private java.lang.String directory;
        private java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private java.lang.String dockerBuildTarget;
        private java.lang.String dockerFile;

        /**
         * Sets the value of {@link DockerImageSource#getDirectory}
         * @param directory The directory containing the Docker image build instructions. This parameter is required.
         *                  This path is relative to the asset manifest location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(java.lang.String directory) {
            this.directory = directory;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageSource#getDockerBuildArgs}
         * @param dockerBuildArgs Additional build arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildArgs(java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs) {
            this.dockerBuildArgs = dockerBuildArgs;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageSource#getDockerBuildTarget}
         * @param dockerBuildTarget Target build stage in a Dockerfile with multiple build stages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerBuildTarget(java.lang.String dockerBuildTarget) {
            this.dockerBuildTarget = dockerBuildTarget;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageSource#getDockerFile}
         * @param dockerFile The name of the file with build instructions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerFile(java.lang.String dockerFile) {
            this.dockerFile = dockerFile;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerImageSource build() {
            return new Jsii$Proxy(directory, dockerBuildArgs, dockerBuildTarget, dockerFile);
        }
    }

    /**
     * An implementation for {@link DockerImageSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageSource {
        private final java.lang.String directory;
        private final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs;
        private final java.lang.String dockerBuildTarget;
        private final java.lang.String dockerFile;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.directory = software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerBuildArgs = software.amazon.jsii.Kernel.get(this, "dockerBuildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerBuildTarget = software.amazon.jsii.Kernel.get(this, "dockerBuildTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerFile = software.amazon.jsii.Kernel.get(this, "dockerFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String directory, final java.util.Map<java.lang.String, java.lang.String> dockerBuildArgs, final java.lang.String dockerBuildTarget, final java.lang.String dockerFile) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directory = java.util.Objects.requireNonNull(directory, "directory is required");
            this.dockerBuildArgs = dockerBuildArgs;
            this.dockerBuildTarget = dockerBuildTarget;
            this.dockerFile = dockerFile;
        }

        @Override
        public final java.lang.String getDirectory() {
            return this.directory;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDockerBuildArgs() {
            return this.dockerBuildArgs;
        }

        @Override
        public final java.lang.String getDockerBuildTarget() {
            return this.dockerBuildTarget;
        }

        @Override
        public final java.lang.String getDockerFile() {
            return this.dockerFile;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("directory", om.valueToTree(this.getDirectory()));
            if (this.getDockerBuildArgs() != null) {
                data.set("dockerBuildArgs", om.valueToTree(this.getDockerBuildArgs()));
            }
            if (this.getDockerBuildTarget() != null) {
                data.set("dockerBuildTarget", om.valueToTree(this.getDockerBuildTarget()));
            }
            if (this.getDockerFile() != null) {
                data.set("dockerFile", om.valueToTree(this.getDockerFile()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.DockerImageSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageSource.Jsii$Proxy that = (DockerImageSource.Jsii$Proxy) o;

            if (!directory.equals(that.directory)) return false;
            if (this.dockerBuildArgs != null ? !this.dockerBuildArgs.equals(that.dockerBuildArgs) : that.dockerBuildArgs != null) return false;
            if (this.dockerBuildTarget != null ? !this.dockerBuildTarget.equals(that.dockerBuildTarget) : that.dockerBuildTarget != null) return false;
            return this.dockerFile != null ? this.dockerFile.equals(that.dockerFile) : that.dockerFile == null;
        }

        @Override
        public final int hashCode() {
            int result = this.directory.hashCode();
            result = 31 * result + (this.dockerBuildArgs != null ? this.dockerBuildArgs.hashCode() : 0);
            result = 31 * result + (this.dockerBuildTarget != null ? this.dockerBuildTarget.hashCode() : 0);
            result = 31 * result + (this.dockerFile != null ? this.dockerFile.hashCode() : 0);
            return result;
        }
    }
}
