package software.amazon.awscdk.cxapi;

/**
 * Artifact properties for CloudFormation stacks.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:07:14.107Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.AwsCloudFormationStackProperties")
@software.amazon.jsii.Jsii.Proxy(AwsCloudFormationStackProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCloudFormationStackProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * A file relative to the assembly root which contains the CloudFormation template for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile();

    /**
     * Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * The name to use for the CloudFormation stack.
     * <p>
     * Default: - name derived from artifact ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackName() {
        return null;
    }

    /**
     * Whether to enable termination protection for this stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsCloudFormationStackProperties> {
        private java.lang.String templateFile;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private java.lang.String stackName;
        private java.lang.Boolean terminationProtection;

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTemplateFile}
         * @param templateFile A file relative to the assembly root which contains the CloudFormation template for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateFile(java.lang.String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getParameters}
         * @param parameters Values for CloudFormation stack parameters that should be passed when the stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getStackName}
         * @param stackName The name to use for the CloudFormation stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCloudFormationStackProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsCloudFormationStackProperties build() {
            return new Jsii$Proxy(templateFile, parameters, stackName, terminationProtection);
        }
    }

    /**
     * An implementation for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCloudFormationStackProperties {
        private final java.lang.String templateFile;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.lang.String stackName;
        private final java.lang.Boolean terminationProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateFile = software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.terminationProtection = software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String templateFile, final java.util.Map<java.lang.String, java.lang.String> parameters, final java.lang.String stackName, final java.lang.Boolean terminationProtection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateFile = java.util.Objects.requireNonNull(templateFile, "templateFile is required");
            this.parameters = parameters;
            this.stackName = stackName;
            this.terminationProtection = terminationProtection;
        }

        @Override
        public final java.lang.String getTemplateFile() {
            return this.templateFile;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateFile", om.valueToTree(this.getTemplateFile()));
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.AwsCloudFormationStackProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCloudFormationStackProperties.Jsii$Proxy that = (AwsCloudFormationStackProperties.Jsii$Proxy) o;

            if (!templateFile.equals(that.templateFile)) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            return this.terminationProtection != null ? this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.templateFile.hashCode();
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            return result;
        }
    }
}
