package software.amazon.awscdk.services.route53;

/**
 * Construction properties for a CrossAccountZoneDelegationRecord.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:22.493Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.route53.$Module.class, fqn = "@aws-cdk/aws-route53.CrossAccountZoneDelegationRecordProps")
@software.amazon.jsii.Jsii.Proxy(CrossAccountZoneDelegationRecordProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CrossAccountZoneDelegationRecordProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The zone to be delegated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getDelegatedZone();

    /**
     * The delegation role in the parent account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getDelegationRole();

    /**
     * The hosted zone id in the parent account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParentHostedZoneId();

    /**
     * The resource record cache time to live (TTL).
     * <p>
     * Default: Duration.days(2)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CrossAccountZoneDelegationRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CrossAccountZoneDelegationRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CrossAccountZoneDelegationRecordProps> {
        private software.amazon.awscdk.services.route53.IHostedZone delegatedZone;
        private software.amazon.awscdk.services.iam.IRole delegationRole;
        private java.lang.String parentHostedZoneId;
        private software.amazon.awscdk.core.Duration ttl;

        /**
         * Sets the value of {@link CrossAccountZoneDelegationRecordProps#getDelegatedZone}
         * @param delegatedZone The zone to be delegated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegatedZone(software.amazon.awscdk.services.route53.IHostedZone delegatedZone) {
            this.delegatedZone = delegatedZone;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountZoneDelegationRecordProps#getDelegationRole}
         * @param delegationRole The delegation role in the parent account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegationRole(software.amazon.awscdk.services.iam.IRole delegationRole) {
            this.delegationRole = delegationRole;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountZoneDelegationRecordProps#getParentHostedZoneId}
         * @param parentHostedZoneId The hosted zone id in the parent account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentHostedZoneId(java.lang.String parentHostedZoneId) {
            this.parentHostedZoneId = parentHostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountZoneDelegationRecordProps#getTtl}
         * @param ttl The resource record cache time to live (TTL).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.core.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CrossAccountZoneDelegationRecordProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CrossAccountZoneDelegationRecordProps build() {
            return new Jsii$Proxy(delegatedZone, delegationRole, parentHostedZoneId, ttl);
        }
    }

    /**
     * An implementation for {@link CrossAccountZoneDelegationRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossAccountZoneDelegationRecordProps {
        private final software.amazon.awscdk.services.route53.IHostedZone delegatedZone;
        private final software.amazon.awscdk.services.iam.IRole delegationRole;
        private final java.lang.String parentHostedZoneId;
        private final software.amazon.awscdk.core.Duration ttl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.delegatedZone = software.amazon.jsii.Kernel.get(this, "delegatedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.delegationRole = software.amazon.jsii.Kernel.get(this, "delegationRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.parentHostedZoneId = software.amazon.jsii.Kernel.get(this, "parentHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.route53.IHostedZone delegatedZone, final software.amazon.awscdk.services.iam.IRole delegationRole, final java.lang.String parentHostedZoneId, final software.amazon.awscdk.core.Duration ttl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.delegatedZone = java.util.Objects.requireNonNull(delegatedZone, "delegatedZone is required");
            this.delegationRole = java.util.Objects.requireNonNull(delegationRole, "delegationRole is required");
            this.parentHostedZoneId = java.util.Objects.requireNonNull(parentHostedZoneId, "parentHostedZoneId is required");
            this.ttl = ttl;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getDelegatedZone() {
            return this.delegatedZone;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getDelegationRole() {
            return this.delegationRole;
        }

        @Override
        public final java.lang.String getParentHostedZoneId() {
            return this.parentHostedZoneId;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTtl() {
            return this.ttl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("delegatedZone", om.valueToTree(this.getDelegatedZone()));
            data.set("delegationRole", om.valueToTree(this.getDelegationRole()));
            data.set("parentHostedZoneId", om.valueToTree(this.getParentHostedZoneId()));
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-route53.CrossAccountZoneDelegationRecordProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CrossAccountZoneDelegationRecordProps.Jsii$Proxy that = (CrossAccountZoneDelegationRecordProps.Jsii$Proxy) o;

            if (!delegatedZone.equals(that.delegatedZone)) return false;
            if (!delegationRole.equals(that.delegationRole)) return false;
            if (!parentHostedZoneId.equals(that.parentHostedZoneId)) return false;
            return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.delegatedZone.hashCode();
            result = 31 * result + (this.delegationRole.hashCode());
            result = 31 * result + (this.parentHostedZoneId.hashCode());
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            return result;
        }
    }
}
