package software.amazon.awscdk.services.secretsmanager;

/**
 * Construction properties for an AttachedSecret.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:15.670Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.SecretTargetAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(SecretTargetAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretTargetAttachmentProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.secretsmanager.AttachedSecretOptions {

    /**
     * The secret to attach to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * @return a {@link Builder} of {@link SecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretTargetAttachmentProps> {
        private software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target;

        /**
         * Sets the value of {@link SecretTargetAttachmentProps#getSecret}
         * @param secret The secret to attach to the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link SecretTargetAttachmentProps#getTarget}
         * @param target The target to attach the secret to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder target(software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretTargetAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretTargetAttachmentProps build() {
            return new Jsii$Proxy(secret, target);
        }
    }

    /**
     * An implementation for {@link SecretTargetAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretTargetAttachmentProps {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.secretsmanager.ISecret secret, final software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secret = java.util.Objects.requireNonNull(secret, "secret is required");
            this.target = java.util.Objects.requireNonNull(target, "target is required");
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget getTarget() {
            return this.target;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secret", om.valueToTree(this.getSecret()));
            data.set("target", om.valueToTree(this.getTarget()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.SecretTargetAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretTargetAttachmentProps.Jsii$Proxy that = (SecretTargetAttachmentProps.Jsii$Proxy) o;

            if (!secret.equals(that.secret)) return false;
            return this.target.equals(that.target);
        }

        @Override
        public final int hashCode() {
            int result = this.secret.hashCode();
            result = 31 * result + (this.target.hashCode());
            return result;
        }
    }
}
