/**
 * <h1>Amazon Simple Notification Service Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Add an SNS Topic to your stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.*;
 * 
 * Topic topic = new Topic(this, "Topic", new TopicProps()
 *         .displayName("Customer subscription topic"));
 * </pre></blockquote>
 * <p>
 * Add a FIFO SNS topic with content-based de-duplication to your stack:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.*;
 * 
 * Topic topic = new Topic(this, "Topic", new TopicProps()
 *         .contentBasedDeduplication(true)
 *         .displayName("Customer subscription topic")
 *         .fifo(true)
 *         .topicName("customerTopic"));
 * </pre></blockquote>
 * <p>
 * Note that FIFO topics require a topic name to be provided. The required <code>.fifo</code> suffix will be automatically added to the topic name if it is not explicitly provided.
 * <p>
 * <h2>Subscriptions</h2>
 * <p>
 * Various subscriptions can be added to the topic by calling the
 * <code>.addSubscription(...)</code> method on the topic. It accepts a <em>subscription</em> object,
 * default implementations of which can be found in the
 * <code>&#64;aws-cdk/aws-sns-subscriptions</code> package:
 * <p>
 * Add an HTTPS Subscription to your topic:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.sns.subscriptions.*;
 * 
 * Object myTopic = new Topic(this, "MyTopic");
 * 
 * myTopic.addSubscription(new UrlSubscription("https://foobar.com/"));
 * </pre></blockquote>
 * <p>
 * Subscribe a queue to the topic:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * myTopic.addSubscription(new SqsSubscription(queue));
 * </pre></blockquote>
 * <p>
 * Note that subscriptions of queues in different accounts need to be manually confirmed by
 * reading the initial message from the queue and visiting the link found in it.
 * <p>
 * <h3>Filter policy</h3>
 * <p>
 * A filter policy can be specified when subscribing an endpoint to a topic.
 * <p>
 * Example with a Lambda subscription:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Topic myTopic = new Topic(this, "MyTopic");
 * Function fn = new Function(this, "Function", ...);
 * 
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * topic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", sns.SubscriptionFilter.stringFilter(new StringConditions()
 *                         .allowlist(asList("red", "orange"))
 *                         .matchPrefixes(asList("bl"))),
 *                 "size", sns.SubscriptionFilter.stringFilter(new StringConditions()
 *                         .denylist(asList("small", "medium"))),
 *                 "price", sns.SubscriptionFilter.numericFilter(new NumericConditions()
 *                         .between(new BetweenCondition().start(100).stop(200))
 *                         .greaterThan(300)),
 *                 "store", sns.SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h2>DLQ setup for SNS Subscription</h2>
 * <p>
 * CDK can attach provided Queue as DLQ for your SNS subscription.
 * See the <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-configure-dead-letter-queue.html">SNS DLQ configuration docs</a> for more information about this feature.
 * <p>
 * Example of usage with user provided DLQ.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Topic topic = new Topic(stack, "Topic");
 * Object dlQueue = Queue.Builder.create(stack, "DeadLetterQueue")
 *         .queueName("MySubscription_DLQ")
 *         .retentionPeriod(cdk.Duration.days(14))
 *         .build();
 * 
 * new Subscription(stack, "Subscription", new SubscriptionProps()
 *         .endpoint("endpoint")
 *         .protocol(sns.SubscriptionProtocol.getLAMBDA())
 *         .topic(topic)
 *         .deadLetterQueue(dlQueue));
 * </pre></blockquote>
 * <p>
 * <h2>CloudWatch Event Rule Target</h2>
 * <p>
 * SNS topics can be used as targets for CloudWatch event rules.
 * <p>
 * Use the <code>&#64;aws-cdk/aws-events-targets.SnsTopic</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.events.targets.*;
 * 
 * codeCommitRepository.onCommit(new SnsTopic(myTopic));
 * </pre></blockquote>
 * <p>
 * This will result in adding a target to the event rule and will also modify the
 * topic resource policy to allow CloudWatch events to publish to the topic.
 * <p>
 * <h2>Topic Policy</h2>
 * <p>
 * A topic policy is automatically created when <code>addToResourcePolicy</code> is called, if
 * one doesn't already exist. Using <code>addToResourcePolicy</code> is the simplest way to
 * add policies, but a <code>TopicPolicy</code> can also be created manually.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Topic topic = new Topic(stack, "Topic");
 * TopicPolicy topicPolicy = new TopicPolicy(stack, "TopicPolicy", new TopicPolicyProps()
 *         .topics(asList(topic)));
 * 
 * topicPolicy.document.addStatements(new PolicyStatement(new PolicyStatementProps()
 *         .actions(asList("sns:Subscribe"))
 *         .principals(asList(new AnyPrincipal()))
 *         .resources(asList(topic.getTopicArn()))));
 * </pre></blockquote>
 * <p>
 * A policy document can also be passed on <code>TopicPolicy</code> construction
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Topic topic = new Topic(stack, "Topic");
 * PolicyDocument policyDocument = new PolicyDocument(new PolicyDocumentProps()
 *         .assignSids(true)
 *         .statements(asList(
 *             new PolicyStatement(new PolicyStatementProps()
 *                     .actions(asList("sns:Subscribe"))
 *                     .principals(asList(new AnyPrincipal()))
 *                     .resources(asList(topic.getTopicArn()))))));
 * 
 * TopicPolicy topicPolicy = new TopicPolicy(this, "Policy", new TopicPolicyProps()
 *         .topics(asList(topic))
 *         .policyDocument(policyDocument));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.sns;
