package software.amazon.awscdk.services.stepfunctions;

/**
 * Represents the Wait state which delays a state machine from continuing for a specified time.
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:07:42.265Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.WaitTime")
public class WaitTime extends software.amazon.jsii.JsiiObject {

    protected WaitTime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WaitTime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Wait a fixed amount of time.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime duration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "duration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Wait for a number of seconds stored in the state object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * $.getWaitSeconds();}</pre></blockquote>
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime secondsPath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "secondsPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Wait until the given ISO8601 timestamp.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * 2016 - 03 - 14;T01:5900;Z;}</pre></blockquote>
     * <p>
     * @param timestamp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime timestamp(final @org.jetbrains.annotations.NotNull java.lang.String timestamp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "timestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(timestamp, "timestamp is required") });
    }

    /**
     * Wait until a timestamp found in the state object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * $.getWaitTimestamp();}</pre></blockquote>
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WaitTime timestampPath(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.WaitTime.class, "timestampPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WaitTime.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }
}
