package software.amazon.awscdk.services.stepfunctions;

/**
 * AWS Step Functions integrates with services directly in the Amazon States Language.
 * <p>
 * You can control these AWS services using service integration patterns:
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:06.241Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.IntegrationPattern")
public enum IntegrationPattern {
    /**
     * Step Functions will wait for an HTTP response and then progress to the next state.
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Step Functions can wait for a request to complete before progressing to the next state.
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RUN_JOB,
    /**
     * Callback tasks provide a way to pause a workflow until a task token is returned.
     * <p>
     * You must set a task token when using the callback pattern
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WAIT_FOR_TASK_TOKEN,
}
