package software.amazon.awscdk.services.stepfunctions;

/**
 * Extract a field from the State Machine data or context that gets passed around between states.
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:06.241Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.JsonPath")
public class JsonPath extends software.amazon.jsii.JsiiObject {

    protected JsonPath(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonPath(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DISCARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "DISCARD", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines if the indicated string is an encoded JSON path.
     * <p>
     * @param value string to be evaluated. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEncodedJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "isEncodedJsonPath", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Instead of using a literal string list, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "listAt", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(path, "path is required") }));
    }

    /**
     * Instead of using a literal number, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number numberAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "numberAt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Instead of using a literal string, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stringAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Special string value to discard state input, output or result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DISCARD;

    /**
     * Use the entire context data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntireContext() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entireContext", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use the entire data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntirePayload() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entirePayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the Task Token field.
     * <p>
     * External actions will need this token to report step completion
     * back to StepFunctions using the <code>SendTaskSuccess</code> or <code>SendTaskFailure</code>
     * calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getTaskToken() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "taskToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
