/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.jsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class NavigationTagsHandler
extends XDocletTagSupport {
    private JsfNavigationRule currentRule = null;
    private String fromViewId = null;
    private HashMap rules = new HashMap();

    public void forAllRules(String template) throws XDocletException {
        Collection viewRules = (Collection)this.rules.get(this.fromViewId);
        Iterator itr = viewRules.iterator();
        while (itr.hasNext()) {
            this.currentRule = (JsfNavigationRule)itr.next();
            this.generate(template);
        }
    }

    public String fromView() {
        return this.fromViewId;
    }

    public String toView() {
        return this.currentRule.getToView();
    }

    public String outcome() {
        return this.currentRule.getOutcome();
    }

    public void forAllViews(String template) throws XDocletException {
        Collection classes = NavigationTagsHandler.getXJavaDoc().getSourceClasses();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            NavigationTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)NavigationTagsHandler.getCurrentClass()) || !this.hasRule(NavigationTagsHandler.getCurrentClass())) continue;
            Iterator it = NavigationTagsHandler.getCurrentClass().getDoc().getTags("jsf.navigation").iterator();
            while (it.hasNext()) {
                XTag tag = (XTag)it.next();
                String fromView = tag.getAttributeValue("from");
                String toView = tag.getAttributeValue("to");
                String result = tag.getAttributeValue("result");
                JsfNavigationRule rule = new JsfNavigationRule(fromView, result, toView);
                ArrayList<JsfNavigationRule> r = (ArrayList<JsfNavigationRule>)this.rules.get(fromView);
                if (r == null) {
                    r = new ArrayList<JsfNavigationRule>();
                }
                r.add(rule);
                this.rules.put(fromView, r);
            }
        }
        Iterator it = this.rules.keySet().iterator();
        while (it.hasNext()) {
            this.fromViewId = it.next().toString();
            this.generate(template);
        }
    }

    private boolean hasRule(XClass clazz) {
        return clazz.getDoc().hasTag("jsf.navigation", false);
    }

    private class JsfNavigationRule {
        private String fromView = null;
        private String outcome = null;
        private String toView = null;

        public JsfNavigationRule(String fromView, String outcome, String toView) {
            this.fromView = fromView;
            this.outcome = outcome;
            this.toView = toView;
        }

        public String getFromView() {
            return this.fromView;
        }

        public String getOutcome() {
            return this.outcome;
        }

        public String getToView() {
            return this.toView;
        }
    }
}

