--
-- Copyright (c) 2015-2016, President and Fellows of Harvard College
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
-- 1. Redistributions of source code must retain the above copyright
-- notice, this list of conditions and the following disclaimer.
--
-- 2. Redistributions in binary form must reproduce the above copyright
-- notice, this list of conditions and the following disclaimer in the
-- documentation and/or other materials provided with the distribution.
--
-- 3. The name of the author may not be used to endorse or promote products
-- derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
-- MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
-- EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
-- SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
-- TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--

-- MySQL dump 10.13  Distrib 5.6.13, for osx10.6 (i386)
--
-- Host: localhost    Database: scheduler
-- ------------------------------------------------------
-- Server version	5.1.73

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activity_log`
--

DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_performed` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `performing_user` int(11) DEFAULT NULL,
  `affected_user` int(11) DEFAULT NULL,
  `affected_subject` int(11) DEFAULT NULL,
  `booked_visit` int(11) DEFAULT NULL,
  `appointment_override_reason` int(11) DEFAULT NULL,
  `affected_study` int(11) DEFAULT NULL,
  `affected_visit` int(11) DEFAULT NULL,
  `changes_detail` longtext,
  `changes_detail_required_field` longtext,
  `affected_resource` int(11) DEFAULT NULL,
  `affected_sublocation` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK611AA614EDA290BE` (`affected_subject`),
  KEY `FK611AA614DB1FAF0` (`affected_user`),
  KEY `FK611AA61429DF80A3` (`performing_user`),
  KEY `FK611AA614A8566378` (`affected_study`),
  KEY `FK611AA614955E5717` (`appointment_override_reason`),
  KEY `FK611AA61417B19716` (`affected_visit`),
  KEY `FK611AA6144267F50` (`affected_sublocation`),
  KEY `FK611AA61494C66E76` (`affected_resource`),
  KEY `FK611AA6147E838528` (`booked_visit`),
  CONSTRAINT `activity_log_0__visit_template` FOREIGN KEY (`affected_visit`) REFERENCES `visit_template` (`id`),
  CONSTRAINT `activity_log_1__user` FOREIGN KEY (`performing_user`) REFERENCES `user` (`id`),
  CONSTRAINT `activity_log_2__sublocation` FOREIGN KEY (`affected_sublocation`) REFERENCES `sublocation` (`id`),
  CONSTRAINT `activity_log_3__booked_visit` FOREIGN KEY (`booked_visit`) REFERENCES `booked_visit` (`id`),
  CONSTRAINT `activity_log_4__resource` FOREIGN KEY (`affected_resource`) REFERENCES `resource` (`id`),
  CONSTRAINT `activity_log_5__appointment_override_reason` FOREIGN KEY (`appointment_override_reason`) REFERENCES `appointment_override_reason` (`id`),
  CONSTRAINT `activity_log_6__study` FOREIGN KEY (`affected_study`) REFERENCES `study` (`id`),
  CONSTRAINT `activity_log_7__user` FOREIGN KEY (`affected_user`) REFERENCES `user` (`id`),
  CONSTRAINT `activity_log_8__subject` FOREIGN KEY (`affected_subject`) REFERENCES `subject` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1210 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_log`
--

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 11:40:25'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 11:40:26'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 11:40:29'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:08:59'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:08:59'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:09:06'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:09:09'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:09:12'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16'),'134.174.149.46',409,410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(11,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(13,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(14,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17'),'134.174.149.46',410,414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(15,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17'),'134.174.149.46',410,415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(16,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(17,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(18,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18'),'134.174.149.46',410,418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(19,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18'),'134.174.149.46',410,419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(20,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(21,'CREATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19'),'134.174.149.46',410,421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(23,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(24,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(25,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(26,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(27,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(28,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,419,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(29,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,416,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(30,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20'),'134.174.149.46',410,411,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(31,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21'),'134.174.149.46',410,412,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(32,'DEACTIVATE STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21'),'134.174.149.46',410,419,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(33,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,1,NULL,'',' Funding Source : 1 Federal PHS to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1 Center for Scientific Review (CSR) to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2001-01-01 10:00:00.0 to Mon Jan 01 10:00:00 EST 2001,  IRB Expiration: 2016-01-01 10:00:00.0 to Fri Jan 01 10:00:00 EST 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(34,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(35,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(36,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(37,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(38,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22'),'134.174.149.46',410,417,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(39,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22'),'134.174.149.46',410,411,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(40,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,2,NULL,'',' Funding Source : 1 Pilot Grant to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2002-02-02 10:00:00.0 to Sat Feb 02 10:00:00 EST 2002,  IRB Expiration: 2016-02-02 10:00:00.0 to Tue Feb 02 10:00:00 EST 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(41,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(42,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(43,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(44,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(45,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(46,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(47,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,418,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(48,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,417,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(49,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,416,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(50,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,411,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(51,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,412,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(52,'DEACTIVATE STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,418,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(53,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,3,NULL,'',' Funding Source : 1 Foundation to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2003-03-03 10:00:00.0 to Mon Mar 03 10:00:00 EST 2003,  IRB Expiration: 2016-03-03 10:00:00.0 to Thu Mar 03 10:00:00 EST 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(54,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(55,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(56,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(57,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(58,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(59,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(60,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,418,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(61,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,417,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(62,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,416,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(63,'DEACTIVATE STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27'),'134.174.149.46',410,416,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(64,'DEACTIVATE STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28'),'134.174.149.46',410,417,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(65,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,4,NULL,'',' Funding Source : 1 Industry to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2004-04-04 10:00:00.0 to Sun Apr 04 10:00:00 EDT 2004,  IRB Expiration: 2016-04-04 10:00:00.0 to Mon Apr 04 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(66,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL),(67,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL),(68,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(69,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(70,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(71,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,418,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL),(72,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,417,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL),(73,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,416,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL),(74,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,6,NULL,'',' Funding Source : 1 Industry to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to CLOSED,  IRB Approval: 2006-06-06 10:00:00.0 to Tue Jun 06 10:00:00 EDT 2006,  IRB Expiration: 2016-06-06 10:00:00.0 to Mon Jun 06 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(75,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(76,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(77,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(78,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(79,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(80,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,419,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(81,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,420,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(82,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,411,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(83,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,413,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(84,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,7,NULL,'',' Funding Source : 1 Foundation to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2003-03-03 10:00:00.0 to Mon Mar 03 10:00:00 EST 2003,  IRB Expiration: 2016-03-03 10:00:00.0 to Thu Mar 03 10:00:00 EST 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(85,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(86,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(87,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(88,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(89,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,420,NULL,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(90,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32'),'134.174.149.46',410,421,NULL,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(91,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,8,NULL,'',' Funding Source : 1 Industry to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2004-04-04 10:00:00.0 to Sun Apr 04 10:00:00 EDT 2004,  IRB Expiration: 2016-04-04 10:00:00.0 to Mon Apr 04 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(92,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(93,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(94,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(95,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(96,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,419,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(97,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,421,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(98,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,413,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(99,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,9,NULL,'',' Funding Source : 1 Foundation to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2005-05-05 10:00:00.0 to Thu May 05 10:00:00 EDT 2005,  IRB Expiration: 2016-05-05 10:00:00.0 to Thu May 05 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(100,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL),(101,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL),(102,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(103,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(104,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(105,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(106,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(107,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,417,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL),(108,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,416,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL),(109,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,411,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL),(110,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,412,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL),(111,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,11,NULL,'',' Funding Source : 1 Institutional/Departmental Funds to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2006-06-06 10:00:00.0 to Tue Jun 06 10:00:00 EDT 2006,  IRB Expiration: 2016-06-06 10:00:00.0 to Mon Jun 06 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(112,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL),(113,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(114,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(115,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(116,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(117,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(118,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,417,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL),(119,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,416,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL),(120,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37'),'134.174.149.46',410,411,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL),(121,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38'),'134.174.149.46',410,412,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL),(122,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,12,NULL,'',' Funding Source : 1 Institutional/Departmental Funds to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2006-06-06 10:00:00.0 to Tue Jun 06 10:00:00 EDT 2006,  IRB Expiration: 2016-06-06 10:00:00.0 to Mon Jun 06 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(123,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL),(124,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(125,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(126,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(127,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(128,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(129,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,417,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL),(130,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,416,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL),(131,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,411,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL),(132,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39'),'134.174.149.46',410,412,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL),(133,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40'),'134.174.149.46',410,NULL,NULL,NULL,NULL,13,NULL,'',' Funding Source : 1 Institutional/Departmental Funds to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2006-06-06 10:00:00.0 to Tue Jun 06 10:00:00 EDT 2006,  IRB Expiration: 2016-06-06 10:00:00.0 to Mon Jun 06 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(134,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40'),'134.174.149.46',410,NULL,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL,NULL),(135,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(136,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(137,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(138,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(139,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(140,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,417,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL,NULL),(141,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,416,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL,NULL),(142,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,411,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL,NULL),(143,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41'),'134.174.149.46',410,412,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL,NULL),(144,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:42'),'134.174.149.46',410,NULL,NULL,NULL,NULL,14,NULL,'',' Funding Source : 1 Institutional/Departmental Funds to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2006-06-06 10:00:00.0 to Tue Jun 06 10:00:00 EDT 2006,  IRB Expiration: 2016-06-06 10:00:00.0 to Mon Jun 06 10:00:00 EDT 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(145,'CREATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:42'),'134.174.149.46',410,NULL,NULL,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(146,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(147,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(148,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(149,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45'),'134.174.149.46',410,421,NULL,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(150,'ADD STUDY MEMBER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45'),'134.174.149.46',410,411,NULL,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(151,'UPDATE STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45'),'134.174.149.46',410,NULL,NULL,NULL,NULL,15,NULL,'',' Funding Source : 1 Foundation to null,  Funding Source GrantId: 1  to ,  Funding Source Site Cost Center: 1  to ,  Funding Source Direct Award: 1 null to null,  Funding Source Indirect Award: 1 null to null,  Funding Source Project Start Date: 1 null to null,  Funding Source Project End Date: 1 null to null,  Funding Source Centers And Institutes: 1  NULL  to null,  Funding Source : 2  NULL  to  NULL ,  Funding Source GrantId: 2  NULL  to  NULL ,  Funding Source Site Cost Center: 2  NULL  to  NULL ,  Funding Source Direct Award: 2  NULL  to  NULL ,  Funding Source Indirect Award: 2  NULL  to  NULL ,  Funding Source Project Start Date: 2  NULL  to  NULL ,  Funding Source Project End Date: 2  NULL  to  NULL ,  Funding Source Centers And Institutes: 2  NULL  to  NULL ,  Funding Source : 3  NULL  to  NULL ,  Funding Source GrantId: 3  NULL  to  NULL ,  Funding Source Site Cost Center: 3  NULL  to  NULL ,  Funding Source Direct Award: 3  NULL  to  NULL ,  Funding Source Indirect Award: 3  NULL  to  NULL ,  Funding Source Project Start Date: 3  NULL  to  NULL ,  Funding Source Project End Date: 3  NULL  to  NULL ,  Funding Source Centers And Institutes: 3  NULL  to  NULL ,  Funding Source : 4  NULL  to  NULL ,  Funding Source GrantId: 4  NULL  to  NULL ,  Funding Source Site Cost Center: 4  NULL  to  NULL ,  Funding Source Direct Award: 4  NULL  to  NULL ,  Funding Source Indirect Award: 4  NULL  to  NULL ,  Funding Source Project Start Date: 4  NULL  to  NULL ,  Funding Source Project End Date: 4  NULL  to  NULL ,  Funding Source Centers And Institutes: 4  NULL  to  NULL ,  Study Status IRB_PROCESS to OPEN,  IRB Approval: 2003-03-03 10:00:00.0 to Mon Mar 03 10:00:00 EST 2003,  IRB Expiration: 2016-03-03 10:00:00.0 to Thu Mar 03 10:00:00 EST 2016,  Protocol Nurse:  NULL ,  Protocol Nutritionist:  NULL ,  Scheduler:  NULL ,  Investigator:  NULL ,  Scheduler 3:  NULL ,  Secondary Scheduler:  NULL ,  Physician:  NULL ,  Physician 2:  NULL ,  Associate Nurse:  NULL ,  Associate Protocol Nutritionist:  NULL , ',NULL,NULL),(152,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46'),'134.174.149.46',410,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(153,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46'),'134.174.149.46',410,NULL,1,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(154,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46'),'134.174.149.46',410,NULL,1,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(155,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46'),'134.174.149.46',410,NULL,1,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(156,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),'134.174.149.46',410,NULL,1,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(157,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),'134.174.149.46',410,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(158,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),'134.174.149.46',410,NULL,2,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(159,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),'134.174.149.46',410,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(160,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),'134.174.149.46',410,NULL,3,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(161,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),'134.174.149.46',410,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(162,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),'134.174.149.46',410,NULL,4,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(163,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),'134.174.149.46',410,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(164,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),'134.174.149.46',410,NULL,5,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(165,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),'134.174.149.46',410,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(166,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),'134.174.149.46',410,NULL,6,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(167,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),'134.174.149.46',410,NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(168,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),'134.174.149.46',410,NULL,7,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(169,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(170,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,8,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(171,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(172,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,9,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(173,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(174,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),'134.174.149.46',410,NULL,10,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(175,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),'134.174.149.46',410,NULL,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(176,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),'134.174.149.46',410,NULL,11,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(177,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),'134.174.149.46',410,NULL,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(178,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),'134.174.149.46',410,NULL,12,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL),(179,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(180,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,13,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(181,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(182,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,14,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(183,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(184,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),'134.174.149.46',410,NULL,15,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(185,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),'134.174.149.46',410,NULL,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(186,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),'134.174.149.46',410,NULL,16,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(187,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),'134.174.149.46',410,NULL,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(188,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),'134.174.149.46',410,NULL,17,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(189,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),'134.174.149.46',410,NULL,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(190,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),'134.174.149.46',410,NULL,18,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL),(191,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),'134.174.149.46',410,NULL,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(192,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),'134.174.149.46',410,NULL,19,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(193,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),'134.174.149.46',410,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(194,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),'134.174.149.46',410,NULL,20,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(195,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),'134.174.149.46',410,NULL,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(196,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),'134.174.149.46',410,NULL,21,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(197,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),'134.174.149.46',410,NULL,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(198,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),'134.174.149.46',410,NULL,22,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(199,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),'134.174.149.46',410,NULL,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(200,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),'134.174.149.46',410,NULL,23,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(201,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),'134.174.149.46',410,NULL,24,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(202,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),'134.174.149.46',410,NULL,24,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(203,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),'134.174.149.46',410,NULL,25,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(204,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),'134.174.149.46',410,NULL,25,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL),(205,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),'134.174.149.46',410,NULL,26,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(206,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),'134.174.149.46',410,NULL,27,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(207,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),'134.174.149.46',410,NULL,28,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(208,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),'134.174.149.46',410,NULL,29,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(209,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58'),'134.174.149.46',410,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(210,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58'),'134.174.149.46',410,NULL,31,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(211,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58'),'134.174.149.46',410,NULL,31,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(212,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59'),'134.174.149.46',410,NULL,31,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(213,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59'),'134.174.149.46',410,NULL,31,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(214,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59'),'134.174.149.46',410,NULL,31,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(215,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00'),'134.174.149.46',410,NULL,32,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(216,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00'),'134.174.149.46',410,NULL,32,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(217,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00'),'134.174.149.46',410,NULL,32,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(218,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),'134.174.149.46',410,NULL,33,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(219,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),'134.174.149.46',410,NULL,33,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(220,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),'134.174.149.46',410,NULL,33,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(221,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),'134.174.149.46',410,NULL,34,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(222,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),'134.174.149.46',410,NULL,34,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(223,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'),'134.174.149.46',410,NULL,34,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL),(224,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'),'134.174.149.46',410,NULL,35,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(225,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'),'134.174.149.46',410,NULL,35,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(226,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(227,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,36,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(228,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,37,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(229,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,37,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(230,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(231,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),'134.174.149.46',410,NULL,38,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL),(232,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),'134.174.149.46',410,NULL,39,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(233,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),'134.174.149.46',410,NULL,39,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(234,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),'134.174.149.46',410,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(235,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),'134.174.149.46',410,NULL,40,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(236,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,41,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(237,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,41,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(238,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,42,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(239,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,42,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL),(240,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,43,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(241,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),'134.174.149.46',410,NULL,43,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL),(242,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),'134.174.149.46',410,NULL,44,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(243,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),'134.174.149.46',410,NULL,44,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL),(244,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),'134.174.149.46',410,NULL,45,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(245,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),'134.174.149.46',410,NULL,45,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL),(246,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'134.174.149.46',410,NULL,46,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(247,'ADD STUDY SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'134.174.149.46',410,NULL,46,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL),(248,'CREATE SUBJECT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'134.174.149.46',410,NULL,47,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(249,'CREATE VISIT : Out TA-001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL),(250,'CREATE VISIT : Out TA-001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL),(251,'CREATE VISIT : Out TA-001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL),(252,'CREATE VISIT : Out TA-001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL),(253,'CREATE VISIT : In TA-001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL),(254,'CREATE VISIT : In TA-001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(255,'CREATE VISIT : In TA-001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL),(256,'CREATE VISIT : In TA-001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,8,NULL,NULL,NULL,NULL),(257,'CREATE VISIT : Out TA-002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL),(258,'CREATE VISIT : Out TA-002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,10,NULL,NULL,NULL,NULL),(259,'CREATE VISIT : Out TA-002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL),(260,'CREATE VISIT : Out TA-002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL),(261,'CREATE VISIT : In TA-002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL),(262,'CREATE VISIT : In TA-002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,14,NULL,NULL,NULL,NULL),(263,'CREATE VISIT : In TA-002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,15,NULL,NULL,NULL,NULL),(264,'CREATE VISIT : In TA-002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL),(265,'CREATE VISIT : Out AS001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,17,NULL,NULL,NULL,NULL),(266,'CREATE VISIT : Out AS001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,18,NULL,NULL,NULL,NULL),(267,'CREATE VISIT : Out AS001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,19,NULL,NULL,NULL,NULL),(268,'CREATE VISIT : Out AS001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,20,NULL,NULL,NULL,NULL),(269,'CREATE VISIT : In AS001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,21,NULL,NULL,NULL,NULL),(270,'CREATE VISIT : In AS001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,22,NULL,NULL,NULL,NULL),(271,'CREATE VISIT : In AS001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,23,NULL,NULL,NULL,NULL),(272,'CREATE VISIT : In AS001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,24,NULL,NULL,NULL,NULL),(273,'CREATE VISIT : Out AS002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,25,NULL,NULL,NULL,NULL),(274,'CREATE VISIT : Out AS002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,26,NULL,NULL,NULL,NULL),(275,'CREATE VISIT : Out AS002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,27,NULL,NULL,NULL,NULL),(276,'CREATE VISIT : Out AS002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,28,NULL,NULL,NULL,NULL),(277,'CREATE VISIT : In AS002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,29,NULL,NULL,NULL,NULL),(278,'CREATE VISIT : In AS002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,30,NULL,NULL,NULL,NULL),(279,'CREATE VISIT : In AS002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,31,NULL,NULL,NULL,NULL),(280,'CREATE VISIT : In AS002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL),(281,'CREATE VISIT : Out TB-003 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,33,NULL,NULL,NULL,NULL),(282,'CREATE VISIT : In RT TB-003 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,34,NULL,NULL,NULL,NULL),(283,'CREATE VISIT : In TB-003 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,35,NULL,NULL,NULL,NULL),(284,'CREATE VISIT : Out TC-004 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,36,NULL,NULL,NULL,NULL),(285,'CREATE VISIT : In RT TC-004 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,37,NULL,NULL,NULL,NULL),(286,'CREATE VISIT : In TC-004 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,38,NULL,NULL,NULL,NULL),(287,'CREATE VISIT : Out TD-005 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,39,NULL,NULL,NULL,NULL),(288,'CREATE VISIT : In RT TD-005 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,40,NULL,NULL,NULL,NULL),(289,'CREATE VISIT : In TD-005 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,41,NULL,NULL,NULL,NULL),(290,'CREATE VISIT : Out TC-006 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,42,NULL,NULL,NULL,NULL),(291,'CREATE VISIT : In RT TC-006 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,43,NULL,NULL,NULL,NULL),(292,'CREATE VISIT : In TC-006 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,44,NULL,NULL,NULL,NULL),(293,'CREATE VISIT : Out AS003 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,45,NULL,NULL,NULL,NULL),(294,'CREATE VISIT : In RT AS003 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,46,NULL,NULL,NULL,NULL),(295,'CREATE VISIT : In AS003 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,47,NULL,NULL,NULL,NULL),(296,'CREATE VISIT : Out AS004 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,48,NULL,NULL,NULL,NULL),(297,'CREATE VISIT : In RT AS004 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,49,NULL,NULL,NULL,NULL),(298,'CREATE VISIT : In AS004 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,50,NULL,NULL,NULL,NULL),(299,'CREATE VISIT : Out Fixed Short by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,51,NULL,NULL,NULL,NULL),(300,'CREATE VISIT : Out Fixed Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,52,NULL,NULL,NULL,NULL),(301,'CREATE VISIT : Out Float Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,53,NULL,NULL,NULL,NULL),(302,'CREATE VISIT : Out Float Single Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,54,NULL,NULL,NULL,NULL),(303,'CREATE VISIT : Out Float Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,55,NULL,NULL,NULL,NULL),(304,'CREATE VISIT : Out Float Linked Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,56,NULL,NULL,NULL,NULL),(305,'CREATE VISIT : Out Flex Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,57,NULL,NULL,NULL,NULL),(306,'CREATE VISIT : Out Flex Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,58,NULL,NULL,NULL,NULL),(307,'CREATE VISIT : Out Flex Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,59,NULL,NULL,NULL,NULL),(308,'CREATE VISIT : Out Flex Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,60,NULL,NULL,NULL,NULL),(309,'CREATE VISIT : Out Resource Blocker Short by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,61,NULL,NULL,NULL,NULL),(310,'CREATE VISIT : Out Resource Blocker 3 Times by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,62,NULL,NULL,NULL,NULL),(311,'CREATE VISIT : Out Room Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,63,NULL,NULL,NULL,NULL),(312,'CREATE VISIT : Out All Rooms by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL),(313,'CREATE VISIT : Out Double Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,65,NULL,NULL,NULL,NULL),(314,'CREATE VISIT : Out Male Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,66,NULL,NULL,NULL,NULL),(315,'CREATE VISIT : Out Female Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,67,NULL,NULL,NULL,NULL),(316,'CREATE VISIT : Out Fixed Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,68,NULL,NULL,NULL,NULL),(317,'CREATE VISIT : Out Flex Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,69,NULL,NULL,NULL,NULL),(318,'CREATE VISIT : Out Float Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,70,NULL,NULL,NULL,NULL),(319,'CREATE VISIT : Out Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,71,NULL,NULL,NULL,NULL),(320,'CREATE VISIT : Out All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,72,NULL,NULL,NULL,NULL),(321,'CREATE VISIT : Out Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,73,NULL,NULL,NULL,NULL),(322,'CREATE VISIT : Out Fifty Resources by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,74,NULL,NULL,NULL,NULL),(323,'CREATE VISIT : In Fixed by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,75,NULL,NULL,NULL,NULL),(324,'CREATE VISIT : In Fixed Time Gap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,76,NULL,NULL,NULL,NULL),(325,'CREATE VISIT : In Fixed QTY Change by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,77,NULL,NULL,NULL,NULL),(326,'CREATE VISIT : In Fixed Midnight Start by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,78,NULL,NULL,NULL,NULL),(327,'CREATE VISIT : In Fixed Midnight Overlap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,79,NULL,NULL,NULL,NULL),(328,'CREATE VISIT : In Float Day Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,80,NULL,NULL,NULL,NULL),(329,'CREATE VISIT : In Float Overnight Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,81,NULL,NULL,NULL,NULL),(330,'CREATE VISIT : In Float Midnight Overlap  Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,82,NULL,NULL,NULL,NULL),(331,'CREATE VISIT : In Float Day Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,83,NULL,NULL,NULL,NULL),(332,'CREATE VISIT : In Float  Overnight Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,84,NULL,NULL,NULL,NULL),(333,'CREATE VISIT : In Float Midnight Overlap  Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,85,NULL,NULL,NULL,NULL),(334,'CREATE VISIT : In Float QTY Change Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,86,NULL,NULL,NULL,NULL),(335,'CREATE VISIT : In Float QTY Change Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,87,NULL,NULL,NULL,NULL),(336,'CREATE VISIT : In Flex Day Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,88,NULL,NULL,NULL,NULL),(337,'CREATE VISIT : In Flex Overnight Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,89,NULL,NULL,NULL,NULL),(338,'CREATE VISIT : In Flex Midnight Overlap Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,90,NULL,NULL,NULL,NULL),(339,'CREATE VISIT : In Flex Day Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,91,NULL,NULL,NULL,NULL),(340,'CREATE VISIT : In Flex Overnight Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,92,NULL,NULL,NULL,NULL),(341,'CREATE VISIT : In Flex Midnight Overlap Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,93,NULL,NULL,NULL,NULL),(342,'CREATE VISIT : In Flex Day Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,94,NULL,NULL,NULL,NULL),(343,'CREATE VISIT : In Flex Overnight Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,95,NULL,NULL,NULL,NULL),(344,'CREATE VISIT : In Flex Midnight Overlap Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,96,NULL,NULL,NULL,NULL),(345,'CREATE VISIT : In Flex Day Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,97,NULL,NULL,NULL,NULL),(346,'CREATE VISIT : In Flex Overnight Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,98,NULL,NULL,NULL,NULL),(347,'CREATE VISIT : In Flex Midnight Overlap Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,99,NULL,NULL,NULL,NULL),(348,'CREATE VISIT : In Flex QTY Change Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,100,NULL,NULL,NULL,NULL),(349,'CREATE VISIT : In Flex QTY Change Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,101,NULL,NULL,NULL,NULL),(350,'CREATE VISIT : In Flex QTY Change Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,102,NULL,NULL,NULL,NULL),(351,'CREATE VISIT : In Flex QTY Change  Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,103,NULL,NULL,NULL,NULL),(352,'CREATE VISIT : In Day Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,104,NULL,NULL,NULL,NULL),(353,'CREATE VISIT : In 11:30 PM Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,105,NULL,NULL,NULL,NULL),(354,'CREATE VISIT : In Midnight Overlap Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,106,NULL,NULL,NULL,NULL),(355,'CREATE VISIT : In Fixed Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,107,NULL,NULL,NULL,NULL),(356,'CREATE VISIT : In Flex Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,108,NULL,NULL,NULL,NULL),(357,'CREATE VISIT : In Float Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,109,NULL,NULL,NULL,NULL),(358,'CREATE VISIT : In Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,110,NULL,NULL,NULL,NULL),(359,'CREATE VISIT : In All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,111,NULL,NULL,NULL,NULL),(360,'CREATE VISIT : In Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,112,NULL,NULL,NULL,NULL),(361,'CREATE VISIT : In 30 Day by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,113,NULL,NULL,NULL,NULL),(362,'CREATE VISIT : In Fixed  RT by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,114,NULL,NULL,NULL,NULL),(363,'CREATE VISIT : In Fixed  RT Time Gap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,115,NULL,NULL,NULL,NULL),(364,'CREATE VISIT : In Fixed RT QTY Change by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,116,NULL,NULL,NULL,NULL),(365,'CREATE VISIT : In Float RT Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,117,NULL,NULL,NULL,NULL),(366,'CREATE VISIT : In Float RT Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,118,NULL,NULL,NULL,NULL),(367,'CREATE VISIT : In Float  RT QTY Change Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,119,NULL,NULL,NULL,NULL),(368,'CREATE VISIT : In Float RT QTY Change Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,120,NULL,NULL,NULL,NULL),(369,'CREATE VISIT : In Flex  RT Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,121,NULL,NULL,NULL,NULL),(370,'CREATE VISIT : In Flex RT Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,122,NULL,NULL,NULL,NULL),(371,'CREATE VISIT : In Flex  RT Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,123,NULL,NULL,NULL,NULL),(372,'CREATE VISIT : In Flex RT Overnight Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,124,NULL,NULL,NULL,NULL),(373,'CREATE VISIT : In Flex RT Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,125,NULL,NULL,NULL,NULL),(374,'CREATE VISIT : In Flex  RT QTY Change Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,126,NULL,NULL,NULL,NULL),(375,'CREATE VISIT : In Flex RT QTY Change Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,127,NULL,NULL,NULL,NULL),(376,'CREATE VISIT : In Flex RT QTY Change Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,128,NULL,NULL,NULL,NULL),(377,'CREATE VISIT : In Flex RT QTY Change  Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,129,NULL,NULL,NULL,NULL),(378,'CREATE VISIT : In room blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,130,NULL,NULL,NULL,NULL),(379,'CREATE VISIT : In All Rooms by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,131,NULL,NULL,NULL,NULL),(380,'CREATE VISIT : In Double Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,132,NULL,NULL,NULL,NULL),(381,'CREATE VISIT : In Male Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,133,NULL,NULL,NULL,NULL),(382,'CREATE VISIT : In Female Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,134,NULL,NULL,NULL,NULL),(383,'CREATE VISIT : In RT Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,135,NULL,NULL,NULL,NULL),(384,'CREATE VISIT : In RT All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL),(385,'CREATE VISIT : In RT Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,137,NULL,NULL,NULL,NULL),(386,'CREATE VISIT : In RT 30 day by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,138,NULL,NULL,NULL,NULL),(387,'APPROVED VISIT TEMPLATE : Out TA-001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL),(388,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,1,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(389,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,1,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(390,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,1,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(391,'APPROVED VISIT TEMPLATE : Out TA-001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL),(392,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,2,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(393,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,2,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(394,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,2,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(395,'APPROVED VISIT TEMPLATE : Out TA-001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,NULL),(396,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,3,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(397,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,3,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(398,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,3,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(399,'APPROVED VISIT TEMPLATE : In TA-001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL),(400,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,5,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(401,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,5,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(402,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,5,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(403,'APPROVED VISIT TEMPLATE : In TA-001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(404,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,6,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(405,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,6,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(406,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,6,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(407,'APPROVED VISIT TEMPLATE : In TA-001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL),(408,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,7,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(409,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,7,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(410,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,7,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(411,'APPROVED VISIT TEMPLATE : In TA-001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,8,NULL,NULL,NULL,NULL),(412,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,8,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(413,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,8,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(414,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,8,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(415,'APPROVED VISIT TEMPLATE : Out TA-002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,9,NULL,NULL,NULL,NULL),(416,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,9,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(417,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,9,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(418,'APPROVED VISIT TEMPLATE : Out TA-002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,10,NULL,NULL,NULL,NULL),(419,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,10,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(420,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,10,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(421,'APPROVED VISIT TEMPLATE : Out TA-002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,11,NULL,NULL,NULL,NULL),(422,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,11,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(423,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,11,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(424,'APPROVED VISIT TEMPLATE : Out TA-002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,12,NULL,NULL,NULL,NULL),(425,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,12,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(426,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,12,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(427,'APPROVED VISIT TEMPLATE : In TA-002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,13,NULL,NULL,NULL,NULL),(428,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,13,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(429,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,13,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(430,'APPROVED VISIT TEMPLATE : In TA-002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,15,NULL,NULL,NULL,NULL),(431,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,15,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(432,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,15,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(433,'APPROVED VISIT TEMPLATE : In TA-002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL),(434,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,16,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(435,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,16,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(436,'APPROVED VISIT TEMPLATE : Out AS001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,17,NULL,NULL,NULL,NULL),(437,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,17,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(438,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,17,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(439,'APPROVED VISIT TEMPLATE : Out AS001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,18,NULL,NULL,NULL,NULL),(440,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,18,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(441,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,18,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(442,'APPROVED VISIT TEMPLATE : Out AS001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,19,NULL,NULL,NULL,NULL),(443,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,19,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(444,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,19,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(445,'APPROVED VISIT TEMPLATE : In AS001 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,21,NULL,NULL,NULL,NULL),(446,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,21,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(447,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,21,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(448,'APPROVED VISIT TEMPLATE : In AS001 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,22,NULL,NULL,NULL,NULL),(449,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,22,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(450,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,22,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(451,'APPROVED VISIT TEMPLATE : In AS001 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,23,NULL,NULL,NULL,NULL),(452,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,23,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(453,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,23,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(454,'APPROVED VISIT TEMPLATE : In AS001 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,24,NULL,NULL,NULL,NULL),(455,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,24,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(456,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,24,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(457,'APPROVED VISIT TEMPLATE : Out AS002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,25,NULL,NULL,NULL,NULL),(458,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,25,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(459,'APPROVED VISIT TEMPLATE : Out AS002 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,26,NULL,NULL,NULL,NULL),(460,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,26,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(461,'APPROVED VISIT TEMPLATE : Out AS002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,27,NULL,NULL,NULL,NULL),(462,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,27,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(463,'APPROVED VISIT TEMPLATE : Out AS002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,28,NULL,NULL,NULL,NULL),(464,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,28,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(465,'APPROVED VISIT TEMPLATE : In AS002 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,29,NULL,NULL,NULL,NULL),(466,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,29,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(467,'APPROVED VISIT TEMPLATE : In AS002 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,31,NULL,NULL,NULL,NULL),(468,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,31,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(469,'APPROVED VISIT TEMPLATE : In AS002 Off Institution by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL),(470,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'134.174.149.46',410,420,NULL,NULL,NULL,NULL,32,NULL,' Email : aps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(471,'APPROVED VISIT TEMPLATE : Out TB-003 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,33,NULL,NULL,NULL,NULL),(472,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,33,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(473,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,33,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(474,'APPROVED VISIT TEMPLATE : In RT TB-003 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,34,NULL,NULL,NULL,NULL),(475,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,34,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(476,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,34,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(477,'APPROVED VISIT TEMPLATE : In TB-003 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,35,NULL,NULL,NULL,NULL),(478,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,35,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(479,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,35,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(480,'APPROVED VISIT TEMPLATE : Out TC-004 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,36,NULL,NULL,NULL,NULL),(481,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,36,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(482,'APPROVED VISIT TEMPLATE : In RT TC-004 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,37,NULL,NULL,NULL,NULL),(483,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,37,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(484,'APPROVED VISIT TEMPLATE : In TC-004 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,38,NULL,NULL,NULL,NULL),(485,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,38,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(486,'APPROVED VISIT TEMPLATE : Out TD-005 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,39,NULL,NULL,NULL,NULL),(487,'APPROVED VISIT TEMPLATE : In RT TD-005 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,40,NULL,NULL,NULL,NULL),(488,'APPROVED VISIT TEMPLATE : In TD-005 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,41,NULL,NULL,NULL,NULL),(489,'APPROVED VISIT TEMPLATE : Out TC-006 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,42,NULL,NULL,NULL,NULL),(490,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,42,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(491,'APPROVED VISIT TEMPLATE : In TC-006 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,44,NULL,NULL,NULL,NULL),(492,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,417,NULL,NULL,NULL,NULL,44,NULL,' Email : ps456@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(493,'APPROVED VISIT TEMPLATE : Out AS003 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,45,NULL,NULL,NULL,NULL),(494,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,45,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(495,'APPROVED VISIT TEMPLATE : In RT AS003 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,46,NULL,NULL,NULL,NULL),(496,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,46,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(497,'APPROVED VISIT TEMPLATE : In AS003 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,47,NULL,NULL,NULL,NULL),(498,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,413,NULL,NULL,NULL,NULL,47,NULL,' Email : bs123@fakek.edu and Role : Scheduler',NULL,NULL),(499,'APPROVED VISIT TEMPLATE : Out AS004 Non CRC by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,48,NULL,NULL,NULL,NULL),(500,'APPROVED VISIT TEMPLATE : In RT AS004 WHT 13 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,49,NULL,NULL,NULL,NULL),(501,'APPROVED VISIT TEMPLATE : In AS004 CNY by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,50,NULL,NULL,NULL,NULL),(502,'APPROVED VISIT TEMPLATE : Out Fixed Short by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,51,NULL,NULL,NULL,NULL),(503,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,51,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(504,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,51,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(505,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,51,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(506,'APPROVED VISIT TEMPLATE : Out Fixed Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,52,NULL,NULL,NULL,NULL),(507,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,52,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(508,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,52,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(509,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,52,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(510,'APPROVED VISIT TEMPLATE : Out Float Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,53,NULL,NULL,NULL,NULL),(511,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,53,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(512,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,53,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(513,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,53,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(514,'APPROVED VISIT TEMPLATE : Out Float Single Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,54,NULL,NULL,NULL,NULL),(515,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,54,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(516,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,54,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(517,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,54,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(518,'APPROVED VISIT TEMPLATE : Out Float Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,55,NULL,NULL,NULL,NULL),(519,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,55,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(520,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,55,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(521,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,55,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(522,'APPROVED VISIT TEMPLATE : Out Float Linked Long by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,56,NULL,NULL,NULL,NULL),(523,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,56,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(524,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,56,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(525,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,56,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(526,'APPROVED VISIT TEMPLATE : Out Flex Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,57,NULL,NULL,NULL,NULL),(527,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,57,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(528,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,57,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(529,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,57,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(530,'APPROVED VISIT TEMPLATE : Out Flex Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,58,NULL,NULL,NULL,NULL),(531,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,58,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(532,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,58,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(533,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,58,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(534,'APPROVED VISIT TEMPLATE : Out Flex Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,59,NULL,NULL,NULL,NULL),(535,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,59,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(536,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,59,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(537,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,59,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(538,'APPROVED VISIT TEMPLATE : Out Flex Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,60,NULL,NULL,NULL,NULL),(539,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,60,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(540,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,60,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(541,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,60,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(542,'APPROVED VISIT TEMPLATE : Out Resource Blocker Short by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,61,NULL,NULL,NULL,NULL),(543,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,61,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(544,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,61,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(545,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,61,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(546,'APPROVED VISIT TEMPLATE : Out Resource Blocker 3 Times by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,62,NULL,NULL,NULL,NULL),(547,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,62,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(548,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,62,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(549,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,62,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(550,'APPROVED VISIT TEMPLATE : Out Room Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,63,NULL,NULL,NULL,NULL),(551,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,63,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(552,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,63,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(553,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,63,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(554,'APPROVED VISIT TEMPLATE : Out All Rooms by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL),(555,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,64,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(556,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,64,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(557,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,64,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(558,'APPROVED VISIT TEMPLATE : Out Double Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,65,NULL,NULL,NULL,NULL),(559,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,65,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(560,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,65,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(561,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,65,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(562,'APPROVED VISIT TEMPLATE : Out Male Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,66,NULL,NULL,NULL,NULL),(563,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,66,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(564,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,66,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(565,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,66,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(566,'APPROVED VISIT TEMPLATE : Out Female Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,67,NULL,NULL,NULL,NULL),(567,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,67,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(568,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,67,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(569,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,67,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(570,'APPROVED VISIT TEMPLATE : Out Fixed Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,68,NULL,NULL,NULL,NULL),(571,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,68,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(572,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,68,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(573,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,68,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(574,'APPROVED VISIT TEMPLATE : Out Flex Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,69,NULL,NULL,NULL,NULL),(575,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,69,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(576,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,69,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(577,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,69,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(578,'APPROVED VISIT TEMPLATE : Out Float Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,70,NULL,NULL,NULL,NULL),(579,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,70,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(580,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,70,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(581,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,70,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(582,'APPROVED VISIT TEMPLATE : Out Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,71,NULL,NULL,NULL,NULL),(583,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,71,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(584,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,71,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(585,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,71,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(586,'APPROVED VISIT TEMPLATE : Out All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,72,NULL,NULL,NULL,NULL),(587,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,72,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(588,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,72,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(589,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,72,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(590,'APPROVED VISIT TEMPLATE : Out Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,73,NULL,NULL,NULL,NULL),(591,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,73,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(592,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,73,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(593,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,73,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(594,'APPROVED VISIT TEMPLATE : Out Fifty Resources by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,74,NULL,NULL,NULL,NULL),(595,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,74,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(596,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,74,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(597,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,74,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(598,'APPROVED VISIT TEMPLATE : In Fixed by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,75,NULL,NULL,NULL,NULL),(599,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,75,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(600,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,75,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(601,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,75,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(602,'APPROVED VISIT TEMPLATE : In Fixed Time Gap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,76,NULL,NULL,NULL,NULL),(603,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,76,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(604,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,76,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(605,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,76,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(606,'APPROVED VISIT TEMPLATE : In Fixed QTY Change by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,77,NULL,NULL,NULL,NULL),(607,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,77,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(608,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,77,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(609,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,77,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(610,'APPROVED VISIT TEMPLATE : In Fixed Midnight Start by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,78,NULL,NULL,NULL,NULL),(611,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,78,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(612,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,78,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(613,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,78,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(614,'APPROVED VISIT TEMPLATE : In Fixed Midnight Overlap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,79,NULL,NULL,NULL,NULL),(615,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,79,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(616,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,79,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(617,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,79,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(618,'APPROVED VISIT TEMPLATE : In Float Day Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,80,NULL,NULL,NULL,NULL),(619,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,80,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(620,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,80,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(621,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,80,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(622,'APPROVED VISIT TEMPLATE : In Float Overnight Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,81,NULL,NULL,NULL,NULL),(623,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,81,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(624,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,81,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(625,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,81,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(626,'APPROVED VISIT TEMPLATE : In Float Midnight Overlap  Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,82,NULL,NULL,NULL,NULL),(627,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,82,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(628,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,82,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(629,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,82,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(630,'APPROVED VISIT TEMPLATE : In Float Day Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,83,NULL,NULL,NULL,NULL),(631,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,83,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(632,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,83,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(633,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,83,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(634,'APPROVED VISIT TEMPLATE : In Float  Overnight Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,84,NULL,NULL,NULL,NULL),(635,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,84,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(636,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,84,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(637,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,84,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(638,'APPROVED VISIT TEMPLATE : In Float Midnight Overlap  Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,85,NULL,NULL,NULL,NULL),(639,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,85,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(640,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,85,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(641,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,85,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(642,'APPROVED VISIT TEMPLATE : In Float QTY Change Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,86,NULL,NULL,NULL,NULL),(643,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,86,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(644,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,86,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(645,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,86,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(646,'APPROVED VISIT TEMPLATE : In Float QTY Change Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,87,NULL,NULL,NULL,NULL),(647,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,87,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(648,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,87,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(649,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,87,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(650,'APPROVED VISIT TEMPLATE : In Flex Day Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,88,NULL,NULL,NULL,NULL),(651,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,88,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(652,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,88,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(653,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,88,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(654,'APPROVED VISIT TEMPLATE : In Flex Overnight Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,89,NULL,NULL,NULL,NULL),(655,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,89,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(656,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,89,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(657,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,89,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(658,'APPROVED VISIT TEMPLATE : In Flex Midnight Overlap Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,90,NULL,NULL,NULL,NULL),(659,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,90,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(660,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,90,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(661,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,90,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(662,'APPROVED VISIT TEMPLATE : In Flex Day Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,91,NULL,NULL,NULL,NULL),(663,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,91,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(664,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,91,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(665,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,91,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(666,'APPROVED VISIT TEMPLATE : In Flex Overnight Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,92,NULL,NULL,NULL,NULL),(667,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,92,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(668,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,92,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(669,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,92,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(670,'APPROVED VISIT TEMPLATE : In Flex Midnight Overlap Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,93,NULL,NULL,NULL,NULL),(671,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,93,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(672,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,93,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(673,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,93,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(674,'APPROVED VISIT TEMPLATE : In Flex Day Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,94,NULL,NULL,NULL,NULL),(675,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,94,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(676,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,94,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(677,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,94,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(678,'APPROVED VISIT TEMPLATE : In Flex Overnight Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,95,NULL,NULL,NULL,NULL),(679,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,95,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(680,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,95,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(681,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,95,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(682,'APPROVED VISIT TEMPLATE : In Flex Midnight Overlap Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,96,NULL,NULL,NULL,NULL),(683,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,96,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(684,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,96,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(685,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,96,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(686,'APPROVED VISIT TEMPLATE : In Flex Day Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,97,NULL,NULL,NULL,NULL),(687,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,97,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(688,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,97,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(689,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,97,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(690,'APPROVED VISIT TEMPLATE : In Flex Overnight Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,98,NULL,NULL,NULL,NULL),(691,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,98,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(692,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,98,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(693,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,98,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(694,'APPROVED VISIT TEMPLATE : In Flex Midnight Overlap Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,99,NULL,NULL,NULL,NULL),(695,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,99,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(696,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,99,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(697,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,99,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(698,'APPROVED VISIT TEMPLATE : In Flex QTY Change Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,100,NULL,NULL,NULL,NULL),(699,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,100,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(700,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,100,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(701,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,100,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(702,'APPROVED VISIT TEMPLATE : In Flex QTY Change Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,101,NULL,NULL,NULL,NULL),(703,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,101,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(704,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,101,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(705,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,101,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(706,'APPROVED VISIT TEMPLATE : In Flex QTY Change Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,102,NULL,NULL,NULL,NULL),(707,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,102,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(708,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,102,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(709,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,102,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(710,'APPROVED VISIT TEMPLATE : In Flex QTY Change  Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,103,NULL,NULL,NULL,NULL),(711,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,103,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(712,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,103,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(713,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,103,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(714,'APPROVED VISIT TEMPLATE : In Day Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,104,NULL,NULL,NULL,NULL),(715,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,104,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(716,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,104,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(717,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,104,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(718,'APPROVED VISIT TEMPLATE : In 11:30 PM Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,105,NULL,NULL,NULL,NULL),(719,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,105,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(720,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,105,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(721,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,105,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(722,'APPROVED VISIT TEMPLATE : In Midnight Overlap Resource Blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,106,NULL,NULL,NULL,NULL),(723,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,106,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(724,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,106,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(725,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,106,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(726,'APPROVED VISIT TEMPLATE : In Fixed Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,107,NULL,NULL,NULL,NULL),(727,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,107,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(728,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,107,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(729,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,107,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(730,'APPROVED VISIT TEMPLATE : In Flex Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,108,NULL,NULL,NULL,NULL),(731,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,108,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(732,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,108,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(733,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,108,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(734,'APPROVED VISIT TEMPLATE : In Float Alt Off by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,109,NULL,NULL,NULL,NULL),(735,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,109,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(736,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,109,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(737,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,109,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(738,'APPROVED VISIT TEMPLATE : In Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,110,NULL,NULL,NULL,NULL),(739,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,110,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(740,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,110,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(741,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,110,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(742,'APPROVED VISIT TEMPLATE : In All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,111,NULL,NULL,NULL,NULL),(743,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,111,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(744,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,111,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(745,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,111,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(746,'APPROVED VISIT TEMPLATE : In Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,112,NULL,NULL,NULL,NULL),(747,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,112,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(748,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,112,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(749,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,112,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(750,'APPROVED VISIT TEMPLATE : In 30 Day by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,113,NULL,NULL,NULL,NULL),(751,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,113,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(752,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,113,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(753,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,113,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(754,'APPROVED VISIT TEMPLATE : In Fixed  RT by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,114,NULL,NULL,NULL,NULL),(755,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,114,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(756,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,114,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(757,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,114,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(758,'APPROVED VISIT TEMPLATE : In Fixed  RT Time Gap by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,115,NULL,NULL,NULL,NULL),(759,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,115,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(760,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,115,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(761,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,115,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(762,'APPROVED VISIT TEMPLATE : In Fixed RT QTY Change by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,116,NULL,NULL,NULL,NULL),(763,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,116,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(764,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,116,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(765,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,116,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(766,'APPROVED VISIT TEMPLATE : In Float RT Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,117,NULL,NULL,NULL,NULL),(767,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,117,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(768,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,117,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(769,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,117,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(770,'APPROVED VISIT TEMPLATE : In Float RT Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,118,NULL,NULL,NULL,NULL),(771,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,118,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(772,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,118,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(773,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,118,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(774,'APPROVED VISIT TEMPLATE : In Float  RT QTY Change Single by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,119,NULL,NULL,NULL,NULL),(775,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,119,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(776,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,119,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(777,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,119,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(778,'APPROVED VISIT TEMPLATE : In Float RT QTY Change Linked by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,120,NULL,NULL,NULL,NULL),(779,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,120,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(780,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,120,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(781,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,120,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(782,'APPROVED VISIT TEMPLATE : In Flex  RT Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,121,NULL,NULL,NULL,NULL),(783,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,121,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(784,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,121,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(785,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,121,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(786,'APPROVED VISIT TEMPLATE : In Flex RT Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,122,NULL,NULL,NULL,NULL),(787,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,122,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(788,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,122,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(789,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,122,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(790,'APPROVED VISIT TEMPLATE : In Flex  RT Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,123,NULL,NULL,NULL,NULL),(791,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,123,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(792,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,123,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(793,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,123,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(794,'APPROVED VISIT TEMPLATE : In Flex RT Overnight Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,124,NULL,NULL,NULL,NULL),(795,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,124,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(796,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,124,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(797,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,124,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(798,'APPROVED VISIT TEMPLATE : In Flex RT Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,125,NULL,NULL,NULL,NULL),(799,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,125,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(800,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,125,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(801,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,125,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(802,'APPROVED VISIT TEMPLATE : In Flex  RT QTY Change Consec 2 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,126,NULL,NULL,NULL,NULL),(803,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,126,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(804,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,126,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(805,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,126,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(806,'APPROVED VISIT TEMPLATE : In Flex RT QTY Change Consec 3 by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,127,NULL,NULL,NULL,NULL),(807,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,127,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(808,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,127,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(809,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,127,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(810,'APPROVED VISIT TEMPLATE : In Flex RT QTY Change Super A by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,128,NULL,NULL,NULL,NULL),(811,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,128,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(812,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,128,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(813,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,128,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(814,'APPROVED VISIT TEMPLATE : In Flex RT QTY Change  Super B by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,129,NULL,NULL,NULL,NULL),(815,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,129,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(816,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,129,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(817,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,129,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(818,'APPROVED VISIT TEMPLATE : In room blocker by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,130,NULL,NULL,NULL,NULL),(819,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,130,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(820,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,130,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(821,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,130,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(822,'APPROVED VISIT TEMPLATE : In All Rooms by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,131,NULL,NULL,NULL,NULL),(823,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,131,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(824,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,131,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(825,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,131,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(826,'APPROVED VISIT TEMPLATE : In Double Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,132,NULL,NULL,NULL,NULL),(827,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,132,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(828,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,132,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(829,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,132,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(830,'APPROVED VISIT TEMPLATE : In Male Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,133,NULL,NULL,NULL,NULL),(831,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,133,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(832,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,133,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(833,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,133,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(834,'APPROVED VISIT TEMPLATE : In Female Room by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,134,NULL,NULL,NULL,NULL),(835,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,134,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(836,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,134,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(837,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,134,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(838,'APPROVED VISIT TEMPLATE : In RT Multi Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,135,NULL,NULL,NULL,NULL),(839,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,135,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(840,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,135,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(841,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,135,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(842,'APPROVED VISIT TEMPLATE : In RT All Fails by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL),(843,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,136,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(844,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,136,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(845,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,136,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(846,'APPROVED VISIT TEMPLATE : In RT Iterative Fail by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,137,NULL,NULL,NULL,NULL),(847,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,137,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(848,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,137,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(849,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,137,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(850,'APPROVED VISIT TEMPLATE : In RT 30 day by Super Admin',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,NULL,NULL,NULL,NULL,NULL,138,NULL,NULL,NULL,NULL),(851,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,416,NULL,NULL,NULL,NULL,138,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(852,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,412,NULL,NULL,NULL,NULL,138,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(853,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'134.174.149.46',410,411,NULL,NULL,NULL,NULL,138,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(854,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39'),'134.174.149.46',410,NULL,NULL,1,2,NULL,NULL,NULL,NULL,NULL,NULL),(855,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39'),'134.174.149.46',410,NULL,NULL,2,2,NULL,NULL,NULL,NULL,NULL,NULL),(856,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),'134.174.149.46',410,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(857,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),'134.174.149.46',410,NULL,NULL,3,2,NULL,NULL,NULL,NULL,NULL,NULL),(858,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),'134.174.149.46',410,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(859,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),'134.174.149.46',410,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(860,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'134.174.149.46',410,NULL,NULL,4,2,NULL,NULL,NULL,NULL,NULL,NULL),(861,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'134.174.149.46',410,NULL,NULL,5,2,NULL,NULL,NULL,NULL,NULL,NULL),(862,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'134.174.149.46',410,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(863,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'134.174.149.46',410,NULL,NULL,6,2,NULL,NULL,NULL,NULL,NULL,NULL),(864,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),'134.174.149.46',410,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(865,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),'134.174.149.46',410,NULL,NULL,7,2,NULL,NULL,NULL,NULL,NULL,NULL),(866,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),'134.174.149.46',410,NULL,NULL,8,2,NULL,NULL,NULL,NULL,NULL,NULL),(867,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'134.174.149.46',410,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(868,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'134.174.149.46',410,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(869,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'134.174.149.46',410,NULL,NULL,9,2,NULL,NULL,NULL,NULL,NULL,NULL),(870,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'134.174.149.46',410,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(871,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'134.174.149.46',410,NULL,NULL,10,2,NULL,NULL,NULL,NULL,NULL,NULL),(872,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'134.174.149.46',410,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(873,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'134.174.149.46',410,NULL,NULL,11,2,NULL,NULL,NULL,NULL,NULL,NULL),(874,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'134.174.149.46',410,NULL,NULL,12,2,NULL,NULL,NULL,NULL,NULL,NULL),(875,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),'134.174.149.46',410,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(876,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),'134.174.149.46',410,NULL,NULL,13,2,NULL,NULL,NULL,NULL,NULL,NULL),(877,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),'134.174.149.46',410,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(878,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),'134.174.149.46',410,NULL,NULL,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(879,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'134.174.149.46',410,NULL,NULL,14,2,NULL,NULL,NULL,NULL,NULL,NULL),(880,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'134.174.149.46',410,NULL,NULL,15,2,NULL,NULL,NULL,NULL,NULL,NULL),(881,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'134.174.149.46',410,NULL,NULL,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(882,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'134.174.149.46',410,NULL,NULL,16,2,NULL,NULL,NULL,NULL,NULL,NULL),(883,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'134.174.149.46',410,NULL,NULL,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(884,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'134.174.149.46',410,NULL,NULL,17,2,NULL,NULL,NULL,NULL,NULL,NULL),(885,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'134.174.149.46',410,NULL,NULL,18,2,NULL,NULL,NULL,NULL,NULL,NULL),(886,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'134.174.149.46',410,NULL,NULL,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(887,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'134.174.149.46',410,NULL,NULL,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(888,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),'134.174.149.46',410,NULL,NULL,19,2,NULL,NULL,NULL,NULL,NULL,NULL),(889,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),'134.174.149.46',410,NULL,NULL,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(890,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),'134.174.149.46',410,NULL,NULL,20,2,NULL,NULL,NULL,NULL,NULL,NULL),(891,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),'134.174.149.46',410,NULL,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(892,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),'134.174.149.46',410,NULL,NULL,21,2,NULL,NULL,NULL,NULL,NULL,NULL),(893,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),'134.174.149.46',410,NULL,NULL,22,2,NULL,NULL,NULL,NULL,NULL,NULL),(894,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),'134.174.149.46',410,NULL,NULL,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(895,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),'134.174.149.46',410,NULL,NULL,23,2,NULL,NULL,NULL,NULL,NULL,NULL),(896,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),'134.174.149.46',410,NULL,NULL,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(897,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),'134.174.149.46',410,NULL,NULL,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(898,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'134.174.149.46',410,NULL,NULL,24,2,NULL,NULL,NULL,NULL,NULL,NULL),(899,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'134.174.149.46',410,NULL,NULL,25,2,NULL,NULL,NULL,NULL,NULL,NULL),(900,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'134.174.149.46',410,NULL,NULL,25,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(901,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'134.174.149.46',410,NULL,NULL,26,2,NULL,NULL,NULL,NULL,NULL,NULL),(902,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'134.174.149.46',410,NULL,NULL,26,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(903,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),'134.174.149.46',410,NULL,NULL,27,2,NULL,NULL,NULL,NULL,NULL,NULL),(904,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),'134.174.149.46',410,NULL,NULL,28,2,NULL,NULL,NULL,NULL,NULL,NULL),(905,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),'134.174.149.46',410,NULL,NULL,28,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(906,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'134.174.149.46',410,NULL,NULL,28,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(907,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'134.174.149.46',410,NULL,NULL,29,2,NULL,NULL,NULL,NULL,NULL,NULL),(908,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'134.174.149.46',410,NULL,NULL,29,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(909,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'134.174.149.46',410,NULL,NULL,30,2,NULL,NULL,NULL,NULL,NULL,NULL),(910,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'134.174.149.46',410,NULL,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(911,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'134.174.149.46',410,NULL,NULL,31,2,NULL,NULL,NULL,NULL,NULL,NULL),(912,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'134.174.149.46',410,NULL,NULL,32,2,NULL,NULL,NULL,NULL,NULL,NULL),(913,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'134.174.149.46',410,NULL,NULL,32,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(914,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'134.174.149.46',410,NULL,NULL,33,2,NULL,NULL,NULL,NULL,NULL,NULL),(915,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'134.174.149.46',410,NULL,NULL,33,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(916,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'134.174.149.46',410,NULL,NULL,33,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(917,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'134.174.149.46',410,NULL,NULL,34,2,NULL,NULL,NULL,NULL,NULL,NULL),(918,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'134.174.149.46',410,NULL,NULL,35,2,NULL,NULL,NULL,NULL,NULL,NULL),(919,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'134.174.149.46',410,NULL,NULL,35,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(920,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'134.174.149.46',410,NULL,NULL,36,2,NULL,NULL,NULL,NULL,NULL,NULL),(921,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'134.174.149.46',410,NULL,NULL,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(922,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'134.174.149.46',410,NULL,NULL,37,2,NULL,NULL,NULL,NULL,NULL,NULL),(923,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'134.174.149.46',410,NULL,NULL,38,2,NULL,NULL,NULL,NULL,NULL,NULL),(924,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'134.174.149.46',410,NULL,NULL,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(925,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'134.174.149.46',410,NULL,NULL,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(926,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),'134.174.149.46',410,NULL,NULL,39,2,NULL,NULL,NULL,NULL,NULL,NULL),(927,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),'134.174.149.46',410,NULL,NULL,39,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(928,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),'134.174.149.46',410,NULL,NULL,40,2,NULL,NULL,NULL,NULL,NULL,NULL),(929,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'134.174.149.46',410,NULL,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(930,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'134.174.149.46',410,NULL,NULL,41,2,NULL,NULL,NULL,NULL,NULL,NULL),(931,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'134.174.149.46',410,NULL,NULL,42,2,NULL,NULL,NULL,NULL,NULL,NULL),(932,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'134.174.149.46',410,NULL,NULL,42,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(933,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),'134.174.149.46',410,NULL,NULL,43,2,NULL,NULL,NULL,NULL,NULL,NULL),(934,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),'134.174.149.46',410,NULL,NULL,43,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(935,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),'134.174.149.46',410,NULL,NULL,44,2,NULL,NULL,NULL,NULL,NULL,NULL),(936,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'134.174.149.46',410,NULL,NULL,45,2,NULL,NULL,NULL,NULL,NULL,NULL),(937,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'134.174.149.46',410,NULL,NULL,45,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(938,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'134.174.149.46',410,NULL,NULL,45,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(939,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'134.174.149.46',410,NULL,NULL,46,2,NULL,NULL,NULL,NULL,NULL,NULL),(940,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'134.174.149.46',410,NULL,NULL,46,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(941,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'134.174.149.46',410,NULL,NULL,47,2,NULL,NULL,NULL,NULL,NULL,NULL),(942,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'134.174.149.46',410,NULL,NULL,47,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(943,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'134.174.149.46',410,NULL,NULL,47,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(944,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'134.174.149.46',410,NULL,NULL,48,2,NULL,NULL,NULL,NULL,NULL,NULL),(945,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03'),'134.174.149.46',410,NULL,NULL,48,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(946,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03'),'134.174.149.46',410,NULL,NULL,49,2,NULL,NULL,NULL,NULL,NULL,NULL),(947,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'134.174.149.46',410,NULL,NULL,50,2,NULL,NULL,NULL,NULL,NULL,NULL),(948,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'134.174.149.46',410,NULL,NULL,51,2,NULL,NULL,NULL,NULL,NULL,NULL),(949,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'134.174.149.46',410,NULL,NULL,52,2,NULL,NULL,NULL,NULL,NULL,NULL),(950,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05'),'134.174.149.46',410,NULL,NULL,53,2,NULL,NULL,NULL,NULL,NULL,NULL),(951,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05'),'134.174.149.46',410,NULL,NULL,54,2,NULL,NULL,NULL,NULL,NULL,NULL),(952,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'134.174.149.46',410,NULL,NULL,55,2,NULL,NULL,NULL,NULL,NULL,NULL),(953,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'134.174.149.46',410,NULL,NULL,56,2,NULL,NULL,NULL,NULL,NULL,NULL),(954,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'134.174.149.46',410,NULL,NULL,57,2,NULL,NULL,NULL,NULL,NULL,NULL),(955,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'134.174.149.46',410,NULL,NULL,58,2,NULL,NULL,NULL,NULL,NULL,NULL),(956,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'134.174.149.46',410,NULL,NULL,59,2,NULL,NULL,NULL,NULL,NULL,NULL),(957,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'134.174.149.46',410,NULL,NULL,59,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(958,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'134.174.149.46',410,NULL,NULL,60,2,NULL,NULL,NULL,NULL,NULL,NULL),(959,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),'134.174.149.46',410,NULL,NULL,60,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(960,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),'134.174.149.46',410,NULL,NULL,60,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(961,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),'134.174.149.46',410,NULL,NULL,61,2,NULL,NULL,NULL,NULL,NULL,NULL),(962,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),'134.174.149.46',410,NULL,NULL,61,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(963,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'134.174.149.46',410,NULL,NULL,62,2,NULL,NULL,NULL,NULL,NULL,NULL),(964,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'134.174.149.46',410,NULL,NULL,63,2,NULL,NULL,NULL,NULL,NULL,NULL),(965,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'134.174.149.46',410,NULL,NULL,63,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(966,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'134.174.149.46',410,NULL,NULL,64,2,NULL,NULL,NULL,NULL,NULL,NULL),(967,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),'134.174.149.46',410,NULL,NULL,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(968,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),'134.174.149.46',410,NULL,NULL,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(969,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),'134.174.149.46',410,NULL,NULL,65,2,NULL,NULL,NULL,NULL,NULL,NULL),(970,'CANCELLED APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),'134.174.149.46',410,NULL,NULL,65,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(971,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12'),'134.174.149.46',410,NULL,NULL,66,2,NULL,NULL,NULL,NULL,NULL,NULL),(972,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12'),'134.174.149.46',410,NULL,NULL,67,2,NULL,NULL,NULL,NULL,NULL,NULL),(973,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'134.174.149.46',410,NULL,NULL,68,2,NULL,NULL,NULL,NULL,NULL,NULL),(974,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'134.174.149.46',410,NULL,NULL,68,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(975,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'134.174.149.46',410,NULL,NULL,68,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(976,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'134.174.149.46',410,NULL,NULL,69,2,NULL,NULL,NULL,NULL,NULL,NULL),(977,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),'134.174.149.46',410,NULL,NULL,69,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(978,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),'134.174.149.46',410,NULL,NULL,69,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(979,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),'134.174.149.46',410,NULL,NULL,70,2,NULL,NULL,NULL,NULL,NULL,NULL),(980,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),'134.174.149.46',410,NULL,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(981,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),'134.174.149.46',410,NULL,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(982,'OVERBOOK',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),'134.174.149.46',410,NULL,NULL,71,2,NULL,NULL,NULL,NULL,NULL,NULL),(983,'CHECKED-IN APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),'134.174.149.46',410,NULL,NULL,71,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(984,'CHECKED-OUT APPOINTMENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:16'),'134.174.149.46',410,NULL,NULL,71,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(985,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:18:58'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(986,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:18:58'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(987,'VIEW STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:19:06'),'10.1.10.224',409,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(988,'VIEW VISIT : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:21:15'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(989,'VIEW VISIT : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:52'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(990,'APPROVED VISIT TEMPLATE : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:56'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(991,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:56'),'10.1.10.224',409,416,NULL,NULL,NULL,NULL,6,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(992,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:56'),'10.1.10.224',409,412,NULL,NULL,NULL,NULL,6,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(993,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:56'),'10.1.10.224',409,411,NULL,NULL,NULL,NULL,6,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(994,'VIEW VISIT : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:22:57'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(995,'All Resources Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:23:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(996,'APPROVED VISIT TEMPLATE : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(997,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05'),'10.1.10.224',409,416,NULL,NULL,NULL,NULL,6,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(998,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05'),'10.1.10.224',409,412,NULL,NULL,NULL,NULL,6,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(999,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05'),'10.1.10.224',409,411,NULL,NULL,NULL,NULL,6,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(1000,'VIEW VISIT : In TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:06'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(1001,'VIEW VISIT : Out TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:11'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL),(1002,'All Resources Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:15'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1003,'All Resources Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:41'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1004,'APPROVED VISIT TEMPLATE : Out TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL),(1005,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'),'10.1.10.224',409,416,NULL,NULL,NULL,NULL,2,NULL,' Email : ps123@fakek.edu and Role : Study Coordinator - Research Asst',NULL,NULL),(1006,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'),'10.1.10.224',409,412,NULL,NULL,NULL,NULL,2,NULL,' Email : nt123@fakek.edu and Role : Nutrition Manager',NULL,NULL),(1007,'APPROVED VISIT TEMPLATE EMAIL SENT',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'),'10.1.10.224',409,411,NULL,NULL,NULL,NULL,2,NULL,' Email : nr123@fakek.edu and Role : Nurse Manager Director',NULL,NULL),(1008,'VIEW VISIT : Out TA-001 CNY by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:03'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL),(1009,'VIEW VISIT : Out TA-001 Off Institution by Final Approver',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:18'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL),(1010,'All Resources Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:21'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1011,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:38'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1012,'Clicked on the Checked-In appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:47'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1013,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:50'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,36,NULL),(1014,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:25:59'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,36,NULL),(1015,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:12'),'10.1.10.224',409,NULL,NULL,53,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1016,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:14'),'10.1.10.224',409,NULL,NULL,53,NULL,NULL,NULL,NULL,NULL,1,NULL),(1017,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:17'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1018,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:19'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,36,NULL),(1019,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:27'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,36,NULL),(1020,'Override (resource otherwise not available) Approved by Other Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:55'),'10.1.10.224',409,NULL,NULL,67,4,NULL,NULL,'Resource : Room 1 - Sub-Location 2 to Room 3 - Sub-Location 3,  Start Time : 2015-10-26 22:00:00.0 to Mon Oct 26 22:00:00 EDT 2015,  End Time : 2015-11-26 01:00:00.0 to Thu Nov 26 01:00:00 EST 2015',NULL,36,NULL),(1021,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:55'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1022,'Add - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:26:57'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,41,NULL),(1023,'Override (resource otherwise not available) Approved by RN Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:08'),'10.1.10.224',409,NULL,NULL,67,2,NULL,NULL,NULL,NULL,19,NULL),(1024,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:08'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1025,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:12'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1026,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:19'),'10.1.10.224',409,NULL,NULL,62,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1027,'Add - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:21'),'10.1.10.224',409,NULL,NULL,62,NULL,NULL,NULL,NULL,NULL,29,NULL),(1028,'Override (resource otherwise not available) Approved by RN Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:31'),'10.1.10.224',409,NULL,NULL,62,2,NULL,NULL,NULL,NULL,33,NULL),(1029,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:31'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1030,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:39'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1031,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:45'),'10.1.10.224',409,NULL,NULL,44,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1032,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:46'),'10.1.10.224',409,NULL,NULL,44,NULL,NULL,NULL,NULL,NULL,1,NULL),(1033,'Override (resource otherwise not available) Approved by RN Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:53'),'10.1.10.224',409,NULL,NULL,44,2,NULL,NULL,'Resource : Nurse - Sub-Location 1 to Nurse - Sub-Location 1,  Start Time : 2015-10-26 07:00:00.0 to Mon Oct 26 07:00:00 EDT 2015,  End Time : 2015-10-27 13:00:00.0 to Tue Oct 27 13:00:00 EDT 2015',NULL,1,NULL),(1034,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:53'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1035,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:56'),'10.1.10.224',409,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1036,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:27:58'),'10.1.10.224',409,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,29,NULL),(1037,'Override (resource otherwise not available) Approved by RD Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:02'),'10.1.10.224',409,NULL,NULL,7,3,NULL,NULL,'Resource : Snack- Sub-Location 1 to Snack- Sub-Location 1,  Start Time : 2015-10-26 22:00:00.0 to Mon Oct 26 22:00:00 EDT 2015,  End Time : 2015-10-27 01:00:00.0 to Tue Oct 27 01:00:00 EDT 2015',NULL,29,NULL),(1038,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:02'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1039,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:06'),'10.1.10.224',409,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1040,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:09'),'10.1.10.224',409,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1041,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:12'),'10.1.10.224',409,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,29,NULL),(1042,'Override (resource otherwise not available) Approved by Other Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:16'),'10.1.10.224',409,NULL,NULL,4,4,NULL,NULL,'Resource : Snack- Sub-Location 1 to Snack- Sub-Location 1,  Start Time : 2015-10-26 07:00:00.0 to Mon Oct 26 07:00:00 EDT 2015,  End Time : 2015-10-26 08:00:00.0 to Mon Oct 26 08:00:00 EDT 2015',NULL,29,NULL),(1043,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:16'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1044,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:19'),'10.1.10.224',409,NULL,NULL,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1045,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:24'),'10.1.10.224',409,NULL,NULL,21,NULL,NULL,NULL,NULL,NULL,1,NULL),(1046,'Override (resource otherwise not available) Approved by Other Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:31'),'10.1.10.224',409,NULL,NULL,21,4,NULL,NULL,'Resource : Nurse - Sub-Location 1 to Nurse - Sub-Location 1,  Start Time : 2015-10-26 07:00:00.0 to Mon Oct 26 07:00:00 EDT 2015,  End Time : 2015-10-26 07:15:00.0 to Mon Oct 26 07:15:00 EDT 2015',NULL,1,NULL),(1047,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:31'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1048,'Clicked on the Checked-In appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:34'),'10.1.10.224',409,NULL,NULL,22,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1049,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:40'),'10.1.10.224',409,NULL,NULL,22,NULL,NULL,NULL,NULL,NULL,1,NULL),(1050,'Override (resource otherwise not available) Approved by RD Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:49'),'10.1.10.224',409,NULL,NULL,22,3,NULL,NULL,'Resource : Nurse - Sub-Location 1 to Nurse - Sub-Location 1,  Start Time : 2015-10-26 07:00:00.0 to Mon Oct 26 07:00:00 EDT 2015,  End Time : 2015-10-26 07:15:00.0 to Mon Oct 26 07:15:00 EDT 2015',NULL,1,NULL),(1051,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:49'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1052,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:28:59'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1053,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17,NULL),(1054,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:23'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17,NULL),(1055,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:27'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1056,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:29'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,NULL),(1057,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:48'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9,NULL),(1058,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:29:53'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1059,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:30:00'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,NULL),(1060,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:30:15'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11,NULL),(1061,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:31:51'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1062,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:32:09'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,NULL),(1063,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:32:22'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,NULL),(1064,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:32:42'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,19,NULL),(1065,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:18'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1066,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:21'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45,NULL),(1067,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:38'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45,NULL),(1068,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:42'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1069,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:46'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45,NULL),(1070,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:48'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1071,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:33:52'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,NULL),(1072,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:34:06'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13,NULL),(1073,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:34:11'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1074,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:34:14'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,NULL),(1075,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:37:25'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,NULL),(1076,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:37:30'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1077,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:42:33'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1078,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:42:33'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1079,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:35'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1080,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:35'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1081,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:38'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1082,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:40'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25,NULL),(1083,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:42'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1084,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:44'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,NULL),(1085,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:00'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,27,NULL),(1086,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:03'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1087,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:05'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL),(1088,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:22'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL),(1089,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:26'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1090,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:31'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL),(1091,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:52'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL),(1092,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:51:56'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1093,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:04'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL),(1094,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:06'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1095,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:09'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL),(1096,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:23'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL),(1097,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:26'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1098,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:31'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,NULL),(1099,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:45'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,NULL),(1100,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:48'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1101,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:51'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL),(1102,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:54'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1103,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:52:56'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,NULL),(1104,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,33,NULL),(1105,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:14'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1106,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:16'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,NULL),(1107,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:29'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39,NULL),(1108,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:32'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1109,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:35'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL),(1110,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:50'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL),(1111,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:55'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1112,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:53:58'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43,NULL),(1113,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:54:15'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43,NULL),(1114,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:54:19'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1115,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:27'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43,NULL),(1116,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:29'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1117,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:32'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,NULL),(1118,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:45'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,NULL),(1119,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:49'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1120,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:53'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35,NULL),(1121,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:55'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1122,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:55:57'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,NULL),(1123,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,NULL),(1124,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:13'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1125,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:17'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41,NULL),(1126,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:19'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1127,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:22'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,NULL),(1128,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:34'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,NULL),(1129,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:36'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1130,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:39'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,29,NULL),(1131,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:41'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1132,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:42'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,NULL),(1133,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:56:55'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,31,NULL),(1134,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1135,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:25'),'10.1.10.224',409,410,NULL,NULL,NULL,NULL,NULL,' Division: NULL  to 0,  Department: NULL  to 0,  Credential: NULL  to 0,  Faculty Rank: NULL  to 0, ',' Role: Final Approver to Final Approver, ',NULL,NULL),(1136,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:27'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1137,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:37'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1138,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:46'),'10.1.10.224',409,414,NULL,NULL,NULL,NULL,NULL,' Division: NULL  to 0,  Department: NULL  to 0,  Credential: NULL  to 0,  Faculty Rank: NULL  to 0, ',' Role: Other Study Staff to Other Study Staff, ',NULL,NULL),(1139,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:47'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1140,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:56'),'10.1.10.224',409,411,NULL,NULL,NULL,NULL,NULL,' Division: NULL  to 0,  Department: NULL  to 0,  Credential: NULL  to 0,  Faculty Rank: NULL  to 0, ',' Role: Nurse Manager Director to Nurse Manager Director, ',NULL,NULL),(1141,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:58:57'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1142,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:59:33'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1143,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:59:42'),'10.1.10.224',409,411,NULL,NULL,NULL,NULL,NULL,' Division: NULL  to 0,  Department: NULL  to 0,  Credential: NULL  to 0,  Faculty Rank: NULL  to 0, ',' Role: Nurse Manager Director to Nurse Manager Director, ',NULL,NULL),(1144,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:59:43'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1145,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:59:53'),'10.1.10.224',409,412,NULL,NULL,NULL,NULL,NULL,' Division: NULL  to 0,  Department: NULL  to 0,  Credential: NULL  to 0,  Faculty Rank: NULL  to 0, ',' Role: Nutrition Manager to Nutrition Manager, ',NULL,NULL),(1146,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:59:55'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1147,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:52:11'),'10.1.10.146',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1148,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:52:11'),'10.1.10.146',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1149,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:52:20'),'10.1.10.146',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1150,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:47:48'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1151,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:47:48'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1152,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:47:50'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1153,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:48:24'),'10.1.10.224',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1154,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:48:24'),'10.1.10.224',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1155,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:09'),'10.1.10.224',414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1156,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:09'),'10.1.10.224',414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1157,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:17'),'10.1.10.224',411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1158,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:17'),'10.1.10.224',411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1159,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:23'),'10.1.10.224',412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1160,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:23'),'10.1.10.224',412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1161,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:41'),'10.1.10.224',413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1162,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:41'),'10.1.10.224',413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1163,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:52'),'10.1.10.224',413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1164,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:52'),'10.1.10.224',413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1165,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:04'),'10.1.10.224',416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1166,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:04'),'10.1.10.224',416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1167,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:16'),'10.1.10.224',417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1168,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:16'),'10.1.10.224',417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1169,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:29'),'10.1.10.224',418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1170,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:29'),'10.1.10.224',418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1171,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:45'),'10.1.10.224',419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1172,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:45'),'10.1.10.224',419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1173,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:04'),'10.1.10.224',420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1174,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:04'),'10.1.10.224',420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1175,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:21'),'10.1.10.224',421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1176,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:21'),'10.1.10.224',421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1177,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:48'),'10.1.10.224',420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1178,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:48'),'10.1.10.224',420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1179,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:58'),'10.1.10.224',421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1180,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:58'),'10.1.10.224',421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1181,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:19'),'10.1.10.224',415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1182,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:19'),'10.1.10.224',415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1183,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:32'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1184,'Clicked on the Checked-Out appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:34'),'10.1.10.224',409,NULL,NULL,60,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1185,'Clicked on the Checked-In appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:38'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1186,'Clicked on the Checked-In appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:46'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1187,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:48'),'10.1.10.224',409,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,36,NULL),(1188,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:01'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1189,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:01'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1190,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:03'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1191,'RESOURCE ASSIGNED ',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:09'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL),(1192,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1193,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:14'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL),(1194,'CREATE RESOURCE DEFAULT SCHEDULE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:29'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL),(1195,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:57'),'10.1.10.224',409,NULL,NULL,37,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1196,'Edit - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:59'),'10.1.10.224',409,NULL,NULL,37,NULL,NULL,NULL,NULL,NULL,29,NULL),(1197,'Clicked on the Checked-In appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:54:02'),'10.1.10.224',409,NULL,NULL,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1198,'VIEW RESOURCE',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:55:10'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1199,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:01'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1200,'Clicked on the Scheduled appointment and viewed the resources list.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:05'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1201,'Add - Overriding an Appointment (Incomplete Action)',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:07'),'10.1.10.224',409,NULL,NULL,67,NULL,NULL,NULL,NULL,NULL,41,NULL),(1202,'Override (resource otherwise not available) Approved by Other Resource Manager',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:31'),'10.1.10.224',409,NULL,NULL,67,4,NULL,NULL,NULL,NULL,13,NULL),(1203,'Appointment Calendar Viewed',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:31'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1204,'VIEW STUDY',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:41'),'10.1.10.224',409,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL),(1205,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:23'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1206,'UPDATE USER',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:45'),'10.1.10.224',409,409,NULL,NULL,NULL,NULL,NULL,' Division: Division [id=1, getId()=1] to 1,  Department: Department [id=1, getId()=1] to 1,  Credential: Credential [id=1, getId()=1] to 1,  Faculty Rank: FacultyRank [id=1, getId()=1] to 1, ',' Role: Final Approver to Final Approver, ',NULL,NULL),(1207,'All Users Viewed.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:46'),'10.1.10.224',409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1208,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:53'),'10.1.10.224',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(1209,'HOME SCREEN - Appointment Calendar View.',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:53'),'10.1.10.224',410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment_override_reason`
--

DROP TABLE IF EXISTS `appointment_override_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointment_override_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment_override_reason`
--

LOCK TABLES `appointment_override_reason` WRITE;
/*!40000 ALTER TABLE `appointment_override_reason` DISABLE KEYS */;
INSERT INTO `appointment_override_reason` VALUES (1,'Change of resource'),(2,'Override (resource otherwise not available) Approved by RN Resource Manager'),(3,'Override (resource otherwise not available) Approved by RD Resource Manager'),(4,'Override (resource otherwise not available) Approved by Other Resource Manager'),(5,'Overlap (double booking) Approved by RN Resource Manager'),(6,'Overlap (double booking) Approved by RD Resource Manager'),(7,'Overlap (double booking) Approved by Other Resource Manager');
/*!40000 ALTER TABLE `appointment_override_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment_status`
--

DROP TABLE IF EXISTS `appointment_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointment_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment_status`
--

LOCK TABLES `appointment_status` WRITE;
/*!40000 ALTER TABLE `appointment_status` DISABLE KEYS */;
INSERT INTO `appointment_status` VALUES (1,'Scheduled'),(2,'Checked-In'),(3,'Checked-Out'),(4,'Cancellation');
/*!40000 ALTER TABLE `appointment_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment_status_reason`
--

DROP TABLE IF EXISTS `appointment_status_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appointment_status_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_status` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_appStatReason_name` (`name`),
  KEY `FK931C3691B55A8CF4` (`appointment_status`),
  CONSTRAINT `appointment_status_reason_0__appointment_status` FOREIGN KEY (`appointment_status`) REFERENCES `appointment_status` (`id`),
  CONSTRAINT `appointment_status_reason_1__appointment_status` FOREIGN KEY (`appointment_status`) REFERENCES `appointment_status` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment_status_reason`
--

LOCK TABLES `appointment_status_reason` WRITE;
/*!40000 ALTER TABLE `appointment_status_reason` DISABLE KEYS */;
INSERT INTO `appointment_status_reason` VALUES (1,4,'Unforeseen Circumstances: Sick'),(2,4,'Ineligible for the study: Non Adherent'),(3,4,'Ineligible for this visit: Menses Dependent'),(4,4,'Unforeseen Circumstances: Personal'),(5,4,'Withdrew Participation'),(6,4,'Ineligible for this visit: Non Adherent'),(7,4,'Administrative Cancel: Equipment Failure'),(8,4,'Unforeseen Circumstances: Weather'),(9,4,'Ineligible for the study: Adverse event at previous visit'),(10,4,'Ineligible for the study: Failed screening visit or other visit'),(11,4,'Administrative Cancel: Data Entry Error'),(12,4,'No Show'),(13,4,'Administrative Cancel: Operational Cancel (CRC Staff Use Only)'),(14,3,'Visit Terminated Prior to Completion'),(15,3,'Visit Completed');
/*!40000 ALTER TABLE `appointment_status_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booked_resource`
--

DROP TABLE IF EXISTS `booked_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `booked_resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booked_visit` int(11) NOT NULL,
  `resource` int(11) DEFAULT NULL,
  `template_resource` int(11) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `scheduled_end_time` datetime DEFAULT NULL,
  `scheduled_start_time` datetime DEFAULT NULL,
  `appointment_override_reason` int(11) DEFAULT NULL,
  `billable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK1334B525F1F4F55B` (`resource`),
  KEY `FK1334B525FF7BB82A` (`template_resource`),
  KEY `FK1334B5257E838528` (`booked_visit`),
  KEY `FK1334B525955E5717` (`appointment_override_reason`),
  CONSTRAINT `booked_resource_1__template_resource` FOREIGN KEY (`template_resource`) REFERENCES `template_resource` (`id`),
  CONSTRAINT `booked_resource_2__resource` FOREIGN KEY (`resource`) REFERENCES `resource` (`id`),
  CONSTRAINT `booked_resource_3__appointment_override_reason` FOREIGN KEY (`appointment_override_reason`) REFERENCES `appointment_override_reason` (`id`),
  CONSTRAINT `booked_resource_4__template_resource` FOREIGN KEY (`template_resource`) REFERENCES `template_resource` (`id`),
  CONSTRAINT `booked_resource_5__booked_visit` FOREIGN KEY (`booked_visit`) REFERENCES `booked_visit` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booked_resource`
--

LOCK TABLES `booked_resource` WRITE;
/*!40000 ALTER TABLE `booked_resource` DISABLE KEYS */;
INSERT INTO `booked_resource` VALUES (1,1,1,1,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(2,2,1,1,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(3,3,1,1,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(4,4,29,3,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(5,5,29,3,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(6,6,29,3,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(7,7,29,8,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(8,8,29,8,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(9,9,36,6,43440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,1),(10,10,36,6,43440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,1),(11,11,29,12,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(12,12,29,12,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(13,13,29,12,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(14,14,29,10,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(15,15,29,10,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(16,16,29,10,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(17,17,29,13,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 12:00:00'),NULL,0),(18,18,29,13,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 12:00:00'),NULL,0),(19,19,29,15,1440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-31 07:00:00'),NULL,0),(20,20,29,15,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(21,21,1,17,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(22,22,1,17,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(23,23,1,17,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(24,24,1,19,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(25,25,1,19,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(26,26,1,19,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(27,27,1,24,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(28,28,1,24,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(29,29,36,22,43440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,1),(30,30,36,22,43440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,1),(31,31,29,28,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(32,32,29,28,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(33,33,29,28,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(34,34,29,26,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(35,35,29,26,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(36,36,29,26,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(37,37,29,29,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 12:00:00'),NULL,0),(38,38,29,29,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 12:00:00'),NULL,0),(39,39,29,31,1440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-31 07:00:00'),NULL,0),(40,40,29,31,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(41,41,29,33,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(42,42,29,33,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(43,43,29,33,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(44,44,1,34,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(45,45,1,34,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(46,46,29,35,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(47,47,29,35,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(48,48,29,35,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(49,49,29,36,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(50,50,29,37,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),NULL,0),(51,51,29,38,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 22:00:00'),NULL,0),(52,52,29,45,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(53,53,1,46,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(54,54,29,47,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(55,55,29,48,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(56,56,29,49,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(57,57,29,50,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 22:00:00'),NULL,0),(58,58,29,25,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(59,59,29,25,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(60,60,29,25,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),NULL,0),(61,61,29,25,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(62,62,29,9,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(63,63,29,9,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(64,64,29,9,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),NULL,0),(65,65,29,9,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),NULL,0),(66,66,29,33,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(67,67,41,6,43440,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,1),(68,68,1,19,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),NULL,0),(69,69,29,27,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-21 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-21 07:00:00'),NULL,0),(70,70,29,45,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-24 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-24 07:00:00'),NULL,0),(71,71,29,48,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-25 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-25 07:00:00'),NULL,0),(72,67,19,NULL,-28142,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0),(73,62,33,NULL,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),NULL,0),(74,67,13,NULL,-28142,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),NULL,0);
/*!40000 ALTER TABLE `booked_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `booked_visit`
--

DROP TABLE IF EXISTS `booked_visit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `booked_visit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `study` int(11) NOT NULL,
  `visit_template` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `study_subject` int(11) NOT NULL,
  `appointment_status` int(11) NOT NULL,
  `appointment_status_reason` int(11) DEFAULT NULL,
  `scheduled_start_time` datetime NOT NULL,
  `scheduled_end_time` datetime NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `cancel_date` datetime DEFAULT NULL,
  `cancel_status` int(11) DEFAULT NULL,
  `check_in_date` datetime DEFAULT NULL,
  `check_out_date` datetime DEFAULT NULL,
  `cancel_status_reason` int(11) DEFAULT NULL,
  `checkout_status_reason` int(11) DEFAULT NULL,
  `vary_duration` tinyint(1) DEFAULT '0',
  `ommitted_activities` tinyint(1) DEFAULT '0',
  `scheduling_time` datetime DEFAULT NULL,
  `scheduling_user_ecommons_id` varchar(250) DEFAULT NULL,
  `scheduling_flavor` varchar(50) DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'OutpatientCRC',
  PRIMARY KEY (`id`),
  KEY `FKB42FCB944CCAB503` (`study`),
  KEY `FKB42FCB94B230C148` (`study_subject`),
  KEY `FKB42FCB9493F01044` (`visit_template`),
  KEY `FKB42FCB94D5C7FFD7` (`appointment_status_reason`),
  KEY `FKB42FCB94B55A8CF4` (`appointment_status`),
  KEY `FKB42FCB94A9B6813E` (`checkout_status_reason`),
  KEY `FKB42FCB94B9093772` (`cancel_status_reason`),
  KEY `FKB42FCB94AE6DDB9` (`cancel_status`),
  KEY `idx_booked_visit_type` (`type`),
  CONSTRAINT `booked_visit_0__study` FOREIGN KEY (`study`) REFERENCES `study` (`id`),
  CONSTRAINT `booked_visit_1__visit_template` FOREIGN KEY (`visit_template`) REFERENCES `visit_template` (`id`),
  CONSTRAINT `booked_visit_3__appointment_status_reason` FOREIGN KEY (`checkout_status_reason`) REFERENCES `appointment_status_reason` (`id`),
  CONSTRAINT `booked_visit_4__appointment_status` FOREIGN KEY (`cancel_status`) REFERENCES `cancellation_status` (`id`),
  CONSTRAINT `booked_visit_5__study_subject` FOREIGN KEY (`study_subject`) REFERENCES `study_subject` (`id`),
  CONSTRAINT `booked_visit_6__appointment_status` FOREIGN KEY (`appointment_status`) REFERENCES `appointment_status` (`id`),
  CONSTRAINT `booked_visit_7__appointment_status_reason` FOREIGN KEY (`cancel_status_reason`) REFERENCES `appointment_status_reason` (`id`),
  CONSTRAINT `booked_visit_9__appointment_status_reason` FOREIGN KEY (`appointment_status_reason`) REFERENCES `appointment_status_reason` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booked_visit`
--

LOCK TABLES `booked_visit` WRITE;
/*!40000 ALTER TABLE `booked_visit` DISABLE KEYS */;
INSERT INTO `booked_visit` VALUES (1,1,1,'Out TA-001 WHT 13',1,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39'),'SA123','OVERBOOK','OutpatientCRC'),(2,1,1,'Out TA-001 WHT 13',8,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39'),'SA123','OVERBOOK','OutpatientCRC'),(3,1,1,'Out TA-001 WHT 13',6,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40'),'SA123','OVERBOOK','OutpatientCRC'),(4,1,3,'Out TA-001 Non CRC',5,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'SA123','OVERBOOK','OutpatientNonCRC'),(5,1,3,'Out TA-001 Non CRC',9,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'SA123','OVERBOOK','OutpatientNonCRC'),(6,1,3,'Out TA-001 Non CRC',1,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41'),'SA123','OVERBOOK','OutpatientNonCRC'),(7,1,8,'In TA-001 Off Institution',7,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),'SA123','OVERBOOK','InpatientOffInstitution'),(8,1,8,'In TA-001 Off Institution',9,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42'),'SA123','OVERBOOK','InpatientOffInstitution'),(9,1,6,'In TA-001 CNY',6,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43'),'SA123','OVERBOOK','InpatientCRC'),(10,1,6,'In TA-001 CNY',7,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'SA123','OVERBOOK','InpatientCRC'),(11,2,12,'Out TA-002 Off Institution',12,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'SA123','OVERBOOK','OutpatientOffInstitution'),(12,2,12,'Out TA-002 Off Institution',15,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44'),'SA123','OVERBOOK','OutpatientOffInstitution'),(13,2,12,'Out TA-002 Off Institution',11,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45'),'SA123','OVERBOOK','OutpatientOffInstitution'),(14,2,10,'Out TA-002 CNY',13,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:30:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'SA123','OVERBOOK','OutpatientCRC'),(15,2,10,'Out TA-002 CNY',10,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'SA123','OVERBOOK','OutpatientCRC'),(16,2,10,'Out TA-002 CNY',11,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),7,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46'),'SA123','OVERBOOK','OutpatientCRC'),(17,2,13,'In TA-002 WHT 13',11,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 11:30:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'SA123','OVERBOOK','InpatientCRC'),(18,2,13,'In TA-002 WHT 13',10,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 11:30:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47'),'SA123','OVERBOOK','InpatientCRC'),(19,2,15,'In TA-002 Non CRC',15,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-31 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-01 06:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),'SA123','OVERBOOK','InpatientNonCRC'),(20,2,15,'In TA-002 Non CRC',10,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 06:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48'),'SA123','OVERBOOK','InpatientNonCRC'),(21,7,17,'Out AS001 WHT 13',30,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),'SA123','OVERBOOK','OutpatientCRC'),(22,7,17,'Out AS001 WHT 13',33,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49'),'SA123','OVERBOOK','OutpatientCRC'),(23,7,17,'Out AS001 WHT 13',35,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50'),'SA123','OVERBOOK','OutpatientCRC'),(24,7,19,'Out AS001 Non CRC',33,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'SA123','OVERBOOK','OutpatientNonCRC'),(25,7,19,'Out AS001 Non CRC',35,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'SA123','OVERBOOK','OutpatientNonCRC'),(26,7,19,'Out AS001 Non CRC',30,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51'),'SA123','OVERBOOK','OutpatientNonCRC'),(27,7,24,'In AS001 Off Institution',35,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),'SA123','OVERBOOK','InpatientOffInstitution'),(28,7,24,'In AS001 Off Institution',30,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52'),'SA123','OVERBOOK','InpatientOffInstitution'),(29,7,22,'In AS001 CNY',30,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'SA123','OVERBOOK','InpatientCRC'),(30,7,22,'In AS001 CNY',37,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53'),'SA123','OVERBOOK','InpatientCRC'),(31,8,28,'Out AS002 Off Institution',39,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'SA123','OVERBOOK','OutpatientOffInstitution'),(32,8,28,'Out AS002 Off Institution',40,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54'),'SA123','OVERBOOK','OutpatientOffInstitution'),(33,8,28,'Out AS002 Off Institution',41,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'SA123','OVERBOOK','OutpatientOffInstitution'),(34,8,26,'Out AS002 CNY',40,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:30:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55'),'SA123','OVERBOOK','OutpatientCRC'),(35,8,26,'Out AS002 CNY',41,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'SA123','OVERBOOK','OutpatientCRC'),(36,8,26,'Out AS002 CNY',41,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:30:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),7,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56'),'SA123','OVERBOOK','OutpatientCRC'),(37,8,29,'In AS002 WHT 13',41,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 11:30:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'SA123','OVERBOOK','InpatientCRC'),(38,8,29,'In AS002 WHT 13',39,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 11:30:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57'),'SA123','OVERBOOK','InpatientCRC'),(39,8,31,'In AS002 Non CRC',39,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-31 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-01 06:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),'SA123','OVERBOOK','InpatientNonCRC'),(40,8,31,'In AS002 Non CRC',40,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 06:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58'),'SA123','OVERBOOK','InpatientNonCRC'),(41,3,33,'Out TB-003 Non CRC',16,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'SA123','OVERBOOK','OutpatientNonCRC'),(42,3,33,'Out TB-003 Non CRC',19,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59'),'SA123','OVERBOOK','OutpatientNonCRC'),(43,3,33,'Out TB-003 Non CRC',18,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),'SA123','OVERBOOK','OutpatientNonCRC'),(44,3,34,'In RT TB-003 WHT 13',17,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00'),'SA123','OVERBOOK','InpatientCRC'),(45,3,34,'In RT TB-003 WHT 13',18,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'SA123','OVERBOOK','InpatientCRC'),(46,3,35,'In TB-003 CNY',21,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01'),'SA123','OVERBOOK','InpatientCRC'),(47,3,35,'In TB-003 CNY',19,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02'),'SA123','OVERBOOK','InpatientCRC'),(48,3,35,'In TB-003 CNY',20,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03'),6,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03'),'SA123','OVERBOOK','InpatientCRC'),(49,4,36,'Out TC-004 Non CRC',22,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03'),'SA123','OVERBOOK','OutpatientNonCRC'),(50,4,37,'In RT TC-004 WHT 13',23,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 13:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'SA123','OVERBOOK','InpatientCRC'),(51,4,38,'In TC-004 CNY',24,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-29 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'SA123','OVERBOOK','InpatientCRC'),(52,9,45,'Out AS003 Non CRC',43,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04'),'SA123','OVERBOOK','OutpatientNonCRC'),(53,9,46,'In RT AS003 WHT 13',44,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05'),'SA123','OVERBOOK','InpatientCRC'),(54,9,47,'In AS003 CNY',45,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05'),'SA123','OVERBOOK','InpatientCRC'),(55,10,48,'Out AS004 Non CRC',47,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'SA123','OVERBOOK','OutpatientNonCRC'),(56,10,49,'In RT AS004 WHT 13',48,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 13:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'SA123','OVERBOOK','InpatientCRC'),(57,10,50,'In AS004 CNY',49,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07'),'SA123','OVERBOOK','InpatientCRC'),(58,8,25,'Out AS002 WHT 13',31,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'SA123','OVERBOOK','OutpatientCRC'),(59,8,25,'Out AS002 WHT 13',31,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'SA123','OVERBOOK','OutpatientCRC'),(60,8,25,'Out AS002 WHT 13',31,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08'),'SA123','OVERBOOK','OutpatientCRC'),(61,8,25,'Out AS002 WHT 13',31,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),7,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09'),'SA123','OVERBOOK','OutpatientCRC'),(62,2,9,'Out TA-002 WHT 13',2,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:15:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'SA123','OVERBOOK','OutpatientCRC'),(63,2,9,'Out TA-002 WHT 13',2,2,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'SA123','OVERBOOK','OutpatientCRC'),(64,2,9,'Out TA-002 WHT 13',2,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:15:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10'),'SA123','OVERBOOK','OutpatientCRC'),(65,2,9,'Out TA-002 WHT 13',2,4,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-28 07:15:00'),'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),7,NULL,NULL,12,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11'),'SA123','OVERBOOK','OutpatientCRC'),(66,3,33,'Out TB-003 Non CRC',3,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 08:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12'),'SA123','OVERBOOK','OutpatientNonCRC'),(67,1,6,'In TA-001 CNY',29,1,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-11-26 01:00:00'),'',NULL,NULL,NULL,NULL,NULL,NULL,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12'),'SA123','OVERBOOK','InpatientCRC'),(68,7,19,'Out AS001 Non CRC',35,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-23 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'SA123','OVERBOOK','OutpatientNonCRC'),(69,8,27,'Out AS002 Non CRC',41,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-21 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-21 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13'),'SA123','OVERBOOK','OutpatientNonCRC'),(70,9,45,'Out AS003 Non CRC',44,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-24 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-24 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14'),'SA123','OVERBOOK','OutpatientNonCRC'),(71,10,48,'Out AS004 Non CRC',49,3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-25 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-25 08:00:00'),'',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:16'),NULL,15,1,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15'),'SA123','OVERBOOK','OutpatientNonCRC');
/*!40000 ALTER TABLE `booked_visit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cancellation_status`
--

DROP TABLE IF EXISTS `cancellation_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cancellation_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cancellation_status`
--

LOCK TABLES `cancellation_status` WRITE;
/*!40000 ALTER TABLE `cancellation_status` DISABLE KEYS */;
INSERT INTO `cancellation_status` VALUES (5,'No Show'),(6,'Late Cancellation'),(7,'Cancellation');
/*!40000 ALTER TABLE `cancellation_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category`
--

DROP TABLE IF EXISTS `category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `csv_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category`
--

LOCK TABLES `category` WRITE;
/*!40000 ALTER TABLE `category` DISABLE KEYS */;
INSERT INTO `category` VALUES (1,'study','Study Information','Study'),(2,'user','Study Staff','Staff'),(3,'funding_source','Study Funding Source','Funding'),(4,'visit_template','Visit Information','Visit Template'),(5,'booked_visit','Scheduled Visit','Sch Visit'),(6,'subject','Subject','Subject'),(7,'resource','Resource Information','Resource'),(8,'override_booked_resource_annotations','Scheduled Resource Activities','Sch Activities'),(9,'template_resource_annotations','Template Resource Activities','Template Activities'),(10,'principal_investigator','Principal Investigator','PI'),(11,'responsible_physician','Responsible Physician','Physician'),(12,'second_responsible_physician','Second Responsible Physician','Physician2'),(13,'first_scheduling_contact','First Scheduling Contact','Scheduler'),(14,'second_scheduling_contact','Second Scheduling Contact','Scheduler2'),(15,'third_scheduling_contact','Third Scheduling Contact','Scheduler3'),(16,'protocol_nurse','Protocol Nurse','Nurse'),(17,'associate_protocol_nurse','Associate Protocol Nurse','Nurse2'),(18,'protocol_nutritionist','Protocol Nutritionist','Nutritionist'),(19,'associate_protocol_nutritionist','Associate Protocol Nutritionist','Nutritionist2'),(20,'first_funding_source','Funding Source 1','Funding1'),(21,'second_funding_source','Funding Source 2','Funding2'),(22,'third_funding_source','Funding Source 3','Funding3'),(23,'fourth_funding_source','Funding Source 4','Funding4'),(24,'template_resource_information','Template Resource Information','Template Resource');
/*!40000 ALTER TABLE `category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `centers_and_institutions`
--

DROP TABLE IF EXISTS `centers_and_institutions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `centers_and_institutions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `centers_and_institutions`
--

LOCK TABLES `centers_and_institutions` WRITE;
/*!40000 ALTER TABLE `centers_and_institutions` DISABLE KEYS */;
INSERT INTO `centers_and_institutions` VALUES (1,'Center for Information Technology (CIT)'),(2,'Center for Scientific Review (CSR)'),(3,'Eunice Kennedy Shriver National Institute of Child Health and Human Development (NICHD)'),(4,'John E. Fogarty International Center (FIC)'),(5,'National Center for Advancing Translational Sciences (NCATS)'),(6,'National Center for Complementary and Alternative Medicine (NCCAM)'),(7,'National Eye Institute (NEI)'),(8,'National Heart, Lung, and Blood Institute (NHLBI)'),(9,'National Human Genome Research Institute (NHGRI)'),(10,'National Institute of Allergy and Infectious Diseases (NIAID)'),(11,'National Institute of Arthritis and Musculoskeletal and Skin Diseases (NIAMS)'),(12,'National Institute of Biomedical Imaging and Bioengineering (NIBIB)'),(13,'National Institute of Dental and Craniofacial Research (NIDCR)'),(14,'National Institute of Diabetes and Digestive and Kidney Diseases (NIDDK)'),(15,'National Institute of Environmental Health Sciences (NIEHS)'),(16,'National Institute of General Medical Sciences (NIGMS)'),(17,'National Institute of Mental Health (NIMH)'),(18,'National Institute of Neurological Disorders and Stroke (NINDS)'),(19,'National Institute of Nursing Research (NINR)'),(20,'National Institute on Aging (NIA)'),(21,'National Institute on Alcohol Abuse and Alcoholism (NIAAA)'),(22,'National Institute on Deafness and Other Communication Disorders (NIDCD)'),(23,'National Institute on Drug Abuse (NIDA)'),(24,'National Institute on Minority Health and Health Disparities (NIMHD)'),(25,'National Library of Medicine (NLM) Centers'),(26,'NIH Clinical Center (CC)'),(27,'National Cancer Institute (NCI)');
/*!40000 ALTER TABLE `centers_and_institutions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment` varchar(255) NOT NULL,
  `visit_template` int(11) DEFAULT NULL,
  `booked_visit` int(11) DEFAULT NULL,
  `user` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `visit_template_ibfk_1` (`visit_template`),
  KEY `booked_visit_ibfk_2` (`booked_visit`),
  KEY `user_ibfk_3` (`user`),
  CONSTRAINT `comments_0__booked_visit` FOREIGN KEY (`booked_visit`) REFERENCES `booked_visit` (`id`),
  CONSTRAINT `comments_1__user` FOREIGN KEY (`user`) REFERENCES `user` (`id`),
  CONSTRAINT `comments_2__visit_template` FOREIGN KEY (`visit_template`) REFERENCES `visit_template` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `country`
--

DROP TABLE IF EXISTS `country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `country`
--

LOCK TABLES `country` WRITE;
/*!40000 ALTER TABLE `country` DISABLE KEYS */;
INSERT INTO `country` VALUES (1,'UNITED STATES'),(2,'UNITED KINGDOM'),(3,'INDIA '),(4,'CHINA'),(5,'AUSTRALIA'),(6,'BANGLADESH'),(7,'BRAZIL'),(8,'CANADA'),(9,'EGYPT '),(10,'FRANCE'),(11,'AFGHANISTAN'),(12,'ALAND ISLANDS'),(13,'ALBANIA'),(14,'ALGERIA'),(15,'AMERICAN SAMOA'),(16,'ANDORRA'),(17,'ANGOLA'),(18,'ANGUILLA'),(19,'ANTARCTICA'),(20,'ANTIGUA AND BARBUDA'),(21,'ARGENTINA'),(22,'ARMENIA'),(23,'ARUBA'),(24,'AUSTRALIA'),(25,'AUSTRIA'),(26,'AZERBAIJAN'),(27,'BAHAMAS'),(28,'BAHRAIN'),(29,'BANGLADESH'),(30,'BARBADOS'),(31,'BELARUS'),(32,'BELGIUM'),(33,'BELIZE'),(34,'BENIN'),(35,'BERMUDA'),(36,'BHUTAN'),(37,'BOLIVIA, PLURINATIONAL STATE OF'),(38,'BONAIRE, SINT EUSTATIUS AND SABA'),(39,'BOSNIA AND HERZEGOVINA'),(40,'BOTSWANA'),(41,'BOUVET ISLAND'),(42,'BRAZIL'),(43,'BRITISH INDIAN OCEAN TERRITORY'),(44,'BRUNEI DARUSSALAM'),(45,'BULGARIA'),(46,'BURKINA FASO'),(47,'BURUNDI'),(48,'CAMBODIA'),(49,'CAMEROON'),(50,'CANADA'),(51,'CAPE VERDE'),(52,'CAYMAN ISLANDS'),(53,'CENTRAL AFRICAN REPUBLIC'),(54,'CHAD'),(55,'CHILE'),(56,'CHINA'),(57,'CHRISTMAS ISLAND'),(58,'COCOS (KEELING) ISLANDS'),(59,'COLOMBIA'),(60,'COMOROS'),(61,'CONGO'),(62,'CONGO, THE DEMOCRATIC REPUBLIC OF THE'),(63,'COOK ISLANDS'),(64,'COSTA RICA'),(65,'COTE DIVOIRE'),(66,'CROATIA'),(67,'CUBA'),(68,'CURACAO'),(69,'CYPRUS'),(70,'CZECH REPUBLIC'),(71,'DENMARK'),(72,'DJIBOUTI'),(73,'DOMINICA'),(74,'DOMINICAN REPUBLIC'),(75,'ECUADOR'),(76,'EGYPT'),(77,'EL SALVADOR'),(78,'EQUATORIAL GUINEA'),(79,'ERITREA'),(80,'ESTONIA'),(81,'ETHIOPIA'),(82,'FALKLAND ISLANDS (MALVINAS)'),(83,'FAROE ISLANDS'),(84,'FIJI'),(85,'FINLAND'),(86,'FRANCE'),(87,'FRENCH GUIANA'),(88,'FRENCH POLYNESIA'),(89,'FRENCH SOUTHERN TERRITORIES'),(90,'GABON'),(91,'GAMBIA'),(92,'GEORGIA'),(93,'GERMANY'),(94,'GHANA'),(95,'GIBRALTAR'),(96,'GREECE'),(97,'GREENLAND'),(98,'GRENADA'),(99,'GUADELOUPE'),(100,'GUAM'),(101,'GUATEMALA'),(102,'GUERNSEY'),(103,'GUINEA'),(104,'BISSAU'),(105,'GUYANA'),(106,'HAITI'),(107,'HEARD ISLAND AND MCDONALD ISLANDS'),(108,'HOLY SEE (VATICAN CITY STATE)'),(109,'HONDURAS'),(110,'HONG KONG'),(111,'HUNGARY'),(112,'ICELAND'),(113,'INDIA'),(114,'INDONESIA'),(115,'IRAN, ISLAMIC REPUBLIC OF'),(116,'IRAQ'),(117,'IRELAND'),(118,'ISLE OF MAN'),(119,'ISRAEL'),(120,'ITALY'),(121,'JAMAICA'),(122,'JAPAN'),(123,'JERSEY'),(124,'JORDAN'),(125,'KAZAKHSTAN'),(126,'KENYA'),(127,'KIRIBATI'),(128,'KOREA, DEMOCRATIC PEOPLES REPUBLIC OF'),(129,'KOREA, REPUBLIC OF'),(130,'KUWAIT'),(131,'KYRGYZSTAN'),(132,'LAO PEOPLES DEMOCRATIC REPUBLIC'),(133,'LATVIA'),(134,'LEBANON'),(135,'LESOTHO'),(136,'LIBERIA'),(137,'LIBYAN ARAB JAMAHIRIYA'),(138,'LIECHTENSTEIN'),(139,'LITHUANIA'),(140,'LUXEMBOURG'),(141,'MACAO'),(142,'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF'),(143,'MADAGASCAR'),(144,'MALAWI'),(145,'MALAYSIA'),(146,'MALDIVES'),(147,'MALI'),(148,'MALTA'),(149,'MARSHALL ISLANDS'),(150,'MARTINIQUE'),(151,'MAURITANIA'),(152,'MAURITIUS'),(153,'MAYOTTE'),(154,'MEXICO'),(155,'MICRONESIA, FEDERATED STATES OF'),(156,'MOLDOVA, REPUBLIC OF'),(157,'MONACO'),(158,'MONGOLIA'),(159,'MONTENEGRO'),(160,'MONTSERRAT'),(161,'MOROCCO'),(162,'MOZAMBIQUE'),(163,'MYANMAR'),(164,'NAMIBIA'),(165,'NAURU'),(166,'NEPAL'),(167,'NETHERLANDS'),(168,'NEW CALEDONIA'),(169,'NEW ZEALAND'),(170,'NICARAGUA'),(171,'NIGER'),(172,'NIGERIA'),(173,'NIUE'),(174,'NORFOLK ISLAND'),(175,'NORTHERN MARIANA ISLANDS'),(176,'NORWAY'),(177,'OMAN'),(178,'PAKISTAN'),(179,'PALAU'),(180,'PALESTINIAN TERRITORY, OCCUPIED'),(181,'PANAMA'),(182,'PAPUA NEW GUINEA'),(183,'PARAGUAY'),(184,'PERU'),(185,'PHILIPPINES'),(186,'PITCAIRN'),(187,'POLAND'),(188,'PORTUGAL'),(189,'PUERTO RICO'),(190,'QATAR'),(191,'REUNION'),(192,'ROMANIA'),(193,'RUSSIAN FEDERATION'),(194,'RWANDA'),(195,'SAINT BARTHELEMY'),(196,'SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA'),(197,'SAINT KITTS AND NEVIS'),(198,'SAINT LUCIA'),(199,'SAINT MARTIN (FRENCH PART)'),(200,'SAINT PIERRE AND MIQUELON'),(201,'SAINT VINCENT AND THE GRENADINES'),(202,'SAMOA'),(203,'SAN MARINO'),(204,'SAO TOME AND PRINCIPE'),(205,'SAUDI ARABIA'),(206,'SENEGAL'),(207,'SERBIA'),(208,'SEYCHELLES'),(209,'SIERRA LEONE'),(210,'SINGAPORE'),(211,'SINT MAARTEN (DUTCH PART)'),(212,'SLOVAKIA'),(213,'SLOVENIA'),(214,'SOLOMON ISLANDS'),(215,'SOMALIA'),(216,'SOUTH AFRICA'),(217,'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS'),(218,'SPAIN'),(219,'SRI LANKA'),(220,'SUDAN'),(221,'SURINAME'),(222,'SVALBARD AND JAN MAYEN'),(223,'SWAZILAND'),(224,'SWEDEN'),(225,'SWITZERLAND'),(226,'SYRIAN ARAB REPUBLIC'),(227,'TAIWAN, PROVINCE OF CHINA'),(228,'TAJIKISTAN'),(229,'TANZANIA, UNITED REPUBLIC OF'),(230,'THAILAND'),(231,'TIMOR'),(232,'LESTE'),(233,'TOGO'),(234,'TOKELAU'),(235,'TONGA'),(236,'TRINIDAD AND TOBAGO'),(237,'TUNISIA'),(238,'TURKEY'),(239,'TURKMENISTAN'),(240,'TURKS AND CAICOS ISLANDS'),(241,'TUVALU'),(242,'UGANDA'),(243,'UKRAINE'),(244,'UNITED ARAB EMIRATES'),(245,'UNITED STATES MINOR OUTLYING ISLANDS'),(246,'URUGUAY'),(247,'UZBEKISTAN'),(248,'VANUATU'),(249,'VATICAN CITY STATE'),(250,'VENEZUELA, BOLIVARIAN REPUBLIC OF'),(251,'VIET NAM'),(252,'VIRGIN ISLANDS, BRITISH'),(253,'VIRGIN ISLANDS, U.S.'),(254,'WALLIS AND FUTUNA'),(255,'WESTERN SAHARA'),(256,'YEMEN'),(257,'ZAMBIA'),(258,'ZIMBABWE');
/*!40000 ALTER TABLE `country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` VALUES (1,'MD'),(2,'PhD'),(3,'MD PhD'),(4,'RN'),(5,'RN PhD'),(6,'RN MSN'),(7,'MA/MS'),(8,'MPH'),(9,'NP'),(10,'PA'),(11,'Other');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db_update_log`
--

DROP TABLE IF EXISTS `db_update_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `db_update_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pom_version` varchar(50) NOT NULL,
  `update_script` varchar(50) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db_update_log`
--

LOCK TABLES `db_update_log` WRITE;
/*!40000 ALTER TABLE `db_update_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `db_update_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `department`
--

DROP TABLE IF EXISTS `department`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `department`
--

LOCK TABLES `department` WRITE;
/*!40000 ALTER TABLE `department` DISABLE KEYS */;
INSERT INTO `department` VALUES (1,'Anesthesia'),(2,'CRC'),(3,'Dermatology'),(4,'Medicine'),(5,'Neurology'),(6,'Nursing'),(7,'Nutrition'),(8,'Obstetrics, Gynecology & Reproductive Biology'),(9,'Ophthalmology'),(10,'Orthopedic Surgery'),(11,'Otology-Laryngology'),(12,'Pathology'),(13,'Pediatrics'),(14,'Physical Medicine & Rehabilitation'),(15,'Population Medicine'),(16,'Psychiatry'),(17,'Radiology'),(18,'Radiation Oncology'),(19,'Surgery'),(20,'Other');
/*!40000 ALTER TABLE `department` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `division`
--

DROP TABLE IF EXISTS `division`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `division` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `division`
--

LOCK TABLES `division` WRITE;
/*!40000 ALTER TABLE `division` DISABLE KEYS */;
INSERT INTO `division` VALUES (1,'Adolescent Medicine'),(2,'Allergy & Inflammation'),(3,'Cardiology'),(4,'Cardiac Surgery'),(5,'Colon & Rectal Surgery'),(6,'Endocrinology'),(7,'Nutrition'),(8,'Emergency Medicine'),(9,'Gastroenterology'),(10,'General Medicine'),(11,'Gerontology'),(12,'Gynecology'),(13,'Hematology/Oncology'),(14,'Infectious Disease'),(15,'Minimally Invasive Surgery'),(16,'Nephrology'),(17,'Neurosurgery'),(18,'Newborn Medicine'),(19,'Plastic & Reconstructive Surgery'),(20,'Podiatry'),(21,'Pulmonology'),(22,'Rheumatology'),(23,'Sleep Medicine'),(24,'Sports Medicine'),(25,'Thoracic Surgery'),(26,'Trauma Surgery & Critical Care'),(27,'Transplant'),(28,'Urologic Surgery'),(29,'Vascular & Endovascular Surgery'),(30,'Weight Loss Surgery'),(31,'Other');
/*!40000 ALTER TABLE `division` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ethnicity`
--

DROP TABLE IF EXISTS `ethnicity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ethnicity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ethnicity`
--

LOCK TABLES `ethnicity` WRITE;
/*!40000 ALTER TABLE `ethnicity` DISABLE KEYS */;
INSERT INTO `ethnicity` VALUES (1,'Not Hispanic or Latino'),(2,'Hispanic or Latino'),(3,'Unknown or Not Reported'),(4,'DECLINED');
/*!40000 ALTER TABLE `ethnicity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faculty_rank`
--

DROP TABLE IF EXISTS `faculty_rank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faculty_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faculty_rank`
--

LOCK TABLES `faculty_rank` WRITE;
/*!40000 ALTER TABLE `faculty_rank` DISABLE KEYS */;
INSERT INTO `faculty_rank` VALUES (1,'Instructor'),(2,'Assistant Professor'),(3,'Associate Professor'),(4,'Professor'),(5,'Lecturer'),(6,'Fellow'),(7,'Other');
/*!40000 ALTER TABLE `faculty_rank` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field`
--

DROP TABLE IF EXISTS `field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `processing` varchar(255) DEFAULT 'DEFAULT',
  `sortable` tinyint(1) NOT NULL DEFAULT '1',
  `type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=261 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field`
--

LOCK TABLES `field` WRITE;
/*!40000 ALTER TABLE `field` DISABLE KEYS */;
INSERT INTO `field` VALUES (1,'study','id','Study ID','DEFAULT',1,'Number'),(2,'study','catalyst_id','Catalyst ID','DEFAULT',1,'ShortString'),(3,'study','clinical_trial','Clinical Trial','DEFAULT',1,'ShortString'),(4,'study','crc_category','CRC Category','DEFAULT',1,'ShortSetStringUI'),(5,'study','crc_funded','CRC Funded','DEFAULT',1,'Boolean'),(6,'study','device_exemption','Device Exemption','DEFAULT',1,'ShortString'),(7,'study','expected_end_date','Expected End Date','DEFAULT',1,'Date'),(8,'study','expected_start_date','Expected Start Date','DEFAULT',1,'Date'),(9,'study','industry_initiated','Industry Initiated','DEFAULT',1,'Boolean'),(10,'study','irb','IRB','DEFAULT',1,'ShortString'),(11,'study','irb_approval_date','IRB Approval Date','DEFAULT',1,'Date'),(12,'study','irb_expiration','IRB Expiration Date','DEFAULT',1,'Date'),(13,'study','irb_renewal_date','IRB Renewal Date','DEFAULT',1,'Date'),(14,'study','local_id','Local ID','DEFAULT',1,'ShortString'),(15,'study','name','Study Name','DEFAULT',1,'ShortString'),(16,'study','new_drug','New Drug','DEFAULT',1,'ShortString'),(17,'study','pediatric','Pediatric','DEFAULT',1,'ShortSetStringUI'),(18,'study','protocol_number','Protocol Number','DEFAULT',1,'ShortString'),(19,'study','short_title','Short Title','DEFAULT',1,'ShortString'),(20,'study','spid','SPID','DEFAULT',1,'ShortString'),(21,'study','status_change','Study Most Recent Update','DEFAULT',1,'Date'),(22,'study','study_abstract','Study Abstract','DEFAULT',0,'LongSetString'),(23,'study','total_inpatient_visits','Total Inpatient Visits','DEFAULT',1,'Number'),(24,'study','total_outpatient_visits','Total Outpatient Visits','DEFAULT',1,'Number'),(25,'study','total_subjects','Total Subjects','DEFAULT',1,'Number'),(26,'study','institution','Institution','InstitutionFromStudy',1,'ShortSetStringDbLongName'),(27,'study','irb_institution','IRB Institution','IRBInstitution',1,'ShortSetStringDB'),(28,'study','study_status','Study Status','StudyStatus',1,'ShortSetStringDbShortName'),(29,'study','id','First Scheduled Visit Date','earliestBookedVisit',0,NULL),(30,'study','id','Most Recent Scheduled Visit Date','latestBookedVisit',0,NULL),(42,'user','institution','User Institution','Institution',1,'ShortSetStringDbLongName'),(43,'user','first_name','First Name','DEFAULT',1,'ShortString'),(44,'user','middle_name','Middle Name','DEFAULT',1,'ShortString'),(45,'user','last_name','Last Name','DEFAULT',1,'ShortString'),(46,'user','active','Active','DEFAULT',1,'Boolean'),(47,'user','ecommons_id','Username','DEFAULT',1,'ShortString'),(48,'user','department','Department','Department',1,'ShortSetStringDB'),(49,'user','division','Division','Division',1,'ShortSetStringDB'),(50,'user','faculty_rank','Faculty Rank','FacultyRank',1,'ShortSetStringDB'),(51,'user','institution_role','User Institutional Role','InstitutionRole',1,'ShortSetStringDB'),(53,'user','role','User Role','Role',1,'ShortSetStringDB'),(54,'user','email','Email Address','DEFAULT',1,'ShortString'),(55,'user','fax','Fax Number','DEFAULT',1,'ShortString'),(56,'user','notification_email','Notification Email','DEFAULT',1,'ShortString'),(57,'user','primary_phone','Phone Number','DEFAULT',1,'ShortString'),(58,'user','secondary_phone','Second Phone Number','DEFAULT',1,'ShortString'),(59,'user','credential','Credentials','Credential',1,'ShortSetStringDB'),(71,'study_funding_source_cai','one_to_four','Funding Source ID','DEFAULT',1,'ShortSetStringUI'),(72,'study_funding_source_cai','comment','Funding Source Comment','DEFAULT',0,'LongSetString'),(73,'study_funding_source_cai','grant_id','Grant ID','DEFAULT',1,'ShortString'),(74,'study_funding_source_cai','funding_source','Funding Source','FundingSource',1,'ShortSetStringDB'),(75,'study_funding_source_cai','project_start_date','Project Start Date','DEFAULT',1,'Date'),(76,'study_funding_source_cai','project_end_date','Project End Date','DEFAULT',1,'Date'),(77,'study_funding_source_cai','site_cost_center','Cost Center','DEFAULT',1,'ShortString'),(79,'study_funding_source_cai','total_direct_award','Total Direct Award','DEFAULT',1,'Number'),(80,'study_funding_source_cai','total_indirect_award','Total Indirect Award','DEFAULT',1,'Number'),(81,'study_funding_source_cai','centers_and_institutions','Centers And Institutions','CentersAndInstitutions',1,'ShortSetStringDB'),(91,'visit_template','id','Visit Template ID','DEFAULT',1,'Number'),(92,'visit_template','active','Active','DEFAULT',1,'Boolean'),(93,'visit_template','approved','Approved','DEFAULT',1,'Boolean'),(94,'visit_template','comment','Visit Template Comment','DEFAULT',0,'LongSetString'),(95,'visit_template','created_date','Visit Template Created Date','DEFAULT',1,'Date'),(96,'visit_template','duration','Visit Template Duration','DEFAULT',1,'Number'),(97,'visit_template','institution_non_crc','Does part of the visit occur at Non-CRC?','DEFAULT',1,'Boolean'),(98,'visit_template','last_update_time','Visit Template Most Recent Update','DEFAULT',1,'Date'),(99,'visit_template','name','Visit Template Name','DEFAULT',1,'ShortString'),(100,'visit_template','nursing','Nursing Level','DEFAULT',1,'Number'),(101,'visit_template','nutrition','Nutrition Level','DEFAULT',1,'Number'),(102,'visit_template','processing','Processing Level','DEFAULT',1,'Number'),(103,'visit_template','setUp','Setup Level','DEFAULT',1,'Number'),(104,'visit_template','relative_time','In Relative Time?','DEFAULT',1,'Boolean'),(105,'visit_template','research_pharmacy','Does this involve Research Pharmacy?','DEFAULT',1,'Boolean'),(106,'visit_template','non_institution_non_crc','Does part of the visit occur Off Institution?','DEFAULT',1,'Boolean'),(108,'visit_template','sublocation','Sub-Location','Sublocation',1,'ShortSetStringDB'),(109,'visit_template','type','Visit Template Visit Type','VisitType',1,'Enum'),(121,'booked_visit','id','Scheduled Visit ID','DEFAULT',1,'Number'),(122,'booked_visit','cancel_date','Cancel Date','DEFAULT',1,'Date'),(123,'booked_visit','check_in_date','Check In Date','DEFAULT',1,'Date'),(124,'booked_visit','check_out_date','Check Out Date','DEFAULT',1,'Date'),(125,'booked_visit','comment','Scheduled Visit Comment','DEFAULT',0,'LongSetString'),(126,'booked_visit','name','Scheduled Visit Name','DEFAULT',1,'ShortString'),(127,'booked_visit','ommitted_activities','Omitted Activities?','DEFAULT',1,'Boolean'),(128,'booked_visit','scheduled_end_time','Scheduled End Time','DEFAULT',1,NULL),(129,'booked_visit','scheduled_start_time','Scheduled Start Time','DEFAULT',1,NULL),(130,'booked_visit','scheduling_flavor','Scheduling Type','DEFAULT',1,'ShortString'),(131,'booked_visit','scheduling_time','User Scheduled Date','DEFAULT',1,'Date'),(132,'booked_visit','scheduling_user_ecommons_id','User that Scheduled','DEFAULT',1,'ShortString'),(133,'booked_visit','vary_duration','Did this visit vary?','DEFAULT',1,'Boolean'),(134,'booked_visit','appointment_status','Appointment Status','AppointmentStatus',1,'ShortSetStringDB'),(135,'booked_visit','appointment_status_reason','Appointment Status Reason','AppointmentStatusReason',1,'ShortSetStringDB'),(136,'booked_visit','cancel_status','Cancel Status','CancellationStatus',1,'ShortSetStringDB'),(142,'booked_visit','type','Visit Type','VisitType',1,'Enum'),(143,'booked_visit','scheduled_end_time,scheduled_start_time','Scheduled Duration','scheduleDuration',0,NULL),(144,'booked_visit','check_out_date,check_in_date','Actual Duration','actualDuration',0,NULL),(145,'booked_visit','check_out_date,check_in_date','# of Overnights','actualDurationOvernights',0,NULL),(147,'booked_visit','scheduled_end_time,scheduled_start_time,check_out_date,check_in_date','Visit Duration Variation','visitVariation',0,NULL),(162,'subject','subject_scheduler_id','Subject Scheduler ID','decrypt',0,NULL),(163,'subject','active','Active','DEFAULT',1,'Boolean'),(164,'subject','first_name','First Name','decrypt',0,NULL),(165,'subject','middle_name','Middle Name','decrypt',0,NULL),(166,'subject','last_name','Last Name','decrypt',0,NULL),(167,'subject','full_name','Full Name','decrypt',0,NULL),(168,'subject','mrn','MRN','decrypt',0,NULL),(169,'subject','birthdate','DOB','DEFAULT',1,'Date'),(170,'subject','street_address1','Street Address','decrypt',0,NULL),(171,'subject','street_address2','Street Address 2','decrypt',0,NULL),(172,'subject','city','City','decrypt',0,NULL),(173,'subject','state','State','State',1,'ShortSetStringDB'),(174,'subject','zip','Zip Code','decrypt',0,NULL),(175,'subject','country','Country','Country',1,'ShortSetStringDB'),(176,'subject','primary_contact_number','Phone Number','decrypt',0,NULL),(177,'subject','secondary_contact_number','Second Phone Number','decrypt',0,NULL),(178,'subject','ethnicity','Ethnicity','Ethnicity',1,'ShortSetStringDB'),(179,'subject','gender','Gender','Gender',1,'ShortSetStringDB'),(180,'subject','race','Race','Race',1,'ShortSetStringDB'),(181,'subject','comment','Comment','DEFAULT',0,'LongSetString'),(182,'subject','created_date','Subject Created Date','DEFAULT',1,'Date'),(192,'booked_resource','id','Scheduled Resource ID','DEFAULT',1,'Number'),(193,'resource','type','Resource Type','DEFAULT',1,'Enum'),(194,'resource','name','Resource Name','Resource',1,'ShortSetStringDbIdBack'),(195,'template_resource','billable','Billable In Template','DEFAULT',1,'Boolean'),(196,'booked_resource','duration','Duration','DEFAULT',1,'Number'),(197,'booked_resource','scheduled_start_time','Resource Start Time','DEFAULT',1,'Date'),(198,'booked_resource','scheduled_end_time','Resource End Time','DEFAULT',1,'Date'),(199,'template_resource','id','Template Resource ID','DEFAULT',1,'Number'),(200,'booked_resource','billable','Billable When Scheduled','DEFAULT',1,'Boolean'),(211,'override_booked_resource_annotations','id','Scheduled Resource Activity ID','DEFAULT',1,'Number'),(212,'line_level_annotations','name','Scheduled Resource Activity','DefaultPlusAnnotations',1,'ShortSetStringDbIdBack'),(213,'override_booked_resource_annotations','quantity','Scheduled Resource Activity Quantity','DEFAULT',1,'Number'),(214,'override_booked_resource_annotations','comment','Scheduled Resource Activity Comment','DEFAULT',0,'LongSetString'),(221,'template_resource_annotations','id','Template Resource Activity ID','DEFAULT',1,'Number'),(222,'template_resource_annotations','comment','Template Resource Activity Comment','DEFAULT',0,'LongSetString'),(223,'template_resource_annotations','quantity','Template Resource Activity Quantity','DEFAULT',1,'Number'),(224,'line_level_annotations','name','Template Resource Activity','DefaultPlusAnnotations',1,'ShortSetStringDbIdBack'),(242,'template_resource','alternate','Uses Standard Alternate?','DEFAULT',1,'Boolean'),(243,'template_resource','id','Resource Sub-Location','SublocationFromTr',1,'ShortSetStringDB'),(244,'template_resource','resource','Resource Name','ResourceFromTr',1,'ShortSetStringDbIdBack'),(245,'template_resource','billable','Billable?','DEFAULT',1,'Boolean'),(246,'template_resource','created_date','Template Resource Most Recent Update','DEFAULT',1,'Date'),(247,'template_resource','duration','Resource Duration','DEFAULT',1,'Number'),(248,'template_resource','start_date','Start Time','DEFAULT',1,'Date'),(249,'template_resource','end_date','End Time','DEFAULT',1,'Date'),(250,'template_resource','flexible','Flexible?','DEFAULT',1,'Boolean'),(251,'template_resource','floatable','Floatable?','DEFAULT',1,'Boolean'),(252,'template_resource','float_start','Float Start Time','DEFAULT',1,'Date'),(253,'template_resource','float_end','Float End Time','DEFAULT',1,'Date'),(254,'template_resource','group_id','Group ID','DEFAULT',1,'ShortString'),(259,'template_resource','start_date','Resource Start Time','DEFAULT',1,'Date'),(260,'template_resource','end_date','Resource End Time','DEFAULT',1,'Date');
/*!40000 ALTER TABLE `field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `funding_source`
--

DROP TABLE IF EXISTS `funding_source`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `funding_source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `funding_source`
--

LOCK TABLES `funding_source` WRITE;
/*!40000 ALTER TABLE `funding_source` DISABLE KEYS */;
INSERT INTO `funding_source` VALUES (1,'Pilot Grant'),(2,'Federal PHS'),(3,'Foundation'),(4,'Industry'),(5,'Institutional/Departmental Funds'),(6,'Other Federal'),(7,'Other');
/*!40000 ALTER TABLE `funding_source` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gender`
--

DROP TABLE IF EXISTS `gender`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gender` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gender`
--

LOCK TABLES `gender` WRITE;
/*!40000 ALTER TABLE `gender` DISABLE KEYS */;
INSERT INTO `gender` VALUES (1,'M','Male'),(2,'F','Female'),(3,'FM','Female to Male'),(4,'MF','Male to Female'),(5,'UNREPORTED','UNREPORTED'),(6,'DECLINED','DECLINED');
/*!40000 ALTER TABLE `gender` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institution`
--

DROP TABLE IF EXISTS `institution`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institution` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `long_name` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institution`
--

LOCK TABLES `institution` WRITE;
/*!40000 ALTER TABLE `institution` DISABLE KEYS */;
INSERT INTO `institution` VALUES (1,'Demo Institution 1','DEMO1'),(2,'Demo Institution 2','DEMO2'),(3,'Demo Institution 3','DEMO3'),(4,'Demo Institution 4','DEMO4'),(5,'Demo Institution 5','DEMO5'),(6,'Demo Institution 6','DEMO6'),(7,'Demo Institution 7','DEMO7'),(8,'Demo Institution 8','DEMO8'),(9,'Demo Institution 9','DEMO9'),(10,'Demo Institution 10','DEMO10'),(11,'Demo Institution 11','DEMO11'),(12,'Demo Institution 12','DEMO12'),(13,'Demo Institution 13','DEMO13'),(14,'Demo Institution 14','DEMO14'),(15,'Demo Institution 15','DEMO15'),(16,'Demo Institution 16','DEMO16'),(17,'Demo Institution 17','DEMO17'),(18,'Demo Institution 18','DEMO18'),(19,'Demo Institution 19','DEMO19'),(20,'Demo Institution 20','DEMO20'),(21,'Demo Institution 21','DEMO21'),(22,'Demo Institution 22','DEMO22'),(23,'Demo Institution 23','DEMO23'),(24,'Demo Institution 24','DEMO24'),(25,'Demo Institution 25','DEMO25'),(26,'Demo Institution 26','DEMO26'),(27,'Demo Institution 27','DEMO27'),(28,'Demo Institution 28','DEMO28'),(29,'Demo Institution 29','DEMO29'),(30,'Demo Institution 30','DEMO30'),(31,'Demo Institution 31','DEMO31'),(32,'Demo Institution 32','DEMO32'),(33,'Demo Institution 33','DEMO33'),(34,'Demo Institution 34','DEMO34'),(35,'Demo Institution 35','DEMO35');
/*!40000 ALTER TABLE `institution` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `institution_role`
--

DROP TABLE IF EXISTS `institution_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `institution_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(21) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_UNIQUE` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `institution_role`
--

LOCK TABLES `institution_role` WRITE;
/*!40000 ALTER TABLE `institution_role` DISABLE KEYS */;
INSERT INTO `institution_role` VALUES (1,'Super Admin has access to all modules and functionality in the System','Super Admin','ROLE_SUPER_ADMIN'),(2,'ND or RD Manager / AD has limited access to modules and functionality in the System','Resource Manager','ROLE_RESOURCE_MANAGER'),(3,'Schedulers have access limited to modules and functionality in the System','Schedulers','ROLE_SCHEDULER'),(4,'Study Staff has access to Resource and Appointments modules and functionality in the System','Study Staff','ROLE_STUDY_STAFF'),(5,'Front Desk has very limited access to modules and functionality in the System','Front Desk','ROLE_FRONT_DESK'),(6,'General View has very limited access to modules and functionality in the System','General View','ROLE_GENERAL_VIEW');
/*!40000 ALTER TABLE `institution_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `irb_institution`
--

DROP TABLE IF EXISTS `irb_institution`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `irb_institution` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `irb_institution`
--

LOCK TABLES `irb_institution` WRITE;
/*!40000 ALTER TABLE `irb_institution` DISABLE KEYS */;
INSERT INTO `irb_institution` VALUES (1,'IRB Demo Inst 1'),(2,'IRB Demo Inst 2'),(3,'IRB Demo Inst 3'),(4,'IRB Demo Inst 4'),(5,'IRB Demo Inst 5'),(6,'IRB Demo Inst 6'),(7,'IRB Demo Inst 7'),(8,'IRB Demo Inst 8'),(9,'IRB Demo Inst 9'),(10,'IRB Demo Inst 10'),(11,'IRB Demo Inst 11'),(12,'IRB Demo Inst 12'),(13,'IRB Demo Inst 13'),(14,'IRB Demo Inst 14'),(15,'IRB Demo Inst 15'),(16,'IRB Demo Inst 16'),(17,'IRB Demo Inst 17'),(18,'IRB Demo Inst 18'),(19,'IRB Demo Inst 19'),(20,'IRB Demo Inst 20'),(21,'IRB Demo Inst 21'),(22,'IRB Demo Inst 22'),(23,'IRB Demo Inst 23'),(24,'IRB Demo Inst 24'),(25,'IRB Demo Inst 25'),(26,'IRB Demo Inst 26'),(27,'IRB Demo Inst 27'),(28,'IRB Demo Inst 28'),(29,'IRB Demo Inst 29'),(30,'IRB Demo Inst 30'),(31,'IRB Demo Inst 31'),(32,'IRB Demo Inst 32'),(33,'IRB Demo Inst 34'),(34,'Other');
/*!40000 ALTER TABLE `irb_institution` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `line_level_annotations`
--

DROP TABLE IF EXISTS `line_level_annotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `line_level_annotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `quantifiable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `line_level_annotations`
--

LOCK TABLES `line_level_annotations` WRITE;
/*!40000 ALTER TABLE `line_level_annotations` DISABLE KEYS */;
INSERT INTO `line_level_annotations` VALUES (1,'Verify Informed Consent',0),(2,'Assessment Nursing Intake - Adult',0),(3,'Assessment Nursing Intake - Pediatrics',0),(4,'Vitals - Simple',1),(5,'Vitals - Complex',1),(6,'EKG 12 Lead',1),(7,'IV access simple - Adult',1),(8,'IV access simple - Pediatrics',1),(9,'IV access complex adult',1),(10,'IV access complex pedi',1),(11,'Monitor and flush drawline',1),(12,'Medication Administration Simple - Adult',1),(13,'Medication Administration Complex - Adult',1),(14,'Medication Administration High Risk IV Push - Adult',1),(15,'Medication Administration Simple - Pediatrics',1),(16,'Medication Administration Complex - Pediatrics',1),(17,'Medication Administration High Risk IV Push - Pediatrics',1),(18,'Monitoring 1:1',0),(19,'Anthropometry',1),(20,'Clinical Nursing Care',0),(21,'Other Specimen Collection Simple',1),(22,'Other Specimen Collection Complex',1),(23,'Patient / family teaching Simple',0),(24,'Patient / family teaching Complex',0),(25,'Point of care testing - simple',1),(26,'Point of care testing - complex',1),(27,'Other',0),(28,'Blood Collection Simple - Pedi',1),(29,'Blood Collection Complex - Pedi',1),(30,'Blood Collection Simple - Adult',1),(31,'Blood Collection Complex - Adult',1),(32,'Travel',0),(33,'Special Protocol Procedure - Simple',1),(34,'Special Protocol Procedure - Complex',1),(35,'Specimen Processing',1),(36,'Protocol Equipment Operation',1),(37,'Clamp Adult',1),(38,'Non-Nutrition Staff: Meal/snack prep and/or delivery',1),(39,'History & Physical - Complete',0),(40,'History & Physical - Targeted',0),(41,'Interprets patient data',0),(42,'Orders labs and diagnostic tests',1),(43,'Assess for AE & SAE',0),(44,'Admitting/Discharging Inpatient',0),(45,'Anthropometry',1),(46,'Education',0),(47,'Food Challenge Preparation',1),(48,'Food Record/Food Recall',1),(49,'Metabolic Sample Collection',1),(50,'Nutrition Documentation',0),(51,'Nutrition Travel',0),(52,'Questionnaire(s)',1),(53,'Service (includes Technician)',1),(54,'Unassisted (Non-CRC personnel performs ultrasound)',1),(55,'Start',1),(56,'Monitor',1),(57,'Download',1),(58,'Body Composition Scan',1),(59,'Bone Scan',1),(60,'DXA Specialized Analysis/Report',1),(61,'Quantity',1),(62,'Comment',0),(63,'Breakfast',1),(64,'Lunch',1),(65,'Dinner',1),(66,'Confirmation of Consent',0),(67,'Standard Research Nursing Care',1),(68,'Blood Collection Complex',1),(69,'Blood Collection Simple',1),(70,'Special Protocol Procedure/Equipment Complex',1),(71,'Special Protocol Procedure/Equipment Simple',1);
/*!40000 ALTER TABLE `line_level_annotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `override_booked_resource_annotations`
--

DROP TABLE IF EXISTS `override_booked_resource_annotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `override_booked_resource_annotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booked_resource` int(11) NOT NULL,
  `line_level_annotations` int(11) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `override_booked_resource_annotations_ibfk_1` (`booked_resource`),
  KEY `override_booked_resource_annotations_ibfk_2` (`line_level_annotations`),
  CONSTRAINT `override_booked_resource_annotations_0__booked_resource` FOREIGN KEY (`booked_resource`) REFERENCES `booked_resource` (`id`),
  CONSTRAINT `override_booked_resource_annotations_1__line_level_annotations` FOREIGN KEY (`line_level_annotations`) REFERENCES `line_level_annotations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `override_booked_resource_annotations`
--

LOCK TABLES `override_booked_resource_annotations` WRITE;
/*!40000 ALTER TABLE `override_booked_resource_annotations` DISABLE KEYS */;
INSERT INTO `override_booked_resource_annotations` VALUES (1,67,62,1,'demo'),(2,72,32,1,'demo'),(3,73,62,1,'demo'),(4,44,3,1,''),(5,44,68,1,''),(6,44,29,1,''),(7,7,61,1,''),(8,4,61,1,''),(9,21,2,1,''),(10,21,31,1,''),(11,22,31,1,''),(12,22,14,1,''),(13,74,48,1,'');
/*!40000 ALTER TABLE `override_booked_resource_annotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `race`
--

DROP TABLE IF EXISTS `race`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `race` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `race`
--

LOCK TABLES `race` WRITE;
/*!40000 ALTER TABLE `race` DISABLE KEYS */;
INSERT INTO `race` VALUES (1,'White'),(2,'Black or African American'),(3,'Asian'),(4,'American Indian/ Alaskan Native'),(5,'Native Hawaiian or Other Pacific Islander'),(6,'More than one race'),(7,'Unknown or Not Reported'),(8,'DECLINED');
/*!40000 ALTER TABLE `race` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `report`
--

DROP TABLE IF EXISTS `report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `report`
--

LOCK TABLES `report` WRITE;
/*!40000 ALTER TABLE `report` DISABLE KEYS */;
INSERT INTO `report` VALUES (1,'List of resources needed by visit for a particular date range ','Daily Resource Usage','daily_resource'),(2,'List of study subjects whose visits are scheduled to begin for a particular date range - and the resources needed for each visit ','Daily Admission and Check-In','daily_adm'),(3,'List of Scheduled, Checked-In meals, snacks and rooms by subject for a particular date range','Metabolic Kitchen by Subject','meta_kitchen'),(4,'List of Cancellations and Reasons by study, visit and subject for a particular date range','Cancellations and Reasons','cancellations'),(5,'List of study Visits (Scheduled, Checked-In) during a particular date range for studies which indicated use of research pharmacy, listed by subject','Weekly Pharmacy','weekly_pharm'),(6,'List of studies assigned to each nurse, including IRB expiration date ','Protocols by Nurse','proto_by_nurse'),(7,'List of Visits by location, visit type, check-in information, subject, and study for a particular date range','Study Visit Location','study_visit_location'),(8,'List of checked-out visit information by PI and department for a particular date range ','Department and PI','dept_and_pi'),(9,'List of Checked-Out Visits by billable resource, with over midnight calculation for a particular date range','Billing','billing'),(10,'List of Checked-Out billable resources with PI information for a particular date range','Billable Resources','billable_resources'),(11,'List of Checked-Out Visits by billable resource sorted by PI; can run single PI reports for a particular date range','Billing by Investigator','billing_by_investigator'),(12,'List of changes to study visit statuses: time of change, user, and visit details for a particular date range','Operations Management: Transactions','transactions'),(13,'List of Checked-Out Visits by completed, terminated prior to completion, and Reasons by visit, PI and study for a particular date range','Census','census'),(14,'List of study subjects in the database who do not have a Scheduled visit, and do not have a Checked-Out status','Subject Purge','subject_purge'),(15,'List of Overrides by user, date, reason, and visit','Override','override'),(16,'List of study subject views by staff','Staff Views of Subjects by MRN','subject_audit_staff_views'),(17,'List of staff views of study subject','Staff Views of Subjects by User','staff_audit_subject_views'),(18,'ALL FIELDS for all studies','Study Data','study_data'),(19,'ALL FIELDS of User records','User Data','user_data'),(20,'Daily overview of Scheduled and Checked-In Visits in a specific date range for booked resources','Daily Overview','daily_overview'),(21,'Off Unit Activity for all the Scheduled and Checked-In Visits','Off Unit Activity','off_unit'),(22,'Level Of service for all the checked-out visits.','Level of Service','level_of_service'),(23,'List of Scheduled, Checked-In meals, snacks and rooms by time for a particular date range','Metabolic Kitchen by Time','meta_kitchen_by_time'),(25,'A list of visits, by subject, and their status history','Visit Status History By Subject','subject_visit_history'),(26,'CRC Availability','CRC Availability','crc_availability'),(27,'A list of subjects with booked visits and the visit status','Visit History by Subject','study_subject_visit'),(28,'Resources, duration, and workload levels for all visit templates','Workload and Resources Report','resource_level_of_service'),(29,'ALL FIELDS on all visit templates','Visit Template Data','visit_template_data'),(31,'Study Status Change Report','Study Status Change','study_status_change'),(32,'A list of visits with scheduled start time, end time, actual duration and visit type in a particular date range','Visit Duration By Visit Type','visit_duration_by_visit_type'),(33,'A count of levels of service per visit in a specific time range','Booked Visit Service Levels by Visit Type','booked_visit_service_level_by_visit_type'),(35,'A count of Ancillaries Only visits by protocol (category A, B, D) in a specific date range','Ancillaries Only Visits By Protocol','ancillary_only_by_protocol'),(36,'List of studies assigned to each nutritionist, including IRB expiration date','Protocols By Nutritionist','proto_by_nutritionist'),(37,'List Of Visits Flagged for Edit.','Visits Flagged for Edit','visits_flagged_edit');
/*!40000 ALTER TABLE `report` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `report_template`
--

DROP TABLE IF EXISTS `report_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `display_name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `date_bound` tinyint(1) NOT NULL,
  `graph_type` char(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `report_template`
--

LOCK TABLES `report_template` WRITE;
/*!40000 ALTER TABLE `report_template` DISABLE KEYS */;
INSERT INTO `report_template` VALUES (1,'Scheduled Visit Data','Administrative',1,'BookedVisit'),(2,'Study & Visit Template Data','Administrative',0,'StudyAndVisitTemplate');
/*!40000 ALTER TABLE `report_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `shared_resource` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_resource_name` (`name`),
  KEY `FKEBABC40E6D9F53A5` (`shared_resource`),
  KEY `idx_resource_type` (`type`),
  CONSTRAINT `resource_0__resource` FOREIGN KEY (`shared_resource`) REFERENCES `resource` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` VALUES (1,'Nurse - Sub-Location 1',NULL,'Nursing'),(2,'Nurse - Sub-Location 2',NULL,'Nursing'),(3,'Nurse - Sub-Location 3',NULL,'Nursing'),(4,'Nurse - Sub-Location 4',NULL,'Nursing'),(5,'Nurse Practitioner  - Sub-Location 1',NULL,'Nursing'),(6,'Nurse Practitioner  - Sub-Location 2',NULL,'Nursing'),(7,'Nurse Practitioner  - Sub-Location 3',NULL,'Nursing'),(8,'Assistant/Tech, Lab - Sub-Location 1',NULL,'Nursing'),(9,'Assistant/Tech, Lab - Sub-Location 2',NULL,'Nursing'),(10,'Assistant/Tech, Lab - Sub-Location 3',NULL,'Nursing'),(11,'Assistant/Tech, Lab - Sub-Location 4',NULL,'Nursing'),(12,'Dietitian, Research - Sub-Location 1',NULL,'Nutrition'),(13,'Dietitian, Research - Sub-Location 2',NULL,'Nutrition'),(14,'Dietitian, Research - Sub-Location 3',NULL,'Nutrition'),(15,'Dietitian, Research - Sub-Location 4',NULL,'Nutrition'),(16,'Assistant/Tech, Diet - Sub-Location 1',NULL,'Nutrition'),(17,'Assistant/Tech, Diet - Sub-Location 2',NULL,'Nutrition'),(18,'DXA - Sub-Location 4',NULL,'Other'),(19,'Calorimeter, Indirect - Sub-Location 1',NULL,'Other'),(20,'Calorimeter, Indirect - Sub-Location 2',NULL,'Other'),(21,'Meal, Weighed-Controlled - Sub-Location 1',NULL,'Nutrition'),(22,'Meal, Weighed-Controlled - Sub-Location 2',NULL,'Nutrition'),(23,'Meal, Weighed-Controlled - Sub-Location 3',NULL,'Nutrition'),(24,'Meal, Weighed-Controlled - Sub-Location 4',NULL,'Nutrition'),(25,'Meal, Regular - Sub-Location 1',NULL,'Nutrition'),(26,'Meal, Regular - Sub-Location 2',NULL,'Nutrition'),(27,'Meal, Regular - Sub-Location 3',NULL,'Nutrition'),(28,'Meal, Regular - Sub-Location 4',NULL,'Nutrition'),(29,'Snack- Sub-Location 1',NULL,'Nutrition'),(30,'Snack- Sub-Location 2',NULL,'Nutrition'),(31,'Snack- Sub-Location 3',NULL,'Nutrition'),(32,'Snack- Sub-Location 4',NULL,'Nutrition'),(33,'Room 1 - Sub-Location 1',NULL,'Room'),(34,'Room 2 - Sub-Location 1',NULL,'Room'),(35,'Room 3 - Sub-Location 1',NULL,'Room'),(36,'Room 1 - Sub-Location 2',NULL,'Room'),(37,'Room 2 - Sub-Location 2',NULL,'Room'),(38,'Room 3 - Sub-Location 2',NULL,'Room'),(39,'Room 1 - Sub-Location 3',NULL,'Room'),(40,'Room 2 - Sub-Location 3',NULL,'Room'),(41,'Room 3 - Sub-Location 3',NULL,'Room'),(42,'Room 1 - Sub-Location 4',NULL,'Room'),(43,'Room 2 - Sub-Location 4',NULL,'Room'),(44,'Room 3 - Sub-Location 4',NULL,'Room'),(45,'Device, Vitaport - Sub-Location 3',NULL,'Other');
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_alternate`
--

DROP TABLE IF EXISTS `resource_alternate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource_alternate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_resource` int(11) NOT NULL,
  `alternate_resource` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_resAlt_srcRes` (`source_resource`,`alternate_resource`),
  KEY `FK229CC589ABB5EAEB` (`alternate_resource`),
  KEY `FK229CC5895C44C86A` (`source_resource`),
  CONSTRAINT `resource_alternate_0__resource` FOREIGN KEY (`alternate_resource`) REFERENCES `resource` (`id`),
  CONSTRAINT `resource_alternate_1__resource` FOREIGN KEY (`source_resource`) REFERENCES `resource` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_alternate`
--

LOCK TABLES `resource_alternate` WRITE;
/*!40000 ALTER TABLE `resource_alternate` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_alternate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_annotation`
--

DROP TABLE IF EXISTS `resource_annotation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource_annotation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource` int(11) NOT NULL,
  `line_level_annotations` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_annotation_unique1` (`resource`,`line_level_annotations`),
  KEY `resource_annotation_ibfk_1` (`resource`),
  KEY `resource_annotation_ibfk_2` (`line_level_annotations`),
  CONSTRAINT `resource_annotation_0__resource` FOREIGN KEY (`resource`) REFERENCES `resource` (`id`),
  CONSTRAINT `resource_annotation_1__line_level_annotations` FOREIGN KEY (`line_level_annotations`) REFERENCES `line_level_annotations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=648 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_annotation`
--

LOCK TABLES `resource_annotation` WRITE;
/*!40000 ALTER TABLE `resource_annotation` DISABLE KEYS */;
INSERT INTO `resource_annotation` VALUES (1,1,1),(2,1,2),(3,1,3),(4,1,4),(5,1,5),(6,1,6),(7,1,7),(8,1,8),(9,1,9),(10,1,10),(11,1,11),(12,1,12),(13,1,13),(14,1,14),(15,1,15),(16,1,16),(17,1,17),(18,1,18),(19,1,19),(20,1,20),(21,1,21),(22,1,22),(23,1,23),(24,1,24),(25,1,25),(26,1,26),(27,1,27),(28,1,28),(29,1,29),(30,1,30),(31,1,31),(32,1,32),(33,1,33),(34,1,34),(35,1,35),(36,1,36),(37,1,37),(38,1,38),(39,1,66),(40,1,67),(41,1,68),(42,1,69),(43,1,70),(44,1,71),(45,2,1),(46,2,2),(47,2,3),(48,2,4),(49,2,5),(50,2,6),(51,2,7),(52,2,8),(53,2,9),(54,2,10),(55,2,11),(56,2,12),(57,2,13),(58,2,14),(59,2,15),(60,2,16),(61,2,17),(62,2,18),(63,2,19),(64,2,20),(65,2,21),(66,2,22),(67,2,23),(68,2,24),(69,2,25),(70,2,26),(71,2,27),(72,2,28),(73,2,29),(74,2,30),(75,2,31),(76,2,32),(77,2,33),(78,2,34),(79,2,35),(80,2,36),(81,2,37),(82,2,38),(83,2,66),(84,2,67),(85,2,68),(86,2,69),(87,2,70),(88,2,71),(89,3,1),(90,3,2),(91,3,3),(92,3,4),(93,3,5),(94,3,6),(95,3,7),(96,3,8),(97,3,9),(98,3,10),(99,3,11),(100,3,12),(101,3,13),(102,3,14),(103,3,15),(104,3,16),(105,3,17),(106,3,18),(107,3,19),(108,3,20),(109,3,21),(110,3,22),(111,3,23),(112,3,24),(113,3,25),(114,3,26),(115,3,27),(116,3,28),(117,3,29),(118,3,30),(119,3,31),(120,3,32),(121,3,33),(122,3,34),(123,3,35),(124,3,36),(125,3,37),(126,3,38),(127,3,66),(128,3,67),(129,3,68),(130,3,69),(131,3,70),(132,3,71),(133,4,1),(134,4,2),(135,4,3),(136,4,4),(137,4,5),(138,4,6),(139,4,7),(140,4,8),(141,4,9),(142,4,10),(143,4,11),(144,4,12),(145,4,13),(146,4,14),(147,4,15),(148,4,16),(149,4,17),(150,4,18),(151,4,19),(152,4,20),(153,4,21),(154,4,22),(155,4,23),(156,4,24),(157,4,25),(158,4,26),(159,4,27),(160,4,28),(161,4,29),(162,4,30),(163,4,31),(164,4,32),(165,4,33),(166,4,34),(167,4,35),(168,4,36),(169,4,37),(170,4,38),(171,4,66),(172,4,67),(173,4,68),(174,4,69),(175,4,70),(176,4,71),(177,5,1),(178,5,2),(179,5,3),(180,5,4),(181,5,5),(182,5,6),(183,5,7),(184,5,8),(185,5,9),(186,5,10),(187,5,11),(188,5,12),(189,5,13),(190,5,14),(191,5,15),(192,5,16),(193,5,17),(194,5,18),(195,5,19),(196,5,20),(197,5,21),(198,5,22),(199,5,23),(200,5,24),(201,5,25),(202,5,26),(203,5,27),(204,5,28),(205,5,29),(206,5,30),(207,5,31),(208,5,32),(209,5,33),(210,5,34),(211,5,35),(212,5,36),(213,5,37),(214,5,38),(215,5,39),(216,5,40),(217,5,41),(218,5,42),(219,5,43),(220,5,44),(221,5,66),(222,5,67),(223,5,68),(224,5,69),(225,5,70),(226,5,71),(227,6,1),(228,6,2),(229,6,3),(230,6,4),(231,6,5),(232,6,6),(233,6,7),(234,6,8),(235,6,9),(236,6,10),(237,6,11),(238,6,12),(239,6,13),(240,6,14),(241,6,15),(242,6,16),(243,6,17),(244,6,18),(245,6,19),(246,6,20),(247,6,21),(248,6,22),(249,6,23),(250,6,24),(251,6,25),(252,6,26),(253,6,27),(254,6,28),(255,6,29),(256,6,30),(257,6,31),(258,6,32),(259,6,33),(260,6,34),(261,6,35),(262,6,36),(263,6,37),(264,6,38),(265,6,39),(266,6,40),(267,6,41),(268,6,42),(269,6,43),(270,6,44),(271,6,66),(272,6,67),(273,6,68),(274,6,69),(275,6,70),(276,6,71),(277,7,1),(278,7,2),(279,7,3),(280,7,4),(281,7,5),(282,7,6),(283,7,7),(284,7,8),(285,7,9),(286,7,10),(287,7,11),(288,7,12),(289,7,13),(290,7,14),(291,7,15),(292,7,16),(293,7,17),(294,7,18),(295,7,19),(296,7,20),(297,7,21),(298,7,22),(299,7,23),(300,7,24),(301,7,25),(302,7,26),(303,7,27),(304,7,28),(305,7,29),(306,7,30),(307,7,31),(308,7,32),(309,7,33),(310,7,34),(311,7,35),(312,7,36),(313,7,37),(314,7,38),(315,7,39),(316,7,40),(317,7,41),(318,7,42),(319,7,43),(320,7,44),(321,7,66),(322,7,67),(323,7,68),(324,7,69),(325,7,70),(326,7,71),(327,8,1),(328,8,2),(329,8,3),(330,8,4),(331,8,5),(332,8,6),(333,8,7),(334,8,8),(335,8,9),(336,8,10),(337,8,11),(338,8,12),(339,8,13),(340,8,14),(341,8,15),(342,8,16),(343,8,17),(344,8,18),(345,8,19),(346,8,20),(347,8,21),(348,8,22),(349,8,23),(350,8,24),(351,8,25),(352,8,26),(353,8,27),(354,8,28),(355,8,29),(356,8,30),(357,8,31),(358,8,32),(359,8,33),(360,8,34),(361,8,35),(362,8,36),(363,8,37),(364,8,38),(365,8,66),(366,8,68),(367,8,69),(368,8,70),(369,8,71),(370,9,1),(371,9,2),(372,9,3),(373,9,4),(374,9,5),(375,9,6),(376,9,7),(377,9,8),(378,9,9),(379,9,10),(380,9,11),(381,9,12),(382,9,13),(383,9,14),(384,9,15),(385,9,16),(386,9,17),(387,9,18),(388,9,19),(389,9,20),(390,9,21),(391,9,22),(392,9,23),(393,9,24),(394,9,25),(395,9,26),(396,9,27),(397,9,28),(398,9,29),(399,9,30),(400,9,31),(401,9,32),(402,9,33),(403,9,34),(404,9,35),(405,9,36),(406,9,37),(407,9,38),(408,9,66),(409,9,68),(410,9,69),(411,9,70),(412,9,71),(413,10,1),(414,10,2),(415,10,3),(416,10,4),(417,10,5),(418,10,6),(419,10,7),(420,10,8),(421,10,9),(422,10,10),(423,10,11),(424,10,12),(425,10,13),(426,10,14),(427,10,15),(428,10,16),(429,10,17),(430,10,18),(431,10,19),(432,10,20),(433,10,21),(434,10,22),(435,10,23),(436,10,24),(437,10,25),(438,10,26),(439,10,27),(440,10,28),(441,10,29),(442,10,30),(443,10,31),(444,10,32),(445,10,33),(446,10,34),(447,10,35),(448,10,36),(449,10,37),(450,10,38),(451,10,66),(452,10,68),(453,10,69),(454,10,70),(455,10,71),(456,11,1),(457,11,2),(458,11,3),(459,11,4),(460,11,5),(461,11,6),(462,11,7),(463,11,8),(464,11,9),(465,11,10),(466,11,11),(467,11,12),(468,11,13),(469,11,14),(470,11,15),(471,11,16),(472,11,17),(473,11,18),(474,11,19),(475,11,20),(476,11,21),(477,11,22),(478,11,23),(479,11,24),(480,11,25),(481,11,26),(482,11,27),(483,11,28),(484,11,29),(485,11,30),(486,11,31),(487,11,32),(488,11,33),(489,11,34),(490,11,35),(491,11,36),(492,11,37),(493,11,38),(494,11,66),(495,11,68),(496,11,69),(497,11,70),(498,11,71),(507,12,1),(508,12,21),(509,12,22),(510,12,25),(511,12,26),(512,12,27),(499,12,45),(500,12,46),(501,12,47),(502,12,48),(503,12,49),(504,12,50),(505,12,51),(506,12,52),(513,12,66),(522,13,1),(523,13,21),(524,13,22),(525,13,25),(526,13,26),(527,13,27),(514,13,45),(515,13,46),(516,13,47),(517,13,48),(518,13,49),(519,13,50),(520,13,51),(521,13,52),(528,13,66),(537,14,1),(538,14,21),(539,14,22),(540,14,25),(541,14,26),(542,14,27),(529,14,45),(530,14,46),(531,14,47),(532,14,48),(533,14,49),(534,14,50),(535,14,51),(536,14,52),(543,14,66),(552,15,1),(553,15,21),(554,15,22),(555,15,25),(556,15,26),(557,15,27),(544,15,45),(545,15,46),(546,15,47),(547,15,48),(548,15,49),(549,15,50),(550,15,51),(551,15,52),(558,15,66),(567,16,1),(568,16,21),(569,16,22),(570,16,25),(571,16,26),(572,16,27),(559,16,45),(560,16,46),(561,16,47),(562,16,48),(563,16,49),(564,16,50),(565,16,51),(566,16,52),(573,16,66),(582,17,1),(583,17,21),(584,17,22),(585,17,25),(586,17,26),(587,17,27),(574,17,45),(575,17,46),(576,17,47),(577,17,48),(578,17,49),(579,17,50),(580,17,51),(581,17,52),(588,17,66),(589,18,58),(590,18,59),(591,18,60),(593,19,32),(592,19,62),(595,20,32),(594,20,62),(596,21,61),(597,21,63),(598,21,64),(599,21,65),(600,22,61),(601,22,63),(602,22,64),(603,22,65),(604,23,61),(605,23,63),(606,23,64),(607,23,65),(608,24,61),(609,24,63),(610,24,64),(611,24,65),(612,25,61),(613,25,63),(614,25,64),(615,25,65),(616,26,61),(617,26,63),(618,26,64),(619,26,65),(620,27,61),(621,27,63),(622,27,64),(623,27,65),(624,28,61),(625,28,63),(626,28,64),(627,28,65),(628,29,61),(629,30,61),(630,31,61),(631,32,61),(632,33,62),(633,34,62),(634,35,62),(635,36,62),(636,37,62),(637,38,62),(638,39,62),(639,40,62),(640,41,62),(641,42,62),(642,43,62),(643,44,62),(644,45,32),(645,45,55),(646,45,56),(647,45,57);
/*!40000 ALTER TABLE `resource_annotation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_schedule`
--

DROP TABLE IF EXISTS `resource_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `day_of_week` int(11) DEFAULT NULL,
  `quantity` float DEFAULT '0',
  `override` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK7720AFA8701BE7FC` (`resource`),
  CONSTRAINT `resource_schedule_1__resource` FOREIGN KEY (`resource`) REFERENCES `resource` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_schedule`
--

LOCK TABLES `resource_schedule` WRITE;
/*!40000 ALTER TABLE `resource_schedule` DISABLE KEYS */;
INSERT INTO `resource_schedule` VALUES (1,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(2,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(3,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(4,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(5,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(6,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(7,17,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(8,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(9,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(10,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(11,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(12,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(13,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(14,9,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(15,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(16,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(17,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(18,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(19,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(20,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(21,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(22,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(23,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(24,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(25,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(26,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(27,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(28,19,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:45:00'),7,1,0),(29,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(30,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(31,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(32,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(33,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(34,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(35,45,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(36,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(37,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(38,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(39,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(40,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(41,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(42,13,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(43,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(44,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(45,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(46,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(47,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(48,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(49,25,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(50,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(51,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(52,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(53,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(54,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(55,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(56,27,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(57,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(58,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(59,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(60,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(61,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(62,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(63,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(64,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(65,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(66,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(67,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(68,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(69,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(70,3,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(71,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(72,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(73,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(74,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(75,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(76,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(77,7,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(78,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(79,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(80,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(81,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(82,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(83,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(84,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(85,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(86,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(87,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(88,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(89,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(90,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(91,33,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(92,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(93,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(94,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(95,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(96,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(97,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(98,39,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(99,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(100,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(101,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(102,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(103,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(104,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(105,37,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(106,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(107,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(108,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(109,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(110,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(111,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(112,43,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(113,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(114,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(115,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(116,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(117,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(118,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(119,35,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(120,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(121,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(122,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(123,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(124,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(125,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(126,41,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(127,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(128,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(129,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(130,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(131,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(132,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(133,29,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(134,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(135,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(136,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(137,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(138,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(139,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(140,31,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0),(141,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),1,1,0),(142,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),2,1,0),(143,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),3,1,0),(144,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),4,1,0),(145,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),5,1,0),(146,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),6,1,0),(147,36,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2008-01-01 23:59:00'),7,1,0);
/*!40000 ALTER TABLE `resource_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_sublocation`
--

DROP TABLE IF EXISTS `resource_sublocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource_sublocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sublocation` int(11) DEFAULT NULL,
  `resource` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_rescSubLoc_id1` (`resource`,`sublocation`),
  KEY `FKB60B9B4450E3AD0B` (`resource`),
  KEY `FKB60B9B44135C3C9B` (`sublocation`),
  CONSTRAINT `resource_sublocation_0__resource` FOREIGN KEY (`resource`) REFERENCES `resource` (`id`),
  CONSTRAINT `resource_sublocation_1__sublocation` FOREIGN KEY (`sublocation`) REFERENCES `sublocation` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_sublocation`
--

LOCK TABLES `resource_sublocation` WRITE;
/*!40000 ALTER TABLE `resource_sublocation` DISABLE KEYS */;
INSERT INTO `resource_sublocation` VALUES (1,1,1),(2,3,3),(3,1,5),(4,3,7),(5,2,9),(6,4,11),(7,2,13),(8,4,15),(9,2,17),(10,1,19),(11,1,21),(12,3,23),(13,1,25),(14,3,27),(15,1,29),(16,3,31),(17,1,33),(18,1,35),(24,2,36),(19,2,37),(20,3,39),(21,3,41),(22,4,43),(23,3,45);
/*!40000 ALTER TABLE `resource_sublocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_type`
--

DROP TABLE IF EXISTS `resource_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resource_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_type`
--

LOCK TABLES `resource_type` WRITE;
/*!40000 ALTER TABLE `resource_type` DISABLE KEYS */;
INSERT INTO `resource_type` VALUES (1,'Nursing'),(2,'Nutrition'),(3,'Room'),(4,'Lab'),(5,'Other');
/*!40000 ALTER TABLE `resource_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_UNIQUE` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` VALUES (1,'Study Coordinator - Research Asst','ROLE_STUDY_COORDINATOR_RESEARCH_ASST'),(2,'PI','ROLE_PI'),(3,'Co-Investigator','ROLE_CO_INVESTIGATOR'),(4,'Other Study Staff','ROLE_OTHER_STUDY_STAFF'),(5,'Nurse','ROLE_NURSE'),(6,'Nutritionist','ROLE_NUTRITIONIST'),(7,'CRC Administration','ROLE_CRC_ADMINISTRATION'),(8,'Lab','ROLE_LAB'),(9,'Administrative Director','ROLE_ADMINISTRATIVE_DIRECTOR'),(10,'Nurse Manager Director','ROLE_NURSE_MANAGER_DIRECTOR'),(11,'Nutrition Manager','ROLE_NUTRITION_MANAGER'),(12,'Final Approver','ROLE_FINAL_APPROVER'),(13,'Physician','ROLE_PHYSICIAN'),(14,'Physician2','ROLE_PHYSICIAN2'),(15,'Scheduler','ROLE_SCHEDULER'),(16,'Scheduler2','ROLE_SCHEDULER2'),(18,'Associate Nurse','ROLE_ASSOCIATE_NURSE'),(19,'Associate RD','ROLE_ASSOCIATE_RD');
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `state`
--

DROP TABLE IF EXISTS `state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `state` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `state`
--

LOCK TABLES `state` WRITE;
/*!40000 ALTER TABLE `state` DISABLE KEYS */;
INSERT INTO `state` VALUES (1,'Massachusetts'),(2,'Alabama'),(3,'Alaska'),(4,'Arizona'),(5,'Arkansas'),(6,'California'),(7,'Colorado'),(8,'Connecticut'),(9,'Delaware'),(10,'Florida'),(11,'Georgia'),(12,'Hawaii'),(13,'Idaho'),(14,'Illinois'),(15,'Indiana'),(16,'Iowa'),(17,'Kansas'),(18,'Kentucky'),(19,'Louisiana'),(20,'Maine'),(21,'Maryland'),(22,'Michigan'),(23,'Minnesota'),(24,'Mississippi'),(25,'Missouri'),(26,'Montana'),(27,'Nebraska'),(28,'Nevada'),(29,'New Hampshire'),(30,'New Jersey'),(31,'New Mexico'),(32,'New York'),(33,'North Carolina'),(34,'North Dakota'),(35,'Ohio'),(36,'Oklahoma'),(37,'Oregon'),(38,'Pennsylvania'),(39,'Rhode Island'),(40,'South Carolina'),(41,'South Dakota'),(42,'Tennessee'),(43,'Texas'),(44,'Utah'),(45,'Vermont'),(46,'Virginia'),(47,'Washington'),(48,'West Virginia'),(49,'Wisconsin'),(50,'Wyoming'),(51,'American Samoa'),(52,'District of Columbia'),(53,'Federated States of Micronesia'),(54,'Guam'),(55,'Marshall Islands'),(56,'Northern Mariana Islands'),(57,'Palau'),(58,'Puerto Rico'),(59,'Virgin Islands');
/*!40000 ALTER TABLE `state` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `study`
--

DROP TABLE IF EXISTS `study`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `study` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catalyst_id` varchar(255) DEFAULT NULL,
  `crc_category` varchar(255) DEFAULT NULL,
  `spid` varchar(255) DEFAULT NULL,
  `protocol_number` varchar(255) DEFAULT NULL,
  `expected_end_date` date DEFAULT NULL,
  `expected_start_date` date DEFAULT NULL,
  `industry_initiated` tinyint(1) DEFAULT '0',
  `institution` int(11) DEFAULT NULL,
  `irb` varchar(255) DEFAULT NULL,
  `irb_approval_date` datetime DEFAULT NULL,
  `irb_expiration` datetime DEFAULT NULL,
  `irb_institution` int(11) DEFAULT NULL,
  `irb_renewal_date` datetime DEFAULT NULL,
  `local_id` varchar(255) DEFAULT NULL,
  `short_title` varchar(255) DEFAULT NULL,
  `name` text,
  `study_status` int(11) DEFAULT NULL,
  `total_inpatient_visits` int(11) DEFAULT NULL,
  `total_outpatient_visits` int(11) DEFAULT NULL,
  `total_subjects` int(11) DEFAULT NULL,
  `pediatric` varchar(255) DEFAULT NULL,
  `principal_investigator` int(11) DEFAULT NULL,
  `responsible_physician` int(11) DEFAULT NULL,
  `responsible_physician2` int(11) DEFAULT NULL,
  `primary_scheduling_contact` int(11) DEFAULT NULL,
  `secondary_scheduling_contact` int(11) DEFAULT NULL,
  `protocol_nutritionist` int(11) DEFAULT NULL,
  `protocol_nurse` int(11) DEFAULT NULL,
  `associate_nurse` int(11) DEFAULT NULL,
  `scheduler3` int(11) DEFAULT NULL,
  `protocol_nurse_string` varchar(255) DEFAULT NULL,
  `protocol_nutritionist_string` varchar(255) DEFAULT NULL,
  `crc_funded` tinyint(1) NOT NULL DEFAULT '0',
  `associate_protocol_nutritionist` int(11) DEFAULT NULL,
  `study_abstract` varchar(3000) DEFAULT NULL,
  `clinical_trial` varchar(15) DEFAULT NULL,
  `new_drug` varchar(15) DEFAULT NULL,
  `device_exemption` varchar(15) DEFAULT NULL,
  `status_change` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK68B0DC9FF65A76B` (`responsible_physician2`),
  KEY `FK68B0DC91ADD054` (`principal_investigator`),
  KEY `FK68B0DC9D3D82F0` (`protocol_nurse`),
  KEY `FK68B0DC930E28873` (`protocol_nutritionist`),
  KEY `FK68B0DC9AF7BD5B` (`responsible_physician`),
  KEY `FK68B0DC97D2606F6` (`associate_nurse`),
  KEY `FK68B0DC97C49620C` (`primary_scheduling_contact`),
  KEY `FK68B0DC9F2DA955A` (`secondary_scheduling_contact`),
  KEY `FK68B0DC96114C21` (`institution`),
  KEY `FK68B0DC99EE8853B` (`irb_institution`),
  KEY `FK68B0DC91E68EAF4` (`study_status`),
  KEY `FK68B0DC9C8CD3712` (`scheduler3`),
  KEY `associte_proto_nutritionist_fk` (`associate_protocol_nutritionist`),
  CONSTRAINT `study_0__user` FOREIGN KEY (`associate_protocol_nutritionist`) REFERENCES `user` (`id`),
  CONSTRAINT `study_10__user` FOREIGN KEY (`principal_investigator`) REFERENCES `user` (`id`),
  CONSTRAINT `study_11__user` FOREIGN KEY (`protocol_nutritionist`) REFERENCES `user` (`id`),
  CONSTRAINT `study_12__user` FOREIGN KEY (`primary_scheduling_contact`) REFERENCES `user` (`id`),
  CONSTRAINT `study_13__user` FOREIGN KEY (`responsible_physician2`) REFERENCES `user` (`id`),
  CONSTRAINT `study_14__user` FOREIGN KEY (`responsible_physician`) REFERENCES `user` (`id`),
  CONSTRAINT `study_15__user` FOREIGN KEY (`secondary_scheduling_contact`) REFERENCES `user` (`id`),
  CONSTRAINT `study_1__study_status` FOREIGN KEY (`study_status`) REFERENCES `study_status` (`id`),
  CONSTRAINT `study_6__irb_institution` FOREIGN KEY (`irb_institution`) REFERENCES `irb_institution` (`id`),
  CONSTRAINT `study_7__user` FOREIGN KEY (`scheduler3`) REFERENCES `user` (`id`),
  CONSTRAINT `study_8__institution` FOREIGN KEY (`institution`) REFERENCES `institution` (`id`),
  CONSTRAINT `study_9__user` FOREIGN KEY (`protocol_nurse`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `study`
--

LOCK TABLES `study` WRITE;
/*!40000 ALTER TABLE `study` DISABLE KEYS */;
INSERT INTO `study` VALUES (1,'TA001','A',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-01-01'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2001-01-01'),0,5,'2001TA001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2001-01-01 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-01-01 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-01-01 10:00:00'),'TA-001','','Test Study 001',2,11,11,5,'Adult',416,NULL,NULL,416,NULL,412,411,NULL,NULL,NULL,NULL,0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:19:06')),(2,'TA002','B',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-02-02'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2002-02-02'),0,5,'2002TA002',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2002-02-02 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-02-02 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-02-02 10:00:00'),'TA-002','','Test Study 002',2,12,12,6,'Pediatric',417,NULL,NULL,417,NULL,NULL,411,NULL,NULL,NULL,'N/A',0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(3,'TB003','C',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03'),0,5,'2003TB003',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-03-03 10:00:00'),'TB-003','','Test Study 003',2,13,13,7,'Adult/Pediatric',411,NULL,NULL,416,417,412,NULL,NULL,NULL,'N/A',NULL,0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(4,'TC004','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-04-04'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-04-04'),1,5,'2004TC004',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-04-04 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-04-04 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-04-04 10:00:00'),'TC-004','','Test Study 004',2,14,14,5,'Adult',418,NULL,NULL,417,416,NULL,NULL,NULL,NULL,'N/A','N/A',1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(5,'TD005','C',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-05-05'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-05-05'),0,5,'2005TB005',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2005-05-05 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-05-05 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-05-05 10:00:00'),'TD-005','','Test Study 005',1,13,13,7,'Adult/Pediatric',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28')),(6,'TC006','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2006TC006',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'TC-006','','Test Study 006',3,14,14,5,'Adult',418,NULL,NULL,417,416,NULL,NULL,NULL,NULL,'N/A','N/A',1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30')),(7,'AS001','A',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03'),0,5,'2003AS001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-03-03 10:00:00'),'AS001','','Auto Study 001',2,13,13,7,'Adult/Pediatric',419,NULL,NULL,413,420,NULL,411,NULL,NULL,NULL,'N/A',0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:56:41')),(8,'AS002','B',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-04-04'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-04-04'),1,5,'2003AS002',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-04-04 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-04-04 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-04-04 10:00:00'),'AS002','','Auto Study 002',2,14,14,5,'Adult',420,NULL,NULL,420,421,NULL,NULL,NULL,NULL,'N/A','N/A',1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03')),(9,'AS003','C',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-05-05'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-05-05'),0,5,'2003AS003',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2005-05-05 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-05-05 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-05-05 10:00:00'),'AS003','','Auto Study 003',2,13,13,7,'Adult/Pediatric',419,NULL,NULL,413,421,NULL,NULL,NULL,NULL,'N/A','N/A',0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05')),(10,'AS004','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2003AS004',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'AS004','','Auto Study 004',1,14,14,5,'Adult',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07')),(11,'OUT001','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2001OUT001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'OUT-001','','Scheduling Outpatient',2,14,14,5,'Adult',416,NULL,NULL,416,417,412,411,NULL,NULL,NULL,NULL,1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36')),(12,'ICT001','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2001ICT001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'ICT-001','','Scheduling Inpatient CT',2,14,14,5,'Adult',416,NULL,NULL,416,417,412,411,NULL,NULL,NULL,NULL,1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38')),(13,'IRT001','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2001IRT001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'IRT-001','','Scheduling Inpatient RT',2,14,14,5,'Adult',416,NULL,NULL,416,417,412,411,NULL,NULL,NULL,NULL,1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40')),(14,'SCB001','D',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2004-06-06'),1,5,'2001SCB001',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2006-06-06 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-06-06 10:00:00'),'SCB-001','','Scheduling Special Cases',2,14,14,5,'Adult',416,NULL,NULL,416,417,412,411,NULL,NULL,NULL,NULL,1,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(15,'AS005','A',NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03'),0,5,'2003AS005',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2003-03-03 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2016-03-03 10:00:00'),26,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2014-03-03 10:00:00'),'AS005','','Auto Study 005',2,13,13,7,'Adult/Pediatric',421,NULL,NULL,421,NULL,NULL,411,NULL,NULL,NULL,'N/A',0,NULL,'auto generated study via the rest calls during deployment','nct','ind','ide',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'));
/*!40000 ALTER TABLE `study` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `study_funding_source_cai`
--

DROP TABLE IF EXISTS `study_funding_source_cai`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `study_funding_source_cai` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `study` int(11) NOT NULL,
  `funding_source` int(11) NOT NULL,
  `centers_and_institutions` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `one_to_four` int(11) NOT NULL,
  `grant_id` varchar(100) DEFAULT NULL,
  `site_cost_center` varchar(100) DEFAULT NULL,
  `total_direct_award` double(19,2) DEFAULT NULL,
  `total_indirect_award` double(19,2) DEFAULT NULL,
  `project_start_date` date DEFAULT NULL,
  `project_end_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `study_funding_source_cai__study` (`study`),
  KEY `study_funding_source_cai__funding_source` (`funding_source`),
  KEY `study_funding_source_cai__cai` (`centers_and_institutions`),
  CONSTRAINT `study_funding_source_cai__study` FOREIGN KEY (`study`) REFERENCES `study` (`id`),
  CONSTRAINT `study_funding_source_cai__funding_source` FOREIGN KEY (`funding_source`) REFERENCES `funding_source` (`id`),
  CONSTRAINT `study_funding_source_cai__cai` FOREIGN KEY (`centers_and_institutions`) REFERENCES `centers_and_institutions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `study_funding_source_cai`
--

LOCK TABLES `study_funding_source_cai` WRITE;
/*!40000 ALTER TABLE `study_funding_source_cai` DISABLE KEYS */;
INSERT INTO `study_funding_source_cai` VALUES (2,1,2,2,'comment 1',1,'','',NULL,NULL,NULL,NULL),(4,2,1,NULL,'comment 2',1,'','',NULL,NULL,NULL,NULL),(6,3,3,NULL,'comment 3',1,'','',NULL,NULL,NULL,NULL),(8,4,4,NULL,'comment 4',1,'','',NULL,NULL,NULL,NULL),(9,5,3,NULL,'comment 5',1,'','',NULL,NULL,NULL,NULL),(11,6,4,NULL,'comment 6',1,'','',NULL,NULL,NULL,NULL),(13,7,3,NULL,'comment 3',1,'','',NULL,NULL,NULL,NULL),(15,8,4,NULL,'comment 4',1,'','',NULL,NULL,NULL,NULL),(17,9,3,NULL,'comment 5',1,'','',NULL,NULL,NULL,NULL),(18,10,4,NULL,'comment 6',1,'','',NULL,NULL,NULL,NULL),(20,11,5,NULL,'comment 1',1,'','',NULL,NULL,NULL,NULL),(22,12,5,NULL,'comment 1',1,'','',NULL,NULL,NULL,NULL),(24,13,5,NULL,'comment 1',1,'','',NULL,NULL,NULL,NULL),(26,14,5,NULL,'comment 1',1,'','',NULL,NULL,NULL,NULL),(28,15,3,NULL,'comment 3',1,'','',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `study_funding_source_cai` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `study_status`
--

DROP TABLE IF EXISTS `study_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `study_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `study_status`
--

LOCK TABLES `study_status` WRITE;
/*!40000 ALTER TABLE `study_status` DISABLE KEYS */;
INSERT INTO `study_status` VALUES (1,'IRB_PROCESS','PENDING'),(2,'OPEN','OPEN'),(3,'CLOSED','CLOSED');
/*!40000 ALTER TABLE `study_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `study_subject`
--

DROP TABLE IF EXISTS `study_subject`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `study_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `subject` int(11) NOT NULL,
  `study` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `FK_studySubj_id1` (`study`,`subject`),
  KEY `FK4C2330B64648AB89` (`subject`),
  KEY `FK4C2330B64CCAB503` (`study`),
  CONSTRAINT `study_subject_0__subject` FOREIGN KEY (`subject`) REFERENCES `subject` (`id`),
  CONSTRAINT `study_subject_1__study` FOREIGN KEY (`study`) REFERENCES `study` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `study_subject`
--

LOCK TABLES `study_subject` WRITE;
/*!40000 ALTER TABLE `study_subject` DISABLE KEYS */;
INSERT INTO `study_subject` VALUES (1,1,1,1),(2,1,1,2),(3,1,1,3),(4,1,1,4),(5,1,2,1),(6,1,3,1),(7,1,4,1),(8,1,5,1),(9,1,6,1),(10,1,7,2),(11,1,8,2),(12,1,9,2),(13,1,10,2),(14,1,11,2),(15,1,12,2),(16,1,13,3),(17,1,14,3),(18,1,15,3),(19,1,16,3),(20,1,17,3),(21,1,18,3),(22,1,19,4),(23,1,20,4),(24,1,21,4),(25,1,22,4),(26,1,23,4),(27,1,24,4),(28,1,25,4),(29,1,31,1),(30,1,31,7),(31,1,31,8),(32,1,31,15),(33,1,32,7),(34,1,32,15),(35,1,33,7),(36,1,33,15),(37,1,34,7),(38,1,34,15),(39,1,35,8),(40,1,36,8),(41,1,37,8),(42,1,38,8),(43,1,39,9),(44,1,40,9),(45,1,41,9),(46,1,42,9),(47,1,43,10),(48,1,44,10),(49,1,45,10),(50,1,46,10);
/*!40000 ALTER TABLE `study_subject` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `study_user`
--

DROP TABLE IF EXISTS `study_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `study_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `study` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_studyUserRole_id1` (`study`,`user`),
  KEY `FKD4EC15744CCAB503` (`study`),
  KEY `FKD4EC1574C7582006` (`user`),
  CONSTRAINT `study_user_0__study` FOREIGN KEY (`study`) REFERENCES `study` (`id`),
  CONSTRAINT `study_user_1__user` FOREIGN KEY (`user`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `study_user`
--

LOCK TABLES `study_user` WRITE;
/*!40000 ALTER TABLE `study_user` DISABLE KEYS */;
INSERT INTO `study_user` VALUES (1,419,1,0),(2,416,1,1),(3,411,1,1),(4,412,1,1),(5,417,2,1),(6,411,2,1),(7,418,3,0),(8,417,3,1),(9,416,3,1),(10,411,3,1),(11,412,3,1),(12,418,4,1),(13,417,4,0),(14,416,4,0),(15,418,6,1),(16,417,6,1),(17,416,6,1),(18,419,7,1),(19,420,7,1),(20,411,7,1),(21,413,7,1),(22,420,8,1),(23,421,8,1),(24,419,9,1),(25,421,9,1),(26,413,9,1),(27,417,11,1),(28,416,11,1),(29,411,11,1),(30,412,11,1),(31,417,12,1),(32,416,12,1),(33,411,12,1),(34,412,12,1),(35,417,13,1),(36,416,13,1),(37,411,13,1),(38,412,13,1),(39,417,14,1),(40,416,14,1),(41,411,14,1),(42,412,14,1),(43,421,15,1),(44,411,15,1);
/*!40000 ALTER TABLE `study_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sub_category`
--

DROP TABLE IF EXISTS `sub_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sub_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `child_id` int(11) NOT NULL,
  `report_template_id` int(11) NOT NULL,
  `expanded` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_category_0__parent_id` (`parent_id`),
  KEY `sub_category_1__child_id` (`child_id`),
  KEY `sub_category_2__template_id` (`report_template_id`),
  CONSTRAINT `sub_category_0__parent_id` FOREIGN KEY (`parent_id`) REFERENCES `category` (`id`),
  CONSTRAINT `sub_category_1__child_id` FOREIGN KEY (`child_id`) REFERENCES `category` (`id`),
  CONSTRAINT `sub_category_2__template_id` FOREIGN KEY (`report_template_id`) REFERENCES `report_template` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sub_category`
--

LOCK TABLES `sub_category` WRITE;
/*!40000 ALTER TABLE `sub_category` DISABLE KEYS */;
INSERT INTO `sub_category` VALUES (259,1,2,1,0),(260,1,3,1,0),(261,4,5,1,0),(262,4,6,1,0),(263,7,8,1,0),(264,7,9,1,0),(265,2,10,1,1),(266,2,11,1,1),(267,2,12,1,1),(268,2,13,1,1),(269,2,14,1,1),(270,2,15,1,1),(271,2,16,1,1),(272,2,17,1,1),(273,2,18,1,1),(274,2,19,1,1),(275,3,20,1,1),(276,3,21,1,1),(277,3,22,1,1),(278,3,23,1,1),(279,1,2,2,0),(280,1,3,2,0),(281,24,9,2,0),(282,2,10,2,1),(283,2,11,2,1),(284,2,12,2,1),(285,2,13,2,1),(286,2,14,2,1),(287,2,15,2,1),(288,2,16,2,1),(289,2,17,2,1),(290,2,18,2,1),(291,2,19,2,1),(292,3,20,2,1),(293,3,21,2,1),(294,3,22,2,1),(295,3,23,2,1);
/*!40000 ALTER TABLE `sub_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subject`
--

DROP TABLE IF EXISTS `subject`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `city` varchar(255) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `ethnicity` int(11) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `gender` int(11) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `mrn` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `primary_contact_number` varchar(255) DEFAULT NULL,
  `race` int(11) DEFAULT NULL,
  `secondary_contact_number` varchar(255) DEFAULT NULL,
  `secure` tinyint(1) NOT NULL DEFAULT '0',
  `state` int(11) DEFAULT NULL,
  `street_address1` varchar(255) DEFAULT NULL,
  `street_address2` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `birthdate` date DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `comment` longtext,
  `subject_scheduler_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK90AA552C586F81EF` (`ethnicity`),
  KEY `FK90AA552C4CCA2293` (`state`),
  KEY `FK90AA552C21EA7A31` (`gender`),
  KEY `FK90AA552CF1F48A11` (`race`),
  KEY `FK90AA552C9722B05D` (`country`),
  CONSTRAINT `subject_0__gender` FOREIGN KEY (`gender`) REFERENCES `gender` (`id`),
  CONSTRAINT `subject_1__state` FOREIGN KEY (`state`) REFERENCES `state` (`id`),
  CONSTRAINT `subject_2__ethnicity` FOREIGN KEY (`ethnicity`) REFERENCES `ethnicity` (`id`),
  CONSTRAINT `subject_3__country` FOREIGN KEY (`country`) REFERENCES `country` (`id`),
  CONSTRAINT `subject_4__race` FOREIGN KEY (`race`) REFERENCES `race` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subject`
--

LOCK TABLES `subject` WRITE;
/*!40000 ALTER TABLE `subject` DISABLE KEYS */;
INSERT INTO `subject` VALUES (1,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','G+kl5zmaKkS0z+yvJoOOYregltfnIIfv5X3LEbcvjHI=',2,'z5N+0uebFzCKX/+8xPn9vg==','BwNVuqJdq/nGlfFk8tSv0A==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Fztn0qx9cS1tFBiEl50I3A==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','hKgSi6lgQ3uWDXGhht867w=='),(2,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','tlK4LC/eh+IkMONbYdu8IregltfnIIfv5X3LEbcvjHI=',3,'Bkv/3Zm8JeP94cx3W/+Y+g==','RSTAdajm4G6Qjve6UaBjww==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','H2JHvqtFXJ0W4AZ3Z+OdTw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','VXGqiIusCABLMR/O2PItPw=='),(3,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','GRhW5qTGostWj36u7ZmR+begltfnIIfv5X3LEbcvjHI=',3,'RVYfmfiSxHoyklTDWAv6Ig==','Lrjj2RMIDz0MOPDKto1yjA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','bd3YMhuaOQth7ebIh2IE7w==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','YyIBgR6zNy2hh+wdT0eOPg=='),(4,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','5FmsZeFHxUDb8sKBCmysRbegltfnIIfv5X3LEbcvjHI=',1,'JCMxjCUBBZd6ITY/0tLAQQ==','T/J2Abnf8BGJYq+7npN8aA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','EQCvnFi7QsYZzKE+DCOWug==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','gsAf+D3zgp8Th6EiAeEnAA=='),(5,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','5sZGr85wy+hEpQzWJAdHH7egltfnIIfv5X3LEbcvjHI=',2,'sFfUU0KsnEKz6LROuIJMew==','VgHWHvBKoBihDEoy549edw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','rWnyt7sFjVz2efqObZ8CkQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','RVkaTxH417Tvrv0cyE4Qsg=='),(6,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','G4O8T02zn0LrYcktApFIi7egltfnIIfv5X3LEbcvjHI=',2,'XPRJhnA84rXC27BlJYkkQw==','6L5ypEjzoG+p22zHdx+V6w==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','b+xZOf1o/V5qvGRTM9d6wA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Fu9O4TGoOmpqyhBAy7PmXw=='),(7,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','04e/q5mhu0R7z8huBUy1tLegltfnIIfv5X3LEbcvjHI=',1,'gC6ALXMQccJaJKG/SMnw1w==','ZnpKCcEbBdei9fBS9OgqbA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','ErjQBW8eXTR03Xo+fveIoQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','eHswSzrn2JckieOABHGtyQ=='),(8,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','r9lmYd9Hzq4nNTSbSqJYAbegltfnIIfv5X3LEbcvjHI=',3,'hc/hz74KYwS0XShQBucHgg==','OamlDGyhN3BdWM+ZQM5sig==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','jIBvbq3vr89mQrmMfmwgnQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','PzsYIRrNhBT+NkTi7p759w=='),(9,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','4tJnIzgUgYFrINOiWKHrRbegltfnIIfv5X3LEbcvjHI=',3,'xRgKBUN5o4iPlHG/xOyFEw==','D3bZ3nVXjlz7Dm8JedS+QQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','73iaU5ExCDzQZ0s6XRd9iQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','IK0+3NlYWkVll83i+vbNCw=='),(10,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','Y/wzKjq30fPLvljOfgMoY7egltfnIIfv5X3LEbcvjHI=',3,'tWLZhFnU0VRq/+eKg4vWHw==','yy69JuWZZpOv6+LzddZGKA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','3sm2DqsYixUVKV8pH/0caw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','1EBb9xV0SQW5hT/aN2H3ew=='),(11,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','L6BMFp/mx0tJpw2dLMaDeregltfnIIfv5X3LEbcvjHI=',2,'ate3m413Rojf8p7qlxpQRw==','TWf+rzvi1ncts5BZ8VW6xg==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','3iyp7yGvK1fB9uW7l1J8cA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','OsI/RldthS/Mz8e/bx2QZw=='),(12,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','Oh2y+R6q0nR1WI906llm1regltfnIIfv5X3LEbcvjHI=',1,'HcwkzAAv8V+oCa8SdHR5Vg==','mMAH8ct1iVCjhc7KyrpdDA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','RV2Al887ZmodMKyzBgA/hA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','eMPmcrRkzONDoked53jvKA=='),(13,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','sbg6yWycVwQFNynNL5begbegltfnIIfv5X3LEbcvjHI=',1,'8iO+FxnMSoJ2FTAUzUvW3w==','41/egQMWhKdnjuzDbktKLQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','q3ytXQ8mplY7dti5190e1w==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Ag2YMKkLDLhajBkjrRzbmg=='),(14,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','A29YH8s6o5/zpnzYiJhBaLegltfnIIfv5X3LEbcvjHI=',1,'fqF7bV3pV90T9z4SujfNFw==','tbEk99BArgzkYDPwdQU+sg==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','qZd8tlf7DCNjETqVW4MH8Q==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','G4FQzCXVdpJtT7QgbnRWaA=='),(15,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','QRjPcVnFQzpR/zGo10g1o7egltfnIIfv5X3LEbcvjHI=',1,'lRNSbgilkLDwvGaC5xTI2g==','lUJswyuoSoyuqreaS/diwQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','rB0+Q1KmbEgy8z+uxLqcOQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','8ATOw0ue+MAh/aXx+zytWw=='),(16,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','35iUWUOUVLsscCuZG4DX/begltfnIIfv5X3LEbcvjHI=',1,'QoWIYm2wTWjIM7nquuiwVw==','R+WCBucSOWGOsqB8L1cx6Q==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Ja3kKOLXk/c2nyFoZYqTBg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','n0DttOgX/uziseTWBgGoHA=='),(17,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','NY9C5Zd3G7yszF48YJJDCbegltfnIIfv5X3LEbcvjHI=',1,'gW2gk3m5GhqTlatmv7SMhA==','q9RD8nSqfwLJ+liODOlKqg==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','1UMU4kLx1zhkBall7EnALA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','2/UmuRs2MgGYKDimuPILdQ=='),(18,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','GeGrC8bNMBEBKX6jxxYgHbegltfnIIfv5X3LEbcvjHI=',1,'7jJX2/XVmuQfxkAhLq6HFw==','wionyXpfn2Txqwx5fdpLRw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','QJiUuWzkWg5Wf3Sb5VPccg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','1b3g+YRPAmGVK26Im6DguQ=='),(19,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','I/zdzSODeU7aD9srN9CRkregltfnIIfv5X3LEbcvjHI=',1,'z0Oq+DmgTOQejzVSA28PIg==','jiAWEypfjFsiMg9GnN2CJw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','IVOvyg4dLdoAPrTn0IV7Hw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','WQB/vrrkb3vgdbJlibWLwg=='),(20,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','jBJkktM2GE1pB7NVAkpjDregltfnIIfv5X3LEbcvjHI=',1,'s4UfgaeA3nlL9S6gvOySiw==','wS1qadejPWViQ/P501Es4w==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','wZzjYZsZYPmb31eUXpwAbA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','+kPN9KB2B63t77XnIMUkMg=='),(21,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','+9ll0xgjoxF0r7LUJbOuz7egltfnIIfv5X3LEbcvjHI=',1,'L2ErYM4A3td5Mfub9+yHlA==','oSlDj39bi8wb5KIc3q67Iw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','8hHQ93gfPfEk4+5xWgCoOQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Gb+JniHbB6ONICkf69N9pg=='),(22,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','lHA50BWkKhjOPgSu/BuT+regltfnIIfv5X3LEbcvjHI=',2,'4SD2ePWUFjvQGNsdk5lodA==','5Dc9BuUP7B/QlVtdCPD6cQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Cx6MQqYiHOawP75+4P0ENg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Pb4HwjpISkc0mLN4Ho7GuA=='),(23,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','9X74IFAtxglF0nJsMUOB+LegltfnIIfv5X3LEbcvjHI=',2,'qD2JqLe2d2T924011Jwr/Q==','SgNWkB8ZeYmIYCD9cVP4gw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','21M66yhWFPj0zJXLSG/z/g==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','kXQzblUUsq6w8N85Sf5kCA=='),(24,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','9LbupkHNwCRX5pnNPE0LHLegltfnIIfv5X3LEbcvjHI=',2,'u/kLmppDZUflv7IGeewcaw==','f3BtKfGVCMh3GwdCbvxDUw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','z8V7cJxXfBRFnbLX0WG1oA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Ybpkr/D3YoyJXHCNINLthA=='),(25,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','HknWx8DlAAxUDFxp1TKLbbegltfnIIfv5X3LEbcvjHI=',2,'wpnaA7NHfaI+vPn+lbNMGQ==','RTolcGgagLCkklM8rO6oTA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','ilT5tT/CPeuOm7RdG17JZg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','rCqVTrT0pULz3oACkp3aaw=='),(26,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','Vfb3WurYV0+RJBVLYN9L/begltfnIIfv5X3LEbcvjHI=',2,'cw1XWSdVzBz0JrId0auqVw==','StVj283pFgLh1k7ViVyCHQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','SC2c6d5Yq+pRkCrFw50FBQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','z/I0K8i28EtrXYZ1muh2fw=='),(27,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','OTnhjIlvnANPEc371nIUEregltfnIIfv5X3LEbcvjHI=',2,'C/jqoLhbt1Vpve8nTSARxg==','OWytWbmsWHZZWQ28zToSTA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','csGhy64Kba463KDOhpLi4Q==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','plMk3A8Z2UfO2bumMFcwyw=='),(28,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','ARZCGNa96kZiftTJdjI1e7egltfnIIfv5X3LEbcvjHI=',1,'+WuqRbOhn5LWnZwz2wUcKA==','++BzfKbn+I1LQLEg1+Lsog==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Pw5jB7upqPyHAwe1HKjCVA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','HkP+Pkl5QuZ4+91MHxMAZg=='),(29,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','uXbd5YEWREX/G3DFAcKdIregltfnIIfv5X3LEbcvjHI=',1,'mZbDNNa8uku9lS56EKz15Q==','YGxWDoTQ3ont+b8XuIXWxA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','WG9ywQ70+4ILtMjsms0Q7w==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','MpFXRe/3OTwjeRIZiu2bkg=='),(30,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57'),2,'4Q6Kle44pYsQ7JTxUWTt8A==','Pwg/JmVz8MtD5xGYDRUyEregltfnIIfv5X3LEbcvjHI=',1,'XtGyqNyP+4EbSW5DdzpCJQ==','WsfkZpem8CiJ72ZokIZkVg==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','HVr3bogkuLr64PNPThH1tw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','i/qF3g6AF33ytkft0WTntw=='),(31,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58'),2,'lRWP9UqBTFEKV2xNy8irIQ==','xzbAO511HIBK1LHuWWl8cw==',2,'HFYGPVLSY6XchbcYdRbxog==','tLNZQChTX8RC36AAu97DhA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Fztn0qx9cS1tFBiEl50I3A==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','IOCwQLLaYlEAkzhesDmCNA=='),(32,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00'),2,'lRWP9UqBTFEKV2xNy8irIQ==','g7DliRHcm4nBFKlartOnIA==',3,'IFzFK7xAE6pN4FYZqLTUCA==','Caythtn2dvmarY1DceEAJA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','H2JHvqtFXJ0W4AZ3Z+OdTw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','UW1Ja9fRI2FUppfXs72UTA=='),(33,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),2,'lRWP9UqBTFEKV2xNy8irIQ==','9hfV63JyBayrRblBE+vtPQ==',3,'8cZHB4sZiaBUJPvY7YkSfQ==','N7kiVDbsMeKVzP9p7QjJzg==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','bd3YMhuaOQth7ebIh2IE7w==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','KnitMtA6czdY6LbimywSQA=='),(34,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01'),2,'lRWP9UqBTFEKV2xNy8irIQ==','OBmGIebbgSF/w9GiNYLgPA==',1,'kFSR8fwMjAHPWkukJmBRpw==','rY7Yano5EBWL9khPlpq1dw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','EQCvnFi7QsYZzKE+DCOWug==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','RGyHlHiaN4PTAEZpepD3+A=='),(35,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'),2,'lRWP9UqBTFEKV2xNy8irIQ==','eLZI8fQyfT7zPmaEr7e6FQ==',2,'I3Rvl8EmJxK1AwmUPzBAsg==','72IZZuifdsyyAOB3SABm1A==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','rWnyt7sFjVz2efqObZ8CkQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Sxe8FWRb7Znw9Itgnl7m3A=='),(36,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02'),2,'lRWP9UqBTFEKV2xNy8irIQ==','HZKTEjMj9SG96IkzFuyuQQ==',2,'9RYIT63LuuzRF7yLeROiRg==','iNRun5pYUZQ1V7Y5ZGo5eA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','b+xZOf1o/V5qvGRTM9d6wA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','kCvPFJGtNvWkzky74+LMnw=='),(37,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),2,'lRWP9UqBTFEKV2xNy8irIQ==','0irAT5DdgUO7FRuW/ZCj6A==',1,'xIX33DLZuJykdMWFDOSRjw==','wbTFMvxpLKqALJmXSjL2dw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','ErjQBW8eXTR03Xo+fveIoQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','eu3/QGZkIXUfog9adEvt3g=='),(38,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03'),2,'lRWP9UqBTFEKV2xNy8irIQ==','R/euYjNizowc1Tf/5yfpXA==',3,'9ZwSQ5jUiOCJNbPV62kk2Q==','DRYS3F4/CCpp3zgF0t0RVA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','jIBvbq3vr89mQrmMfmwgnQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','eW5mg/xjne+oNNoNaIQGOA=='),(39,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),2,'lRWP9UqBTFEKV2xNy8irIQ==','BkSNMIY22Fq5LnE4lSgOSg==',3,'ddtjO14EoOUm2nlzD3pq4g==','GC76tUqBrUcYCw4Zo0fq8w==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','73iaU5ExCDzQZ0s6XRd9iQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','SaKP+6eo56uxNxp7lkENwQ=='),(40,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),2,'lRWP9UqBTFEKV2xNy8irIQ==','ljOXzBADDLxXptrUhAyzuA==',3,'pB1xdeWBy+9k0PM865E01w==','MbQCW59amVGCgatOBXLeSA==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','3sm2DqsYixUVKV8pH/0caw==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','U6D2kDRgoxcGdeZXHHXm7A=='),(41,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04'),2,'lRWP9UqBTFEKV2xNy8irIQ==','ONmDIJSyN7UqbG+EyuPG7w==',2,'KafrTD3qq2BzyVkQPn0LMg==','CJ/ij75efZkai177Hdg5cw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','3iyp7yGvK1fB9uW7l1J8cA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','Fw0rknA8FKS7/+dWX/VdOQ=='),(42,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),2,'lRWP9UqBTFEKV2xNy8irIQ==','/GHl9li3yxvEn+SaLTA+zg==',1,'KWvTqQK/Vm8BgnRCXW/qvQ==','ZihISPrKoy8g6ID7Ucbqqw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','RV2Al887ZmodMKyzBgA/hA==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','GksiUg5t73NEwm1jkKNHcg=='),(43,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05'),2,'lRWP9UqBTFEKV2xNy8irIQ==','BJenKY2XPK8C7JYG2kJ9kg==',1,'nG5tmgD23Mlr7yCDp4NY/w==','r64v3axFSsc02NjEV74GUQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','q3ytXQ8mplY7dti5190e1w==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','h755LwMSXDpRu74YKDQCcQ=='),(44,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),2,'lRWP9UqBTFEKV2xNy8irIQ==','InZtFGkj2yUGYz594AUMaA==',1,'din2sDERMyjd0XCweQ7hVA==','sIolp+kCIcEzYUWUUXdzEQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','qZd8tlf7DCNjETqVW4MH8Q==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','M1hzkBtNapLEWeLp4xN84A=='),(45,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06'),2,'lRWP9UqBTFEKV2xNy8irIQ==','SRmvSFIEwYm5YLD48qGYIw==',1,'oBYKg2zZyFS4rtJjTqKm2g==','IolyN8FGm0wtKL3w0mQu6w==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','rB0+Q1KmbEgy8z+uxLqcOQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','jhV+n6G0visU4ir8rUWK+A=='),(46,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),2,'lRWP9UqBTFEKV2xNy8irIQ==','D2Vdx6uRddyLAse2EPyi2A==',1,'qWSnnoQiMzlHERAeZSqYIw==','LJ/NEUYTVRSQwAT+Mt2+Bw==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Ja3kKOLXk/c2nyFoZYqTBg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','pQ5TyOZSurO/wADcppXFaA=='),(47,1,'h03bBN7FjeUt5V1LGSoesQ==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),2,'lRWP9UqBTFEKV2xNy8irIQ==','6bLpugtBPFhGodUbrVct2A==',1,'oFoiTJMdg4tY1EN+O3bGGA==','DsPoJ6aPTwWgCIqXijdIEQ==','t6CW1+cgh+/lfcsRty+Mcg==','+jTgZXXe+PXLPN7/YwbxoQ==',1,'t6CW1+cgh+/lfcsRty+Mcg==',1,1,'wmC3ZFgUUMJdUUaVQSoehg==','t6CW1+cgh+/lfcsRty+Mcg==','Ja3kKOLXk/c2nyFoZYqTBg==',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'1980-12-25'),1,'','6ROwbwnFRPNtPbKiL8nE/Q==');
/*!40000 ALTER TABLE `subject` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sublocation`
--

DROP TABLE IF EXISTS `sublocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sublocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `institution` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FKBBCF1DF56114C21` (`institution`),
  CONSTRAINT `sublocation_0__institution` FOREIGN KEY (`institution`) REFERENCES `institution` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sublocation`
--

LOCK TABLES `sublocation` WRITE;
/*!40000 ALTER TABLE `sublocation` DISABLE KEYS */;
INSERT INTO `sublocation` VALUES (1,'Sub-Location 1',1),(2,'Sub-Location 2',1),(3,'Sub-Location 3',1),(4,'Sub-Location 4',1);
/*!40000 ALTER TABLE `sublocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sublocation_closure_interval`
--

DROP TABLE IF EXISTS `sublocation_closure_interval`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sublocation_closure_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sublocation` int(11) NOT NULL,
  `reason` varchar(400) DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FKA3BC2B53135C3C9B` (`sublocation`),
  CONSTRAINT `sublocation_closure_interval_0__sublocation` FOREIGN KEY (`sublocation`) REFERENCES `sublocation` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sublocation_closure_interval`
--

LOCK TABLES `sublocation_closure_interval` WRITE;
/*!40000 ALTER TABLE `sublocation_closure_interval` DISABLE KEYS */;
/*!40000 ALTER TABLE `sublocation_closure_interval` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_approval_history`
--

DROP TABLE IF EXISTS `template_approval_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_approval_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visit_template` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `approved` tinyint(1) DEFAULT '0',
  `comment` varchar(255) DEFAULT NULL,
  `status_change_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_tmpApprov_visitUser` (`visit_template`,`user`),
  KEY `FK2E5DD7BD93F01044` (`visit_template`),
  KEY `FK2E5DD7BDF1F7CC05` (`user`),
  CONSTRAINT `template_approval_history_0__visit_template` FOREIGN KEY (`visit_template`) REFERENCES `visit_template` (`id`),
  CONSTRAINT `template_approval_history_1__user` FOREIGN KEY (`user`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_approval_history`
--

LOCK TABLES `template_approval_history` WRITE;
/*!40000 ALTER TABLE `template_approval_history` DISABLE KEYS */;
INSERT INTO `template_approval_history` VALUES (1,1,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(2,2,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(3,3,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(4,5,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(5,6,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(6,7,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(7,8,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(8,9,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(9,10,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(10,11,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(11,12,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(12,13,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(13,15,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(14,16,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(15,17,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(16,18,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03')),(17,19,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03')),(18,21,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(19,22,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(20,23,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(21,24,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(22,25,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(23,26,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(24,27,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(25,28,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(26,29,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(27,31,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(28,32,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(29,33,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(30,34,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(31,35,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(32,36,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(33,37,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(34,38,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(35,39,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(36,40,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(37,41,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(38,42,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(39,44,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(40,45,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(41,46,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(42,47,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(43,48,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(44,49,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(45,50,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(46,51,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(47,52,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(48,53,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(49,54,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12')),(50,55,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12')),(51,56,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(52,57,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(53,58,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(54,59,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(55,60,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(56,61,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(57,62,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(58,63,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(59,64,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(60,65,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(61,66,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(62,67,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(63,68,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(64,69,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(65,70,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(66,71,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(67,72,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(68,73,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(69,74,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(70,75,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(71,76,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(72,77,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(73,78,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(74,79,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(75,80,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(76,81,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(77,82,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(78,83,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(79,84,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(80,85,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(81,86,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(82,87,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(83,88,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(84,89,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(85,90,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(86,91,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(87,92,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(88,93,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(89,94,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(90,95,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(91,96,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(92,97,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(93,98,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(94,99,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(95,100,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(96,101,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(97,102,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(98,103,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28')),(99,104,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28')),(100,105,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28')),(101,106,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(102,107,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(103,108,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(104,109,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(105,110,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(106,111,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(107,112,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(108,113,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(109,114,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(110,115,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(111,116,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(112,117,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(113,118,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(114,119,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(115,120,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(116,121,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(117,122,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(118,123,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(119,124,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(120,125,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(121,126,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(122,127,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(123,128,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(124,129,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(125,130,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(126,131,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(127,132,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(128,133,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(129,134,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(130,135,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(131,136,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(132,137,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(133,138,410,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(134,6,409,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05')),(135,2,409,1,'',TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'));
/*!40000 ALTER TABLE `template_approval_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_category`
--

DROP TABLE IF EXISTS `template_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_template_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `expanded` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `FK_template_category_id1` (`report_template_id`,`category_id`),
  KEY `template_category_0__category_id` (`category_id`),
  KEY `template_category_1__template_id` (`report_template_id`),
  CONSTRAINT `template_category_0__category_id` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`),
  CONSTRAINT `template_category_1__template_id` FOREIGN KEY (`report_template_id`) REFERENCES `report_template` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_category`
--

LOCK TABLES `template_category` WRITE;
/*!40000 ALTER TABLE `template_category` DISABLE KEYS */;
INSERT INTO `template_category` VALUES (259,1,1,0),(260,1,4,0),(261,1,7,0),(262,2,1,0),(263,2,4,0),(264,2,24,0);
/*!40000 ALTER TABLE `template_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_category_field`
--

DROP TABLE IF EXISTS `template_category_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_category_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_template_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `suffix` varchar(255) NOT NULL,
  `selected` tinyint(1) NOT NULL,
  `csv_order` int(11) NOT NULL,
  `csv_order2` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_category_field_0__field_id` (`field_id`),
  KEY `template_category_field_1__template_id` (`report_template_id`),
  KEY `template_category_field_2__category_id` (`category_id`),
  CONSTRAINT `template_category_field_0__field_id` FOREIGN KEY (`field_id`) REFERENCES `field` (`id`),
  CONSTRAINT `template_category_field_1__template_id` FOREIGN KEY (`report_template_id`) REFERENCES `report_template` (`id`),
  CONSTRAINT `template_category_field_2__category_id` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=602 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_category_field`
--

LOCK TABLES `template_category_field` WRITE;
/*!40000 ALTER TABLE `template_category_field` DISABLE KEYS */;
INSERT INTO `template_category_field` VALUES (1,1,1,1,'',0,1,1),(2,1,2,1,'',0,11,1),(3,1,3,1,'',0,12,1),(4,1,4,1,'',0,13,1),(5,1,5,1,'',0,14,1),(6,1,6,1,'',0,15,1),(7,1,7,1,'',0,7,1),(8,1,8,1,'',0,6,1),(9,1,9,1,'',0,16,1),(10,1,10,1,'',0,18,1),(11,1,11,1,'',0,8,1),(12,1,12,1,'',0,10,1),(13,1,13,1,'',0,9,1),(14,1,14,1,'',1,3,1),(15,1,15,1,'',0,2,1),(16,1,16,1,'',0,20,1),(17,1,17,1,'',0,21,1),(18,1,18,1,'',0,22,1),(19,1,19,1,'',0,23,1),(20,1,20,1,'',0,24,1),(21,1,21,1,'',0,5,1),(22,1,22,1,'',0,25,1),(23,1,23,1,'',0,26,1),(24,1,24,1,'',0,27,1),(25,1,25,1,'',0,28,1),(26,1,26,1,'',0,17,1),(27,1,27,1,'',0,19,1),(28,1,28,1,'',0,4,1),(29,1,42,10,'_inv',0,15,2),(30,1,43,10,'_inv',1,2,2),(31,1,44,10,'_inv',0,3,2),(32,1,45,10,'_inv',1,4,2),(33,1,46,10,'_inv',0,5,2),(34,1,47,10,'_inv',0,1,2),(35,1,48,10,'_inv',0,12,2),(36,1,49,10,'_inv',0,13,2),(37,1,50,10,'_inv',1,14,2),(38,1,51,10,'_inv',0,17,2),(39,1,52,10,'_inv',0,0,2),(40,1,53,10,'_inv',0,18,2),(41,1,54,10,'_inv',0,6,2),(42,1,55,10,'_inv',0,10,2),(43,1,56,10,'_inv',0,7,2),(44,1,57,10,'_inv',0,8,2),(45,1,58,10,'_inv',0,9,2),(46,1,59,10,'_inv',0,11,2),(47,1,42,11,'_doc',0,15,3),(48,1,43,11,'_doc',0,2,3),(49,1,44,11,'_doc',0,3,3),(50,1,45,11,'_doc',0,4,3),(51,1,46,11,'_doc',0,5,3),(52,1,47,11,'_doc',0,1,3),(53,1,48,11,'_doc',0,12,3),(54,1,49,11,'_doc',0,13,3),(55,1,50,11,'_doc',0,14,3),(56,1,51,11,'_doc',0,17,3),(57,1,52,11,'_doc',0,0,3),(58,1,53,11,'_doc',0,18,3),(59,1,54,11,'_doc',0,6,3),(60,1,55,11,'_doc',0,10,3),(61,1,56,11,'_doc',0,7,3),(62,1,57,11,'_doc',0,8,3),(63,1,58,11,'_doc',0,9,3),(64,1,59,11,'_doc',0,11,3),(65,1,42,12,'_doc2',0,15,4),(66,1,43,12,'_doc2',0,2,4),(67,1,44,12,'_doc2',0,3,4),(68,1,45,12,'_doc2',0,4,4),(69,1,46,12,'_doc2',0,5,4),(70,1,47,12,'_doc2',0,1,4),(71,1,48,12,'_doc2',0,12,4),(72,1,49,12,'_doc2',0,13,4),(73,1,50,12,'_doc2',0,14,4),(74,1,51,12,'_doc2',0,17,4),(75,1,52,12,'_doc2',0,0,4),(76,1,53,12,'_doc2',0,18,4),(77,1,54,12,'_doc2',0,6,4),(78,1,55,12,'_doc2',0,10,4),(79,1,56,12,'_doc2',0,7,4),(80,1,57,12,'_doc2',0,8,4),(81,1,58,12,'_doc2',0,9,4),(82,1,59,12,'_doc2',0,11,4),(83,1,42,13,'_sch',0,15,5),(84,1,43,13,'_sch',0,2,5),(85,1,44,13,'_sch',0,3,5),(86,1,45,13,'_sch',0,4,5),(87,1,46,13,'_sch',0,5,5),(88,1,47,13,'_sch',0,1,5),(89,1,48,13,'_sch',0,12,5),(90,1,49,13,'_sch',0,13,5),(91,1,50,13,'_sch',0,14,5),(92,1,51,13,'_sch',0,17,5),(93,1,52,13,'_sch',0,0,5),(94,1,53,13,'_sch',0,18,5),(95,1,54,13,'_sch',0,6,5),(96,1,55,13,'_sch',0,10,5),(97,1,56,13,'_sch',0,7,5),(98,1,57,13,'_sch',0,8,5),(99,1,58,13,'_sch',0,9,5),(100,1,59,13,'_sch',0,11,5),(101,1,42,14,'_sch2',0,15,6),(102,1,43,14,'_sch2',0,2,6),(103,1,44,14,'_sch2',0,3,6),(104,1,45,14,'_sch2',0,4,6),(105,1,46,14,'_sch2',0,5,6),(106,1,47,14,'_sch2',0,1,6),(107,1,48,14,'_sch2',0,12,6),(108,1,49,14,'_sch2',0,13,6),(109,1,50,14,'_sch2',0,14,6),(110,1,51,14,'_sch2',0,17,6),(111,1,52,14,'_sch2',0,0,6),(112,1,53,14,'_sch2',0,18,6),(113,1,54,14,'_sch2',0,6,6),(114,1,55,14,'_sch2',0,10,6),(115,1,56,14,'_sch2',0,7,6),(116,1,57,14,'_sch2',0,8,6),(117,1,58,14,'_sch2',0,9,6),(118,1,59,14,'_sch2',0,11,6),(119,1,42,15,'_sch3',0,15,7),(120,1,43,15,'_sch3',0,2,7),(121,1,44,15,'_sch3',0,3,7),(122,1,45,15,'_sch3',0,4,7),(123,1,46,15,'_sch3',0,5,7),(124,1,47,15,'_sch3',0,1,7),(125,1,48,15,'_sch3',0,12,7),(126,1,49,15,'_sch3',0,13,7),(127,1,50,15,'_sch3',0,14,7),(128,1,51,15,'_sch3',0,17,7),(129,1,52,15,'_sch3',0,0,7),(130,1,53,15,'_sch3',0,18,7),(131,1,54,15,'_sch3',0,6,7),(132,1,55,15,'_sch3',0,10,7),(133,1,56,15,'_sch3',0,7,7),(134,1,57,15,'_sch3',0,8,7),(135,1,58,15,'_sch3',0,9,7),(136,1,59,15,'_sch3',0,11,7),(137,1,42,16,'_nrs',0,15,8),(138,1,43,16,'_nrs',0,2,8),(139,1,44,16,'_nrs',0,3,8),(140,1,45,16,'_nrs',0,4,8),(141,1,46,16,'_nrs',0,5,8),(142,1,47,16,'_nrs',0,1,8),(143,1,48,16,'_nrs',0,12,8),(144,1,49,16,'_nrs',0,13,8),(145,1,50,16,'_nrs',0,14,8),(146,1,51,16,'_nrs',0,17,8),(147,1,52,16,'_nrs',0,0,8),(148,1,53,16,'_nrs',0,18,8),(149,1,54,16,'_nrs',0,6,8),(150,1,55,16,'_nrs',0,10,8),(151,1,56,16,'_nrs',0,7,8),(152,1,57,16,'_nrs',0,8,8),(153,1,58,16,'_nrs',0,9,8),(154,1,59,16,'_nrs',0,11,8),(155,1,42,17,'_nrs2',0,15,9),(156,1,43,17,'_nrs2',0,2,9),(157,1,44,17,'_nrs2',0,3,9),(158,1,45,17,'_nrs2',0,4,9),(159,1,46,17,'_nrs2',0,5,9),(160,1,47,17,'_nrs2',0,1,9),(161,1,48,17,'_nrs2',0,12,9),(162,1,49,17,'_nrs2',0,13,9),(163,1,50,17,'_nrs2',0,14,9),(164,1,51,17,'_nrs2',0,17,9),(165,1,52,17,'_nrs2',0,0,9),(166,1,53,17,'_nrs2',0,18,9),(167,1,54,17,'_nrs2',0,6,9),(168,1,55,17,'_nrs2',0,10,9),(169,1,56,17,'_nrs2',0,7,9),(170,1,57,17,'_nrs2',0,8,9),(171,1,58,17,'_nrs2',0,9,9),(172,1,59,17,'_nrs2',0,11,9),(173,1,42,18,'_nut',0,15,10),(174,1,43,18,'_nut',0,2,10),(175,1,44,18,'_nut',0,3,10),(176,1,45,18,'_nut',0,4,10),(177,1,46,18,'_nut',0,5,10),(178,1,47,18,'_nut',0,1,10),(179,1,48,18,'_nut',0,12,10),(180,1,49,18,'_nut',0,13,10),(181,1,50,18,'_nut',0,14,10),(182,1,51,18,'_nut',0,17,10),(183,1,52,18,'_nut',0,0,10),(184,1,53,18,'_nut',0,18,10),(185,1,54,18,'_nut',0,6,10),(186,1,55,18,'_nut',0,10,10),(187,1,56,18,'_nut',0,7,10),(188,1,57,18,'_nut',0,8,10),(189,1,58,18,'_nut',0,9,10),(190,1,59,18,'_nut',0,11,10),(191,1,42,19,'_nut2',0,15,11),(192,1,43,19,'_nut2',0,2,11),(193,1,44,19,'_nut2',0,3,11),(194,1,45,19,'_nut2',0,4,11),(195,1,46,19,'_nut2',0,5,11),(196,1,47,19,'_nut2',0,1,11),(197,1,48,19,'_nut2',0,12,11),(198,1,49,19,'_nut2',0,13,11),(199,1,50,19,'_nut2',0,14,11),(200,1,51,19,'_nut2',0,17,11),(201,1,52,19,'_nut2',0,0,11),(202,1,53,19,'_nut2',0,18,11),(203,1,54,19,'_nut2',0,6,11),(204,1,55,19,'_nut2',0,10,11),(205,1,56,19,'_nut2',0,7,11),(206,1,57,19,'_nut2',0,8,11),(207,1,58,19,'_nut2',0,9,11),(208,1,59,19,'_nut2',0,11,11),(209,1,71,20,'_f1',0,1,12),(210,1,72,20,'_f1',0,10,12),(211,1,73,20,'_f1',0,4,12),(212,1,74,20,'_f1',0,2,12),(213,1,75,20,'_f1',0,8,12),(214,1,76,20,'_f1',0,9,12),(215,1,77,20,'_f1',0,5,12),(216,1,79,20,'_f1',0,6,12),(217,1,80,20,'_f1',0,7,12),(218,1,81,20,'_f1',0,3,12),(219,1,71,21,'_f2',0,1,13),(220,1,72,21,'_f2',0,10,13),(221,1,73,21,'_f2',0,4,13),(222,1,74,21,'_f2',0,2,13),(223,1,75,21,'_f2',0,8,13),(224,1,76,21,'_f2',0,9,13),(225,1,77,21,'_f2',0,5,13),(226,1,79,21,'_f2',0,6,13),(227,1,80,21,'_f2',0,7,13),(228,1,81,21,'_f2',0,3,13),(229,1,71,22,'_f3',0,1,14),(230,1,72,22,'_f3',0,10,14),(231,1,73,22,'_f3',0,4,14),(232,1,74,22,'_f3',0,2,14),(233,1,75,22,'_f3',0,8,14),(234,1,76,22,'_f3',0,9,14),(235,1,77,22,'_f3',0,5,14),(236,1,79,22,'_f3',0,6,14),(237,1,80,22,'_f3',0,7,14),(238,1,81,22,'_f3',0,3,14),(239,1,71,23,'_f4',0,1,15),(240,1,72,23,'_f4',0,10,15),(241,1,73,23,'_f4',0,4,15),(242,1,74,23,'_f4',0,2,15),(243,1,75,23,'_f4',0,8,15),(244,1,76,23,'_f4',0,9,15),(245,1,77,23,'_f4',0,5,15),(246,1,79,23,'_f4',0,6,15),(247,1,80,23,'_f4',0,7,15),(248,1,81,23,'_f4',0,3,15),(249,1,91,4,'',0,1,16),(250,1,92,4,'',0,3,16),(251,1,93,4,'',0,4,16),(252,1,94,4,'',0,19,16),(253,1,95,4,'',0,5,16),(254,1,96,4,'',0,18,16),(255,1,97,4,'',0,7,16),(256,1,98,4,'',0,6,16),(257,1,99,4,'',0,2,16),(258,1,100,4,'',1,12,16),(259,1,101,4,'',1,13,16),(260,1,102,4,'',1,14,16),(261,1,103,4,'',1,15,16),(262,1,104,4,'',0,10,16),(263,1,105,4,'',0,9,16),(264,1,106,4,'',0,8,16),(265,1,108,4,'',1,16,16),(266,1,109,4,'',1,17,16),(267,1,121,5,'',0,1,17),(268,1,122,5,'',1,7,17),(269,1,123,5,'',1,14,17),(270,1,124,5,'',1,15,17),(271,1,125,5,'',0,22,17),(272,1,126,5,'',1,2,17),(273,1,127,5,'',0,20,17),(274,1,128,5,'',1,12,17),(275,1,129,5,'',1,11,17),(276,1,130,5,'',0,3,17),(277,1,131,5,'',0,10,17),(278,1,132,5,'',0,9,17),(279,1,133,5,'',0,19,17),(280,1,134,5,'',1,4,17),(281,1,135,5,'',1,5,17),(282,1,136,5,'',0,8,17),(283,1,142,5,'',0,21,17),(284,1,143,5,'',0,13,17),(285,1,144,5,'',0,16,17),(286,1,145,5,'',1,17,17),(287,1,147,5,'',0,18,17),(288,1,162,6,'',0,1,18),(289,1,163,6,'',0,6,18),(290,1,164,6,'',0,2,18),(291,1,165,6,'',0,3,18),(292,1,166,6,'',1,4,18),(293,1,167,6,'',0,5,18),(294,1,168,6,'',1,7,18),(295,1,169,6,'',0,9,18),(296,1,170,6,'',0,12,18),(297,1,171,6,'',0,13,18),(298,1,172,6,'',0,14,18),(299,1,173,6,'',0,15,18),(300,1,174,6,'',0,16,18),(301,1,175,6,'',0,17,18),(302,1,176,6,'',0,18,18),(303,1,177,6,'',0,19,18),(304,1,178,6,'',0,10,18),(305,1,179,6,'',0,8,18),(306,1,180,6,'',0,11,18),(307,1,181,6,'',0,21,18),(308,1,182,6,'',0,20,18),(309,1,192,7,'',0,1,19),(310,1,193,7,'',1,2,19),(311,1,194,7,'',1,3,19),(312,1,195,7,'',1,7,19),(313,1,196,7,'',1,6,19),(314,1,197,7,'',1,4,19),(315,1,198,7,'',1,5,19),(316,1,199,7,'',0,9,19),(317,1,200,7,'',0,8,19),(318,1,211,8,'',0,1,20),(319,1,212,8,'_br',0,2,20),(320,1,213,8,'',0,3,20),(321,1,214,8,'',0,4,20),(322,1,221,9,'',0,1,21),(323,1,222,9,'',0,4,21),(324,1,223,9,'',1,3,21),(325,1,224,9,'_vt',1,2,21),(326,2,1,1,'',0,1,1),(327,2,15,1,'',0,2,1),(328,2,14,1,'',1,3,1),(329,2,28,1,'',0,4,1),(330,2,21,1,'',0,5,1),(331,2,8,1,'',0,6,1),(332,2,7,1,'',0,7,1),(333,2,29,1,'',0,8,1),(334,2,30,1,'',0,9,1),(335,2,11,1,'',0,10,1),(336,2,13,1,'',0,11,1),(337,2,12,1,'',0,12,1),(338,2,2,1,'',0,13,1),(339,2,3,1,'',0,14,1),(340,2,4,1,'',0,15,1),(341,2,5,1,'',0,16,1),(342,2,6,1,'',0,17,1),(343,2,9,1,'',0,18,1),(344,2,26,1,'',0,19,1),(345,2,10,1,'',0,20,1),(346,2,27,1,'',0,21,1),(347,2,16,1,'',0,22,1),(348,2,17,1,'',0,23,1),(349,2,18,1,'',0,24,1),(350,2,19,1,'',0,25,1),(351,2,20,1,'',0,26,1),(352,2,22,1,'',0,27,1),(353,2,23,1,'',0,28,1),(354,2,24,1,'',0,29,1),(355,2,25,1,'',0,30,1),(356,2,47,10,'_inv',0,1,2),(357,2,43,10,'_inv',1,2,2),(358,2,44,10,'_inv',0,3,2),(359,2,45,10,'_inv',1,4,2),(360,2,46,10,'_inv',0,5,2),(361,2,54,10,'_inv',0,6,2),(362,2,56,10,'_inv',0,7,2),(363,2,57,10,'_inv',0,8,2),(364,2,58,10,'_inv',0,9,2),(365,2,55,10,'_inv',0,10,2),(366,2,59,10,'_inv',0,11,2),(367,2,48,10,'_inv',0,12,2),(368,2,49,10,'_inv',0,13,2),(369,2,50,10,'_inv',0,14,2),(370,2,42,10,'_inv',0,15,2),(371,2,51,10,'_inv',0,16,2),(372,2,53,10,'_inv',0,17,2),(373,2,47,11,'_doc',0,1,3),(374,2,43,11,'_doc',0,2,3),(375,2,44,11,'_doc',0,3,3),(376,2,45,11,'_doc',0,4,3),(377,2,46,11,'_doc',0,5,3),(378,2,54,11,'_doc',0,6,3),(379,2,56,11,'_doc',0,7,3),(380,2,57,11,'_doc',0,8,3),(381,2,58,11,'_doc',0,9,3),(382,2,55,11,'_doc',0,10,3),(383,2,59,11,'_doc',0,11,3),(384,2,48,11,'_doc',0,12,3),(385,2,49,11,'_doc',0,13,3),(386,2,50,11,'_doc',0,14,3),(387,2,42,11,'_doc',0,15,3),(388,2,51,11,'_doc',0,16,3),(389,2,53,11,'_doc',0,17,3),(390,2,47,12,'_doc2',0,1,4),(391,2,43,12,'_doc2',0,2,4),(392,2,44,12,'_doc2',0,3,4),(393,2,45,12,'_doc2',0,4,4),(394,2,46,12,'_doc2',0,5,4),(395,2,54,12,'_doc2',0,6,4),(396,2,56,12,'_doc2',0,7,4),(397,2,57,12,'_doc2',0,8,4),(398,2,58,12,'_doc2',0,9,4),(399,2,55,12,'_doc2',0,10,4),(400,2,59,12,'_doc2',0,11,4),(401,2,48,12,'_doc2',0,12,4),(402,2,49,12,'_doc2',0,13,4),(403,2,50,12,'_doc2',0,14,4),(404,2,42,12,'_doc2',0,15,4),(405,2,51,12,'_doc2',0,16,4),(406,2,53,12,'_doc2',0,17,4),(407,2,47,13,'_sch',0,1,5),(408,2,43,13,'_sch',0,2,5),(409,2,44,13,'_sch',0,3,5),(410,2,45,13,'_sch',0,4,5),(411,2,46,13,'_sch',0,5,5),(412,2,54,13,'_sch',0,6,5),(413,2,56,13,'_sch',0,7,5),(414,2,57,13,'_sch',0,8,5),(415,2,58,13,'_sch',0,9,5),(416,2,55,13,'_sch',0,10,5),(417,2,59,13,'_sch',0,11,5),(418,2,48,13,'_sch',0,12,5),(419,2,49,13,'_sch',0,13,5),(420,2,50,13,'_sch',0,14,5),(421,2,42,13,'_sch',0,15,5),(422,2,51,13,'_sch',0,16,5),(423,2,53,13,'_sch',0,17,5),(424,2,47,14,'_sch2',0,1,6),(425,2,43,14,'_sch2',0,2,6),(426,2,44,14,'_sch2',0,3,6),(427,2,45,14,'_sch2',0,4,6),(428,2,46,14,'_sch2',0,5,6),(429,2,54,14,'_sch2',0,6,6),(430,2,56,14,'_sch2',0,7,6),(431,2,57,14,'_sch2',0,8,6),(432,2,58,14,'_sch2',0,9,6),(433,2,55,14,'_sch2',0,10,6),(434,2,59,14,'_sch2',0,11,6),(435,2,48,14,'_sch2',0,12,6),(436,2,49,14,'_sch2',0,13,6),(437,2,50,14,'_sch2',0,14,6),(438,2,42,14,'_sch2',0,15,6),(439,2,51,14,'_sch2',0,16,6),(440,2,53,14,'_sch2',0,17,6),(441,2,47,15,'_sch3',0,1,7),(442,2,43,15,'_sch3',0,2,7),(443,2,44,15,'_sch3',0,3,7),(444,2,45,15,'_sch3',0,4,7),(445,2,46,15,'_sch3',0,5,7),(446,2,54,15,'_sch3',0,6,7),(447,2,56,15,'_sch3',0,7,7),(448,2,57,15,'_sch3',0,8,7),(449,2,58,15,'_sch3',0,9,7),(450,2,55,15,'_sch3',0,10,7),(451,2,59,15,'_sch3',0,11,7),(452,2,48,15,'_sch3',0,12,7),(453,2,49,15,'_sch3',0,13,7),(454,2,50,15,'_sch3',0,14,7),(455,2,42,15,'_sch3',0,15,7),(456,2,51,15,'_sch3',0,16,7),(457,2,53,15,'_sch3',0,17,7),(458,2,47,16,'_nrs',0,1,8),(459,2,43,16,'_nrs',0,2,8),(460,2,44,16,'_nrs',0,3,8),(461,2,45,16,'_nrs',0,4,8),(462,2,46,16,'_nrs',0,5,8),(463,2,54,16,'_nrs',0,6,8),(464,2,56,16,'_nrs',0,7,8),(465,2,57,16,'_nrs',0,8,8),(466,2,58,16,'_nrs',0,9,8),(467,2,55,16,'_nrs',0,10,8),(468,2,59,16,'_nrs',0,11,8),(469,2,48,16,'_nrs',0,12,8),(470,2,49,16,'_nrs',0,13,8),(471,2,50,16,'_nrs',0,14,8),(472,2,42,16,'_nrs',0,15,8),(473,2,51,16,'_nrs',0,16,8),(474,2,53,16,'_nrs',0,17,8),(475,2,47,17,'_nrs2',0,1,9),(476,2,43,17,'_nrs2',0,2,9),(477,2,44,17,'_nrs2',0,3,9),(478,2,45,17,'_nrs2',0,4,9),(479,2,46,17,'_nrs2',0,5,9),(480,2,54,17,'_nrs2',0,6,9),(481,2,56,17,'_nrs2',0,7,9),(482,2,57,17,'_nrs2',0,8,9),(483,2,58,17,'_nrs2',0,9,9),(484,2,55,17,'_nrs2',0,10,9),(485,2,59,17,'_nrs2',0,11,9),(486,2,48,17,'_nrs2',0,12,9),(487,2,49,17,'_nrs2',0,13,9),(488,2,50,17,'_nrs2',0,14,9),(489,2,42,17,'_nrs2',0,15,9),(490,2,51,17,'_nrs2',0,16,9),(491,2,53,17,'_nrs2',0,17,9),(492,2,47,18,'_nut',0,1,10),(493,2,43,18,'_nut',0,2,10),(494,2,44,18,'_nut',0,3,10),(495,2,45,18,'_nut',0,4,10),(496,2,46,18,'_nut',0,5,10),(497,2,54,18,'_nut',0,6,10),(498,2,56,18,'_nut',0,7,10),(499,2,57,18,'_nut',0,8,10),(500,2,58,18,'_nut',0,9,10),(501,2,55,18,'_nut',0,10,10),(502,2,59,18,'_nut',0,11,10),(503,2,48,18,'_nut',0,12,10),(504,2,49,18,'_nut',0,13,10),(505,2,50,18,'_nut',0,14,10),(506,2,42,18,'_nut',0,15,10),(507,2,51,18,'_nut',0,16,10),(508,2,53,18,'_nut',0,17,10),(509,2,47,19,'_nut2',0,1,11),(510,2,43,19,'_nut2',0,2,11),(511,2,44,19,'_nut2',0,3,11),(512,2,45,19,'_nut2',0,4,11),(513,2,46,19,'_nut2',0,5,11),(514,2,54,19,'_nut2',0,6,11),(515,2,56,19,'_nut2',0,7,11),(516,2,57,19,'_nut2',0,8,11),(517,2,58,19,'_nut2',0,9,11),(518,2,55,19,'_nut2',0,10,11),(519,2,59,19,'_nut2',0,11,11),(520,2,48,19,'_nut2',0,12,11),(521,2,49,19,'_nut2',0,13,11),(522,2,50,19,'_nut2',0,14,11),(523,2,42,19,'_nut2',0,15,11),(524,2,51,19,'_nut2',0,16,11),(525,2,53,19,'_nut2',0,17,11),(526,2,71,20,'_f1',0,1,12),(527,2,74,20,'_f1',0,2,12),(528,2,81,20,'_f1',0,3,12),(529,2,73,20,'_f1',0,4,12),(530,2,77,20,'_f1',0,5,12),(531,2,79,20,'_f1',0,6,12),(532,2,80,20,'_f1',0,7,12),(533,2,75,20,'_f1',0,8,12),(534,2,76,20,'_f1',0,9,12),(535,2,72,20,'_f1',0,10,12),(536,2,71,21,'_f2',0,1,13),(537,2,74,21,'_f2',0,2,13),(538,2,81,21,'_f2',0,3,13),(539,2,73,21,'_f2',0,4,13),(540,2,77,21,'_f2',0,5,13),(541,2,79,21,'_f2',0,6,13),(542,2,80,21,'_f2',0,7,13),(543,2,75,21,'_f2',0,8,13),(544,2,76,21,'_f2',0,9,13),(545,2,72,21,'_f2',0,10,13),(546,2,71,22,'_f3',0,1,14),(547,2,74,22,'_f3',0,2,14),(548,2,81,22,'_f3',0,3,14),(549,2,73,22,'_f3',0,4,14),(550,2,77,22,'_f3',0,5,14),(551,2,79,22,'_f3',0,6,14),(552,2,80,22,'_f3',0,7,14),(553,2,75,22,'_f3',0,8,14),(554,2,76,22,'_f3',0,9,14),(555,2,72,22,'_f3',0,10,14),(556,2,71,23,'_f4',0,1,15),(557,2,74,23,'_f4',0,2,15),(558,2,81,23,'_f4',0,3,15),(559,2,73,23,'_f4',0,4,15),(560,2,77,23,'_f4',0,5,15),(561,2,79,23,'_f4',0,6,15),(562,2,80,23,'_f4',0,7,15),(563,2,75,23,'_f4',0,8,15),(564,2,76,23,'_f4',0,9,15),(565,2,72,23,'_f4',0,10,15),(566,2,91,4,'',1,1,16),(567,2,99,4,'',1,2,16),(568,2,92,4,'',1,3,16),(569,2,93,4,'',1,4,16),(570,2,95,4,'',0,5,16),(571,2,98,4,'',0,6,16),(572,2,97,4,'',0,7,16),(573,2,106,4,'',0,8,16),(574,2,105,4,'',0,9,16),(575,2,104,4,'',0,10,16),(576,2,100,4,'',1,11,16),(577,2,101,4,'',1,12,16),(578,2,102,4,'',1,13,16),(579,2,103,4,'',1,14,16),(580,2,108,4,'',1,15,16),(581,2,109,4,'',1,16,16),(582,2,96,4,'',1,17,16),(583,2,94,4,'',0,18,16),(584,2,199,24,'',0,1,17),(585,2,244,24,'',1,2,17),(586,2,245,24,'',1,3,17),(587,2,250,24,'',0,4,17),(588,2,252,24,'',0,5,17),(589,2,253,24,'',0,6,17),(590,2,251,24,'',0,7,17),(591,2,254,24,'',0,8,17),(592,2,247,24,'',1,9,17),(593,2,259,24,'',1,10,17),(594,2,260,24,'',1,11,17),(595,2,243,24,'',0,12,17),(596,2,246,24,'',0,13,17),(597,2,242,24,'',0,14,17),(598,2,221,9,'',1,1,18),(599,2,224,9,'_vt',1,2,18),(600,2,223,9,'',1,3,18),(601,2,222,9,'',1,4,18);
/*!40000 ALTER TABLE `template_category_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_resource`
--

DROP TABLE IF EXISTS `template_resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visit_template` int(11) NOT NULL,
  `resource` int(11) NOT NULL,
  `alternate` tinyint(1) NOT NULL DEFAULT '1',
  `duration` int(11) DEFAULT NULL,
  `float_start` int(11) DEFAULT NULL,
  `float_end` int(11) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `floatable` tinyint(1) DEFAULT '0',
  `flexible` tinyint(1) DEFAULT '0',
  `billable` tinyint(1) DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `group_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FKF23B923393F01044` (`visit_template`),
  KEY `FKF23B923350E3AD0B` (`resource`),
  CONSTRAINT `template_resource_0__visit_template` FOREIGN KEY (`visit_template`) REFERENCES `visit_template` (`id`),
  CONSTRAINT `template_resource_1__resource` FOREIGN KEY (`resource`) REFERENCES `resource` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_resource`
--

LOCK TABLES `template_resource` WRITE;
/*!40000 ALTER TABLE `template_resource` DISABLE KEYS */;
INSERT INTO `template_resource` VALUES (1,1,1,1,15,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(2,2,29,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(3,3,29,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(4,4,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(5,5,29,1,1410,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),NULL),(6,6,36,1,43380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-03-03 01:00:00'),NULL),(7,7,29,0,1380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(8,8,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(9,9,29,1,15,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(10,10,29,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(11,11,29,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(12,12,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(13,13,29,1,1410,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),NULL),(14,14,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(15,15,29,0,1380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(16,16,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(17,17,1,1,15,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(18,18,29,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(19,19,1,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(20,20,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:42'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(21,21,29,1,1410,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:42'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),NULL),(22,22,36,1,43380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-03-03 01:00:00'),NULL),(23,23,29,0,1380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(24,24,1,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(25,25,29,1,15,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(26,26,29,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(27,27,29,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(28,28,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(29,29,29,1,1410,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),NULL),(30,30,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(31,31,29,0,1380,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(32,32,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(33,33,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(34,34,1,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(35,35,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(36,36,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(37,37,29,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(38,38,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(39,39,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(40,40,1,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(41,41,1,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(42,42,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(43,43,29,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(44,44,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(45,45,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(46,46,1,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(47,47,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(48,48,29,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(49,49,29,0,1800,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:00:00'),NULL),(50,50,29,1,180,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(51,51,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(52,51,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(53,52,1,1,840,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),NULL),(54,52,33,1,840,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),NULL),(55,53,1,1,15,0,60,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(56,53,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(57,54,1,1,360,0,720,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),NULL),(58,54,33,1,840,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),NULL),(59,55,1,1,30,0,120,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'6c1e88cd-7d7a-4125-aec5-2496fee5a71a'),(60,55,33,1,120,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 02:00:00'),NULL),(61,55,19,1,30,0,120,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'6c1e88cd-7d7a-4125-aec5-2496fee5a71a'),(62,56,1,1,360,0,720,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),'3e72d53e-64a4-4a2e-9e21-8a93276f74df'),(63,56,33,1,840,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),NULL),(64,56,19,1,360,0,720,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),'3e72d53e-64a4-4a2e-9e21-8a93276f74df'),(65,57,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'c800402f-2738-44a5-ad76-025173836c35'),(66,57,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(67,57,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'c800402f-2738-44a5-ad76-025173836c35'),(68,58,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'b2a43be8-ad2e-491a-82bd-c7c915e41e50'),(69,58,33,1,90,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:30:00'),NULL),(70,58,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'b2a43be8-ad2e-491a-82bd-c7c915e41e50'),(71,58,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:30:00'),'b2a43be8-ad2e-491a-82bd-c7c915e41e50'),(72,59,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b'),(73,59,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(74,59,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b'),(75,59,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b'),(76,60,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:30:00'),'e30bf5c6-b84c-49c5-a92f-7ec6f19be914'),(77,60,33,1,120,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 02:00:00'),NULL),(78,60,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'e30bf5c6-b84c-49c5-a92f-7ec6f19be914'),(79,60,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'e30bf5c6-b84c-49c5-a92f-7ec6f19be914'),(80,61,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(81,62,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(82,62,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 08:00:00'),NULL),(83,62,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),NULL),(84,63,33,1,360,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),NULL),(85,64,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(86,65,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(87,65,33,1,120,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 04:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),NULL),(88,66,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(89,66,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(90,67,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(91,67,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(92,68,1,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(93,68,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(94,69,1,0,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),'5225bb48-f7b9-477c-ae57-20050391737e'),(95,69,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(96,69,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),'5225bb48-f7b9-477c-ae57-20050391737e'),(97,70,1,0,15,0,60,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:15:00'),NULL),(98,70,33,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL),(99,71,1,0,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(100,72,1,0,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(101,73,1,0,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(102,74,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:30:00'),NULL),(103,75,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),NULL),(104,75,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 19:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:00:00'),NULL),(105,76,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),NULL),(106,76,33,1,2940,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 16:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 17:00:00'),NULL),(107,76,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 13:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 14:00:00'),NULL),(108,77,1,1,75,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 06:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),NULL),(109,77,1,1,135,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 14:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:30:00'),NULL),(110,77,1,1,1020,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 05:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 22:00:00'),NULL),(111,77,33,1,3840,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-04 07:00:00'),NULL),(112,78,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 01:00:00'),NULL),(113,78,33,1,2160,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 11:00:00'),NULL),(114,79,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:30:00'),NULL),(115,79,33,1,2160,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 11:00:00'),NULL),(116,80,1,1,15,2100,2160,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:15:00'),NULL),(117,80,33,1,1950,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 20:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 05:00:00'),NULL),(118,81,1,1,15,1425,1485,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:00:00'),NULL),(119,81,33,1,2415,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 07:00:00'),NULL),(120,82,1,1,30,1425,1545,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:15:00'),NULL),(121,82,33,1,2460,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 17:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:00:00'),NULL),(122,83,1,1,15,2100,2160,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:15:00'),'ef269a45-2aab-42df-8396-c258a8f49924'),(123,83,33,1,1590,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 02:00:00'),NULL),(124,83,19,1,15,2100,2160,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:15:00'),'ef269a45-2aab-42df-8396-c258a8f49924'),(125,84,1,1,15,1425,1485,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:00:00'),'e40818c2-d1ef-4b58-a7b1-8fc0fdf1e68e'),(126,84,19,1,15,1425,1485,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:00:00'),'e40818c2-d1ef-4b58-a7b1-8fc0fdf1e68e'),(127,84,33,1,2190,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 16:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 05:15:00'),NULL),(128,85,1,1,30,1425,1545,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:15:00'),'626d3a54-1b98-428a-81c3-a2749bd9b656'),(129,85,33,1,2085,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 08:45:00'),NULL),(130,85,19,1,30,1425,1545,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:15:00'),'626d3a54-1b98-428a-81c3-a2749bd9b656'),(131,86,1,1,15,1875,1935,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),NULL),(132,86,1,1,15,2355,2415,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),NULL),(133,86,33,1,2400,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 07:00:00'),NULL),(134,87,33,1,2400,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 07:00:00'),NULL),(135,87,1,1,15,1875,1935,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'a6c924f3-13b8-4149-a9b5-199bc2f956b5'),(136,87,1,1,15,2355,2415,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'90c30aea-44c8-41cc-9866-5de526af7630'),(137,87,19,1,15,1875,1935,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'a6c924f3-13b8-4149-a9b5-199bc2f956b5'),(138,87,19,1,15,2355,2415,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'90c30aea-44c8-41cc-9866-5de526af7630'),(139,88,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),'c7a4fa6c-4833-46d0-9cce-379804044af5'),(140,88,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'c7a4fa6c-4833-46d0-9cce-379804044af5'),(141,88,33,1,2280,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 02:00:00'),NULL),(142,89,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),'801dfcc1-7761-492a-9ebc-1af31b3cdf17'),(143,89,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),'801dfcc1-7761-492a-9ebc-1af31b3cdf17'),(144,89,33,1,2160,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 21:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 09:00:00'),NULL),(145,90,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),'4b39608a-2676-46ee-9176-f05866899cc4'),(146,90,33,1,2565,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 18:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 13:30:00'),NULL),(147,90,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),'4b39608a-2676-46ee-9176-f05866899cc4'),(148,91,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),'20c34dcc-ef83-416c-8b7a-dd6602f521bb'),(149,91,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'20c34dcc-ef83-416c-8b7a-dd6602f521bb'),(150,91,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:30:00'),'20c34dcc-ef83-416c-8b7a-dd6602f521bb'),(151,91,33,1,2220,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 22:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 11:00:00'),NULL),(152,92,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),'9503941b-3486-461c-bbf3-77387d6771e0'),(153,92,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),'9503941b-3486-461c-bbf3-77387d6771e0'),(154,92,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 01:00:00'),'9503941b-3486-461c-bbf3-77387d6771e0'),(155,92,33,1,2610,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 09:30:00'),NULL),(156,93,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),'a6c809c5-3d57-4ceb-9d7e-1665c28c1280'),(157,93,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),'a6c809c5-3d57-4ceb-9d7e-1665c28c1280'),(158,93,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 01:15:00'),'a6c809c5-3d57-4ceb-9d7e-1665c28c1280'),(159,93,33,1,3060,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 14:00:00'),NULL),(160,94,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),'7a5e156a-ca6b-4565-81ea-c89f1b6e460b'),(161,94,33,1,2115,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:15:00'),NULL),(162,94,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),'7a5e156a-ca6b-4565-81ea-c89f1b6e460b'),(163,94,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'7a5e156a-ca6b-4565-81ea-c89f1b6e460b'),(164,95,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),'b8fa142c-fdbe-475a-9efc-5725ddcd5e22'),(165,95,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),'b8fa142c-fdbe-475a-9efc-5725ddcd5e22'),(166,95,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),'b8fa142c-fdbe-475a-9efc-5725ddcd5e22'),(167,95,33,1,2400,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 17:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 09:00:00'),NULL),(168,96,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),'574b9125-5d40-40c3-8650-ffd02c12d312'),(169,96,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),'574b9125-5d40-40c3-8650-ffd02c12d312'),(170,96,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),'574b9125-5d40-40c3-8650-ffd02c12d312'),(171,96,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 06:00:00'),NULL),(172,97,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),'36702ed7-9c8b-419f-83bb-52e0ab971828'),(173,97,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 16:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 07:00:00'),NULL),(174,97,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'36702ed7-9c8b-419f-83bb-52e0ab971828'),(175,97,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'36702ed7-9c8b-419f-83bb-52e0ab971828'),(176,98,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),'7cddb493-cdbf-490b-b419-bcfa21e33794'),(177,98,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),'7cddb493-cdbf-490b-b419-bcfa21e33794'),(178,98,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:30:00'),'7cddb493-cdbf-490b-b419-bcfa21e33794'),(179,98,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 17:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 08:00:00'),NULL),(180,99,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),'c1c31ad7-85a8-4cb3-ab0f-91016de15f18'),(181,99,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),'c1c31ad7-85a8-4cb3-ab0f-91016de15f18'),(182,99,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:45:00'),'c1c31ad7-85a8-4cb3-ab0f-91016de15f18'),(183,99,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 18:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 09:00:00'),NULL),(184,100,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 19:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:00:00'),NULL),(185,100,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'bacef3f7-b487-44cc-8ed1-5424bd5e5d8b'),(186,100,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'9f25279c-934b-4341-bc1b-cf0f4a318e01'),(187,100,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),'bacef3f7-b487-44cc-8ed1-5424bd5e5d8b'),(188,100,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),'9f25279c-934b-4341-bc1b-cf0f4a318e01'),(189,101,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e'),(190,101,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'efc9bcf1-5506-4116-8bfc-2b017bb5450f'),(191,101,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e'),(192,101,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),'efc9bcf1-5506-4116-8bfc-2b017bb5450f'),(193,101,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:30:00'),'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e'),(194,101,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:30:00'),'efc9bcf1-5506-4116-8bfc-2b017bb5450f'),(195,101,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 20:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 11:00:00'),NULL),(196,102,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 21:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 12:00:00'),NULL),(197,102,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'b365b13c-d164-44a4-84f0-e19693120f9a'),(198,102,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'e2a9e1d1-05b3-4603-8537-b99deb3360c4'),(199,102,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'b365b13c-d164-44a4-84f0-e19693120f9a'),(200,102,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'e2a9e1d1-05b3-4603-8537-b99deb3360c4'),(201,102,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),'b365b13c-d164-44a4-84f0-e19693120f9a'),(202,102,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),'e2a9e1d1-05b3-4603-8537-b99deb3360c4'),(203,103,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),'a15d77cf-d0e1-42da-ad35-2bc7352e0141'),(204,103,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),'65bc3e6f-fde4-40b9-93aa-103949acbba8'),(205,103,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),'a15d77cf-d0e1-42da-ad35-2bc7352e0141'),(206,103,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),'65bc3e6f-fde4-40b9-93aa-103949acbba8'),(207,103,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 08:00:00'),'a15d77cf-d0e1-42da-ad35-2bc7352e0141'),(208,103,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 16:00:00'),'65bc3e6f-fde4-40b9-93aa-103949acbba8'),(209,103,33,1,2160,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 19:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 07:00:00'),NULL),(210,104,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 07:45:00'),NULL),(211,104,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 15:45:00'),NULL),(212,105,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:00:00'),NULL),(213,105,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:00:00'),NULL),(214,105,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 23:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-04 00:00:00'),NULL),(215,106,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 00:15:00'),NULL),(216,106,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 00:15:00'),NULL),(217,106,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 23:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-04 00:15:00'),NULL),(218,107,1,0,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),NULL),(219,107,33,1,2175,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 16:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 04:45:00'),NULL),(220,108,1,0,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),'8f7e116e-4c35-4b74-85be-485b2b6fdb72'),(221,108,33,1,2385,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:45:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 06:30:00'),NULL),(222,108,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:30:00'),'8f7e116e-4c35-4b74-85be-485b2b6fdb72'),(223,109,1,0,15,2100,2160,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:15:00'),NULL),(224,110,1,1,1500,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 09:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 10:00:00'),NULL),(225,111,1,1,1500,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 09:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 10:00:00'),NULL),(226,112,1,1,1500,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 09:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 10:00:00'),NULL),(227,113,1,1,1500,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 09:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 10:00:00'),NULL),(228,114,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),NULL),(229,114,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(230,115,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),NULL),(231,115,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(232,115,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 10:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 11:00:00'),NULL),(233,115,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(234,116,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:45:00'),NULL),(235,116,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:45:00'),NULL),(236,116,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(237,117,1,1,15,360,420,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),NULL),(238,117,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(239,118,1,1,15,360,420,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),'d117a61a-a89f-47a1-9087-7f7767dcfefc'),(240,118,19,1,15,360,420,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),'d117a61a-a89f-47a1-9087-7f7767dcfefc'),(241,118,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(242,119,1,1,15,375,435,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),NULL),(243,119,1,1,15,855,915,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),NULL),(244,119,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(245,120,1,1,15,375,435,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'7291b207-cc72-46d9-806d-85713f7f638b'),(246,120,1,1,15,855,915,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'36bac479-6335-4c6f-b6dc-055bb37d84f0'),(247,120,19,1,15,375,435,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'7291b207-cc72-46d9-806d-85713f7f638b'),(248,120,19,1,15,855,915,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29'),1,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:15:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'36bac479-6335-4c6f-b6dc-055bb37d84f0'),(249,120,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(250,121,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'3a792629-a5b1-4507-be23-08e3f20dc39e'),(251,121,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'3a792629-a5b1-4507-be23-08e3f20dc39e'),(252,121,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(253,122,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70'),(254,122,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70'),(255,122,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:30:00'),'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70'),(256,122,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(257,123,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'e96797e1-db2b-4141-9c12-2eab1795c2e9'),(258,123,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'e96797e1-db2b-4141-9c12-2eab1795c2e9'),(259,123,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'e96797e1-db2b-4141-9c12-2eab1795c2e9'),(260,123,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(261,125,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'c6c92ad1-869a-4270-930a-85cafaee7e10'),(262,125,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'c6c92ad1-869a-4270-930a-85cafaee7e10'),(263,125,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'c6c92ad1-869a-4270-930a-85cafaee7e10'),(264,125,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(265,126,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(266,126,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'b65ac451-1c63-4a39-a88e-d383d6212023'),(267,126,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'cf8a8263-8b5d-43a9-9de6-626685a4226e'),(268,126,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'b65ac451-1c63-4a39-a88e-d383d6212023'),(269,126,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),'cf8a8263-8b5d-43a9-9de6-626685a4226e'),(270,127,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7'),(271,127,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'f976988e-6345-4c6b-821c-b27490caf53b'),(272,127,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7'),(273,127,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),'f976988e-6345-4c6b-821c-b27490caf53b'),(274,127,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:30:00'),'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7'),(275,127,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:30:00'),'f976988e-6345-4c6b-821c-b27490caf53b'),(276,127,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(277,128,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(278,128,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'cf1075e6-b330-4e74-83f9-e7ce8038835d'),(279,128,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'f2adf94a-5dbc-4590-9d6a-03c2be81833a'),(280,128,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'cf1075e6-b330-4e74-83f9-e7ce8038835d'),(281,128,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'f2adf94a-5dbc-4590-9d6a-03c2be81833a'),(282,128,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'cf1075e6-b330-4e74-83f9-e7ce8038835d'),(283,128,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),'f2adf94a-5dbc-4590-9d6a-03c2be81833a'),(284,129,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),'d37d5ef8-018c-48ac-93fd-2ababeb33a9f'),(285,129,1,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),'cc9b76bb-b32b-49ce-9b85-97ca5a505db4'),(286,129,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'d37d5ef8-018c-48ac-93fd-2ababeb33a9f'),(287,129,22,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),'cc9b76bb-b32b-49ce-9b85-97ca5a505db4'),(288,129,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 06:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 07:00:00'),'d37d5ef8-018c-48ac-93fd-2ababeb33a9f'),(289,129,27,1,30,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 14:30:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 15:00:00'),'cc9b76bb-b32b-49ce-9b85-97ca5a505db4'),(290,129,33,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,1,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(291,130,33,1,720,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),NULL),(292,131,33,1,720,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 12:00:00'),NULL),(293,132,1,1,1080,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 18:00:00'),NULL),(294,132,33,1,480,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 20:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(295,133,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),NULL),(296,133,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 19:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:00:00'),NULL),(297,134,1,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:39'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 11:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 12:00:00'),NULL),(298,134,33,1,2340,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:39'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 19:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-03 10:00:00'),NULL),(299,135,1,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(300,136,1,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(301,137,1,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(302,138,1,1,1680,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40'),0,0,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 04:00:00'),NULL),(303,6,15,1,15,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:23:57'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 09:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-02 09:15:00'),NULL),(304,2,35,1,60,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:52'),0,0,0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 00:00:00'),TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2012-02-01 01:00:00'),NULL);
/*!40000 ALTER TABLE `template_resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_resource_annotations`
--

DROP TABLE IF EXISTS `template_resource_annotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_resource_annotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_resource` int(11) NOT NULL,
  `line_level_annotations` int(11) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `template_resource_annotations_ibfk_1` (`template_resource`),
  KEY `template_resource_annotations_ibfk_2` (`line_level_annotations`),
  CONSTRAINT `template_resource_annotations_0__template_resource` FOREIGN KEY (`template_resource`) REFERENCES `template_resource` (`id`),
  CONSTRAINT `template_resource_annotations_1__line_level_annotations` FOREIGN KEY (`line_level_annotations`) REFERENCES `line_level_annotations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_resource_annotations`
--

LOCK TABLES `template_resource_annotations` WRITE;
/*!40000 ALTER TABLE `template_resource_annotations` DISABLE KEYS */;
INSERT INTO `template_resource_annotations` VALUES (1,6,62,1,'here\'s a comment'),(2,303,66,1,''),(3,303,51,1,''),(4,303,50,1,''),(5,303,49,313,'another comment'),(6,2,61,1424,'sample comment'),(7,304,62,1,'sdd');
/*!40000 ALTER TABLE `template_resource_annotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_resource_group`
--

DROP TABLE IF EXISTS `template_resource_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_resource_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(255) NOT NULL,
  `template_resource` int(11) NOT NULL,
  `flex_group` tinyint(1) DEFAULT '0',
  `visit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_tempResGrp_resc` (`template_resource`),
  KEY `FK99A13973BC25E8A1` (`visit`),
  CONSTRAINT `template_resource_group_0__visit_template` FOREIGN KEY (`visit`) REFERENCES `visit_template` (`id`),
  CONSTRAINT `template_resource_group_1__template_resource` FOREIGN KEY (`template_resource`) REFERENCES `template_resource` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_resource_group`
--

LOCK TABLES `template_resource_group` WRITE;
/*!40000 ALTER TABLE `template_resource_group` DISABLE KEYS */;
INSERT INTO `template_resource_group` VALUES (1,'6c1e88cd-7d7a-4125-aec5-2496fee5a71a',59,0,55),(2,'6c1e88cd-7d7a-4125-aec5-2496fee5a71a',61,0,55),(3,'3e72d53e-64a4-4a2e-9e21-8a93276f74df',62,0,56),(4,'3e72d53e-64a4-4a2e-9e21-8a93276f74df',64,0,56),(5,'c800402f-2738-44a5-ad76-025173836c35',65,1,57),(6,'c800402f-2738-44a5-ad76-025173836c35',67,1,57),(7,'b2a43be8-ad2e-491a-82bd-c7c915e41e50',68,1,58),(8,'b2a43be8-ad2e-491a-82bd-c7c915e41e50',70,1,58),(9,'b2a43be8-ad2e-491a-82bd-c7c915e41e50',71,1,58),(10,'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b',72,1,59),(11,'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b',74,1,59),(12,'b8ecfb57-dba2-4d0b-93ae-b6b2b2ac578b',75,1,59),(13,'e30bf5c6-b84c-49c5-a92f-7ec6f19be914',78,1,60),(14,'e30bf5c6-b84c-49c5-a92f-7ec6f19be914',79,1,60),(15,'e30bf5c6-b84c-49c5-a92f-7ec6f19be914',76,1,60),(16,'5225bb48-f7b9-477c-ae57-20050391737e',94,1,69),(17,'5225bb48-f7b9-477c-ae57-20050391737e',96,1,69),(18,'ef269a45-2aab-42df-8396-c258a8f49924',122,0,83),(19,'ef269a45-2aab-42df-8396-c258a8f49924',124,0,83),(20,'e40818c2-d1ef-4b58-a7b1-8fc0fdf1e68e',125,0,84),(21,'e40818c2-d1ef-4b58-a7b1-8fc0fdf1e68e',126,0,84),(22,'a6c924f3-13b8-4149-a9b5-199bc2f956b5',135,0,87),(23,'a6c924f3-13b8-4149-a9b5-199bc2f956b5',137,0,87),(24,'90c30aea-44c8-41cc-9866-5de526af7630',136,0,87),(25,'90c30aea-44c8-41cc-9866-5de526af7630',138,0,87),(26,'c7a4fa6c-4833-46d0-9cce-379804044af5',139,1,88),(27,'c7a4fa6c-4833-46d0-9cce-379804044af5',140,1,88),(28,'801dfcc1-7761-492a-9ebc-1af31b3cdf17',142,1,89),(29,'801dfcc1-7761-492a-9ebc-1af31b3cdf17',143,1,89),(30,'4b39608a-2676-46ee-9176-f05866899cc4',145,1,90),(31,'4b39608a-2676-46ee-9176-f05866899cc4',147,1,90),(32,'20c34dcc-ef83-416c-8b7a-dd6602f521bb',148,1,91),(33,'20c34dcc-ef83-416c-8b7a-dd6602f521bb',149,1,91),(34,'20c34dcc-ef83-416c-8b7a-dd6602f521bb',150,1,91),(35,'9503941b-3486-461c-bbf3-77387d6771e0',152,1,92),(36,'9503941b-3486-461c-bbf3-77387d6771e0',153,1,92),(37,'9503941b-3486-461c-bbf3-77387d6771e0',154,1,92),(38,'a6c809c5-3d57-4ceb-9d7e-1665c28c1280',156,1,93),(39,'a6c809c5-3d57-4ceb-9d7e-1665c28c1280',157,1,93),(40,'a6c809c5-3d57-4ceb-9d7e-1665c28c1280',158,1,93),(41,'7a5e156a-ca6b-4565-81ea-c89f1b6e460b',160,1,94),(42,'7a5e156a-ca6b-4565-81ea-c89f1b6e460b',162,1,94),(43,'7a5e156a-ca6b-4565-81ea-c89f1b6e460b',163,1,94),(44,'b8fa142c-fdbe-475a-9efc-5725ddcd5e22',164,1,95),(45,'b8fa142c-fdbe-475a-9efc-5725ddcd5e22',165,1,95),(46,'b8fa142c-fdbe-475a-9efc-5725ddcd5e22',166,1,95),(47,'574b9125-5d40-40c3-8650-ffd02c12d312',168,1,96),(48,'574b9125-5d40-40c3-8650-ffd02c12d312',169,1,96),(49,'574b9125-5d40-40c3-8650-ffd02c12d312',170,1,96),(50,'36702ed7-9c8b-419f-83bb-52e0ab971828',172,1,97),(51,'36702ed7-9c8b-419f-83bb-52e0ab971828',174,1,97),(52,'36702ed7-9c8b-419f-83bb-52e0ab971828',175,1,97),(53,'7cddb493-cdbf-490b-b419-bcfa21e33794',176,1,98),(54,'7cddb493-cdbf-490b-b419-bcfa21e33794',177,1,98),(55,'7cddb493-cdbf-490b-b419-bcfa21e33794',178,1,98),(56,'c1c31ad7-85a8-4cb3-ab0f-91016de15f18',180,1,99),(57,'c1c31ad7-85a8-4cb3-ab0f-91016de15f18',181,1,99),(58,'c1c31ad7-85a8-4cb3-ab0f-91016de15f18',182,1,99),(59,'bacef3f7-b487-44cc-8ed1-5424bd5e5d8b',185,1,100),(60,'bacef3f7-b487-44cc-8ed1-5424bd5e5d8b',187,1,100),(61,'9f25279c-934b-4341-bc1b-cf0f4a318e01',186,1,100),(62,'9f25279c-934b-4341-bc1b-cf0f4a318e01',188,1,100),(63,'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e',189,1,101),(64,'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e',191,1,101),(65,'23078cd1-4b2e-4933-97af-ce4ba0d2ce6e',193,1,101),(66,'efc9bcf1-5506-4116-8bfc-2b017bb5450f',190,1,101),(67,'efc9bcf1-5506-4116-8bfc-2b017bb5450f',192,1,101),(68,'efc9bcf1-5506-4116-8bfc-2b017bb5450f',194,1,101),(69,'b365b13c-d164-44a4-84f0-e19693120f9a',197,1,102),(70,'b365b13c-d164-44a4-84f0-e19693120f9a',199,1,102),(71,'b365b13c-d164-44a4-84f0-e19693120f9a',201,1,102),(72,'e2a9e1d1-05b3-4603-8537-b99deb3360c4',198,1,102),(73,'e2a9e1d1-05b3-4603-8537-b99deb3360c4',200,1,102),(74,'e2a9e1d1-05b3-4603-8537-b99deb3360c4',202,1,102),(75,'a15d77cf-d0e1-42da-ad35-2bc7352e0141',203,1,103),(76,'a15d77cf-d0e1-42da-ad35-2bc7352e0141',205,1,103),(77,'a15d77cf-d0e1-42da-ad35-2bc7352e0141',207,1,103),(78,'65bc3e6f-fde4-40b9-93aa-103949acbba8',204,1,103),(79,'65bc3e6f-fde4-40b9-93aa-103949acbba8',206,1,103),(80,'65bc3e6f-fde4-40b9-93aa-103949acbba8',208,1,103),(81,'8f7e116e-4c35-4b74-85be-485b2b6fdb72',220,1,108),(82,'8f7e116e-4c35-4b74-85be-485b2b6fdb72',222,1,108),(83,'d117a61a-a89f-47a1-9087-7f7767dcfefc',239,0,118),(84,'d117a61a-a89f-47a1-9087-7f7767dcfefc',240,0,118),(85,'7291b207-cc72-46d9-806d-85713f7f638b',245,0,120),(86,'7291b207-cc72-46d9-806d-85713f7f638b',247,0,120),(87,'36bac479-6335-4c6f-b6dc-055bb37d84f0',246,0,120),(88,'36bac479-6335-4c6f-b6dc-055bb37d84f0',248,0,120),(89,'3a792629-a5b1-4507-be23-08e3f20dc39e',250,1,121),(90,'3a792629-a5b1-4507-be23-08e3f20dc39e',251,1,121),(91,'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70',253,1,122),(92,'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70',254,1,122),(93,'3b2db26c-656a-4ca1-a37d-7f7a0cb39f70',255,1,122),(94,'e96797e1-db2b-4141-9c12-2eab1795c2e9',257,1,123),(95,'e96797e1-db2b-4141-9c12-2eab1795c2e9',258,1,123),(96,'e96797e1-db2b-4141-9c12-2eab1795c2e9',259,1,123),(97,'c6c92ad1-869a-4270-930a-85cafaee7e10',261,1,125),(98,'c6c92ad1-869a-4270-930a-85cafaee7e10',262,1,125),(99,'c6c92ad1-869a-4270-930a-85cafaee7e10',263,1,125),(100,'b65ac451-1c63-4a39-a88e-d383d6212023',266,1,126),(101,'b65ac451-1c63-4a39-a88e-d383d6212023',268,1,126),(102,'cf8a8263-8b5d-43a9-9de6-626685a4226e',267,1,126),(103,'cf8a8263-8b5d-43a9-9de6-626685a4226e',269,1,126),(104,'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7',270,1,127),(105,'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7',272,1,127),(106,'f0dd26aa-c372-40f8-8c4e-a7b5dd1ae4f7',274,1,127),(107,'f976988e-6345-4c6b-821c-b27490caf53b',271,1,127),(108,'f976988e-6345-4c6b-821c-b27490caf53b',273,1,127),(109,'f976988e-6345-4c6b-821c-b27490caf53b',275,1,127),(110,'cf1075e6-b330-4e74-83f9-e7ce8038835d',278,1,128),(111,'cf1075e6-b330-4e74-83f9-e7ce8038835d',280,1,128),(112,'cf1075e6-b330-4e74-83f9-e7ce8038835d',282,1,128),(113,'f2adf94a-5dbc-4590-9d6a-03c2be81833a',279,1,128),(114,'f2adf94a-5dbc-4590-9d6a-03c2be81833a',281,1,128),(115,'f2adf94a-5dbc-4590-9d6a-03c2be81833a',283,1,128),(116,'d37d5ef8-018c-48ac-93fd-2ababeb33a9f',284,1,129),(117,'d37d5ef8-018c-48ac-93fd-2ababeb33a9f',286,1,129),(118,'d37d5ef8-018c-48ac-93fd-2ababeb33a9f',288,1,129),(119,'cc9b76bb-b32b-49ce-9b85-97ca5a505db4',285,1,129),(120,'cc9b76bb-b32b-49ce-9b85-97ca5a505db4',287,1,129),(121,'cc9b76bb-b32b-49ce-9b85-97ca5a505db4',289,1,129),(122,'626d3a54-1b98-428a-81c3-a2749bd9b656',128,0,85),(123,'626d3a54-1b98-428a-81c3-a2749bd9b656',130,0,85);
/*!40000 ALTER TABLE `template_resource_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_user`
--

DROP TABLE IF EXISTS `template_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_template_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `last_update_time` datetime NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_user_0__user_id` (`user_id`),
  KEY `template_user_1__template_id` (`report_template_id`),
  CONSTRAINT `template_user_0__user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `template_user_1__template_id` FOREIGN KEY (`report_template_id`) REFERENCES `report_template` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_user`
--

LOCK TABLES `template_user` WRITE;
/*!40000 ALTER TABLE `template_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_user_filter_selection`
--

DROP TABLE IF EXISTS `template_user_filter_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_user_filter_selection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_user_selection_id` int(11) NOT NULL,
  `expression` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_user_filter_selection_fk1` (`template_user_selection_id`),
  CONSTRAINT `template_user_filter_selection_constraint1` FOREIGN KEY (`template_user_selection_id`) REFERENCES `template_user_selection` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_user_filter_selection`
--

LOCK TABLES `template_user_filter_selection` WRITE;
/*!40000 ALTER TABLE `template_user_filter_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_user_filter_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_user_selection`
--

DROP TABLE IF EXISTS `template_user_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_user_selection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_user_id` int(11) NOT NULL,
  `tcf_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_user_selection_fk1` (`template_user_id`),
  KEY `template_user_selection_fk2` (`tcf_id`),
  CONSTRAINT `template_user_selection_constraint1` FOREIGN KEY (`template_user_id`) REFERENCES `template_user` (`id`),
  CONSTRAINT `template_user_selection_constraint2` FOREIGN KEY (`tcf_id`) REFERENCES `template_category_field` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_user_selection`
--

LOCK TABLES `template_user_selection` WRITE;
/*!40000 ALTER TABLE `template_user_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_user_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_user_sort_selection`
--

DROP TABLE IF EXISTS `template_user_sort_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template_user_sort_selection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_user_selection_id` int(11) NOT NULL,
  `order_by` varchar(21) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `template_user_sort_selection_fk1` (`template_user_selection_id`),
  CONSTRAINT `template_user_sort_selection_constraint1` FOREIGN KEY (`template_user_selection_id`) REFERENCES `template_user_selection` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_user_sort_selection`
--

LOCK TABLES `template_user_sort_selection` WRITE;
/*!40000 ALTER TABLE `template_user_sort_selection` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_user_sort_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `credential` int(255) DEFAULT NULL,
  `department` int(255) DEFAULT NULL,
  `division` int(255) DEFAULT NULL,
  `ecommons_id` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `faculty_rank` int(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `institution` int(11) DEFAULT NULL,
  `irb_institution` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `pager` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `primary_phone` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `secondary_phone` varchar(255) DEFAULT NULL,
  `institution_role` int(11) DEFAULT NULL,
  `role` int(11) DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `notification_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=422 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` VALUES
  (409,1,1,1,1,'fa123','fa123@e.edu',1,'','Alma',3,NULL,'Apple','','','rmAAVapx/FA1QH8KR2jQxr9QazJ1HoxR18WcE1sVmNo=','(555) 555-5555','$3@Nn3HMS2012','',1,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:01'),NULL), (410,1,NULL,NULL,NULL,'SA123','sa123@fakek.edu',NULL,'(123) 456-7890','Bobby',5,NULL,'Boyle','','(123) 456-7890','f+6Td7nl2XuN5Mb9L/eVhWyMJ+XvO/aXk5MBIuiXL2k=','(123) 456-7890','974f23cc-54ad-4216-856d-d552a4f0905d','(123) 456-7890',1,12,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:52'),NULL), (411,1,NULL,NULL,NULL,'NR123','nr123@fakek.edu',NULL,'(123) 456-7890','Carly',5,NULL,'Cart','','(123) 456-7890','Kuvg3o/k3t8B8fp8Leg6pXKzJJoR5C9SI74AXQXlK+Q=','(123) 456-7890','888c550e-ab4a-48f1-8e39-076371d60a0d','(123) 456-7890',2,10,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:17'),NULL), (412,1,NULL,NULL,NULL,'NT123','nt123@fakek.edu',NULL,'(123) 456-7890','Donny',5,NULL,'Dove','','(123) 456-7890','uvDjTVWxmZRZmrGQXm8vw1omPQTkFzKzubcAVIa3Mlg=','(123) 456-7890','8700aa72-81f0-4fcc-93a8-b5577a666584','(123) 456-7890',2,11,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:23'),NULL), (413,1,NULL,NULL,NULL,'BS123','bs123@fakek.edu',NULL,'(123) 456-7890','Edna',5,NULL,'Everage','','(123) 456-7890','sLVFnI6+nS1lGhXXJ7XcKejqqtAvZLjm1qNVYteywOE=','(123) 456-7890','6f1954ba-f96d-4464-98e0-ed9702b0eb20','(123) 456-7890',3,15,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:51'),NULL), (414,1,NULL,NULL,NULL,'FD123','fd123@fakek.edu',NULL,'(123) 456-7890','Fanny',5,NULL,'Farber','','(123) 456-7890','avBUNGzEl30SvYJ61Hm1C7/brZng2cwOu2ksKO0WabY=','(123) 456-7890','2ca71aaf-ba67-41b6-9393-0cce2c24b0f8','(123) 456-7890',5,4,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:09'),NULL), (415,1,NULL,NULL,NULL,'GV123','gv123@fakek.edu',NULL,'(123) 456-7890','Greg',5,NULL,'Gumble','','(123) 456-7890','/z1r8c7mXoNbQWWYC2VOWEDeh777xxCPENddNCVI/LA=','(123) 456-7890','e61ed63b-1aca-40fe-9b56-b0e7c5aa5588','(123) 456-7890',6,5,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:18'),NULL), (416,1,NULL,NULL,NULL,'PS123','ps123@fakek.edu',NULL,'(123) 456-7890','Helen',5,NULL,'Hayes','','(123) 456-7890','dknOY14OAnCZB0NRhGaAZusoTOTmxl7O+UDnjUW3vws=','(123) 456-7890','9b94afd3-a3e2-4729-8d5d-4d6b6f78412b','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:04'),NULL), (417,1,NULL,NULL,NULL,'PS456','ps456@fakek.edu',NULL,'(123) 456-7890','Ingrid',5,NULL,'India','','(123) 456-7890','svJcl4ISL4c3Syy0Gq3BlFKwdKsn4us0orinlW4HbhI=','(123) 456-7890','e4a40c6f-2b6e-4af8-abd0-6aa8782f8e1e','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:15'),NULL), (418,1,NULL,NULL,NULL,'PS890','ps890@fakek.edu',NULL,'(123) 456-7890','Jacob',5,NULL,'Jones','','(123) 456-7890','t72PSS6CDVNxrKWhVPwjexxBuODiaelipOiJc+aaP+w=','(123) 456-7890','da592047-aa58-4c2f-8602-e00ad4f1e4bb','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:29'),NULL), (419,1,NULL,NULL,NULL,'APS123','aps123@fakek.edu',NULL,'(123) 456-7890','Loyd',5,NULL,'Lamp','','(123) 456-7890','eI/0F/8jmUbm6ZzGtrkE9HKY5xqjQbJs5+3D4JnQLG4=','(123) 456-7890','c89e1ac2-56eb-4b36-91be-583cffa164a7','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:45'),NULL), (420,1,NULL,NULL,NULL,'APS456','aps456@fakek.edu',NULL,'(123) 456-7890','Melnea',5,NULL,'Moses','','(123) 456-7890','WWKTHB0I4bQD0yEn2ADGdIuSw8QPZ/oJd7Qxpp5ZGxE=','(123) 456-7890','1f1b1cbe-dc34-4857-8f13-8bc04c71bf81','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:48'),NULL), (421,1,NULL,NULL,NULL,'APS789','aps789@fakek.edu',NULL,'(123) 456-7890','Ned',5,NULL,'Needham','','(123) 456-7890','XndNsGO5FLW9qLcPdnxMiJEvQ6X0AbLNLyXd7dkcNw0=','(123) 456-7890','bb948118-f601-4c79-af9c-76f6ff278874','(123) 456-7890',4,1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:58'),NULL);
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_session`
--

DROP TABLE IF EXISTS `user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(200) DEFAULT NULL,
  `session_id` varchar(200) DEFAULT NULL,
  `user` int(11) NOT NULL,
  `last_access_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FKD1401A22F1F7CC05` (`user`),
  CONSTRAINT `user_session_0__user` FOREIGN KEY (`user`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1076 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_session`
--

LOCK TABLES `user_session` WRITE;
/*!40000 ALTER TABLE `user_session` DISABLE KEYS */;
INSERT INTO `user_session` VALUES (1,'10.1.10.224',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 11:40:23')),(2,'10.1.10.224',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:08:57')),(3,'134.174.149.46',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16')),(4,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16')),(5,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16')),(6,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16')),(7,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:16')),(8,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17')),(9,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17')),(10,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17')),(11,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:17')),(12,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18')),(13,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18')),(14,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18')),(15,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18')),(16,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:18')),(17,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19')),(18,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19')),(19,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19')),(20,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:19')),(21,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20')),(22,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20')),(23,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20')),(24,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20')),(25,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:20')),(26,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21')),(27,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21')),(28,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21')),(29,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:21')),(30,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22')),(31,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22')),(32,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22')),(33,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:22')),(34,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:23')),(35,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:23')),(36,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(37,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(38,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(39,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(40,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(41,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:24')),(42,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25')),(43,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25')),(44,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:25')),(45,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26')),(46,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26')),(47,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26')),(48,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26')),(49,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:26')),(50,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27')),(51,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27')),(52,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27')),(53,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27')),(54,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:27')),(55,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28')),(56,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28')),(57,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28')),(58,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:28')),(59,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29')),(60,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29')),(61,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29')),(62,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29')),(63,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:29')),(64,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30')),(65,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30')),(66,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30')),(67,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:30')),(68,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31')),(69,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31')),(70,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31')),(71,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:31')),(72,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32')),(73,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32')),(74,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32')),(75,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32')),(76,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:32')),(77,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33')),(78,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33')),(79,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33')),(80,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33')),(81,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:33')),(82,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34')),(83,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34')),(84,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34')),(85,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:34')),(86,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(87,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(88,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(89,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(90,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(91,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(92,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:35')),(93,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36')),(94,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36')),(95,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:36')),(96,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37')),(97,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37')),(98,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37')),(99,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37')),(100,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:37')),(101,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38')),(102,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38')),(103,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38')),(104,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:38')),(105,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39')),(106,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39')),(107,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39')),(108,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:39')),(109,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40')),(110,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40')),(111,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40')),(112,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:40')),(113,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(114,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(115,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(116,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(117,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:41')),(118,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:42')),(119,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:42')),(120,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44')),(121,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44')),(122,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:44')),(123,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45')),(124,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45')),(125,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45')),(126,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:45')),(127,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46')),(128,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46')),(129,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46')),(130,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46')),(131,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:46')),(132,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47')),(133,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47')),(134,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47')),(135,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47')),(136,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:47')),(137,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(138,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(139,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(140,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(141,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(142,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:48')),(143,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49')),(144,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49')),(145,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49')),(146,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:49')),(147,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50')),(148,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50')),(149,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50')),(150,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:50')),(151,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(152,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(153,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(154,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(155,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(156,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:51')),(157,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52')),(158,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52')),(159,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52')),(160,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:52')),(161,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(162,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(163,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(164,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(165,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(166,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:53')),(167,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(168,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(169,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(170,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(171,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:54')),(172,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55')),(173,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55')),(174,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55')),(175,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55')),(176,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:55')),(177,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56')),(178,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56')),(179,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56')),(180,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:56')),(181,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(182,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(183,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(184,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(185,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:57')),(186,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58')),(187,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58')),(188,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58')),(189,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58')),(190,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:58')),(191,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59')),(192,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59')),(193,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59')),(194,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59')),(195,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:11:59')),(196,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(197,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(198,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(199,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(200,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(201,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(202,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:00')),(203,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01')),(204,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01')),(205,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01')),(206,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01')),(207,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:01')),(208,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(209,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(210,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(211,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(212,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(213,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:02')),(214,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03')),(215,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03')),(216,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03')),(217,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:03')),(218,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(219,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(220,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(221,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(222,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(223,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:04')),(224,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05')),(225,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05')),(226,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05')),(227,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:05')),(228,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(229,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(230,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(231,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(232,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(233,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:06')),(234,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07')),(235,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07')),(236,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07')),(237,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07')),(238,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08')),(239,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08')),(240,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08')),(241,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08')),(242,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08')),(243,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(244,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(245,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(246,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(247,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(248,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09')),(249,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(250,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(251,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(252,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(253,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(254,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10')),(255,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11')),(256,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11')),(257,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11')),(258,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11')),(259,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11')),(260,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12')),(261,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12')),(262,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12')),(263,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12')),(264,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12')),(265,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(266,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(267,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(268,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(269,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(270,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13')),(271,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(272,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(273,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(274,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(275,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(276,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14')),(277,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15')),(278,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15')),(279,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15')),(280,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15')),(281,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17')),(282,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17')),(283,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17')),(284,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17')),(285,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(286,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(287,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(288,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(289,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(290,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18')),(291,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19')),(292,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19')),(293,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19')),(294,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19')),(295,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(296,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(297,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(298,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(299,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(300,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20')),(301,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21')),(302,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21')),(303,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21')),(304,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21')),(305,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21')),(306,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(307,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(308,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(309,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(310,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(311,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22')),(312,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23')),(313,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23')),(314,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23')),(315,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23')),(316,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23')),(317,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(318,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(319,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(320,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(321,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(322,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24')),(323,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(324,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(325,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(326,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(327,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(328,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25')),(329,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26')),(330,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26')),(331,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26')),(332,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26')),(333,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26')),(334,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27')),(335,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27')),(336,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27')),(337,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27')),(338,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27')),(339,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(340,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(341,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(342,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(343,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(344,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28')),(345,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29')),(346,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29')),(347,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29')),(348,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29')),(349,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29')),(350,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(351,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(352,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(353,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(354,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(355,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(356,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30')),(357,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31')),(358,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31')),(359,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31')),(360,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31')),(361,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(362,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(363,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(364,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(365,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(366,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32')),(367,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33')),(368,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33')),(369,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33')),(370,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33')),(371,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33')),(372,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34')),(373,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34')),(374,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34')),(375,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34')),(376,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34')),(377,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(378,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(379,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(380,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(381,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(382,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35')),(383,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(384,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(385,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(386,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(387,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(388,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36')),(389,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37')),(390,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37')),(391,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37')),(392,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:37')),(393,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38')),(394,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38')),(395,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38')),(396,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38')),(397,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:38')),(398,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39')),(399,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39')),(400,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39')),(401,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39')),(402,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:39')),(403,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(404,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(405,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(406,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(407,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(408,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:40')),(409,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41')),(410,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41')),(411,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41')),(412,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:41')),(413,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:42')),(414,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:42')),(415,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:42')),(416,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43')),(417,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43')),(418,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43')),(419,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43')),(420,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:43')),(421,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44')),(422,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44')),(423,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44')),(424,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44')),(425,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:44')),(426,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45')),(427,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45')),(428,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45')),(429,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45')),(430,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:45')),(431,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46')),(432,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46')),(433,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46')),(434,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46')),(435,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:46')),(436,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(437,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(438,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(439,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(440,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(441,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:47')),(442,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48')),(443,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48')),(444,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48')),(445,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48')),(446,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:48')),(447,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49')),(448,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49')),(449,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49')),(450,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49')),(451,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:49')),(452,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50')),(453,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50')),(454,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50')),(455,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:50')),(456,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51')),(457,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51')),(458,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51')),(459,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:51')),(460,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(461,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(462,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(463,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(464,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(465,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:52')),(466,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53')),(467,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53')),(468,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53')),(469,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53')),(470,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:53')),(471,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(472,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(473,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(474,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(475,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(476,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:54')),(477,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55')),(478,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55')),(479,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55')),(480,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55')),(481,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:55')),(482,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56')),(483,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56')),(484,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56')),(485,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56')),(486,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:56')),(487,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57')),(488,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57')),(489,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57')),(490,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57')),(491,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:57')),(492,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58')),(493,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58')),(494,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58')),(495,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58')),(496,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:58')),(497,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59')),(498,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59')),(499,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59')),(500,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:59')),(501,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00')),(502,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00')),(503,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00')),(504,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00')),(505,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:00')),(506,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(507,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(508,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(509,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(510,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(511,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:01')),(512,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02')),(513,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02')),(514,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02')),(515,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02')),(516,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:02')),(517,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03')),(518,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03')),(519,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03')),(520,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03')),(521,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:03')),(522,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04')),(523,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04')),(524,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04')),(525,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04')),(526,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:04')),(527,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05')),(528,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05')),(529,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05')),(530,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:05')),(531,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06')),(532,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06')),(533,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06')),(534,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06')),(535,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:06')),(536,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07')),(537,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07')),(538,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07')),(539,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07')),(540,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:07')),(541,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08')),(542,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08')),(543,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08')),(544,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08')),(545,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:08')),(546,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09')),(547,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09')),(548,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09')),(549,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09')),(550,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:09')),(551,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10')),(552,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10')),(553,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10')),(554,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10')),(555,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:10')),(556,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11')),(557,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11')),(558,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11')),(559,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11')),(560,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:11')),(561,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12')),(562,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12')),(563,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12')),(564,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12')),(565,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:12')),(566,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13')),(567,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13')),(568,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13')),(569,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13')),(570,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:13')),(571,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14')),(572,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14')),(573,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14')),(574,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14')),(575,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:14')),(576,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(577,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(578,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(579,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(580,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(581,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:15')),(582,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16')),(583,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16')),(584,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16')),(585,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16')),(586,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:16')),(587,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17')),(588,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17')),(589,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17')),(590,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17')),(591,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:17')),(592,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18')),(593,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18')),(594,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18')),(595,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:18')),(596,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19')),(597,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19')),(598,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19')),(599,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19')),(600,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:19')),(601,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20')),(602,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20')),(603,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20')),(604,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20')),(605,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:20')),(606,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21')),(607,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21')),(608,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21')),(609,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21')),(610,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:21')),(611,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22')),(612,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22')),(613,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:22')),(614,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23')),(615,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23')),(616,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23')),(617,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23')),(618,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:23')),(619,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24')),(620,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24')),(621,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24')),(622,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24')),(623,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:24')),(624,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25')),(625,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25')),(626,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25')),(627,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25')),(628,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:25')),(629,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26')),(630,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26')),(631,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26')),(632,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26')),(633,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:26')),(634,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27')),(635,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27')),(636,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27')),(637,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27')),(638,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:27')),(639,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28')),(640,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28')),(641,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28')),(642,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28')),(643,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:28')),(644,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29')),(645,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29')),(646,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29')),(647,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29')),(648,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:29')),(649,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30')),(650,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30')),(651,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30')),(652,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30')),(653,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:30')),(654,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31')),(655,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31')),(656,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31')),(657,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31')),(658,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:31')),(659,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32')),(660,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32')),(661,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32')),(662,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32')),(663,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:32')),(664,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33')),(665,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33')),(666,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33')),(667,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:33')),(668,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(669,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(670,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(671,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(672,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(673,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:34')),(674,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35')),(675,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35')),(676,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35')),(677,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35')),(678,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:35')),(679,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36')),(680,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36')),(681,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36')),(682,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36')),(683,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:36')),(684,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37')),(685,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37')),(686,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37')),(687,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37')),(688,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:37')),(689,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38')),(690,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38')),(691,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38')),(692,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38')),(693,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:38')),(694,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:39')),(695,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:39')),(696,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(697,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(698,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(699,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(700,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(701,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:40')),(702,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:41')),(703,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:41')),(704,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:41')),(705,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:42')),(706,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:42')),(707,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:43')),(708,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:43')),(709,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:43')),(710,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:44')),(711,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:44')),(712,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:44')),(713,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:45')),(714,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:45')),(715,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:45')),(716,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:45')),(717,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:46')),(718,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:46')),(719,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:47')),(720,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:47')),(721,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:47')),(722,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:48')),(723,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:48')),(724,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:49')),(725,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:49')),(726,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:49')),(727,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:50')),(728,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:50')),(729,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:50')),(730,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:51')),(731,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:51')),(732,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:52')),(733,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:52')),(734,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:52')),(735,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:53')),(736,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:53')),(737,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:53')),(738,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:53')),(739,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:54')),(740,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:54')),(741,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:54')),(742,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:55')),(743,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:55')),(744,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:56')),(745,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:56')),(746,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:56')),(747,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:57')),(748,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:57')),(749,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:57')),(750,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(751,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(752,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58')),(753,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(754,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(755,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59')),(756,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(757,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(758,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00')),(759,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(760,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(761,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01')),(762,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(763,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(764,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(765,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02')),(766,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03')),(767,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03')),(768,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03')),(769,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(770,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(771,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(772,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04')),(773,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(774,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(775,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(776,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05')),(777,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(778,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(779,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(780,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(781,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06')),(782,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(783,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(784,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07')),(785,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(786,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(787,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(788,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08')),(789,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(790,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(791,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(792,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(793,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(794,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09')),(795,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(796,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(797,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10')),(798,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(799,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(800,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(801,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11')),(802,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12')),(803,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12')),(804,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12')),(805,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(806,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(807,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13')),(808,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(809,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(810,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14')),(811,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(812,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(813,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15')),(814,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(815,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(816,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16')),(817,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(818,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(819,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17')),(820,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(821,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(822,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18')),(823,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(824,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(825,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19')),(826,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(827,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(828,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20')),(829,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(830,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(831,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21')),(832,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(833,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(834,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22')),(835,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(836,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(837,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23')),(838,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(839,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(840,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24')),(841,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(842,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(843,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(844,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25')),(845,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(846,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(847,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26')),(848,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(849,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(850,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(851,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27')),(852,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28')),(853,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28')),(854,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(855,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(856,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(857,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29')),(858,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(859,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(860,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30')),(861,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(862,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(863,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31')),(864,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(865,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(866,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(867,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32')),(868,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(869,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(870,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33')),(871,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(872,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(873,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34')),(874,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(875,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(876,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35')),(877,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(878,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(879,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(880,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36')),(881,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(882,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(883,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37')),(884,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(885,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(886,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38')),(887,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39')),(888,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39')),(889,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39')),(890,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:39')),(891,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40')),(892,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40')),(893,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40')),(894,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:40')),(895,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41')),(896,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41')),(897,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41')),(898,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:41')),(899,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42')),(900,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42')),(901,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42')),(902,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42')),(903,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:42')),(904,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43')),(905,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43')),(906,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43')),(907,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43')),(908,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:43')),(909,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44')),(910,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44')),(911,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44')),(912,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44')),(913,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:44')),(914,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45')),(915,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45')),(916,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45')),(917,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45')),(918,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:45')),(919,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46')),(920,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46')),(921,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46')),(922,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:46')),(923,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47')),(924,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47')),(925,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47')),(926,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47')),(927,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:47')),(928,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48')),(929,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48')),(930,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48')),(931,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48')),(932,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:48')),(933,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49')),(934,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49')),(935,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49')),(936,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:49')),(937,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50')),(938,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50')),(939,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50')),(940,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50')),(941,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:50')),(942,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51')),(943,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51')),(944,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51')),(945,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:51')),(946,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52')),(947,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52')),(948,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52')),(949,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:52')),(950,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53')),(951,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53')),(952,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53')),(953,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53')),(954,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:53')),(955,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54')),(956,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54')),(957,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54')),(958,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54')),(959,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:54')),(960,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55')),(961,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55')),(962,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55')),(963,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55')),(964,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:55')),(965,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56')),(966,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56')),(967,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56')),(968,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:56')),(969,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57')),(970,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57')),(971,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57')),(972,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57')),(973,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:57')),(974,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58')),(975,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58')),(976,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58')),(977,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58')),(978,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:58')),(979,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59')),(980,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59')),(981,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59')),(982,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:59')),(983,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00')),(984,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00')),(985,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00')),(986,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00')),(987,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:00')),(988,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01')),(989,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01')),(990,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01')),(991,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01')),(992,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:01')),(993,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02')),(994,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02')),(995,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02')),(996,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:02')),(997,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03')),(998,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03')),(999,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03')),(1000,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03')),(1001,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:03')),(1002,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04')),(1003,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04')),(1004,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04')),(1005,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:04')),(1006,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05')),(1007,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05')),(1008,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05')),(1009,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:05')),(1010,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:06')),(1011,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:06')),(1012,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07')),(1013,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07')),(1014,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07')),(1015,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07')),(1016,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:07')),(1017,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08')),(1018,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08')),(1019,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08')),(1020,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:08')),(1021,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1022,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1023,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1024,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1025,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1026,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:09')),(1027,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10')),(1028,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10')),(1029,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:10')),(1030,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11')),(1031,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11')),(1032,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11')),(1033,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:11')),(1034,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1035,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1036,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1037,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1038,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1039,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:12')),(1040,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13')),(1041,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13')),(1042,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13')),(1043,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:13')),(1044,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14')),(1045,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14')),(1046,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14')),(1047,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14')),(1048,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:14')),(1049,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15')),(1050,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15')),(1051,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15')),(1052,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15')),(1053,'134.174.149.46',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:15:15')),(1054,'10.1.10.224',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:18:57')),(1055,'10.1.10.224','7615B4B3E2A953CFAEF6E1060E324F01',409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:42:33')),(1056,'10.1.10.224','A8829F8BF97757D012D7A32EDBC28758',409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 13:50:34')),(1057,'10.1.10.146',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 08:52:11')),(1058,'10.1.10.224',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:47:48')),(1059,'10.1.10.224','CB186A8F5B4C14060E2E8C0CC339341C',410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:48:24')),(1060,'10.1.10.224',NULL,414,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:09')),(1061,'10.1.10.224',NULL,411,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:17')),(1062,'10.1.10.224',NULL,412,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:23')),(1063,'10.1.10.224','D2C01E2AA7B44A0320D095753304325B',413,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:41')),(1064,'10.1.10.224',NULL,413,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:49:51')),(1065,'10.1.10.224',NULL,416,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:04')),(1066,'10.1.10.224',NULL,417,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:15')),(1067,'10.1.10.224',NULL,418,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:29')),(1068,'10.1.10.224',NULL,419,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:50:45')),(1069,'10.1.10.224',NULL,420,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:04')),(1070,'10.1.10.224',NULL,421,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:21')),(1071,'10.1.10.224',NULL,420,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:48')),(1072,'10.1.10.224',NULL,421,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:51:58')),(1073,'10.1.10.224','AC8EA8751205B23E3AD618AACC6F7CD1',415,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:52:18')),(1074,'10.1.10.224',NULL,409,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:53:01')),(1075,'10.1.10.224',NULL,410,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-27 09:57:52'));
/*!40000 ALTER TABLE `user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `visit_template`
--

DROP TABLE IF EXISTS `visit_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `visit_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `study` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `short_name` varchar(255) DEFAULT NULL,
  `sublocation` int(11) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0',
  `relative_time` tinyint(1) DEFAULT '0',
  `duration` int(11) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `created_date` datetime DEFAULT NULL,
  `nursing` varchar(11) DEFAULT NULL,
  `nutrition` varchar(11) DEFAULT NULL,
  `processing` varchar(11) DEFAULT NULL,
  `non_institution_non_CRC` tinyint(1) DEFAULT '0',
  `institution_non_crc` tinyint(1) DEFAULT '0',
  `active` tinyint(1) DEFAULT '0',
  `setUp` varchar(11) DEFAULT NULL,
  `research_pharmacy` tinyint(1) DEFAULT '0',
  `last_update_time` datetime DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'OutpatientCRC',
  PRIMARY KEY (`id`),
  KEY `FK6B04D4BE967D31E` (`study`),
  KEY `FKDE7A74EE135C3C9B` (`sublocation`),
  KEY `idx_visit_template_type` (`type`),
  CONSTRAINT `visit_template_0__sublocation` FOREIGN KEY (`sublocation`) REFERENCES `sublocation` (`id`),
  CONSTRAINT `visit_template_1__study` FOREIGN KEY (`study`) REFERENCES `study` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `visit_template`
--

LOCK TABLES `visit_template` WRITE;
/*!40000 ALTER TABLE `visit_template` DISABLE KEYS */;
INSERT INTO `visit_template` VALUES (1,1,'Out TA-001 WHT 13','',1,1,0,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'OutpatientCRC'),(2,1,'Out TA-001 CNY','',2,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:07'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:59'),'OutpatientCRC'),(3,1,'Out TA-001 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:58'),'OutpatientNonCRC'),(4,1,'Out TA-001 Off Institution','',4,0,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'OutpatientOffInstitution'),(5,1,'In TA-001 WHT 13','',1,1,0,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'InpatientCRC'),(6,1,'In TA-001 CNY','',2,1,0,43380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:24:05'),'InpatientCRC'),(7,1,'In TA-001 Non CRC','',3,1,0,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:08'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:13:59'),'InpatientNonCRC'),(8,1,'In TA-001 Off Institution','',4,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'InpatientOffInstitution'),(9,2,'Out TA-002 WHT 13','',1,1,0,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'OutpatientCRC'),(10,2,'Out TA-002 CNY','',2,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:00'),'OutpatientCRC'),(11,2,'Out TA-002 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'OutpatientNonCRC'),(12,2,'Out TA-002 Off Institution','',4,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:09'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'OutpatientOffInstitution'),(13,2,'In TA-002 WHT 13','',1,1,0,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:01'),'InpatientCRC'),(14,2,'In TA-002 CNY','',2,0,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'InpatientCRC'),(15,2,'In TA-002 Non CRC','',3,1,0,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'InpatientNonCRC'),(16,2,'In TA-002 Off Institution','',4,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'InpatientOffInstitution'),(17,7,'Out AS001 WHT 13','',1,1,0,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:10'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:02'),'OutpatientCRC'),(18,7,'Out AS001 CNY','',2,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'OutpatientCRC'),(19,7,'Out AS001 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:03'),'OutpatientNonCRC'),(20,7,'Out AS001 Off Institution','',4,0,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'OutpatientOffInstitution'),(21,7,'In AS001 WHT 13','',1,1,0,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:11'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'InpatientCRC'),(22,7,'In AS001 CNY','',2,1,0,43380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'InpatientCRC'),(23,7,'In AS001 Non CRC','',3,1,0,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'InpatientNonCRC'),(24,7,'In AS001 Off Institution','',4,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:04'),'InpatientOffInstitution'),(25,8,'Out AS002 WHT 13','',1,1,0,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:12'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'OutpatientCRC'),(26,8,'Out AS002 CNY','',2,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'OutpatientCRC'),(27,8,'Out AS002 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'OutpatientNonCRC'),(28,8,'Out AS002 Off Institution','',4,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:05'),'OutpatientOffInstitution'),(29,8,'In AS002 WHT 13','',1,1,0,1410,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'InpatientCRC'),(30,8,'In AS002 CNY','',2,0,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'InpatientCRC'),(31,8,'In AS002 Non CRC','',3,1,0,1380,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:13'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'InpatientNonCRC'),(32,8,'In AS002 Off Institution','',4,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:06'),'InpatientOffInstitution'),(33,3,'Out TB-003 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'OutpatientNonCRC'),(34,3,'In RT TB-003 WHT 13','',1,1,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'InpatientCRC'),(35,3,'In TB-003 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:14'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'InpatientCRC'),(36,4,'Out TC-004 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:07'),'OutpatientNonCRC'),(37,4,'In RT TC-004 WHT 13','',1,1,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'InpatientCRC'),(38,4,'In TC-004 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:15'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'InpatientCRC'),(39,5,'Out TD-005 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'OutpatientNonCRC'),(40,5,'In RT TD-005 WHT 13','',1,1,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:08'),'InpatientCRC'),(41,5,'In TD-005 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'InpatientCRC'),(42,6,'Out TC-006 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:17'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'OutpatientNonCRC'),(43,6,'In RT TC-006 WHT 13','',1,0,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'InpatientCRC'),(44,6,'In TC-006 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'InpatientCRC'),(45,9,'Out AS003 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:09'),'OutpatientNonCRC'),(46,9,'In RT AS003 WHT 13','',1,1,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:18'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'InpatientCRC'),(47,9,'In AS003 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'InpatientCRC'),(48,10,'Out AS004 Non CRC','',3,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'OutpatientNonCRC'),(49,10,'In RT AS004 WHT 13','',1,1,1,1800,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:10'),'InpatientCRC'),(50,10,'In AS004 CNY','',2,1,0,180,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:19'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'InpatientCRC'),(51,11,'Out Fixed Short','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'OutpatientCRC'),(52,11,'Out Fixed Long','',1,1,0,840,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'OutpatientCRC'),(53,11,'Out Float Single','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'3','3','3',0,1,1,'3',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:11'),'OutpatientCRC'),(54,11,'Out Float Single Long','',1,1,0,840,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'4','4','4',1,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'OutpatientCRC'),(55,11,'Out Float Linked','',1,1,0,120,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:20'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:12'),'OutpatientCRC'),(56,11,'Out Float Linked Long','',1,1,0,840,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'6','6','6',0,1,1,'6',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'OutpatientCRC'),(57,11,'Out Flex Consec 2','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'OutpatientCRC'),(58,11,'Out Flex Consec 3','',1,1,0,90,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'1','1','1',1,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:13'),'OutpatientCRC'),(59,11,'Out Flex Super A','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'OutpatientCRC'),(60,11,'Out Flex Super B','',1,1,0,120,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:21'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'OutpatientCRC'),(61,14,'Out Resource Blocker Short','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'4','4','4',0,1,1,'4',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:14'),'OutpatientCRC'),(62,14,'Out Resource Blocker 3 Times','',1,1,0,900,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'5','5','5',1,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'OutpatientCRC'),(63,14,'Out Room Blocker','',1,1,0,360,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'OutpatientCRC'),(64,14,'Out All Rooms','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'7','7','7',0,1,1,'7',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'OutpatientCRC'),(65,14,'Out Double Room','',1,1,0,360,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:22'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:15'),'OutpatientCRC'),(66,14,'Out Male Room','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'2','2','2',1,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'OutpatientCRC'),(67,14,'Out Female Room','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'OutpatientCRC'),(68,14,'Out Fixed Alt Off','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:16'),'OutpatientCRC'),(69,14,'Out Flex Alt Off','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'5','5','5',0,1,1,'5',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'OutpatientCRC'),(70,14,'Out Float Alt Off','',1,1,0,60,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:23'),'6','6','6',1,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'OutpatientCRC'),(71,14,'Out Multi Fail','',1,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:17'),'OutpatientCRC'),(72,14,'Out All Fails','',1,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'1','1','1',0,1,1,'1',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'OutpatientCRC'),(73,14,'Out Iterative Fail','',1,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'OutpatientCRC'),(74,14,'Out Fifty Resources','',1,1,0,30,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'3','3','3',1,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:18'),'OutpatientCRC'),(75,12,'In Fixed','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:24'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'InpatientCRC'),(76,12,'In Fixed Time Gap','',1,1,0,2940,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'InpatientCRC'),(77,12,'In Fixed QTY Change','',1,1,0,3840,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'6','6','6',0,1,1,'6',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:19'),'InpatientCRC'),(78,12,'In Fixed Midnight Start','',1,1,0,2160,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'7','7','7',1,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'InpatientCRC'),(79,12,'In Fixed Midnight Overlap','',1,1,0,2160,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'InpatientCRC'),(80,12,'In Float Day Single','',1,1,0,1950,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'2','2','2',0,1,1,'2',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:20'),'InpatientCRC'),(81,12,'In Float Overnight Single','',1,1,0,2415,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:25'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'InpatientCRC'),(82,12,'In Float Midnight Overlap  Single','',1,1,0,2460,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'4','4','4',1,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'InpatientCRC'),(83,12,'In Float Day Linked','',1,1,0,1590,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:21'),'InpatientCRC'),(84,12,'In Float  Overnight Linked','',1,1,0,2190,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'InpatientCRC'),(85,12,'In Float Midnight Overlap  Linked','',1,1,0,2085,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'7','7','7',0,1,1,'7',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'InpatientCRC'),(86,12,'In Float QTY Change Single','',1,1,0,2400,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:26'),'1','1','1',1,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:22'),'InpatientCRC'),(87,12,'In Float QTY Change Linked','',1,1,0,2400,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'InpatientCRC'),(88,12,'In Flex Day Consec 2','',1,1,0,2280,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'3','3','3',0,1,1,'3',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'InpatientCRC'),(89,12,'In Flex Overnight Consec 2','',1,1,0,2160,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:23'),'InpatientCRC'),(90,12,'In Flex Midnight Overlap Consec 2','',1,1,0,2565,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'5','5','5',1,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'InpatientCRC'),(91,12,'In Flex Day Consec 3','',1,1,0,2220,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:27'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'InpatientCRC'),(92,12,'In Flex Overnight Consec 3','',1,1,0,2610,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:24'),'InpatientCRC'),(93,12,'In Flex Midnight Overlap Consec 3','',1,1,0,3060,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'1','1','1',0,1,1,'1',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'InpatientCRC'),(94,12,'In Flex Day Super A','',1,1,0,2115,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'2','2','2',1,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'InpatientCRC'),(95,12,'In Flex Overnight Super A','',1,1,0,2400,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:25'),'InpatientCRC'),(96,12,'In Flex Midnight Overlap Super A','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:28'),'4','4','4',0,1,1,'4',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'InpatientCRC'),(97,12,'In Flex Day Super B','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'InpatientCRC'),(98,12,'In Flex Overnight Super B','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'6','6','6',1,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'InpatientCRC'),(99,12,'In Flex Midnight Overlap Super B','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:26'),'InpatientCRC'),(100,12,'In Flex QTY Change Consec 2','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'InpatientCRC'),(101,12,'In Flex QTY Change Consec 3','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'2','2','2',0,1,1,'2',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'InpatientCRC'),(102,12,'In Flex QTY Change Super A','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:29'),'3','3','3',1,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:27'),'InpatientCRC'),(103,12,'In Flex QTY Change  Super B','',1,1,0,2160,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'InpatientCRC'),(104,14,'In Day Resource Blocker','',1,1,0,510,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'5','5','5',0,1,1,'5',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'InpatientCRC'),(105,14,'In 11:30 PM Resource Blocker','',1,1,0,2910,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:28'),'InpatientCRC'),(106,14,'In Midnight Overlap Resource Blocker','',1,1,0,2910,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'7','7','7',1,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'InpatientCRC'),(107,14,'In Fixed Alt Off','',1,1,0,2175,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:30'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'InpatientCRC'),(108,14,'In Flex Alt Off','',1,1,0,2385,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:29'),'InpatientCRC'),(109,14,'In Float Alt Off','',1,1,0,15,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'3','3','3',0,1,1,'3',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'InpatientCRC'),(110,14,'In Multi Fail','',1,1,0,1500,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'4','4','4',1,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'InpatientCRC'),(111,14,'In All Fails','',1,1,0,1500,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'InpatientCRC'),(112,14,'In Iterative Fail','',1,1,0,1500,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:31'),'6','6','6',0,1,1,'6',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:30'),'InpatientCRC'),(113,14,'In 30 Day','',1,1,0,1500,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'InpatientCRC'),(114,13,'In Fixed  RT','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'1','1','1',1,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'InpatientCRC'),(115,13,'In Fixed  RT Time Gap','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:31'),'InpatientCRC'),(116,13,'In Fixed RT QTY Change','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'InpatientCRC'),(117,13,'In Float RT Single','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:32'),'4','4','4',0,1,1,'4',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'InpatientCRC'),(118,13,'In Float RT Linked','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'5','5','5',1,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'InpatientCRC'),(119,13,'In Float  RT QTY Change Single','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'6','6','6',0,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:32'),'InpatientCRC'),(120,13,'In Float RT QTY Change Linked','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'7','7','7',0,1,1,'7',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'InpatientCRC'),(121,13,'In Flex  RT Consec 2','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'InpatientCRC'),(122,13,'In Flex RT Consec 3','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:33'),'2','2','2',1,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:33'),'InpatientCRC'),(123,13,'In Flex  RT Super A','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'InpatientCRC'),(124,13,'In Flex RT Overnight Super A','',1,1,1,NULL,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'InpatientCRC'),(125,13,'In Flex RT Super B','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'5','5','5',0,1,1,'5',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:34'),'InpatientCRC'),(126,13,'In Flex  RT QTY Change Consec 2','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'6','6','6',1,0,1,'6',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'InpatientCRC'),(127,13,'In Flex RT QTY Change Consec 3','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:34'),'7','7','7',0,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'InpatientCRC'),(128,13,'In Flex RT QTY Change Super A','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'1','1','1',0,1,1,'1',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:35'),'InpatientCRC'),(129,13,'In Flex RT QTY Change  Super B','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'2','2','2',0,0,1,'2',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'InpatientCRC'),(130,14,'In room blocker','',1,1,0,720,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'3','3','3',1,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'InpatientCRC'),(131,14,'In All Rooms','',1,1,0,720,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'4','4','4',0,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'InpatientCRC'),(132,14,'In Double Room','',1,1,0,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:35'),'5','5','5',0,0,1,'5',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:36'),'InpatientCRC'),(133,14,'In Male Room','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'6','6','6',0,1,1,'6',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'InpatientCRC'),(134,14,'In Female Room','',1,1,0,2340,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'7','7','7',1,0,1,'7',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'InpatientCRC'),(135,14,'In RT Multi Fail','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'1','1','1',0,0,1,'1',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:37'),'InpatientCRC'),(136,14,'In RT All Fails','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'2','2','2',0,1,1,'2',1,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'InpatientCRC'),(137,14,'In RT Iterative Fail','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'3','3','3',0,0,1,'3',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'InpatientCRC'),(138,14,'In RT 30 day','',1,1,1,1680,NULL,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:12:36'),'4','4','4',1,0,1,'4',0,TIMESTAMPADD(DAY,TIMESTAMPDIFF(DAY,'2015-10-26',now()),'2015-10-26 12:14:38'),'InpatientCRC');
/*!40000 ALTER TABLE `visit_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `visit_type`
--

DROP TABLE IF EXISTS `visit_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `visit_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `visit_type`
--

LOCK TABLES `visit_type` WRITE;
/*!40000 ALTER TABLE `visit_type` DISABLE KEYS */;
INSERT INTO `visit_type` VALUES (1,'Outpatient CRC'),(2,'Outpatient Non CRC'),(3,'Outpatient Off Institution'),(4,'Inpatient CRC'),(5,'Inpatient Non CRC'),(6,'Inpatient Off Institution');
/*!40000 ALTER TABLE `visit_type` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2015-10-27 10:29:06

set foreign_key_checks = 0;
truncate table subject;
set foreign_key_checks = 1;

