--
-- Copyright (c) 2015-2016, President and Fellows of Harvard College
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
-- 1. Redistributions of source code must retain the above copyright
-- notice, this list of conditions and the following disclaimer.
--
-- 2. Redistributions in binary form must reproduce the above copyright
-- notice, this list of conditions and the following disclaimer in the
-- documentation and/or other materials provided with the distribution.
--
-- 3. The name of the author may not be used to endorse or promote products
-- derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
-- MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
-- EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
-- SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
-- TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--

--
--

ALTER TABLE subject ADD latest_ssot_refresh datetime DEFAULT NULL;
ALTER TABLE subject ADD COLUMN puid VARCHAR(255) DEFAULT NULL;
ALTER TABLE subject DROP COLUMN subject_scheduler_id;
ALTER TABLE subject ADD COLUMN archival_status VARCHAR(255) DEFAULT NULL;
ALTER TABLE subject ADD COLUMN gender_enum VARCHAR(255) NOT NULL DEFAULT 'UNREPORTED';

ALTER TABLE booked_visit MODIFY study_subject int(11);

--
-- ethnicity mapping from EMPI to scheduler
--
DROP TABLE IF EXISTS `ethnicity_mapping`;
CREATE TABLE `ethnicity_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `external` varchar(255) NOT NULL,
  `scheduler` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_empi_scheduler_ethnicity_scheduler` (`scheduler`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- JIRA HCCRCSCHEDULING-4742
--
DELETE FROM template_user_selection WHERE tcf_id = (
  SELECT tcf.id
  FROM template_category_field tcf
    JOIN field f ON tcf.field_id = f.id
  WHERE f.table_name = 'subject' AND f.name = 'subject_scheduler_id'
);

DELETE FROM template_category_field WHERE field_id = (
  SELECT id from field where field.table_name = 'subject' AND field.name = 'subject_scheduler_id'
);

DELETE FROM field WHERE table_name = 'subject' AND name = 'subject_scheduler_id';

--
-- END OF HCCRCSCHEDULING-4742
--

DROP TABLE IF EXISTS `subject_mrn`;
CREATE TABLE `subject_mrn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` int(11) NOT NULL,
  `mrn` varchar(255) NOT NULL,
  `site` varchar(255) default NULL,
  `status` VARCHAR(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `FK_subject_mrn_site_id1` (`subject`,`mrn`, `site`),
  KEY `FK_subject_mrn_id2` (`subject`),
  CONSTRAINT `subject_mrn_0__subject` FOREIGN KEY (`subject`) REFERENCES `subject` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- hold appointments
insert into appointment_status values (5, "Hold");

insert into subject_mrn (subject, mrn) (select id, mrn from subject);

UPDATE subject SET gender_enum = (SELECT g.code FROM gender g WHERE g.id = subject.gender);

ALTER TABLE `study_subject` ADD subject_mrn INT(11) DEFAULT NULL;

-- study subject's subject replaced by subject's initial subject-mrn
UPDATE study_subject ss SET ss.subject_mrn =
(SELECT ssm.id FROM subject_mrn ssm where ssm.subject =
    (SELECT s.id FROM subject s where s.id = ss.subject) );

ALTER TABLE study_subject
  ADD CONSTRAINT study_subject_0__subject_mrn
FOREIGN KEY(subject_mrn)
REFERENCES subject_mrn(id);

ALTER TABLE `study_subject` DROP FOREIGN KEY `study_subject_0__subject`;

-- we need to execute the following but ONLY if the unique key exists: ALTER TABLE `study_subject` DROP index `FK_studySubj_id1`;
select * from information_schema.statistics where table_name = 'study_subject' and index_name = 'FK_studySubj_id1' and table_schema = database();
set @count := (select count(*) from information_schema.statistics where table_name = 'study_subject' and index_name = 'FK_studySubj_id1' and table_schema = database());
set @sqlstmt := if( @count > 0, 'ALTER TABLE `study_subject` DROP index `FK_studySubj_id1`;', 'select ''INFO: Index FK_studySubj_id1 does not exists; no need to remove it.''');
PREPARE stmt FROM @sqlstmt;
EXECUTE stmt;

ALTER TABLE `study_subject` DROP COLUMN subject;

-- now that subject_mrn foreign key is set; set the column to be NOT NULL:
ALTER TABLE `study_subject` MODIFY subject_mrn INT(11) NOT NULL;

-- this still breaks: ALTER TABLE `study_subject` ADD UNIQUE KEY `UK_study_subject_mrn_1` (`study`,`subject_mrn`);

ALTER TABLE `booked_visit` ADD subject_mrn int(11);

-- booked visit's study-subject replaced by subject-mrn

UPDATE booked_visit bv SET bv.subject_mrn =
(SELECT sm.id FROM subject_mrn sm, study_subject ss
WHERE ss.id = bv.study_subject and sm.id = ss.subject_mrn);

ALTER TABLE booked_visit
  ADD CONSTRAINT booked_visit_5__subject_mrn
FOREIGN KEY(subject_mrn)
REFERENCES subject_mrn(id);

ALTER TABLE `booked_visit` DROP FOREIGN KEY `booked_visit_5__study_subject`;

ALTER TABLE `booked_visit` DROP COLUMN `study_subject`;

ALTER TABLE `subject` DROP COLUMN `mrn`;

UPDATE field set table_name = 'booked_visit', name = 'subject_mrn', processing = 'MrnFromSubjectMrn' where name = 'mrn';

DROP TABLE IF EXISTS `nightly_batch_changes`;
CREATE TABLE `nightly_batch_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `changes` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

ALTER TABLE `subject` ADD COLUMN `gender_empi` VARCHAR(75) DEFAULT NULL after gender;


-- HCCRCSCHEDULING-5166 - Change case of UNREPORTED AND DECLINED gender values  --
UPDATE `gender` set name = 'Unreported' where name = 'UNREPORTED';
UPDATE `gender` set name = 'Declined' where name = 'DECLINED';

ALTER TABLE activity_log
ADD COLUMN affected_subject_mrn int(11) DEFAULT NULL;

ALTER TABLE activity_log
ADD CONSTRAINT activity_log_9__subject_mrn
FOREIGN KEY(affected_subject_mrn)
REFERENCES subject_mrn(id);
