--
-- Copyright (c) 2015-2016, President and Fellows of Harvard College
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
-- 1. Redistributions of source code must retain the above copyright
-- notice, this list of conditions and the following disclaimer.
--
-- 2. Redistributions in binary form must reproduce the above copyright
-- notice, this list of conditions and the following disclaimer in the
-- documentation and/or other materials provided with the distribution.
--
-- 3. The name of the author may not be used to endorse or promote products
-- derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
-- MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
-- EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
-- SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
-- TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--

ALTER TABLE resource MODIFY `shared_resource_notes` VARCHAR(255);

-- --------------------------------------------
-- HCCRCSCHEDULING-5983, HCCRCSCHEDULING-5984 (new booked-visit-activity-log)

-- in the booked_visit table, replace the scheduling_user_ecommons_id column (contains the username)
-- with a scheduling_user containing the scheduling user's id;
-- migrate the data

ALTER TABLE booked_visit ADD COLUMN `scheduling_user` int(11) DEFAULT NULL;
ALTER TABLE booked_visit ADD CONSTRAINT `FK_bv_scheduling_user` FOREIGN KEY (`scheduling_user`) REFERENCES `user` (`id`);
ALTER TABLE booked_visit ADD KEY `IDX_bv_scheduling_user` (`scheduling_user`);

-- migrate scheduling_user_ecommons_id (the user's eCommonsId, i.e. login name) to
-- an ID in the user table.
-- Note: this should later be overwritten (hopefully to the same ID) when we back-fill
-- booked_visit.scheduling_user from the activity log (see below). However I'm not 100%
-- certain that every booked_visit with a non-null scheduling_user_ecommons_id has a
-- corresponding entry in the activity log
update booked_visit bv
set scheduling_user =
(select u.id from user u where u.ecommons_id = bv.scheduling_user_ecommons_id)
where bv.scheduling_user_ecommons_id IS NOT NULL;

alter table booked_visit drop COLUMN `scheduling_user_ecommons_id`;

-- in the booked_visit table, add user id's for the check-in, check-out and cancel operations

ALTER TABLE booked_visit ADD COLUMN `check_in_user` int(11) DEFAULT NULL;
ALTER TABLE booked_visit ADD CONSTRAINT `FK_bv_check_in_user` FOREIGN KEY (`check_in_user`) REFERENCES `user` (`id`);
ALTER TABLE booked_visit ADD KEY `IDX_bv_check_in_user` (`check_in_user`);

ALTER TABLE booked_visit ADD COLUMN `check_out_user` int(11) DEFAULT NULL;
ALTER TABLE booked_visit ADD CONSTRAINT `FK_bv_check_out_user` FOREIGN KEY (`check_out_user`) REFERENCES `user` (`id`);
ALTER TABLE booked_visit ADD KEY `IDX_bv_check_out_user` (`check_out_user`);

ALTER TABLE booked_visit ADD COLUMN `cancel_user` int(11) DEFAULT NULL;
ALTER TABLE booked_visit ADD CONSTRAINT `FK_bv_cancel_user` FOREIGN KEY (`cancel_user`) REFERENCES `user` (`id`);
ALTER TABLE booked_visit ADD KEY `IDX_bv_cancel_user` (`cancel_user`);

-- create the activity log table specific to booked_visit,
-- and migrate the relevant data

DROP TABLE IF EXISTS `booked_visit_activity_log`;
CREATE TABLE `booked_visit_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_performed` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `performing_user` int(11) DEFAULT NULL,
  `booked_visit` int(11) DEFAULT NULL,
  `appointment_override_reason` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bva_log_performing_user` (`performing_user`),
  KEY `bva_log_appointment_override_reason` (`appointment_override_reason`),
  KEY `bva_log_booked_visit` (`booked_visit`),
  CONSTRAINT `bva_log_user` FOREIGN KEY (`performing_user`) REFERENCES `user` (`id`),
  CONSTRAINT `bva_log_booked_visit` FOREIGN KEY (`booked_visit`) REFERENCES `booked_visit` (`id`),
  CONSTRAINT `bva_log_appointment_override_reason` FOREIGN KEY (`appointment_override_reason`) REFERENCES `appointment_override_reason` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

-- In the 9 inserts below, we need to map the legacy action_performed value (all caps) to the
-- new camel-case values found in BookedVisitActivityLogStatics. e.g "RESCHEDULED APPOINTMENT"
-- maps to "Rescheduled"

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Batch Entry", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "BATCH ENTRY";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Cancelled", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "CANCELLED APPOINTMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Checked-In", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "CHECKED-IN APPOINTMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Checked-Out", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "CHECKED-OUT APPOINTMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Commented", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "CREATE BOOKED VISIT COMMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Overbooked", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "OVERBOOK";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Rescheduled", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "RESCHEDULED APPOINTMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Scheduled", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "SCHEDULED APPOINTMENT";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select "Viewed Appointment List Details", date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed = "Appointment List View Detail";

insert into booked_visit_activity_log
(action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason)
  select action_performed, date, ip_address, performing_user, booked_visit, appointment_override_reason
  from activity_log al
  where al.action_performed LIKE "Clicked on the % appointment and viewed the resources list.";

-- Back-fill the new activity fields in the booked_visit table:


update booked_visit bv
set
  scheduling_user =
  (SELECT bval.performing_user
   FROM booked_visit_activity_log bval
   WHERE
     bval.booked_visit = bv.id
     AND bval.action_performed IN ("Scheduled", "Overbooked", "Rescheduled")
   ORDER BY bval.date DESC LIMIT 1
  ),
  scheduling_time =
  (SELECT bval.date
   FROM booked_visit_activity_log bval
   WHERE
     bval.booked_visit = bv.id
     AND bval.action_performed IN ("Scheduled", "Overbooked", "Rescheduled")
   ORDER BY bval.date DESC LIMIT 1
  )
;


update booked_visit bv
set
  check_in_user =
  (SELECT bval.performing_user
   FROM booked_visit_activity_log bval
   WHERE
     bval.booked_visit = bv.id
     AND bval.action_performed = "Checked-In"
   ORDER BY bval.date DESC LIMIT 1
  )
;

update booked_visit bv
set
  check_out_user =
  (SELECT bval.performing_user
   FROM booked_visit_activity_log bval
   WHERE
     bval.booked_visit = bv.id
     AND bval.action_performed = "Checked-Out"
   ORDER BY bval.date DESC LIMIT 1
  )
;

update booked_visit bv
set
  cancel_user =
  (SELECT bval.performing_user
   FROM booked_visit_activity_log bval
   WHERE
     bval.booked_visit = bv.id
     AND bval.action_performed = "Cancelled"
   ORDER BY bval.date DESC LIMIT 1
  )
;

-- clean-up legacy activity log entries

delete FROM activity_log
  where action_performed = "BATCH ENTRY";

delete FROM activity_log
where action_performed = "CANCELLED APPOINTMENT";

delete FROM activity_log
  where action_performed = "CHECKED-IN APPOINTMENT";

delete FROM activity_log
  where action_performed = "CHECKED-OUT APPOINTMENT";

delete FROM activity_log
where action_performed = "CREATE BOOKED VISIT COMMENT";

delete FROM activity_log
  where action_performed = "OVERBOOK";

delete FROM activity_log
  where action_performed = "RESCHEDULED APPOINTMENT";

delete FROM activity_log
  where action_performed = "SCHEDULED APPOINTMENT";

delete FROM activity_log
where action_performed = "Appointment List View Detail";

delete FROM activity_log
  where action_performed LIKE "Clicked on the % appointment and viewed the resources list.";


/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;


-- end of HCCRCSCHEDULING-5983/5984 (new booked-visit-activity-log)
-- --------------------------------------------

