--
-- Copyright (c) 2015-2016, President and Fellows of Harvard College
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
-- 1. Redistributions of source code must retain the above copyright
-- notice, this list of conditions and the following disclaimer.
--
-- 2. Redistributions in binary form must reproduce the above copyright
-- notice, this list of conditions and the following disclaimer in the
-- documentation and/or other materials provided with the distribution.
--
-- 3. The name of the author may not be used to endorse or promote products
-- derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
-- MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
-- EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
-- SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
-- TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--

--
ALTER TABLE booked_visit ADD visit_type int(11) NOT NULL;
ALTER TABLE visit_template ADD visit_type int(11) NOT NULL;

update booked_visit set visit_type = 1 where type = "OutpatientCRC";
update booked_visit set visit_type = 2 where type = "OutpatientNonCRC";
update booked_visit set visit_type = 3 where type = "OutpatientOffInstitution";
update booked_visit set visit_type = 4 where type = "InpatientCRC";
update booked_visit set visit_type = 5 where type = "InpatientNonCRC";
update booked_visit set visit_type = 6 where type = "InpatientOffInstitution";

update visit_template set visit_type = 1 where type = "OutpatientCRC";
update visit_template set visit_type = 2 where type = "OutpatientNonCRC";
update visit_template set visit_type = 3 where type = "OutpatientOffInstitution";
update visit_template set visit_type = 4 where type = "InpatientCRC";
update visit_template set visit_type = 5 where type = "InpatientNonCRC";
update visit_template set visit_type = 6 where type = "InpatientOffInstitution";

ALTER TABLE booked_visit ADD CONSTRAINT booked_visit_fk_visit_type FOREIGN KEY (visit_type) REFERENCES visit_type(id);
ALTER TABLE visit_template ADD CONSTRAINT visit_template_fk_visit_type FOREIGN KEY (visit_type) REFERENCES visit_type(id);

ALTER TABLE visit_type ADD inpatient tinyint(1) NOT NULL;

update visit_type set inpatient = 1 where name like '%Inpatient%';

update field set processing = 'VisitType' where id in (109, 142);
update field set type = 'ShortSetStringDB' where id in (109, 142);
update field set name = 'visit_type' where id in (109, 142);

ALTER TABLE booked_visit DROP COLUMN type;
ALTER TABLE visit_template DROP COLUMN type;

-- HCCRCSCHEDULING-6308

-- start_minutes and end_minutes may be NULL (for a few records of old, bad data)
ALTER TABLE template_resource ADD COLUMN start_minutes INT;
ALTER TABLE template_resource ADD COLUMN end_minutes INT;

UPDATE template_resource set start_minutes =
(SELECT TIMESTAMPDIFF(MINUTE,'2012-02-01 00:00:00',start_date));
UPDATE template_resource set end_minutes =
(SELECT TIMESTAMPDIFF(MINUTE,'2012-02-01 00:00:00',end_date));

ALTER TABLE template_resource DROP COLUMN start_date;
ALTER TABLE template_resource DROP COLUMN end_date;

UPDATE field set name = 'start_minutes'
where table_name = 'template_resource' and name = 'start_date';
UPDATE field set name = 'end_minutes'
where table_name = 'template_resource' and name = 'end_date';

UPDATE field set type = 'Number'
where table_name = 'template_resource' and name = 'start_minutes';
UPDATE field set type = 'Number'
where table_name = 'template_resource' and name = 'end_minutes';

update field set table_name = 'user' where id = 132;
update field set name = 'ecommons_id' where id = 132;

