/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.Epic;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="QueryReply")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EmpiSubjectDto {
    private String logMessage;
    @XmlAttribute(name="Session")
    private int session;
    @XmlElement(name="Patients")
    private Patients patients;

    public EmpiSubjectDto() {
    }

    public Patients getPatients() {
        return this.patients;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public EmpiSubjectDto(List<Patient> patients) {
        this.patients = new Patients(patients);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public static EmpiSubjectDto unmarshall(String xmlInput) {
        EmpiSubjectDto empiSubjectDto = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EmpiSubjectDto.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ByteArrayInputStream stringAsStream = new ByteArrayInputStream(xmlInput.getBytes(StandardCharsets.UTF_8));
            empiSubjectDto = (EmpiSubjectDto)jaxbUnmarshaller.unmarshal((InputStream)stringAsStream);
        }
        catch (JAXBException e) {
            SchedulerRuntimeException.logAndThrow("Cannot unmarshall the string: " + xmlInput, (Exception)((Object)e));
        }
        return empiSubjectDto;
    }

    public String marshall() {
        String result = null;
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EmpiSubjectDto.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this, (Writer)stringWriter);
            result = stringWriter.toString();
        }
        catch (JAXBException e) {
            SchedulerRuntimeException.logAndThrow("Cannot marshall the EmpiSubjectDto", (Exception)((Object)e));
        }
        return result;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DupMrn {
        @XmlAttribute(name="Site")
        private String site;
        @XmlAttribute(name="Value")
        private String value;

        public DupMrn() {
        }

        public DupMrn(String site, String value) {
            this.site = site;
            this.value = value;
        }

        public String getSite() {
            return this.site;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DupMrns {
        @XmlElement(name="DupeMRN")
        private List<DupMrn> dupMrnList;

        public DupMrns() {
        }

        public DupMrns(List<DupMrn> dupMrnList) {
            this.dupMrnList = dupMrnList;
        }

        public List<DupMrn> getDupMrnList() {
            return this.dupMrnList;
        }

        public String toCommaList() {
            String result = Joiner.on((String)",").join((Iterable)this.dupMrnList.stream().map(m -> m.getValue() + ":" + m.getSite()).collect(Collectors.toList()));
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class OtherPid {
        @XmlAttribute(name="Religion")
        private String religion;
        @XmlAttribute(name="Language")
        private String language;
        @XmlAttribute(name="Marital")
        private String marital;
        @XmlAttribute(name="Vet")
        private String vet;
        @XmlAttribute(name="Race")
        private String race;
        @XmlAttribute(name="Mmaiden")
        private String nMaiden;
        @XmlAttribute(name="Race2")
        private String race2;
        @XmlAttribute(name="RaceText")
        private String raceText;

        public OtherPid() {
        }

        public OtherPid(String religion, String marital, String language, String vet, String race, String nMaiden, String race2, String raceText) {
            this.religion = religion;
            this.marital = marital;
            this.language = language;
            this.vet = vet;
            this.race = race;
            this.nMaiden = nMaiden;
            this.race2 = race2;
            this.raceText = raceText;
        }

        public String getReligion() {
            return this.religion;
        }

        public String getMarital() {
            return this.marital;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getVet() {
            return this.vet;
        }

        public String getRace() {
            return this.race;
        }

        public String getnMaiden() {
            return this.nMaiden;
        }

        public String getRace2() {
            return this.race2;
        }

        public String getRaceText() {
            return this.raceText;
        }

        public void setRace(String race) {
            this.race = race;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LastFiled {
        @XmlAttribute(name="Date")
        private String dateAsString;
        @XmlAttribute(name="Site")
        private String site;

        public LastFiled() {
        }

        public LastFiled(String dateAsString, String site) {
            this.dateAsString = dateAsString;
            this.site = site;
        }

        public String getDateAsString() {
            return this.dateAsString;
        }

        public String getSite() {
            return this.site;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Aliases {
        @XmlElement(name="Name")
        private List<Name> nameList;

        public Aliases() {
            this.nameList = Lists.newArrayList();
        }

        public Aliases(List<Name> nameList) {
            this.nameList = nameList;
        }

        public List<Name> getNameList() {
            return this.nameList;
        }

        public void setNameList(List<Name> nameList) {
            this.nameList = nameList;
        }

        public String toCommaList() {
            String result = Joiner.on((String)",").join((Iterable)this.nameList.stream().map(m -> m.getLast() + ":" + m.getFirst() + ":" + m.getMiddleInitial()).collect(Collectors.toList()));
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Phone {
        @XmlAttribute(name="Type")
        private String type;
        @XmlAttribute(name="Number")
        private String number;

        public Phone() {
        }

        public Phone(String type, String number) {
            this.type = type;
            this.number = number;
        }

        public String getType() {
            return this.type;
        }

        public String getNumber() {
            return this.number;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Phones {
        @XmlElement(name="Phone")
        private List<Phone> phoneList;

        public Phones() {
        }

        public Phones(List<Phone> phoneList) {
            this.phoneList = phoneList;
        }

        public List<Phone> getPhoneList() {
            return this.phoneList;
        }

        public void setPhoneList(List<Phone> phoneList) {
            this.phoneList = phoneList;
        }

        public String toCommaList() {
            String result = Joiner.on((String)",").join((Iterable)this.phoneList.stream().map(m -> m.getType() + ":" + m.getNumber()).collect(Collectors.toList()));
            return result;
        }

        public String getByPosition(int position) {
            Phone resultPhone = this.phoneList == null || this.phoneList.size() < position + 1 ? null : this.phoneList.get(position);
            String result = resultPhone == null ? null : resultPhone.getNumber();
            return result;
        }

        public String getPrimary() {
            return this.getByPosition(0);
        }

        public String getSecondary() {
            return this.getByPosition(1);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Address {
        @XmlAttribute(name="Line1")
        private String line1;
        @XmlAttribute(name="Line2")
        private String line2;
        @XmlAttribute(name="City")
        private String city;
        @XmlAttribute(name="State")
        private String state;
        @XmlAttribute(name="Zip")
        private String zipAsString;
        @XmlAttribute(name="Country")
        private String country;

        public Address() {
        }

        public Address(String line1, String line2, String city, String state, String zipAsString, String country) {
            this.line1 = line1;
            this.line2 = line2;
            this.city = city;
            this.state = state;
            this.zipAsString = zipAsString;
            this.country = country;
        }

        public String getLine1() {
            return this.line1;
        }

        public String getLine2() {
            return this.line2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getZipAsString() {
            return this.zipAsString;
        }

        public String getCountry() {
            return this.country;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Name {
        @XmlAttribute(name="Last")
        private String last;
        @XmlAttribute(name="First")
        private String first;
        @XmlAttribute(name="MI")
        private String middleInitial;
        @XmlAttribute(name="Suffix")
        private String suffix;
        @XmlAttribute(name="Prefix")
        private String prefix;

        public Name() {
        }

        public Name(String last, String first, String middleInitial) {
            this.last = last;
            this.first = first;
            this.middleInitial = middleInitial;
        }

        public String getLast() {
            return this.last;
        }

        public String getFirst() {
            return this.first;
        }

        public String getMiddleInitial() {
            return this.middleInitial;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toCommentString() {
            return this.last + ", " + this.first + ", " + this.middleInitial;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Ethnicity {
        @XmlAttribute(name="Ethnic1")
        private String ethnic1;
        @XmlAttribute(name="Ethnic2")
        private String ethnic2;
        @XmlAttribute(name="EthnicText")
        private String ethnicText;

        public Ethnicity() {
        }

        public Ethnicity(String ethnic1, String ethnic2, String ethnicText) {
            this.ethnic1 = ethnic1;
            this.ethnic2 = ethnic2;
            this.ethnicText = ethnicText;
        }

        public String getEthnic1() {
            return this.ethnic1;
        }

        public String getEthnic2() {
            return this.ethnic2;
        }

        public String getEthnicText() {
            return this.ethnicText;
        }

        public void setEthnic1(String ethnic1) {
            this.ethnic1 = ethnic1;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Mrn {
        @XmlAttribute(name="Site")
        private String site;
        @XmlAttribute(name="Value")
        private String value;
        @XmlAttribute(name="Status")
        private String status;

        public Mrn() {
        }

        public Mrn(String site, String value, String status) {
            this.site = site;
            this.value = value;
            this.status = status;
        }

        public String getSite() {
            return this.site;
        }

        public String getStatus() {
            return this.status;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Site: " + this.site + ", Value: " + this.value + ", Status: " + this.status;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Mrns {
        @XmlElement(name="MRN")
        private List<Mrn> mrnList = Lists.newArrayList();

        public List<Mrn> getMrnList() {
            return this.mrnList;
        }

        public void setMrnList(List<Mrn> mrnList) {
            this.mrnList = mrnList;
        }

        public String toCommaList() {
            String result = Joiner.on((String)",").join((Iterable)this.mrnList.stream().map(m -> m.getValue() + ":" + m.getSite() + ":" + m.getStatus()).collect(Collectors.toList()));
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SCFlag {
        @XmlAttribute(name="Code")
        private String code;
        @XmlAttribute(name="Status")
        private String status;

        public SCFlag() {
        }

        public SCFlag(String code, String status) {
            this.code = code;
            this.status = status;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class SCFlags {
        @XmlElement(name="SCFlag")
        private List<SCFlag> scFlagList = Lists.newArrayList();

        public List<SCFlag> getScFlagList() {
            return this.scFlagList;
        }

        public void setScFlagList(List<SCFlag> scFlagList) {
            this.scFlagList = scFlagList;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Patient {
        @XmlAttribute(name="UID")
        private int uid;
        @XmlAttribute(name="Status")
        private String status;
        @XmlAttribute(name="Gender")
        private String gender;
        @XmlAttribute(name="DOB")
        private String dobString;
        @XmlAttribute(name="SSN")
        private String ssn;
        @XmlAttribute(name="VIP")
        private String vip;
        @XmlAttribute(name="TestFlag")
        private String testFlag;
        @XmlElement(name="MRNs")
        private Mrns mrns;
        @XmlElement(name="Name")
        private Name name;
        @XmlElement(name="Address")
        private Address address;
        @XmlElement(name="Phones")
        private Phones phones;
        @XmlElement(name="Aliases")
        private Aliases aliases;
        @XmlElement(name="LastFiled")
        private LastFiled lastFiled;
        @XmlElement(name="OtherPID")
        private OtherPid otherPid;
        @XmlElement(name="SCFlags")
        private SCFlags scFlags;
        @XmlElement(name="Ethnicity")
        private Ethnicity ethnicity;
        @XmlElement(name="DupeMRNs")
        private DupMrns dupMrns;

        public int getUid() {
            return this.uid;
        }

        public String getStatus() {
            return this.status;
        }

        public String getGender() {
            return this.gender;
        }

        public String getDobString() {
            return this.dobString;
        }

        public Mrns getMrns() {
            return this.mrns;
        }

        public Name getName() {
            return this.name;
        }

        public Ethnicity getEthnicity() {
            return this.ethnicity;
        }

        public Address getAddress() {
            return this.address;
        }

        public Phones getPhones() {
            return this.phones;
        }

        public Aliases getAliases() {
            return this.aliases;
        }

        public LastFiled getLastFiled() {
            return this.lastFiled;
        }

        public OtherPid getOtherPid() {
            return this.otherPid;
        }

        public DupMrns getDupMrns() {
            return this.dupMrns;
        }

        public void setUid(int uid) {
            this.uid = uid;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setGender(String gender) {
            this.gender = gender;
        }

        public void setDobString(String dobString) {
            this.dobString = dobString;
        }

        public void setMrns(Mrns mrns) {
            this.mrns = mrns;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public void setPhones(Phones phones) {
            this.phones = phones;
        }

        public void setAliases(Aliases aliases) {
            this.aliases = aliases;
        }

        public void setLastFiled(LastFiled lastFiled) {
            this.lastFiled = lastFiled;
        }

        public void setOtherPid(OtherPid otherPid) {
            this.otherPid = otherPid;
        }

        public void setEthnicity(Ethnicity ethnicity) {
            this.ethnicity = ethnicity;
        }

        public void setDupMrns(DupMrns dupMrns) {
            this.dupMrns = dupMrns;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Patients {
        @XmlElement(name="Patient")
        private List<Patient> patientList = new ArrayList<Patient>();

        public Patients() {
        }

        public List<Patient> getPatientList() {
            return this.patientList;
        }

        public Patients(List<Patient> patientList) {
            this.patientList = patientList;
        }
    }
}

