/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.FundingSourceInfo;
import edu.harvard.catalyst.scheduler.entity.IRBInstitution;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudyFundingSource;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class StudyDataReportResponseDTO {
    private String catalystId;
    private String localId;
    private String name;
    private DtoInstitution institution;
    private DtoStudyStatus studyStatus;
    private Date expectedStartDate;
    private Date expectedEndDate;
    private Date statusChange;
    private Date firstVisitDate;
    private Date lastScheduledVisitDate;
    private String irb;
    private Date irbExpiration;
    private Date irbRenewalDate;
    private Date irbApprovalDate;
    private Integer totalSubjects;
    private Integer totalOutpatientVisits;
    private Integer totalInpatientVisits;
    private Boolean industryInitiated;
    private User4 investigator;
    private User4 physician;
    private User4 physician2;
    private User3 scheduler;
    private User3 secondaryScheduler;
    private User3 scheduler3;
    private User1 protocolNurse;
    private User1 associateNurse;
    private User1 protocolNutritionist;
    private User1 associateProtocolNutritionist;
    private Boolean crcFunded;
    private String crcCategory;
    private DtoIrbInstitution irbInstitution;
    private List<FundingSourceInfo> fundingSourceInfoList = new ArrayList<FundingSourceInfo>();

    public StudyDataReportResponseDTO(Study study, Set<StudyFundingSource> sfsSet) {
        if (study == null) {
            SchedulerRuntimeException.logAndThrow("Study parameter should be non-null");
        }
        this.catalystId = study.getCatalystId();
        this.localId = study.getLocalId();
        this.irb = study.getIrb();
        this.irbExpiration = study.getIrbExpiration();
        this.irbRenewalDate = study.getIrbRenewalDate();
        this.irbApprovalDate = study.getIrbApprovalDate();
        this.statusChange = study.getStatusChange();
        this.firstVisitDate = study.getFirstVisitDate();
        this.lastScheduledVisitDate = study.getLastScheduledVisitDate();
        this.name = study.getName();
        this.industryInitiated = study.getIndustryInitiated();
        this.totalSubjects = study.getTotalSubjects();
        this.totalOutpatientVisits = study.getTotalOutpatientVisits();
        for (StudyFundingSource sfs : sfsSet) {
            FundingSourceInfo fsi = new FundingSourceInfo(sfs);
            this.fundingSourceInfoList.add(fsi);
        }
        this.studyStatus = new DtoStudyStatus(study.getStudyStatus());
        this.institution = new DtoInstitution(study.getInstitution());
        this.irbInstitution = new DtoIrbInstitution(study.getIrbInstitution());
        this.investigator = new User4(study.getInvestigator());
        this.physician = new User4(study.getPhysician());
        this.physician2 = new User4(study.getPhysician2());
        this.scheduler = new User3(study.getScheduler());
        this.secondaryScheduler = new User3(study.getSecondaryScheduler());
        this.scheduler3 = new User3(study.getScheduler3());
        this.protocolNurse = new User1(study.getProtocolNurse());
        this.associateNurse = new User1(study.getAssociateNurse());
        this.protocolNutritionist = new User1(study.getProtocolNutritionist());
        this.associateProtocolNutritionist = new User1(study.getAssociateProtocolNutritionist());
        this.expectedStartDate = study.getExpectedStartDate();
        this.expectedEndDate = study.getExpectedEndDate();
        this.totalInpatientVisits = study.getTotalInpatientVisits();
        this.crcCategory = study.getCrcCategory();
        this.crcFunded = study.getCrcFunded();
    }

    class User1 {
        String firstName = "";
        String middleName = "";
        String lastName = "";

        User1(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
        }
    }

    class User3 {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        String email = "";
        String primaryPhone = "";

        User3(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
            this.email = user.getEmail();
            this.primaryPhone = user.getPrimaryPhone();
        }
    }

    class User4 {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        String email = "";
        String primaryPhone = "";
        String pager = "";

        User4(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
            this.email = user.getEmail();
            this.primaryPhone = user.getPrimaryPhone();
            this.pager = user.getPager();
        }
    }

    class DtoIrbInstitution {
        String name = "";

        DtoIrbInstitution(IRBInstitution irbInstitution1) {
            if (irbInstitution1 == null) {
                return;
            }
            this.name = irbInstitution1.getName();
        }
    }

    class DtoInstitution {
        String longName = "";

        DtoInstitution(Institution institution1) {
            if (institution1 == null) {
                return;
            }
            this.longName = institution1.getLongName();
        }
    }

    class DtoStudyStatus {
        String shortName = "";

        DtoStudyStatus(StudyStatus studyStatus1) {
            if (studyStatus1 == null) {
                return;
            }
            this.shortName = studyStatus1.getShortName();
        }
    }
}

