/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Edge;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Field;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.FieldProcessingEnum;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategoryField;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Graph {
    private Set<Vertex> vertices;
    private Set<Edge> edges;
    private Vertex rootVertex;
    private Map<String, Vertex> shortNameToVertex;
    private Map<Set<Vertex>, Edge> verticesToEdge;
    private int counter = 0;
    static final String ALIEN_VERTEX = "Alien Vertex(es)!";

    public Graph() {
    }

    public Graph(Set<Edge> edges, Vertex rootVertex, boolean renumber) {
        this.init(edges, rootVertex, renumber);
    }

    private Graph(Set<Edge> edges, Vertex rootVertex) {
        this.init(edges, rootVertex, false);
    }

    protected void init(Set<Edge> totalEdges, Vertex rootVertex, boolean renumber) {
        this.edges = totalEdges;
        this.rootVertex = rootVertex;
        this.vertices = this.initVerticesFromEdges();
        this.verticesToEdge = this.initVerticesToEdgeMap();
        this.shortNameToVertex = this.initShortNameToVertexMap();
        if (renumber) {
            this.numberTheVertices(rootVertex, new HashSet<Vertex>());
        }
        if (!this.isConnected()) {
            SchedulerRuntimeException.logAndThrow("Graph is not connected.");
        }
    }

    void numberTheVertices(Vertex startingPoint, Set<Vertex> alreadyDone) {
        if (!alreadyDone.contains(startingPoint)) {
            startingPoint.setPriority(this.counter++);
            alreadyDone.add(startingPoint);
            for (Edge outEdge : this.outEdges(startingPoint)) {
                Vertex nextVertex = outEdge.getPointTwo();
                this.numberTheVertices(nextVertex, alreadyDone);
            }
        }
    }

    Map<Set<Vertex>, Edge> initVerticesToEdgeMap() {
        HashMap<Set<Vertex>, Edge> result = new HashMap<Set<Vertex>, Edge>();
        for (Edge edge : this.edges) {
            HashSet endpoints = Sets.newHashSet((Object[])new Vertex[]{edge.getPointOne(), edge.getPointTwo()});
            result.put(endpoints, edge);
        }
        return result;
    }

    Set<Vertex> initVerticesFromEdges() {
        HashSet<Vertex> result = new HashSet<Vertex>();
        for (Edge edge : this.edges) {
            Vertex one = edge.getPointOne();
            Vertex two = edge.getPointTwo();
            result.add(one);
            result.add(two);
        }
        if (this.edges.size() == 0) {
            result.add(this.rootVertex);
        }
        return result;
    }

    Map<String, Vertex> initShortNameToVertexMap() {
        HashMap<String, Vertex> result = new HashMap<String, Vertex>();
        for (Vertex vertex : this.vertices) {
            String shortName = vertex.getTableShortName();
            result.put(shortName, vertex);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Graph:").append("\n");
        ArrayList<String> edgeStringList = new ArrayList<String>();
        for (Edge edge : this.edges) {
            edgeStringList.add(edge.toString());
        }
        String edgeString = Joiner.on((String)"\n").join(edgeStringList);
        builder.append(edgeString);
        if (this.vertices.size() == 1) {
            for (Vertex theOneVertex : this.vertices) {
                builder.append(theOneVertex.toString());
            }
        }
        return builder.toString();
    }

    public Set<Vertex> getVertices() {
        return this.vertices;
    }

    Set<Edge> getEdgesFromVertices(Set<Vertex> vertices) {
        HashSet<Edge> result = new HashSet<Edge>();
        for (Vertex pointOne : vertices) {
            HashSet<Vertex> others = new HashSet<Vertex>(vertices);
            others.remove(pointOne);
            for (Vertex otherPoint : others) {
                HashSet twoPoints = Sets.newHashSet((Object[])new Vertex[]{pointOne, otherPoint});
                Edge edge = this.verticesToEdge.get(twoPoints);
                if (edge == null) continue;
                result.add(edge);
            }
        }
        return result;
    }

    boolean isConnected() {
        return this.isConnected(this.vertices);
    }

    boolean isConnected(Set<Vertex> candidateVertices) {
        HashSet<Vertex> aliens = new HashSet<Vertex>(candidateVertices);
        aliens.removeAll(this.vertices);
        if (aliens.size() > 0) {
            SchedulerRuntimeException.logAndThrow(ALIEN_VERTEX);
        }
        if (candidateVertices.size() == 0) {
            return false;
        }
        Vertex startingPoint = Collections.min(candidateVertices, new Vertex.VertexComparator());
        HashSet<Vertex> accountedFor = new HashSet<Vertex>();
        this.checkConnection(candidateVertices, accountedFor, startingPoint);
        return candidateVertices.equals(accountedFor);
    }

    void checkConnection(Set<Vertex> candidateVertices, Set<Vertex> accountedFor, Vertex startingPoint) {
        if (!this.vertices.contains(startingPoint)) {
            SchedulerRuntimeException.logAndThrow(ALIEN_VERTEX);
        }
        if (candidateVertices.size() == 0) {
            return;
        }
        accountedFor.add(startingPoint);
        Set<Edge> outEdges = this.outEdges(startingPoint);
        for (Edge edge : outEdges) {
            Vertex pointTwo = edge.getPointTwo();
            if (!candidateVertices.contains(pointTwo)) continue;
            HashSet<Vertex> smallerCandidates = new HashSet<Vertex>(candidateVertices);
            smallerCandidates.remove(startingPoint);
            this.checkConnection(smallerCandidates, accountedFor, pointTwo);
        }
    }

    public Graph getSmallConnectedSubgraph(Set<Vertex> requiredSubset) {
        HashSet<Vertex> puSet = new HashSet<Vertex>(this.vertices);
        ArrayList<Vertex> verticesAsList = new ArrayList<Vertex>(this.vertices);
        Collections.sort(verticesAsList, new Vertex.VertexComparator());
        Collections.reverse(verticesAsList);
        for (int i = 0; i < verticesAsList.size(); ++i) {
            Vertex currentVertex = (Vertex)verticesAsList.get(i);
            HashSet<Vertex> chippedPuSet = new HashSet<Vertex>(puSet);
            chippedPuSet.remove(currentVertex);
            if (!this.isConnected(chippedPuSet) || !chippedPuSet.containsAll(requiredSubset)) continue;
            puSet = chippedPuSet;
        }
        Set<Edge> edges = this.getEdgesFromVertices(puSet);
        Vertex startingPoint = Collections.min(puSet, new Vertex.VertexComparator());
        Graph result = puSet.size() == 1 ? new Graph(new HashSet<Edge>(), startingPoint) : new Graph(edges, startingPoint);
        return result;
    }

    Set<Edge> outEdges(Vertex vertex) {
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (Edge edge : this.edges) {
            Vertex vertexOne = edge.getPointOne();
            if (!vertexOne.equals(vertex)) continue;
            result.add(edge);
        }
        return result;
    }

    public QueryScalarsTcfs createQueryScalarsTcfs(List<TemplateCategoryField> tcfList, Map<Integer, String> tcfIdToStringSortList, Map<Integer, String> tcfIdToStringFilterList, List<TemplateCategoryField> tcfsWithFilters, List<TemplateCategoryField> tcfsWithSorts, List<Integer> tcfIdsForSortPriority) {
        QueryScalarsTcfs qsfResult = new QueryScalarsTcfs();
        qsfResult.setTcfs(tcfList);
        if (tcfList.size() > 0) {
            List<String> qsfScalars = qsfResult.getScalars();
            ArrayList selectColumns = Lists.newArrayList();
            ArrayList whereClauseList = Lists.newArrayList();
            ArrayList orderClauseList = Lists.newArrayList();
            HashSet<Vertex> vertexSet = new HashSet<Vertex>();
            List<Object> fromTables = Lists.newArrayList();
            vertexSet.add(this.rootVertex);
            fromTables.add(this.rootVertex.fullName());
            HashMap tcfIdToSortPhrase = Maps.newHashMap();
            for (TemplateCategoryField tcf : tcfList) {
                this.processOneTcf(qsfScalars, selectColumns, fromTables, whereClauseList, vertexSet, tcf, tcfIdToStringSortList, tcfIdToStringFilterList, tcfsWithFilters, tcfsWithSorts, tcfIdToSortPhrase);
            }
            for (Integer tcfId : tcfIdsForSortPriority) {
                orderClauseList.add(tcfIdToSortPhrase.get(tcfId));
            }
            Graph subGraph = this.getSmallConnectedSubgraph(vertexSet);
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("SELECT ").append(Joiner.on((String)",").join((Iterable)selectColumns)).append(" FROM ");
            StringBuilder joinBuilder = new StringBuilder();
            this.traverseEdgesForJoin(subGraph, this.rootVertex, whereClauseList, false, null, joinBuilder, fromTables);
            fromTables = this.postProcessFromTablesForSorts(fromTables, tcfsWithSorts);
            queryBuilder.append(Joiner.on((String)" inner join ").join((Iterable)fromTables));
            String joinResult = this.postProcessQueryForSorts(joinBuilder, tcfsWithSorts);
            queryBuilder.append(joinResult);
            if (whereClauseList.size() > 0) {
                queryBuilder.append(" WHERE ").append(Joiner.on((String)" AND ").join((Iterable)whereClauseList));
            }
            String qsfQuery = queryBuilder.toString();
            qsfResult.setQueryString(qsfQuery);
            if (!orderClauseList.isEmpty()) {
                StringBuilder orderBuilder = new StringBuilder();
                orderBuilder.append(" ORDER BY ").append(Joiner.on((String)",").join((Iterable)orderClauseList));
                qsfResult.setOrderString(orderBuilder.toString());
            }
        }
        return qsfResult;
    }

    List<String> postProcessFromTablesForSorts(List<String> fromTables, List<TemplateCategoryField> tcfsWithSorts) {
        for (TemplateCategoryField tcf : tcfsWithSorts) {
            FieldProcessingEnum fieldProcessingEnum = tcf.getField().getFieldProcessingEnum();
            fromTables = fieldProcessingEnum.postProcessFromTablesForSort(fromTables, tcf);
        }
        return fromTables;
    }

    String postProcessQueryForSorts(StringBuilder joinBuilder, List<TemplateCategoryField> tcfsWithSorts) {
        String result = joinBuilder.toString();
        for (TemplateCategoryField tcf : tcfsWithSorts) {
            FieldProcessingEnum fieldProcessingEnum = tcf.getField().getFieldProcessingEnum();
            result = fieldProcessingEnum.postProcessQueryForSort(result, tcf);
        }
        return result;
    }

    void processOneTcf(List<String> qsfScalars, List<String> selectColumns, List<String> fromTables, List<String> whereClauses, Set<Vertex> vertexSet, TemplateCategoryField tcf, Map<Integer, String> tcfIdToStringSortList, Map<Integer, String> tcfIdToStringFilterList, List<TemplateCategoryField> tcfsWithFilters, List<TemplateCategoryField> tcfsWithSorts, Map<Integer, String> tcfIdToSortPhrase) {
        String suffix = tcf.getSuffix();
        Field field = tcf.getField();
        String table = field.getTable();
        String shortName = Field.getTableAlias(table) + suffix;
        Vertex vertex = this.shortNameToVertex.get(shortName);
        if (vertex == null) {
            SchedulerRuntimeException.logAndThrow("No Vertex for <" + shortName + ">");
        }
        vertexSet.add(vertex);
        this.addScalarsAndSelectColumns(tcf, qsfScalars, selectColumns, fromTables, whereClauses, field.getColumn(), shortName, tcfIdToStringSortList, tcfIdToStringFilterList, tcfsWithFilters, tcfsWithSorts, tcfIdToSortPhrase);
    }

    void traverseEdgesForJoin(Graph subGraph, Vertex currentVertex, List<String> whereClauseList, boolean previousLeftJoin, Vertex previousRhs, StringBuilder builder, List<String> fromTables) {
        for (Edge edge : subGraph.outEdges(currentVertex)) {
            boolean leftJoin = edge.getJoinType().equals((Object)Edge.JoinType.LEFT);
            Vertex rhs = edge.getPointTwo();
            edge.produceJoinLists(whereClauseList, previousLeftJoin, previousRhs, builder, fromTables);
            this.traverseEdgesForJoin(subGraph, rhs, whereClauseList, leftJoin, rhs, builder, fromTables);
        }
    }

    public void addScalarsAndSelectColumns(TemplateCategoryField tcf, List<String> qsfScalars, List<String> selectColumns, List<String> fromTables, List<String> whereClauses, String columnsString, String shortName, Map<Integer, String> tcfIdToStringSortList, Map<Integer, String> tcfIdToStringFilterList, List<TemplateCategoryField> tcfsWithFilters, List<TemplateCategoryField> tcfsWithSorts, Map<Integer, String> tcfIdToSortPhrase) {
        ArrayList columns = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)columnsString));
        for (String column : columns) {
            String officialColumn = shortName + "." + column;
            String scalarColumn = column + "_" + shortName;
            qsfScalars.add(scalarColumn);
            StringBuilder builder = new StringBuilder();
            builder.append(officialColumn).append(" ").append(scalarColumn);
            String selectColumn = builder.toString();
            selectColumns.add(selectColumn);
            if (tcfsWithSorts.contains(tcf)) {
                FieldProcessingEnum processingEnum = tcf.getField().getFieldProcessingEnum();
                processingEnum.sortFromTableAddition(column, fromTables);
                processingEnum.sortWhereClauseAddition(column, officialColumn, whereClauses);
                String orderBy = tcfIdToStringSortList.get(tcf.getId());
                String orderString = processingEnum.sortOrderByPhrase(scalarColumn, column, orderBy);
                tcfIdToSortPhrase.put(tcf.getId(), orderString);
            }
            if (!tcfsWithFilters.contains(tcf)) continue;
            String commaJoinedString = tcfIdToStringFilterList.get(tcf.getId());
            Field tcfField = tcf.getField();
            Field.FieldType fieldType = tcfField.getFieldType();
            if (fieldType == null) {
                SchedulerRuntimeException.logAndThrow("Hey, field " + tcfField.getDisplayName() + " doesn't have a filter!");
            }
            String whereClause = tcfField.commaJoinedStringToSqlString(officialColumn, commaJoinedString);
            whereClauses.add(whereClause);
        }
    }

    public static class QueryScalarsTcfs {
        String queryString = "";
        String orderString = "";
        List<String> scalars = new ArrayList<String>();
        List<TemplateCategoryField> tcfs = new ArrayList<TemplateCategoryField>();

        public void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getOrderString() {
            return this.orderString;
        }

        public void setOrderString(String orderString) {
            this.orderString = orderString;
        }

        public List<String> getScalars() {
            return this.scalars;
        }

        public List<TemplateCategoryField> getTcfs() {
            return this.tcfs;
        }

        public void setTcfs(List<TemplateCategoryField> tcfs) {
            this.tcfs = tcfs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryScalarsTcfs that = (QueryScalarsTcfs)o;
            return this.queryString.equals(that.queryString);
        }

        public int hashCode() {
            return this.queryString.hashCode();
        }
    }
}

