/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.util.Base64;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class SubjectDataEncryptor {
    private Key encryptionKey;
    static final String ALGORITHM = "AES";

    public static void setEncryptionKey(Key encryptionKey) {
        SubjectDataEncryptor.getInstance().encryptionKey = encryptionKey;
    }

    private static SubjectDataEncryptor getInstance() {
        return Holder.instance;
    }

    private SubjectDataEncryptor() {
    }

    public static String encrypt(String valueToEnc) {
        String encryptedValue = null;
        String complaint = "Couldn't encrypt '" + valueToEnc + "'";
        try {
            if (valueToEnc == null) {
                return "";
            }
            SubjectDataEncryptor.getInstance();
            Key key = SubjectDataEncryptor.getKey();
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, key);
            byte[] encValue = c.doFinal(valueToEnc.getBytes());
            encryptedValue = Base64.base64Encode(encValue);
        }
        catch (NoSuchPaddingException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (NoSuchAlgorithmException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (InvalidKeyException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (BadPaddingException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (IllegalBlockSizeException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        return encryptedValue;
    }

    public static String decrypt(String encryptedValue) {
        return SubjectDataEncryptor.decrypt(encryptedValue, SubjectDataEncryptor.getKey());
    }

    public static String decrypt(String encryptedValue, Key key) {
        String decryptedValue = null;
        String complaint = "Couldn't decrypt '" + encryptedValue + "'";
        try {
            if (encryptedValue == null) {
                return null;
            }
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, key);
            byte[] decordedValue = Base64.base64Decode(encryptedValue);
            byte[] decValue = c.doFinal(decordedValue);
            decryptedValue = new String(decValue);
        }
        catch (NoSuchPaddingException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (NoSuchAlgorithmException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (InvalidKeyException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (BadPaddingException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        catch (IllegalBlockSizeException exception) {
            SchedulerRuntimeException.logAndThrow(complaint, exception);
        }
        return decryptedValue;
    }

    static Key getKey() {
        return SubjectDataEncryptor.getInstance().encryptionKey;
    }

    public static Subject encryptSubjectInPlace(Subject subjectEntity) {
        if (subjectEntity != null) {
            if (subjectEntity.getFirstName() != null) {
                subjectEntity.setFirstName(SubjectDataEncryptor.encrypt(subjectEntity.getFirstName().toUpperCase()));
            }
            if (subjectEntity.getMiddleName() != null) {
                subjectEntity.setMiddleName(SubjectDataEncryptor.encrypt(subjectEntity.getMiddleName().toUpperCase()));
            }
            if (subjectEntity.getPuid() != null) {
                subjectEntity.setPuid(SubjectDataEncryptor.encrypt(subjectEntity.getPuid().toUpperCase()));
            }
            if (subjectEntity.getLastName() != null) {
                subjectEntity.setLastName(SubjectDataEncryptor.encrypt(subjectEntity.getLastName().toUpperCase()));
            }
            if (subjectEntity.getFullName() != null) {
                subjectEntity.setFullName(SubjectDataEncryptor.encrypt(subjectEntity.getFullName().toUpperCase()));
            }
            if (subjectEntity.getStreetAddress1() != null) {
                subjectEntity.setStreetAddress1(SubjectDataEncryptor.encrypt(subjectEntity.getStreetAddress1().toUpperCase()));
            }
            if (subjectEntity.getStreetAddress2() != null) {
                subjectEntity.setStreetAddress2(SubjectDataEncryptor.encrypt(subjectEntity.getStreetAddress2().toUpperCase()));
            }
            if (subjectEntity.getCity() != null) {
                subjectEntity.setCity(SubjectDataEncryptor.encrypt(subjectEntity.getCity().toUpperCase()));
            }
            if (subjectEntity.getZip() != null) {
                subjectEntity.setZip(SubjectDataEncryptor.encrypt(subjectEntity.getZip().toUpperCase()));
            }
            if (subjectEntity.getPrimaryContactNumber() != null) {
                subjectEntity.setPrimaryContactNumber(SubjectDataEncryptor.encrypt(subjectEntity.getPrimaryContactNumber().toUpperCase()));
            }
            if (subjectEntity.getSecondaryContactNumber() != null) {
                subjectEntity.setSecondaryContactNumber(SubjectDataEncryptor.encrypt(subjectEntity.getSecondaryContactNumber().toUpperCase()));
            }
            subjectEntity.setSecure(Boolean.TRUE);
        }
        return subjectEntity;
    }

    public static void decryptSubjectWithinStudySubject(StudySubject studySubject) {
        if (studySubject == null) {
            return;
        }
        Subject encrypted = studySubject.getSubject();
        Subject subjectCopy = Subject.defensiveCopy(encrypted);
        Subject decrypted = SubjectDataEncryptor.decryptSubject(subjectCopy);
        SubjectMrn subjectMrnCopy = SubjectMrn.defensiveCopy(studySubject.getSubjectMrn());
        subjectMrnCopy.setSubject(decrypted);
        studySubject.setSubjectMrn(subjectMrnCopy);
    }

    public static SubjectMrn decryptSubjectMrnAndSubject(SubjectMrn subjectMrn) {
        if (subjectMrn == null) {
            return null;
        }
        SubjectMrn subjectMrnCopy = SubjectMrn.defensiveCopy(subjectMrn);
        Subject encryptedSubject = subjectMrnCopy.getSubject();
        Subject decryptedSubject = SubjectDataEncryptor.decryptSubject(encryptedSubject);
        String decryptedMrn = SubjectDataEncryptor.decrypt(subjectMrnCopy.getMrn());
        subjectMrnCopy.setMrn(decryptedMrn);
        subjectMrnCopy.setSubject(decryptedSubject);
        return subjectMrnCopy;
    }

    public static Subject decryptSubject(Subject subjectEntity) {
        return SubjectDataEncryptor.decryptSubject(subjectEntity, Subject.defensiveCopy(subjectEntity), SubjectDataEncryptor.getKey());
    }

    public static Subject decryptSubjectMrnWithinSubject(Subject subjectEntity) {
        Subject targetSubject = Subject.defensiveCopy(subjectEntity);
        if (subjectEntity == null) {
            return null;
        }
        if (targetSubject.getSecure()) {
            targetSubject.setSubjectMrnSet(targetSubject.getDecryptedSubjectMrnSet());
            targetSubject.setSecure(false);
        }
        return targetSubject;
    }

    public static Subject decryptSubjectLastName(Subject subjectEntity) {
        Subject targetSubject = Subject.defensiveCopy(subjectEntity);
        Key key = SubjectDataEncryptor.getKey();
        if (subjectEntity == null) {
            return null;
        }
        if (targetSubject.getSecure()) {
            targetSubject.setLastName(SubjectDataEncryptor.decrypt(targetSubject.getLastName(), key));
            targetSubject.setSecure(false);
        }
        return targetSubject;
    }

    public static Subject decryptSubjectInPlace(Subject subjectEntity) {
        return SubjectDataEncryptor.decryptSubject(subjectEntity, subjectEntity, SubjectDataEncryptor.getKey());
    }

    public static Subject decryptSubject(Subject startingSubject, Subject targetSubject, Key key) {
        if (startingSubject == null) {
            return null;
        }
        if (targetSubject.getSecure()) {
            targetSubject.setFullName(SubjectDataEncryptor.decrypt(targetSubject.getFullName(), key));
            targetSubject.setFirstName(SubjectDataEncryptor.decrypt(targetSubject.getFirstName(), key));
            targetSubject.setPuid(SubjectDataEncryptor.decrypt(targetSubject.getPuid(), key));
            targetSubject.setLastName(SubjectDataEncryptor.decrypt(targetSubject.getLastName(), key));
            targetSubject.setMiddleName(SubjectDataEncryptor.decrypt(targetSubject.getMiddleName(), key));
            targetSubject.setStreetAddress1(SubjectDataEncryptor.decrypt(targetSubject.getStreetAddress1(), key));
            targetSubject.setStreetAddress2(SubjectDataEncryptor.decrypt(targetSubject.getStreetAddress2(), key));
            targetSubject.setCity(SubjectDataEncryptor.decrypt(targetSubject.getCity(), key));
            targetSubject.setZip(SubjectDataEncryptor.decrypt(targetSubject.getZip(), key));
            targetSubject.setPrimaryContactNumber(SubjectDataEncryptor.decrypt(targetSubject.getPrimaryContactNumber(), key));
            targetSubject.setSecondaryContactNumber(SubjectDataEncryptor.decrypt(targetSubject.getSecondaryContactNumber(), key));
            targetSubject.setSubjectMrnSet(targetSubject.getDecryptedSubjectMrnSet());
            targetSubject.setSecure(false);
        }
        return targetSubject;
    }

    private static final class Holder {
        private static final SubjectDataEncryptor instance = new SubjectDataEncryptor();

        private Holder() {
        }
    }
}

