/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.UserDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetUsersResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDetailResponse;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.AuthService;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/management")
@Singleton
@Component
public class ManagementResource
extends SecuredResource {
    private AuthService service;

    @Autowired
    public ManagementResource(AuthService service) {
        this.service = service;
    }

    ManagementResource() {
    }

    @GET
    @Path(value="/getUsers")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getUsers(@QueryParam(value="filterString") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        GetUsersResponse users = this.service.getUsers(filterString, sortBy, orderBy, page, maxResults, this.getRemoteHost(), this.getUser());
        return this.gson.toJson((Object)users);
    }

    @GET
    @Path(value="/getRolesList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getRolesList() {
        List<Role> roles = this.service.getRoles();
        return this.gson.toJson(roles);
    }

    @POST
    @Path(value="/updatePassword")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String updatePassword(@FormParam(value="data") String data) {
        Gson gson = new GsonBuilder().registerTypeAdapter(UserDTO.class, (Object)new UserDTO()).create();
        UserDTO dto = (UserDTO)gson.fromJson(data, UserDTO.class);
        dto = this.service.updatePassword(dto, this.getUser());
        return gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/createUser")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String createUser(@FormParam(value="data") String data) {
        HashMap<String, String> map = new HashMap<String, String>();
        Gson gson = new GsonBuilder().registerTypeAdapter(UserDTO.class, (Object)new UserDTO()).create();
        UserDTO dto = (UserDTO)gson.fromJson(data, UserDTO.class);
        if (!(dto = this.service.createUser(dto, this.getUser(), this.getContextPath(), this.getRemoteHost(), this.getServerName(), this.getServerPort())).isResult()) {
            map.put("errorMsg", dto.getErrorMsg());
        }
        return gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/updateUser")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String updateUser(@FormParam(value="data") String data) {
        HashMap<String, String> map = new HashMap<String, String>();
        Gson gson = new GsonBuilder().registerTypeAdapter(UserDTO.class, (Object)new UserDTO()).create();
        UserDTO unmarshalled = (UserDTO)gson.fromJson(data, UserDTO.class);
        UserDTO dto = this.service.updateUser(unmarshalled, this.getUser(), this.getRemoteHost());
        if (!dto.isResult()) {
            map.put("errorMsg", dto.getErrorMsg());
        }
        return gson.toJson((Object)dto);
    }

    @GET
    @Path(value="/changeUserStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String changeUserStatus(@QueryParam(value="user") int userId) {
        BooleanResultDTO result = this.service.changeUserStatus(userId, this.getUser(), this.getContextPath(), this.getRemoteHost(), this.getServerName(), this.getServerPort());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getUserData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getUserData(@QueryParam(value="user") int userId) {
        UserDetailResponse result = this.service.getUserData(userId);
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getStudyMembersStudyScreen")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyMembersStudyScreen(@QueryParam(value="filterString") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy) {
        List<UserDataResponse> users = this.service.getStudyMembers(filterString, sortBy, orderBy);
        return this.gson.toJson(users);
    }
}

