/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.SwitchSubjectResultDTO;
import edu.harvard.catalyst.scheduler.dto.VisitRenderSummaryDTO;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AppointmentDAO
extends SiteDAO {
    public static final Integer SCHEDULE_ID = 1;
    private static final Integer CHECKIN_ID = 2;
    private static final Integer CHECKOUT_ID = 3;
    private static final Integer CANCEL_ID = 4;
    protected static final Integer HOLD_ID = 5;
    public static final String SCHEDULED_APPT_STATUS = "Scheduled";
    public static final String CHECKED_IN_APPT_STATUS = "Checked-In";
    public static final String HOLD_APPT_STATUS = "Hold";

    static boolean isAllDay(boolean homeView, VisitType visitType) {
        return AppointmentDAO.isAllDay(homeView, visitType.isInpatient());
    }

    static boolean isAllDay(boolean homeView, boolean isInpatient) {
        return homeView && isInpatient;
    }

    public List<SublocationClosureInterval> findSublocationSchedule(Sublocation sublocation, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocation);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public boolean isSublocationClosed(Sublocation sublocation, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocation);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List list = query.list();
        return !list.isEmpty();
    }

    public List<BookedResource> findOverbookConflictResourcesByVisitStatus(Resource resource, Date startDate, Date endDate) {
        String findBookedResource = "select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime";
        Query query = this.newQuery("select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public List<OverbookTimelineDataResponseDTO> getOverbookTimelineData(Date startDate, Date endDate, ResourceType resourceType, List<Integer> sublocations, String orderBy, User user) {
        SQLQuery query = this.createOverbookTimelineQuery(startDate, endDate, resourceType, sublocations, orderBy);
        List resultRows = query.list();
        long selectedMinutes = startDate.getTime() / 60000L;
        List<Date> selectedDates = DateUtility.dateInterval(startDate, endDate);
        Ref<Integer> previousResource = new Ref<Integer>(0);
        Function<Object[], OverbookTimelineDataResponseDTO> toOverbookTimelineDataResponseDTO = resultRow -> {
            String subjectFirstName;
            String visit;
            Integer resource = (Integer)resultRow[0];
            String resourceName = (String)resultRow[1];
            Date scheduledStartTime = (Date)resultRow[7];
            Date scheduledEndTime = (Date)resultRow[8];
            Integer bookedVisitId = (Integer)resultRow[9];
            boolean hasBookedVisitId = bookedVisitId != null;
            boolean hasSubjectData = resultRow[10] != null;
            boolean isNewResource = !resource.equals(previousResource.get());
            boolean notStudyStaff = !user.isStudyStaff();
            boolean hasBookedVisitIdAndNotStudyStaff = hasBookedVisitId && notStudyStaff;
            boolean hasBookedVisitIdAndIsNewResource = hasBookedVisitId && isNewResource;
            int rowCount = hasBookedVisitIdAndIsNewResource ? this.getResourceCount(resource, startDate, endDate) : 0;
            long sixtySecondsInMillis = Duration.ofSeconds(60L).toMillis();
            String rooms = hasBookedVisitId ? this.findRoomString(bookedVisitId) : "";
            long startTime = hasBookedVisitId ? scheduledStartTime.getTime() / sixtySecondsInMillis : 0L;
            long endTime = hasBookedVisitId ? scheduledEndTime.getTime() / sixtySecondsInMillis : 0L;
            String piName = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[5] : "";
            String localId = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[6] : "";
            String string = visit = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[4] : "";
            String string2 = hasSubjectData ? (hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[10]) : "") : (subjectFirstName = "No Subject Assigned");
            String subjectLastName = hasSubjectData ? (hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[11]) : "") : "No Subject Assigned";
            String visitHoverStartTime = DateUtility.format(DateUtility.date24HTime(), (Date)resultRow[2]);
            String visitHoverEndTime = DateUtility.format(DateUtility.date24HTime(), (Date)resultRow[3]);
            String resourceHoverStartTime = DateUtility.format(DateUtility.date24HTime(), (Date)resultRow[7]);
            String resourceHoverEndTime = DateUtility.format(DateUtility.date24HTime(), (Date)resultRow[8]);
            String alternateResources = isNewResource ? this.findAlternateResourcesString(resource) : "";
            ArrayList<Map<String, String>> defaultResourceSchedule = isNewResource ? this.getDefaultResourceSchedule(selectedDates, resource) : new ArrayList();
            ArrayList<Map<String, String>> temporaryResourceSchedule = isNewResource ? this.getTemporaryResourceSchedule(startDate, endDate, resource) : new ArrayList<Map<String, String>>();
            OverbookTimelineDataResponseDTO overbookTimeLineData = new OverbookTimelineDataResponseDTO(resource, resourceName, rooms, visitHoverStartTime, visitHoverEndTime, resourceHoverStartTime, resourceHoverEndTime, visit, piName, localId, subjectFirstName, subjectLastName, startTime, endTime, selectedMinutes, defaultResourceSchedule, temporaryResourceSchedule, alternateResources, rowCount);
            previousResource.set(resource);
            return overbookTimeLineData;
        };
        return RichList.enrich((List)resultRows).map(toOverbookTimelineDataResponseDTO).toList();
    }

    private SQLQuery createOverbookTimelineQuery(Date startDate, Date endDate, ResourceType resourceType, List<Integer> sublocations, String orderBy) {
        Object[] columnsArray = new String[]{"resource.id", "resource.name", "bvStart", "bvEnd", "visit_template.name", "user.last_name", "study.local_id", "brStart", "brEnd", "bvId", "subject.first_name", "subject.last_name"};
        String columnSqlList = Joiner.on((String)", ").join(columnsArray);
        String filterBy = sublocations.isEmpty() ? " " : " and resource_sublocation.sublocation IN (" + Joiner.on((String)",").join(sublocations) + ") ";
        String findBookedResource = "SELECT " + columnSqlList + " " + "FROM resource_sublocation, resource " + "LEFT OUTER JOIN (select br.resource, br.id, br.booked_visit, booked_visit.visit_template, booked_visit.id bvId," + "booked_visit.scheduled_start_time AS bvStart, " + "booked_visit.scheduled_end_time AS bvEnd, " + "br.scheduled_start_time AS brStart, " + "br.scheduled_end_time AS brEnd," + "booked_visit.study, booked_visit.appointment_status, s.principal_investigator, su.id subjectId " + "from booked_resource br, study s, booked_visit " + "LEFT OUTER JOIN subject_mrn sm ON sm.id = booked_visit.subject_mrn " + "LEFT OUTER JOIN subject su ON su.id = sm.subject " + "WHERE " + "br.booked_visit = booked_visit.id " + "and booked_visit.study = s.id " + "and booked_visit.appointment_status IN (1,2,5) and  " + "((:startTime between br.scheduled_start_time  " + "                 and br.scheduled_end_time)  " + "                 or (:endTime between br.scheduled_start_time " + "                 and br.scheduled_end_time)  " + "                 or (br.scheduled_start_time > :startTime and  " + "                 br.scheduled_end_time < :endTime)) ) AS bookedData ON resource.id = bookedData.resource " + "                LEFT OUTER JOIN study ON bookedData.study = study.id " + "                LEFT OUTER JOIN subject ON bookedData.subjectId = subject.id " + "                LEFT OUTER JOIN visit_template ON bookedData.visit_template = visit_template.id " + "                LEFT OUTER JOIN user ON bookedData.principal_investigator = user.id " + "                where resource_sublocation.resource = resource.id and resource.type IN (:resourceType) " + filterBy + "                ORDER BY resource.name " + orderBy + ", bookedData.brStart";
        SQLQuery query = this.newSqlQuery(findBookedResource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("resourceType", (Object)resourceType.getName());
        for (Object column : columnsArray) {
            query.addScalar((String)column);
        }
        return query;
    }

    private List<Map<String, String>> getDefaultResourceSchedule(List<Date> selectedDates, Integer resource) {
        List dayOfWeeks = RichList.enrich(selectedDates).map(date -> DateUtility.getDayOfTheWeek(date)).toList();
        List defaultSchedules = RichList.enrich((List)dayOfWeeks).flatMapList(day -> this.findResourceScheduleByResource(resource, (Integer)day, false)).toList();
        Function<ResourceSchedule, Map> toDefaultScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"defaultScheduleTime", (Object)(DateUtility.retrieveDayOfWeek(schedule.getDayOfWeek()) + ": " + DateUtility.format(DateUtility.hourMin(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.hourMin(), schedule.getEndTime()))), Pair.pair((Object)"defaultScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich((List)defaultSchedules).map(toDefaultScheduleMap).toList();
    }

    private List<Map<String, String>> getTemporaryResourceSchedule(Date startDate, Date endDate, Integer resource) {
        List<ResourceSchedule> exceptionSchedules = this.findExceptionSchedule(resource, startDate, endDate, true);
        Function<ResourceSchedule, Map> toExceptionScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"exceptionScheduleTime", (Object)(DateUtility.format(DateUtility.date24HTime(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.date24HTime(), schedule.getEndTime()))), Pair.pair((Object)"exceptionScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich(exceptionSchedules).map(toExceptionScheduleMap).toList();
    }

    private int getResourceCount(int resource, Date startDate, Date endDate) {
        String findResourceCount = "SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ";
        Query query = this.newQuery("SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List dateRangeList = query.list();
        return this.isOverlappingDates(dateRangeList);
    }

    public int isOverlappingDates(List<BookedResource> dateRangeList) {
        int rowCount = 0;
        Date latestEndTimeRow1 = dateRangeList.get(0).getScheduledEndTime();
        Date latestEndTimeRow2 = dateRangeList.get(0).getScheduledEndTime();
        for (int index1 = 1; index1 < dateRangeList.size(); ++index1) {
            Date startDate = dateRangeList.get(index1).getScheduledStartTime();
            Date endDate = dateRangeList.get(index1).getScheduledEndTime();
            if (startDate.getTime() >= latestEndTimeRow1.getTime()) {
                latestEndTimeRow1 = endDate;
                if (rowCount != 0) continue;
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() < latestEndTimeRow1.getTime() && startDate.getTime() < latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                ++rowCount;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) continue;
            latestEndTimeRow2 = endDate;
            ++rowCount;
        }
        return rowCount;
    }

    public List<ResourceSchedule> findExceptionSchedule(Integer resourceId, Date startDate, Date endDate, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        String findExceptionSchedule = "SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime";
        Query query = this.session().createQuery("SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public String findAlternateResourcesString(Integer resourceId) {
        Resource resource = this.findById(Resource.class, resourceId);
        String hql = "select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name";
        Query query = this.newQuery("select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name");
        query.setParameter("resource", (Object)resource);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public List<ResourceSchedule> findResourceScheduleByResource(Integer resourceId, Integer dayOfWeek, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        Criteria criteria = this.newCriteria(ResourceSchedule.class);
        criteria.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        criteria.add((Criterion)Restrictions.eq((String)"dayOfWeek", (Object)dayOfWeek));
        criteria.add((Criterion)Restrictions.eq((String)"override", (Object)override));
        criteria.addOrder(Order.asc((String)"startTime"));
        return criteria.list();
    }

    public TemplateResource findTemplateResourceById(int id) {
        return this.findById(TemplateResource.class, id);
    }

    public CancellationStatus findCancellationStatusById(int id) {
        return this.findById(CancellationStatus.class, id);
    }

    public AppointmentStatus findScheduledStatus() {
        return this.findById(SCHEDULE_ID);
    }

    public AppointmentStatus findById(int id) {
        return this.findById(AppointmentStatus.class, id);
    }

    public AppointmentStatus findHoldStatus() {
        return this.findById(HOLD_ID);
    }

    public TemplateResourceGroup findTemplateResourceGroup(TemplateResource templateResource) {
        VisitTemplate visit = templateResource.getVisitTemplate();
        String groupId = templateResource.getGroupId();
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"visit", (Object)visit));
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)groupId));
        List result = criteria.list();
        return (TemplateResourceGroup)result.get(0);
    }

    public List<TemplateResourceGroup> findTrgListByGroupId(String group) {
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)group));
        return criteria.list();
    }

    public AppointmentStatus findCheckedInStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKIN_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public AppointmentStatus findCheckedOutStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKOUT_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public AppointmentStatus findCancelledStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CANCEL_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public List<BookedResource> findBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public Date findLatestBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC";
        Query query = this.newQuery("SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        return (Date)query.uniqueResult();
    }

    public boolean findBookedResourcesByBookedVisit(TemplateResource templateResource) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ");
        query.setParameter("templateResource", (Object)templateResource);
        return query.list().size() > 0;
    }

    public BookedResource findBookedResourceById(Integer id) {
        return this.findById(BookedResource.class, id);
    }

    public AppointmentOverrideReason findAppointmentOverrideReasonById(Integer id) {
        return this.findById(AppointmentOverrideReason.class, id);
    }

    public AppointmentStatusReason findAppointmentStatusReasonById(Integer id) {
        return this.findById(AppointmentStatusReason.class, id);
    }

    public List<VisitCommentsResponse.VisitComment> findAppointmentCommentsByVisit(BookedVisit visit) {
        Criteria criteria = this.newCriteria(Comments.class);
        criteria.add((Criterion)Restrictions.eq((String)"bookedVisit", (Object)visit));
        return VisitCommentsResponse.fromTemplateApprovalHistoryList(criteria.list());
    }

    public long findTotalAppointmentCommentsByVisit(int bookedVisitId) {
        String findTotalVisitComments = "SELECT COUNT(c) FROM Comments c WHERE c.bookedVisit.id = :bookedVisit";
        Query query = this.newQuery("SELECT COUNT(c) FROM Comments c WHERE c.bookedVisit.id = :bookedVisit");
        query.setParameter("bookedVisit", (Object)bookedVisitId);
        return (Long)query.uniqueResult();
    }

    public List<TemplateResource> getSingleFloatTemplateResources(VisitTemplate selectedVisit) {
        String findFloatTemplateResource = "SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ");
        query.setParameter("visit", (Object)selectedVisit);
        return query.list();
    }

    public List<TemplateResourceGroup> getTemplateResourceGroups(VisitTemplate selectedVisit, boolean flexVsFloat) {
        String findTemplateResourceGroups = "SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ";
        Query query = this.newQuery("SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ");
        query.setParameter("visit", (Object)selectedVisit);
        query.setParameter("flexGroup", (Object)flexVsFloat);
        return query.list();
    }

    public BookedResource findOrderedBookedResource(BookedVisit bookedVisit, String columnSort, String orderBy) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit order by " + columnSort + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        List brs = query.list();
        return (BookedResource)brs.get(0);
    }

    public List<BookedResource> findRoomBookedResourcesByBookedVisit(int bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'";
        Query query = this.newQuery("SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public List<BookedResourcesResponse> getBookedResourcesListByBookedVisit(int bookedVisit, String sortBy, String orderBy, int page, int maxResults) {
        String sortOn = sortBy;
        if (sortBy.equalsIgnoreCase("br.scheduled_start_time")) {
            sortOn = " br.scheduled_start_time " + orderBy + ", br.scheduled_end_time ";
        } else if (sortBy.equalsIgnoreCase("br.scheduled_end_time")) {
            sortOn = " br.scheduled_end_time " + orderBy + ", br.scheduled_start_time ";
        }
        String findBookedVisit = "SELECT br.id, r.name, group_concat(lla.name separator ', '), br.scheduled_start_time, br.scheduled_end_time  FROM booked_visit bv, resource r, booked_resource br  LEFT OUTER JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id  LEFT OUTER JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id  WHERE br.booked_visit = bv.id and bv.id = :bookedVisit and br.resource = r.id  group by br.id order by " + sortOn + " " + orderBy;
        SQLQuery query = this.newSqlQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        int offSet = (page - 1) * maxResults;
        query.setFirstResult(offSet);
        query.setMaxResults(maxResults);
        List resultRows = query.list();
        ArrayList bookedResourcesResponseDTOs = Lists.newArrayList();
        Long total = this.findBookedResourcesCount(bookedVisit);
        for (Object[] row : resultRows) {
            Integer bookedResource = (Integer)row[0];
            String resourceName = (String)row[1];
            String annotations = (String)row[2];
            Date scheduledStartTime = (Date)row[3];
            Date scheduledEndTime = (Date)row[4];
            BookedResourcesResponse bookedResourcesResponseDTO = new BookedResourcesResponse(bookedResource, resourceName, annotations, scheduledStartTime, scheduledEndTime, "", "", "", total, false);
            bookedResourcesResponseDTOs.add(bookedResourcesResponseDTO);
        }
        return bookedResourcesResponseDTOs;
    }

    Long findBookedResourcesCount(int bookedVisit) {
        String findCount = "SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit";
        Query query = this.newQuery("SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit").setParameter("bookedVisit", (Object)bookedVisit);
        return (Long)query.uniqueResult();
    }

    public String findRoomString(int visit) {
        Session session = this.session();
        String hql = "select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC";
        Query query = session.createQuery("select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC");
        query.setParameter("visit", (Object)visit);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public boolean canUserSeeBookedVisit(User user, Integer bookedVisitId) {
        boolean result = true;
        if (user.isStudyStaff()) {
            Query query = this.newQuery("select bv from Study s, StudyUser su, BookedVisit bv  where s.id = su.study    and :user = su.user    and bv.study = s.id    and bv.id = :bvId    and su.active=true    and s.studyStatus !=3");
            query.setParameter("user", (Object)user);
            query.setParameter("bvId", (Object)bookedVisitId);
            BookedVisit bookedVisit = (BookedVisit)query.uniqueResult();
            if (bookedVisit == null) {
                result = false;
            }
        }
        return result;
    }

    public List<CalendarVisitsResponse> getCalendarBookedVisits(String sublocationName, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff) {
        if (isStudyStaff && (studies == null || studies.isEmpty())) {
            return Lists.newArrayList();
        }
        String findBookedVisit = "select bv FROM BookedVisit bv  where (bv.appointmentStatus IN (1,2,3,5) OR  (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        boolean sublocationNameIsPresent = MiscUtil.isNonNullNonEmpty(sublocationName);
        if (sublocationNameIsPresent) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        if (isStudyStaff) {
            findBookedVisit = findBookedVisit + " and bv.study IN (:studies) ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (sublocationNameIsPresent) {
            query.setParameter("sublocation", (Object)sublocationName);
        }
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        return this.bookedVisitsDTO(homeView, query.list());
    }

    public List<CalendarVisitsResponse> findBookedVisitsByResource(String resource, User user, List<Study> studies, Date startDate, Date endDate, boolean homeView, String sublocationName) {
        String columnHqlList = CalendarBookedVisitsColumn.columnHqlList;
        String findBookedVisit = this.getCalendarBookedVisitsQueryHql(columnHqlList);
        if (studies != null && (!studies.isEmpty() && !user.isStudyStaff() || user.isStudyStaff())) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studies)";
        }
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        findBookedVisit = findBookedVisit + " and br.resource.name = :resource GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        if (studies != null && (!studies.isEmpty() && !user.isStudyStaff() || user.isStudyStaff())) {
            query.setParameterList("studies", studies);
        }
        query.setParameter("resource", (Object)resource);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            query.setParameter("sublocation", (Object)sublocationName);
        }
        return this.getCalendarVisitsDTOs(homeView, query.list());
    }

    public List<CalendarVisitsResponse> findBookedVisitsByApppointmentStatus(int appointmentStatusId, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff, String sublocationName) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.appointmentStatus.id IN (:appointmentStatus) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        if (MiscUtil.isNonNullNonEmpty(studies)) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studies)";
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            findBookedVisit = findBookedVisit + " and (bv.cancelDate >= :dayBeforeYesterday)";
        }
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameter("appointmentStatus", (Object)appointmentStatusId);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            Date twoDaysAgo = this.getDayBeforeYesterday();
            query.setParameter("dayBeforeYesterday", (Object)twoDaysAgo);
        }
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            query.setParameter("sublocation", (Object)sublocationName);
        }
        return this.bookedVisitsDTO(homeView, query.list());
    }

    List<CalendarVisitsResponse> bookedVisitsDTO(boolean homeView, List<BookedVisit> resultRows) {
        ArrayList results = Lists.newArrayList();
        for (BookedVisit bv : resultRows) {
            Integer eventId = bv.getId();
            String appointmentStatus = bv.getAppointmentStatus().getName();
            String localId = bv.getStudy().getLocalId();
            String piLastName = bv.getStudy().getInvestigator() != null ? bv.getStudy().getInvestigator().getLastName() : "";
            String visitName = bv.getVisitTemplate().getName();
            String subjectLastName = bv.getSubjectMrn() == null ? "No Subject Assigned" : bv.getSubjectMrnDecrypted().getSubject().getLastName();
            String scheduledStartTime = DateUtility.format(DateUtility.dateHourMin(), bv.getScheduledStartTime());
            String scheduledEndTime = DateUtility.format(DateUtility.dateHourMin(), bv.getScheduledEndTime());
            String rooms = this.findRoomString(eventId);
            boolean allDay = AppointmentDAO.isAllDay(homeView, bv.getVisitType());
            CalendarVisitsResponse calendarVisitsResponse = new CalendarVisitsResponse(eventId, visitName, piLastName, rooms, localId, subjectLastName, appointmentStatus, scheduledStartTime, scheduledEndTime, allDay, bv.getVisitType().isInpatient());
            results.add(calendarVisitsResponse);
        }
        return results;
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, boolean homeView, String sublocationName) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.study IN (:study) and  ((bv.appointmentStatus.id IN (1,2,3,5)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameterList("study", study);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            query.setParameter("sublocation", (Object)sublocationName);
        }
        return this.bookedVisitsDTO(homeView, query.list());
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsBySubject(User user, List<Study> studyList, List<Subject> subject, String sublocationName, Date startDate, Date endDate, boolean homeView) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.subjectMrn is not NULL and bv.subjectMrn.subject IN (:subjectList) and  ((bv.appointmentStatus.id IN (1,2,3)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        if (user.isStudyStaff()) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studyList) ";
        }
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameterList("subjectList", subject);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (MiscUtil.isNonNullNonEmpty(sublocationName)) {
            query.setParameter("sublocation", (Object)sublocationName);
        }
        if (user.isStudyStaff()) {
            query.setParameterList("studyList", studyList);
        }
        return this.bookedVisitsDTO(homeView, query.list());
    }

    List<CalendarVisitsResponse> getCalendarVisitsDTOs(boolean homeView, List<Object[]> resultRows) {
        Function<Object[], CalendarVisitsResponse> toCalendarVisitsResponse = resultRow -> {
            String resultSubjectLastName = resultRow[5] == null ? "No Subject Assigned" : SubjectDataEncryptor.decrypt((String)resultRow[5]);
            Integer eventId = (Integer)resultRow[0];
            String appointmentStatus = (String)resultRow[1];
            String localId = (String)resultRow[2];
            String userLastName = (String)resultRow[3];
            String piLastName = userLastName != null ? userLastName : "";
            String visitName = (String)resultRow[4];
            String subjectLastName = resultSubjectLastName;
            String scheduledStartTime = DateUtility.format(DateUtility.dateHourMin(), (Date)resultRow[6]);
            String scheduledEndTime = DateUtility.format(DateUtility.dateHourMin(), (Date)resultRow[7]);
            Boolean isInpatient = (Boolean)resultRow[8];
            String rooms = this.findRoomString(eventId);
            boolean allDay = AppointmentDAO.isAllDay(homeView, isInpatient);
            return new CalendarVisitsResponse(eventId, visitName, piLastName, rooms, localId, subjectLastName, appointmentStatus, scheduledStartTime, scheduledEndTime, allDay, isInpatient);
        };
        return RichList.enrich(resultRows).map(toCalendarVisitsResponse).toList();
    }

    private String getCalendarBookedVisitsQueryHql(String columnHqlList) {
        return "SELECT " + columnHqlList + " " + "FROM " + "BookedVisit bv JOIN bv.study s " + "LEFT JOIN s.investigator u " + "LEFT JOIN bv.subjectMrn sm " + "LEFT JOIN sm.subject subj, " + "BookedResource br, " + "AppointmentStatus apSt, " + "VisitTemplate vt, " + "Sublocation sub " + "WHERE " + "br.bookedVisit = bv.id and " + "bv.visitTemplate = vt.id and " + "bv.appointmentStatus = apSt.id and " + "vt.sublocation = sub.id and " + " ((apSt.id IN (1,2,3,5)) OR (apSt.id = 4 AND bv.cancelDate > :dayBeforeDate)) " + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) " + " or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) " + " or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisits(Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv FROM BookedVisit bv where  ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        return this.bookedVisitsResponses(page - 1, query, total);
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv  FROM BookedVisit bv  where bv.study IN (:studies) and ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate))  and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameterList("studies", study);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        return this.bookedVisitsResponses(page - 1, query, total);
    }

    String listToSpaceWhereString(List<String> whereClauses) {
        String result = "";
        if (!whereClauses.isEmpty()) {
            result = " WHERE (" + Joiner.on((String)" and ").join(whereClauses) + ")";
        }
        return result;
    }

    boolean useTimeRangeForBookedVisits(Date fromDate) {
        return fromDate != null;
    }

    boolean useSyncTimeForBookedVisits(Date fromDate, Date toDate) {
        return fromDate == null && toDate != null;
    }

    boolean filterByStudyForBookedVisits(List<Study> studyList) {
        return studyList != null;
    }

    String getTimeRangeString(String start, String end) {
        return "(" + end + " >= :startTime and :endTime >= " + start + ")";
    }

    public List<BookedVisitsResponse> findBookedVisitsForStudyList(List<Study> studyList, String sortBy, String orderBy, int oneIndexedPageNumber, int maxResults, Date fromDate, Date toDate, SearchDTO searchDTO) {
        String timeBeforeTodate = "bv.scheduledStartTime < (:toDate)";
        String selectFields = "bv.id,  bv.scheduledStartTime,  bv.scheduledEndTime,  vt.name,  st.localId,  st.irb,  st.catalystId,  s.firstName,  s.lastName,  sm.mrn,  apSt.name";
        String fromTables = "BookedVisit bv  join bv.study st  join bv.visitTemplate vt  join bv.appointmentStatus apSt  left join bv.subjectMrn sm  left join sm.subject s with ( s.archivalStatus IS NULL )";
        boolean filteringByStudy = this.filterByStudyForBookedVisits(studyList);
        boolean usingRange = this.useTimeRangeForBookedVisits(fromDate);
        boolean usingSync = this.useSyncTimeForBookedVisits(fromDate, toDate);
        StringBuilder mainQueryBuilder = new StringBuilder("select ").append(selectFields);
        StringBuilder mainCountQueryBuilder = new StringBuilder("select count ( * )");
        StringBuilder syncOffsetQueryBuilder = new StringBuilder("select count ( * )");
        ArrayList queryBuilders = Lists.newArrayList((Object[])new StringBuilder[]{mainQueryBuilder, mainCountQueryBuilder, syncOffsetQueryBuilder});
        queryBuilders.stream().forEach(b -> b.append(" from ").append(fromTables));
        ArrayList mainWhereClauses = Lists.newArrayList();
        ArrayList mainCountWhereClauses = Lists.newArrayList();
        ArrayList syncOffsetWhereClauses = Lists.newArrayList();
        ArrayList whereClauseLists = Lists.newArrayList((Object[])new List[]{mainWhereClauses, mainCountWhereClauses, syncOffsetWhereClauses});
        HashMap queryBuilderToWhereClauseList = Maps.newHashMap();
        queryBuilderToWhereClauseList.put(mainQueryBuilder, mainWhereClauses);
        queryBuilderToWhereClauseList.put(mainCountQueryBuilder, mainCountWhereClauses);
        queryBuilderToWhereClauseList.put(syncOffsetQueryBuilder, syncOffsetWhereClauses);
        if (usingRange) {
            String timeRange = this.getTimeRangeString("bv.scheduledStartTime", "bv.scheduledEndTime");
            mainWhereClauses.add(timeRange);
            mainCountWhereClauses.add(timeRange);
        } else if (usingSync) {
            syncOffsetWhereClauses.add(timeBeforeTodate);
        }
        if (filteringByStudy) {
            whereClauseLists.stream().forEach(c -> c.add("bv.study in (:studyList)"));
        }
        List<String> whereClauseAtomsForFilters = searchDTO.generateSearchClauseList();
        whereClauseLists.stream().forEach(c -> c.addAll(whereClauseAtomsForFilters));
        queryBuilders.stream().forEach(b -> b.append(this.listToSpaceWhereString((List)queryBuilderToWhereClauseList.get(b))));
        String sortAndOrder = "ORDER BY " + sortBy + " " + orderBy;
        mainQueryBuilder.append(" ").append(sortAndOrder);
        syncOffsetQueryBuilder.append(" ").append(sortAndOrder);
        Query mainQuery = this.newQuery(mainQueryBuilder.toString());
        Query mainCountQuery = this.newQuery(mainCountQueryBuilder.toString());
        Query syncOffsetQuery = this.newQuery(syncOffsetQueryBuilder.toString());
        if (filteringByStudy) {
            mainQuery.setParameterList("studyList", studyList);
            mainCountQuery.setParameterList("studyList", studyList);
            syncOffsetQuery.setParameterList("studyList", studyList);
        }
        int zeroIndexedPageNumber = oneIndexedPageNumber - 1;
        searchDTO.assignQueryParameterValues(mainQuery);
        searchDTO.assignQueryParameterValues(mainCountQuery);
        searchDTO.assignQueryParameterValues(syncOffsetQuery);
        if (usingRange) {
            mainCountQuery.setParameter("startTime", (Object)fromDate);
            mainQuery.setParameter("startTime", (Object)fromDate);
            Date endDateAdjustedToEndOfDay = DateUtility.adjustToEndOfDay(toDate);
            mainCountQuery.setParameter("endTime", (Object)endDateAdjustedToEndOfDay);
            mainQuery.setParameter("endTime", (Object)endDateAdjustedToEndOfDay);
        } else if (usingSync) {
            syncOffsetQuery.setParameter("toDate", (Object)toDate);
            zeroIndexedPageNumber = this.getSyncedZeroIndexedPageNumber(maxResults, syncOffsetQuery);
        }
        int resultOffset = zeroIndexedPageNumber * maxResults;
        mainQuery.setFirstResult(resultOffset);
        mainQuery.setMaxResults(maxResults);
        List mainResults = mainQuery.list();
        long total = (Long)mainCountQuery.uniqueResult();
        return this.bookedVisitsResponses(zeroIndexedPageNumber, mainResults, (Long)total);
    }

    int getSyncedZeroIndexedPageNumber(int maxResults, Query syncOffsetQuery) {
        int result = 0;
        long totalRows = (Long)syncOffsetQuery.uniqueResult();
        if (totalRows > 0L) {
            result = (int)(totalRows - 1L) / maxResults;
        }
        return result;
    }

    private List<BookedVisitsResponse> bookedVisitsResponses(int page, Query query, Long total) {
        List resultRows = query.list();
        ArrayList results = Lists.newArrayList();
        for (BookedVisit bv : resultRows) {
            String visitName = bv.getVisitTemplate().getName();
            String irb = bv.getStudy().getIrb();
            String catId = bv.getStudy().getCatalystId();
            String localId = bv.getStudy().getLocalId();
            SubjectMrn subjectMrn = bv.getSubjectMrnDecrypted();
            String subjectFirstName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getFirstName();
            String subjectLastName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getLastName();
            String subjectMrnCode = subjectMrn == null ? "N/A" : subjectMrn.getMrn();
            String apptStatusName = bv.getAppointmentStatus().getName();
            Date scheduledStartTime = bv.getScheduledStartTime();
            Date scheduledEndTime = bv.getScheduledEndTime();
            BookedVisitsResponse result = new BookedVisitsResponse(bv.getId(), visitName, irb, catId, localId, subjectFirstName, subjectLastName, subjectMrnCode, apptStatusName, scheduledStartTime, scheduledEndTime, total, page);
            results.add(result);
        }
        return results;
    }

    String adjustForDecryptionAndNA(String in, String adjusted) {
        String result = null == in ? adjusted : SubjectDataEncryptor.decrypt(in);
        return result;
    }

    List<BookedVisitsResponse> bookedVisitsResponses(int page, List<Object[]> resultSetList, Long total) {
        ArrayList results = Lists.newArrayList();
        for (Object[] row : resultSetList) {
            int index = 0;
            Integer id = (Integer)row[index++];
            Date scheduledStartTime = (Date)row[index++];
            Date scheduledEndTime = (Date)row[index++];
            String visitName = (String)row[index++];
            String localId = (String)row[index++];
            String irb = (String)row[index++];
            String catId = (String)row[index++];
            String subjectFirstName = this.adjustForDecryptionAndNA((String)row[index++], "No Subject Assigned");
            String subjectLastName = this.adjustForDecryptionAndNA((String)row[index++], "No Subject Assigned");
            String subjectMrnCode = this.adjustForDecryptionAndNA((String)row[index++], "N/A");
            String apptStatusName = (String)row[index++];
            BookedVisitsResponse result = new BookedVisitsResponse(id, visitName, irb, catId, localId, subjectFirstName, subjectLastName, subjectMrnCode, apptStatusName, scheduledStartTime, scheduledEndTime, total, page);
            results.add(result);
        }
        return results;
    }

    public List<StudySubject> findStudySubjectBySubject(Subject subject) {
        String findStudySubjectQueryString = "FROM StudySubject ss WHERE ss.subjectMrn.subject = :subject ";
        Query query = this.newQuery(findStudySubjectQueryString);
        query.setParameter("subject", (Object)subject);
        return query.list();
    }

    public List<StudySubject> findStudySubjectBySubjectAndStudy(Subject subject, Study study) {
        String findStudySubjectQueryString = "FROM StudySubject ss WHERE ss.study = :study and ss.subjectMrn.subject = :subject ";
        Query query = this.newQuery(findStudySubjectQueryString);
        query.setParameter("subject", (Object)subject);
        query.setParameter("study", (Object)study);
        return query.list();
    }

    public boolean subjectHasBookedVisitInDateRange(Integer subject, Date startDate, Date endDate) {
        String findBookedVisit = "SELECT bv.id FROM BookedVisit bv, Subject s, SubjectMrn sm  WHERE   bv.subjectMrn = sm.id AND sm.subject = s.id AND s.id = :subject   AND bv.appointmentStatus.id IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )";
        Query query = this.newQuery("SELECT bv.id FROM BookedVisit bv, Subject s, SubjectMrn sm  WHERE   bv.subjectMrn = sm.id AND sm.subject = s.id AND s.id = :subject   AND bv.appointmentStatus.id IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )");
        query.setParameter("subject", (Object)subject);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list().size() != 0;
    }

    public BookedVisit findBookedVisitById(int id) {
        return this.findById(BookedVisit.class, id);
    }

    public Date getDayBeforeYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        return new Date(calendar.getTimeInMillis());
    }

    public List<BookedResource> findBookedResources(Resource sharedResource) {
        String findBookedResources = "SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND ap.name IN ('Scheduled','Hold','Checked-In') ";
        Query query = this.newQuery("SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND ap.name IN ('Scheduled','Hold','Checked-In') ").setParameter("resource", (Object)sharedResource);
        return query.list();
    }

    public SwitchSubjectResultDTO switchVisitSubject(Integer newSubjectMrnId, BookedVisit visit, boolean homeScreen, String className) {
        String fullName;
        if (newSubjectMrnId.equals(0)) {
            visit.setSubjectMrn(null);
            fullName = "No Subject Assigned";
            visit.setAppointmentStatus(this.findHoldStatus());
            className = visit.getAppointmentStatus().getName();
        } else {
            SubjectMrn subjectMrn = this.findById(SubjectMrn.class, newSubjectMrnId);
            visit.setSubjectMrn(subjectMrn);
            visit.setAppointmentStatus(this.findScheduledStatus());
            fullName = SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getFullName());
        }
        this.updateEntity(visit);
        VisitRenderSummaryDTO visitRenderSummaryDTO = new VisitRenderSummaryDTO(visit, className, homeScreen);
        return new SwitchSubjectResultDTO(true, newSubjectMrnId, fullName, visitRenderSummaryDTO);
    }

    public List<BookedVisit> getAllBookedVisitByStudyAndSubjectMrn(Study study, SubjectMrn subjectMrn) {
        String queryString = "select bv from BookedVisit bv where bv.study = :study and bv.subjectMrn = :subjectMrn";
        Query query = this.newQuery(queryString);
        query.setParameter("study", (Object)study);
        query.setParameter("subjectMrn", (Object)subjectMrn);
        return query.list();
    }

    private static final class CalendarBookedVisitsColumn {
        static final List<String> columnsHql = Arrays.asList("bv.id", "apSt.name", "bv.study.localId", "u.lastName", "bv.name", "subj.lastName", "bv.scheduledStartTime", "bv.scheduledEndTime", "bv.visitType.inpatient");
        static final String columnHqlList = Joiner.on((String)", ").join(columnsHql);

        private CalendarBookedVisitsColumn() {
        }
    }

    private static final class Ref<A> {
        private A a;

        Ref(A a) {
            this.a = a;
        }

        A get() {
            return this.a;
        }

        void set(A a) {
            this.a = a;
        }
    }
}

