/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.security.SchedulerSession;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

@Produces(value={"text/plain"})
public class BaseResource {
    protected final Gson gson;
    public final Gson bookedVisitSkippingGson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz == BookedVisit.class;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }
    }}).serializeNulls().create();
    public final Gson subjectMrnSkippingGson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz == SubjectMrn.class;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }
    }}).serializeNulls().create();
    @Context
    protected HttpServletRequest request;
    @Autowired
    private SchedulerSession session;

    void setSession(SchedulerSession session) {
        this.session = session;
    }

    void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public BaseResource() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date date, Type typeOfT, JsonSerializationContext context) {
                return new JsonPrimitive((Number)date.getTime());
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                return new Date(json.getAsJsonPrimitive().getAsLong());
            }
        });
        this.gson = builder.create();
    }

    protected User getUser() {
        return this.session.getUserDetails().getUser();
    }

    protected UserSession getUserSession() {
        return this.session.getUserDetails().getUserSession();
    }

    protected void updateUserSession(UserSession us) {
        this.session.getUserDetails().setUserSession(us);
    }

    protected String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    protected String getServerName() {
        return this.request.getServerName();
    }

    protected int getServerPort() {
        return this.request.getServerPort();
    }

    protected String getContextPath() {
        return this.request.getContextPath();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }
}

