/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.scheduler.core.BookedVisitActivityLogStatics;
import edu.harvard.catalyst.scheduler.dto.AncillaryOnlyByProtocolReportDTO;
import edu.harvard.catalyst.scheduler.dto.BillableResourcesReportDTO;
import edu.harvard.catalyst.scheduler.dto.BillingByInvestigatorReportDTO;
import edu.harvard.catalyst.scheduler.dto.BillingReportDTO;
import edu.harvard.catalyst.scheduler.dto.BookedVisitServiceLevelByVisitTypeReportDTO;
import edu.harvard.catalyst.scheduler.dto.CRCAvailabilityReportDTO;
import edu.harvard.catalyst.scheduler.dto.CensusReportDTO;
import edu.harvard.catalyst.scheduler.dto.DailyAdmReportDTO;
import edu.harvard.catalyst.scheduler.dto.DailyOverviewReportDTO;
import edu.harvard.catalyst.scheduler.dto.DailyResourceReportDTO;
import edu.harvard.catalyst.scheduler.dto.DeptAndPiReportDTO;
import edu.harvard.catalyst.scheduler.dto.LevelOfServiceReportDTO;
import edu.harvard.catalyst.scheduler.dto.MetaKitchenReportDTO;
import edu.harvard.catalyst.scheduler.dto.NursingAndRoomDailyOverviewReportDTO;
import edu.harvard.catalyst.scheduler.dto.NutritionDailyResourceReportDTO;
import edu.harvard.catalyst.scheduler.dto.NutritionTasksReportDTO;
import edu.harvard.catalyst.scheduler.dto.OffUnitReportDTO;
import edu.harvard.catalyst.scheduler.dto.OverrideReportDTO;
import edu.harvard.catalyst.scheduler.dto.ProtoNurseReportDTO;
import edu.harvard.catalyst.scheduler.dto.ReportDTO;
import edu.harvard.catalyst.scheduler.dto.StaffAuditSubjectViewsReportDTO;
import edu.harvard.catalyst.scheduler.dto.StudyStatusChangeReportDTO;
import edu.harvard.catalyst.scheduler.dto.StudySubjectVisitReportDTO;
import edu.harvard.catalyst.scheduler.dto.StudyVisitLocationReportDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectAuditStaffViewsReportDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectPurgeReportDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectVisitHistoryReportDTO;
import edu.harvard.catalyst.scheduler.dto.TransactionsReportDTO;
import edu.harvard.catalyst.scheduler.dto.UserReportDTO;
import edu.harvard.catalyst.scheduler.dto.VisitDurationByVisitTypeReportDTO;
import edu.harvard.catalyst.scheduler.dto.VisitTemplateReportDTO;
import edu.harvard.catalyst.scheduler.dto.VisitsFlaggedEditReportDTO;
import edu.harvard.catalyst.scheduler.dto.WeeklyPharmReportDTO;
import edu.harvard.catalyst.scheduler.dto.WorkloadAndResourceResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.CancellationsReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.statics.StudyStatusFilter;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Report;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudyFundingSource;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.HqlClauses;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.persistence.SortStrategy;
import edu.harvard.catalyst.scheduler.persistence.UserDataReportFilterStrategy;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ReportDAO
extends SiteDAO {
    private static final Logger log = Logger.getLogger(ReportDAO.class);
    static final Comparator<StaffAuditSubjectViewsReportDTO> StaffAuditNameComparator = (o1, o2) -> {
        int nameOrder = o1.getSubjectLastName().compareToIgnoreCase(o2.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getDate().compareTo(o2.getDate());
    };
    static final Comparator<StaffAuditSubjectViewsReportDTO> StaffAuditNameComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getSubjectLastName().compareToIgnoreCase(o1.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getDate().compareTo(o2.getDate());
    };
    static final Comparator<ActivityLog> OverrideComparator = (o1, o2) -> {
        int nameOrder = o1.getPerformingUser().getEcommonsId().compareToIgnoreCase(o2.getPerformingUser().getEcommonsId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getDate().compareTo(o2.getDate());
    };
    static final Comparator<ActivityLog> OverrideComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getPerformingUser().getEcommonsId().compareToIgnoreCase(o1.getPerformingUser().getEcommonsId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getDate().compareTo(o2.getDate());
    };
    static final Comparator<SubjectPurgeReportDTO> SubjectPurgeNameComparator = (o1, o2) -> o1.getLastName().compareToIgnoreCase(o2.getLastName());
    static final Comparator<SubjectPurgeReportDTO> SubjectPurgeNameComparatorDesc = (o1, o2) -> o2.getLastName().compareToIgnoreCase(o1.getLastName());
    static final Comparator<OffUnitReportDTO> OffUnitComparator = (o1, o2) -> {
        int nameOrder = o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getResourceStartTime().compareTo(o2.getResourceStartTime());
    };
    static final Comparator<OffUnitReportDTO> OffUnitComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getScheduledStartTime().compareTo(o1.getScheduledStartTime());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getResourceStartTime().compareTo(o2.getResourceStartTime());
    };
    static final Comparator<DailyOverviewReportDTO> DailyOverviewComparator = (o1, o2) -> {
        int nameOrder = o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getBookedVisitId() == o2.getBookedVisitId()) {
            return o1.getResourceStartTime().compareTo(o2.getResourceStartTime());
        }
        return nameOrder;
    };
    static final Comparator<DailyOverviewReportDTO> DailyOverviewComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getScheduledStartTime().compareTo(o1.getScheduledStartTime());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getBookedVisitId() == o2.getBookedVisitId()) {
            return o1.getResourceStartTime().compareTo(o2.getResourceStartTime());
        }
        return nameOrder;
    };
    static final Comparator<WeeklyPharmReportDTO> WeeklyPharmComparator = (o1, o2) -> {
        int nameOrder = o1.getStudyName().compareTo(o2.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
    };
    static final Comparator<WeeklyPharmReportDTO> WeeklyPharmComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getStudyName().compareTo(o1.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
    };
    static final Comparator<StudyVisitLocationReportDTO> StudyVisitLocationComparatorAsc = (o1, o2) -> {
        int nameOrder = o1.getSublocationName().compareTo(o2.getSublocationName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getCheckInTime() != null && o2.getCheckInTime() != null) {
            return o1.getCheckInTime().compareTo(o2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<StudyVisitLocationReportDTO> StudyVisitLocationComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getSublocationName().compareTo(o1.getSublocationName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getCheckInTime() != null && o2.getCheckInTime() != null) {
            return o1.getCheckInTime().compareTo(o2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<BillableResourcesReportDTO> BillableResourcesComparator = (o1, o2) -> {
        int nameOrder = o1.getResourceName().compareToIgnoreCase(o2.getResourceName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getCheckInTime() != null && o2.getCheckInTime() != null) {
            return o1.getCheckInTime().compareTo(o2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<BillableResourcesReportDTO> BillableResourcesComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getResourceName().compareToIgnoreCase(o1.getResourceName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (o1.getCheckInTime() != null && o2.getCheckInTime() != null) {
            return o1.getCheckInTime().compareTo(o2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<TransactionsReportDTO> TransactionsComparator = (p1, p2) -> {
        int nameOrder = p1.getAppointmentStatus().compareToIgnoreCase(p2.getAppointmentStatus());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getCancelTime().compareTo(p2.getCancelTime());
    };
    static final Comparator<TransactionsReportDTO> TransactionsComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getAppointmentStatus().compareToIgnoreCase(p1.getAppointmentStatus());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getCancelTime().compareTo(p2.getCancelTime());
    };
    static final Comparator<DailyResourceReportDTO> DailyResourceComparator = (p1, p2) -> {
        int nameOrder = p1.getResourceName().compareTo(p2.getResourceName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<DailyResourceReportDTO> DailyResourceComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getResourceName().compareTo(p1.getResourceName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<DailyAdmReportDTO> DailyAdmNameComparator = (p1, p2) -> {
        int nameOrder = p1.getSubjectId().compareTo(p2.getSubjectId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getResourceName().compareTo(p2.getResourceName());
    };
    static final Comparator<DailyAdmReportDTO> DailyAdmNameComparatorDesc = (p1, p2) -> {
        int nameOrder = p1.getSubjectId().compareTo(p2.getSubjectId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p2.getResourceName().compareTo(p1.getResourceName());
    };
    static final Comparator<DailyAdmReportDTO> DailyAdmNameComparatorOrderingByTime = (p1, p2) -> p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    static final Comparator<MetaKitchenReportDTO> MetaKitchenNameComparator = (p1, p2) -> {
        int nameOrder = p1.getSubjectLastName().compareTo(p2.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<MetaKitchenReportDTO> MetaKitchenNameComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getSubjectLastName().compareTo(p1.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<MetaKitchenReportDTO> MetaKitchenByTimeComparator = (p1, p2) -> p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    static final Comparator<MetaKitchenReportDTO> MetaKitchenByTimeComparatorDesc = (p1, p2) -> p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    static final Comparator<DeptAndPiReportDTO> DeptAndPiComparator = (p1, p2) -> {
        int nameOrder = p1.getPiLastName().compareTo(p2.getPiLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInTime() != null && p2.getCheckInTime() != null) {
            return p1.getCheckInTime().compareTo(p2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<DeptAndPiReportDTO> DeptAndPiComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getPiLastName().compareTo(p1.getPiLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInTime() != null && p2.getCheckInTime() != null) {
            return p1.getCheckInTime().compareTo(p2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<BillingReportDTO> BillingComparator = (o1, o2) -> {
        int nameOrder = o1.getStudyName().compareToIgnoreCase(o2.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getCheckInTime().compareTo(o2.getCheckInTime());
    };
    static final Comparator<BillingReportDTO> BillingComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getStudyName().compareToIgnoreCase(o1.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getCheckInTime().compareTo(o2.getCheckInTime());
    };
    static final Comparator<BillingByInvestigatorReportDTO> BillingByInvestigatorComparator = (p1, p2) -> {
        int nameOrder = p1.getPiLastName().compareTo(p2.getPiLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInTime() != null && p2.getCheckInTime() != null) {
            return p1.getCheckInTime().compareTo(p2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<BillingByInvestigatorReportDTO> BillingByInvestigatorComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getPiLastName().compareTo(p1.getPiLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInTime() != null && p2.getCheckInTime() != null) {
            return p1.getCheckInTime().compareTo(p2.getCheckInTime());
        }
        return 0;
    };
    static final Comparator<CensusReportDTO> CensusComparator = (p1, p2) -> {
        int nameOrder = p1.getAsrName().compareTo(p2.getAsrName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getScheduledStartTime() != null && p2.getScheduledStartTime() != null) {
            return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
        }
        return 0;
    };
    static final Comparator<CensusReportDTO> CensusComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getAsrName().compareTo(p1.getAsrName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getScheduledStartTime() != null && p2.getScheduledStartTime() != null) {
            return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
        }
        return 0;
    };
    static final Comparator<LevelOfServiceReportDTO> LevelOfServiceComparator = (p1, p2) -> {
        int nameOrder = p1.getStudyName().compareTo(p2.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInDate() != null && p2.getCheckInDate() != null) {
            return p1.getCheckInDate().compareTo(p2.getCheckInDate());
        }
        return nameOrder;
    };
    static final Comparator<LevelOfServiceReportDTO> LevelOfServiceComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getStudyName().compareTo(p1.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        if (p1.getCheckInDate() != null && p2.getCheckInDate() != null) {
            return p1.getCheckInDate().compareTo(p2.getCheckInDate());
        }
        return nameOrder;
    };
    static final Comparator<StudySubjectVisitReportDTO> StudySubjectVisitComparator = (p1, p2) -> {
        int nameOrder = p1.getSubjectLastName().compareTo(p2.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<StudySubjectVisitReportDTO> StudySubjectVisitComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getSubjectLastName().compareTo(p1.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<StudyStatusChangeReportDTO> StudyStatusChangeComparator = (p1, p2) -> {
        int nameOrder = p1.getStudyName().compareTo(p2.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getDateStatusChange().compareTo(p2.getDateStatusChange());
    };
    static final Comparator<StudyStatusChangeReportDTO> StudyStatusChangeComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getStudyName().compareTo(p1.getStudyName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getDateStatusChange().compareTo(p2.getDateStatusChange());
    };
    static final Comparator<SubjectVisitHistoryReportDTO> SubjectVisitHistoryComparator = (p1, p2) -> {
        int nameOrder = p1.getSubjectLastName().compareTo(p2.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p1.getScheduledStartTime().compareTo(p2.getScheduledStartTime());
    };
    static final Comparator<SubjectVisitHistoryReportDTO> SubjectVisitHistoryComparatorDesc = (p1, p2) -> {
        int nameOrder = p2.getSubjectLastName().compareTo(p1.getSubjectLastName());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return p2.getScheduledStartTime().compareTo(p1.getScheduledStartTime());
    };
    static final Comparator<NutritionTasksReportDTO> NutritionTasksComparator = (o1, o2) -> {
        int nameOrder = o1.getLocalId().compareToIgnoreCase(o2.getLocalId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
    };
    static final Comparator<NutritionTasksReportDTO> NutritionTasksComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getLocalId().compareToIgnoreCase(o1.getLocalId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
    };
    static final Comparator<BookedVisitServiceLevelByVisitTypeReportDTO> BookedVisitLevelServiceComparatorString = (o1, o2) -> o1.getNursinglevel().compareTo(o2.getNursinglevel());
    static final Comparator<BookedVisitServiceLevelByVisitTypeReportDTO> BookedVisitLevelServiceComparator = (o1, o2) -> {
        int nameOrder = o1.getVisitId().compareTo(o2.getVisitId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o2.getNursinglevel().compareTo(o1.getNursinglevel());
    };
    static final Comparator<BookedVisitServiceLevelByVisitTypeReportDTO> BookedVisitLevelServiceComparatorDesc = (o1, o2) -> {
        int nameOrder = o2.getVisitId().compareTo(o1.getVisitId());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o2.getNursinglevel().compareTo(o1.getNursinglevel());
    };

    static String orEmpty(String s) {
        return s == null ? "" : s;
    }

    static void setStartAndEndTimeParameters(ReportDTO dto, Query query) {
        query.setParameter("startTime", (Object)dto.getStartTime());
        query.setParameter("endTime", (Object)dto.getEndTime());
    }

    private static void setSubjectDateParam(Query query, String subjectDob) {
        if (!subjectDob.isEmpty()) {
            query.setParameter("subjectDate", (Object)new Date(subjectDob));
        }
    }

    static String makeLevelMapKey(Integer visitId, String levelValue) {
        String levelString = ReportDAO.makeLevelString(levelValue);
        return "Visit" + visitId + levelString;
    }

    static String makeLevelString(String levelValue) {
        return "Level" + levelValue;
    }

    private static void logHqlQuery(List<?> results, Query query) {
        int numResults = results != null ? results.size() : -1;
        String logMessage = " HQL Query with " + numResults + " results\n" + query.getQueryString().trim();
        log.debug((Object)logMessage);
    }

    private static void logSqlQuery(List<?> results, Query query) {
        int numResults = results != null ? results.size() : -1;
        String logMessage = " SQL Query with " + numResults + " results\n" + query.getQueryString().trim();
        log.debug((Object)logMessage);
    }

    private void logCriteriaQuery(List<?> results, Criteria criteria, String description) {
        int numResults = results != null ? results.size() : -1;
        String logMessage = " Criteria Query with " + numResults + " results\n" + criteria.toString().trim() + "\n" + description.toString().trim();
        log.debug((Object)logMessage);
    }

    public List<Report> getReports() {
        Criteria criteria = this.newCriteria(Report.class).addOrder(Order.asc((String)"title"));
        List result = criteria.list();
        this.logCriteriaQuery(result, criteria, "order by 'title', ascending");
        return result;
    }

    public List<ResourceType> getResourceTypes() {
        return ResourceType.valueList();
    }

    public List<Sublocation> getSublocations() {
        Criteria criteria = this.newCriteria(Sublocation.class).addOrder(Order.asc((String)"name"));
        List sublocations = criteria.list();
        Predicate<Sublocation> isNonCrcOrOffInstitution = sl -> sl.getName().equalsIgnoreCase("Non CRC") || sl.getName().equalsIgnoreCase("Off Institution");
        List otherSublocationList = ListUtils.enrich((List)sublocations).filter(isNonCrcOrOffInstitution).toList();
        sublocations.removeAll(otherSublocationList);
        sublocations.addAll(otherSublocationList);
        return sublocations;
    }

    public Report getReportDataById(int id) {
        return this.findById(Report.class, id);
    }

    InstitutionRole findInstitutionRoleByType(InstitutionRoleType type) {
        Criteria criteria = this.newCriteria(InstitutionRole.class).add((Criterion)Restrictions.eq((String)"type", (Object)type));
        return (InstitutionRole)criteria.uniqueResult();
    }

    public List<UserReportDTO> getUserDataReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        Criteria crit = this.newCriteria(User.class);
        Optional<UserDataReportFilterStrategy> filterStrategyOption = UserDataReportFilterStrategy.fromIdString(filterid);
        if (filterStrategyOption.isPresent()) {
            crit.add(filterStrategyOption.get().makeCriterion(this, filterString));
        }
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        crit.addOrder(sortStrategy.makeOrder("lastName"));
        List users = crit.list();
        this.logCriteriaQuery(users, crit, "order by 'lastName', default:ascending. actual sortId <" + sortid + ">. may filter on filterId <" + filterid + "> and filterString <" + filterString + ">");
        List<UserReportDTO> userReportDTOS = users.stream().map(u -> new UserReportDTO((User)u)).collect(Collectors.toList());
        dto.setUserDataReport(userReportDTOS);
        return userReportDTOS;
    }

    public List<ProtoNurseReportDTO> getProtoNurseAndNutritionReport(ReportDTO dto) {
        String whereSubClause;
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = "select u.id, u.firstName, u.middleName, u.lastName, s.name, s.spid, s.catalystId, s.localId, s.studyStatus.name, s.irb, s.irbExpiration from User u, Study s where ";
        if (dto.getName().equalsIgnoreCase("proto_nutritionist")) {
            baseHql = baseHql + " s.protocolNutritionist = u.id ";
        } else if (dto.getName().equalsIgnoreCase("proto_by_nurse")) {
            baseHql = baseHql + " s.protocolNurse = u.id ";
        }
        Map filterIdsToColumns = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"1", (Object)"u.lastName"), Pair.pair((Object)"2", (Object)"s.localId"), Pair.pair((Object)"3", (Object)"s.studyStatus.name")});
        if (filterIdsToColumns.containsKey(filterid)) {
            String columnName = (String)filterIdsToColumns.get(filterid);
            whereSubClause = " and " + columnName + " like '%" + filterString + "%' ";
        } else {
            whereSubClause = "";
        }
        String groupByClause = " group by s.id ";
        String sortByColumnName = "u.lastName";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("u.lastName", sortStrategy);
        String hql = baseHql + whereSubClause + " group by s.id " + orderByClause;
        Query query = this.session().createQuery(hql);
        List queryResults = query.list();
        ReportDAO.logHqlQuery(queryResults, query);
        List protoNurseNutritionReportDtos = ListUtils.enrich((List)queryResults).map(resultRow -> ProtoNurseReportDTO.fromArray(resultRow)).toList();
        dto.setProtoNurseNutritionReport(protoNurseNutritionReportDtos);
        return protoNurseNutritionReportDtos;
    }

    public List<StaffAuditSubjectViewsReportDTO> getStaffAuditSubjectViewsReport(ReportDTO dto, User user) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        InstitutionRoleType institutionRoleType = user.getInstitutionRole().getType();
        String groupByClause = " group by al.affectedSubject, u.id, al.actionPerformed, al.date ";
        String baseHql = "select sm, al.actionPerformed, al.date, al.ipAddress, u.firstName, u.middleName, u.lastName, u.id, u.ecommonsId from ActivityLog al, SubjectMrn sm, User u  where al.date >= :startTime and al.date <= :endTime and al.affectedSubject = sm.subject.id and al.performingUser = u.id ";
        String baseHqlWithParams = institutionRoleType == InstitutionRoleType.ROLE_SUPER_ADMIN ? "select sm, al.actionPerformed, al.date, al.ipAddress, u.firstName, u.middleName, u.lastName, u.id, u.ecommonsId from ActivityLog al, SubjectMrn sm, User u  where al.date >= :startTime and al.date <= :endTime and al.affectedSubject = sm.subject.id and al.performingUser = u.id " : "select sm, al.actionPerformed, al.date, al.ipAddress, u.firstName, u.middleName, u.lastName, u.id, u.ecommonsId from ActivityLog al, SubjectMrn sm, User u  where al.date >= :startTime and al.date <= :endTime and al.affectedSubject = sm.subject.id and al.performingUser = u.id  and u.id = :currentUser ";
        String filterClause = "1".equalsIgnoreCase(filterid) ? " and u.lastName like '%" + filterString + "%' " : ("2".equalsIgnoreCase(filterid) ? " and u.ecommonsId like '%" + filterString + "%' " : "");
        String hql = baseHqlWithParams + filterClause + " group by al.affectedSubject, u.id, al.actionPerformed, al.date ";
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        if (institutionRoleType != InstitutionRoleType.ROLE_SUPER_ADMIN) {
            query.setParameter("currentUser", (Object)user.getId());
        }
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList finalList = Lists.newArrayList();
        for (Object[] resultRow : resultRows) {
            SubjectMrn subjectMrn = (SubjectMrn)resultRow[0];
            if (subjectMrn.getSubject().getArchivalStatus() != null) continue;
            StaffAuditSubjectViewsReportDTO localDto = new StaffAuditSubjectViewsReportDTO();
            localDto.setSubjectId(subjectMrn.getId());
            localDto.setSubjectFirstName(SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getFirstName()));
            localDto.setSubjectMiddleName(SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getMiddleName()));
            localDto.setSubjectLastName(SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getLastName()));
            localDto.setMrn(SubjectDataEncryptor.decrypt(subjectMrn.getMrn()));
            localDto.setActionPerformed((String)resultRow[1]);
            localDto.setDate((Date)resultRow[2]);
            localDto.setIpAddress((String)resultRow[3]);
            localDto.setUserFirstName((String)resultRow[4]);
            localDto.setUserMiddleName((String)resultRow[5]);
            localDto.setUserLastName((String)resultRow[6]);
            localDto.setUserId((Integer)resultRow[7]);
            localDto.setEcommons((String)resultRow[8]);
            finalList.add(localDto);
        }
        Optional<SortStrategy> sortStrategyOption = SortStrategy.fromIdString(sortid);
        ArrayList sortedStaffAuditSubjectViewsReportDTOs = Lists.newArrayList((Iterable)finalList);
        if (sortStrategyOption.isPresent()) {
            if (sortStrategyOption.get() == SortStrategy.ASCENDING) {
                Collections.sort(sortedStaffAuditSubjectViewsReportDTOs, StaffAuditNameComparator);
            } else {
                Collections.sort(sortedStaffAuditSubjectViewsReportDTOs, StaffAuditNameComparatorDesc);
            }
        } else {
            Collections.sort(sortedStaffAuditSubjectViewsReportDTOs, StaffAuditNameComparator);
        }
        dto.setStaffAuditSubjectViewsReport(sortedStaffAuditSubjectViewsReportDTOs);
        return sortedStaffAuditSubjectViewsReportDTOs;
    }

    public List<SubjectAuditStaffViewsReportDTO> getSubjectAuditStaffViewsReport(ReportDTO dto) {
        String sortid = dto.getSortId();
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String baseHql = "select al.performingUser, al.actionPerformed, al.date, al.ipAddress, sm from ActivityLog al, SubjectMrn sm where al.date >= :startTime and al.date <= :endTime and sm.mrn = :mrn and al.affectedSubject = sm.subject.id  and sm.subject.archivalStatus IS NULL ";
        String filterClause = "1".equalsIgnoreCase(filterid) ? " and al.performingUser.lastName like '%" + filterString + "%' " : "";
        String sortByColumnName = "al.date";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("al.date", sortStrategy);
        Query query = this.session().createQuery("select al.performingUser, al.actionPerformed, al.date, al.ipAddress, sm from ActivityLog al, SubjectMrn sm where al.date >= :startTime and al.date <= :endTime and sm.mrn = :mrn and al.affectedSubject = sm.subject.id  and sm.subject.archivalStatus IS NULL " + filterClause + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        query.setParameter("mrn", (Object)SubjectDataEncryptor.encrypt(dto.getMrn().toUpperCase()));
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList subjectAuditStaffViewsReportDTOs = Lists.newArrayList();
        for (Object[] resultRow : resultRows) {
            SubjectAuditStaffViewsReportDTO newObj = new SubjectAuditStaffViewsReportDTO();
            newObj.setUserId((User)resultRow[0]);
            newObj.setActionPerformed((String)resultRow[1]);
            newObj.setDate((Date)resultRow[2]);
            newObj.setIpAddress((String)resultRow[3]);
            SubjectMrn subjectMrn = (SubjectMrn)resultRow[4];
            newObj.setSubjectName(SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getFullName()));
            newObj.setSubjectId(subjectMrn.getId());
            subjectAuditStaffViewsReportDTOs.add(newObj);
        }
        dto.setSubjectAuditStaffViewsReport(subjectAuditStaffViewsReportDTOs);
        return subjectAuditStaffViewsReportDTOs;
    }

    public List<OverrideReportDTO> getOverrideReport(ReportDTO dto) {
        String filterString;
        String filterid;
        String sortid = dto.getSortId();
        if ("0".equals(dto.getFilterId())) {
            filterid = null;
            filterString = null;
        } else {
            filterString = dto.getFilterString();
            filterid = dto.getFilterId();
        }
        String baseHql = "select al from ActivityLog al where (al.appointmentOverrideReason IS NOT NULL) and  al.actionPerformed != 'OVERBOOK' and al.actionPerformed != 'ROOM RESERVED' and al.date >= :startTime and al.date <= :endTime ";
        String filterClause = this.setOverrideReportFilterClause(filterString, filterid);
        String sortByColumnName = "al.performingUser.ecommonsId";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("al.performingUser.ecommonsId", sortStrategy);
        Query query = this.session().createQuery("select al from ActivityLog al where (al.appointmentOverrideReason IS NOT NULL) and  al.actionPerformed != 'OVERBOOK' and al.actionPerformed != 'ROOM RESERVED' and al.date >= :startTime and al.date <= :endTime " + filterClause + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List activityLogs = query.list();
        ReportDAO.logHqlQuery(activityLogs, query);
        Comparator<ActivityLog> ordering = sortStrategy == SortStrategy.ASCENDING ? OverrideComparator : OverrideComparatorDesc;
        Collections.sort(activityLogs, ordering);
        List<OverrideReportDTO> overrideReportDTOS = activityLogs.stream().map(al -> new OverrideReportDTO((ActivityLog)al)).collect(Collectors.toList());
        dto.setOverrideReport(overrideReportDTOS);
        return overrideReportDTOS;
    }

    protected String setOverrideReportFilterClause(String filterString, String filterid) {
        String filterClause = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? " and al.performingUser.ecommonsId like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid) ? " and al.bookedVisit.visitTemplate.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid) ? " and al.bookedVisit.study.localId like '%" + filterString + "%' " : ("4".equals(filterid) ? " and al.appointmentOverrideReason.id like '%1%' " : ("5".equals(filterid) ? " and al.appointmentOverrideReason.id like '%2%' " : ("6".equals(filterid) ? " and al.appointmentOverrideReason.id like '%3%' " : ("7".equals(filterid) ? " and al.appointmentOverrideReason.id like '%4%' " : ("8".equals(filterid) ? " and al.appointmentOverrideReason.id like '%5%' " : ("9".equals(filterid) ? " and al.appointmentOverrideReason.id like '%6%' " : ("10".equals(filterid) ? " and al.appointmentOverrideReason.id like '%7%' " : "")))))))));
        return filterClause;
    }

    public List<SubjectPurgeReportDTO> getSubjectPurgeReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        if (filterid != null && ("1".equals(filterid) || "2".equals(filterid))) {
            filterString = SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase());
        }
        String hql = " select s.firstName, s.middleName, s.lastName, sm.mrn, s.createdDate  from Subject s, SubjectMrn sm, BookedVisit bv where bv.subjectMrn = sm.id and sm.subject = s.id  and s.archivalStatus IS NULL ";
        String hql2 = " select s.firstName, s.middleName, s.lastName, sm.mrn, s.createdDate, u.firstName, u.middleName, u.lastName  from Subject s, ActivityLog al, SubjectMrn sm, User u where sm.subject = s.id and al.affectedSubject = s.id and  al.actionPerformed = 'CREATE SUBJECT' and al.performingUser = u.id  and s.archivalStatus IS NULL ";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            hql2 = hql2 + " and s.lastName like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            hql2 = hql2 + " and sm.mrn like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            hql2 = hql2 + " and u.lastName like '%" + filterString + "%' ";
        }
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery(" select s.firstName, s.middleName, s.lastName, sm.mrn, s.createdDate  from Subject s, SubjectMrn sm, BookedVisit bv where bv.subjectMrn = sm.id and sm.subject = s.id  and s.archivalStatus IS NULL ");
        Query query2 = session.createQuery(hql2);
        List list = query.list();
        ReportDAO.logHqlQuery(list, query);
        ArrayList resultList = Lists.newArrayList();
        ArrayList resultList2 = Lists.newArrayList();
        for (Object obj : list) {
            SubjectPurgeReportDTO newDto = new SubjectPurgeReportDTO();
            newDto.setFirstName(SubjectDataEncryptor.decrypt((String)obj[0]));
            newDto.setMiddleName(SubjectDataEncryptor.decrypt((String)obj[1]));
            newDto.setLastName(SubjectDataEncryptor.decrypt((String)obj[2]));
            newDto.setMrn(SubjectDataEncryptor.decrypt((String)obj[3]));
            newDto.setCreateTime((Date)obj[4]);
            newDto.setUserFirstName(null);
            newDto.setUserMiddleName(null);
            newDto.setUserLastName(null);
            resultList.add(newDto);
        }
        List list2 = query2.list();
        ReportDAO.logHqlQuery(list2, query);
        for (Object[] obj : list2) {
            SubjectPurgeReportDTO newDto = new SubjectPurgeReportDTO();
            newDto.setFirstName(SubjectDataEncryptor.decrypt((String)obj[0]));
            newDto.setMiddleName(SubjectDataEncryptor.decrypt((String)obj[1]));
            newDto.setLastName(SubjectDataEncryptor.decrypt((String)obj[2]));
            newDto.setMrn(SubjectDataEncryptor.decrypt((String)obj[3]));
            newDto.setCreateTime((Date)obj[4]);
            newDto.setUserFirstName((String)obj[5]);
            newDto.setUserMiddleName((String)obj[6]);
            newDto.setUserLastName((String)obj[7]);
            resultList2.add(newDto);
        }
        for (int i = 0; i < resultList.size(); ++i) {
            for (int j = 0; j < resultList2.size(); ++j) {
                if (!((SubjectPurgeReportDTO)resultList2.get(j)).getMrn().equals(((SubjectPurgeReportDTO)resultList.get(i)).getMrn())) continue;
                resultList2.remove(j);
            }
        }
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        Comparator<SubjectPurgeReportDTO> ordering = sortStrategy == SortStrategy.DESCENDING ? SubjectPurgeNameComparatorDesc : SubjectPurgeNameComparator;
        Collections.sort(resultList2, ordering);
        dto.setSubjectPurgeReport(resultList2);
        return resultList2;
    }

    public List<OffUnitReportDTO> getOffUnitReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterId = dto.getFilterId();
        String sortId = dto.getSortId();
        String baseHql = "select bv.id, bv.scheduledStartTime, bv.scheduledEndTime, st.localId, st.irb, vt.name, s.firstName, s.middleName, s.lastName, sm.mrn, s.gender, s.birthdate, r.name, br.scheduledStartTime, br.scheduledEndTime, vt.visitType, vt.comment, bv.appointmentStatus from BookedVisit bv, Study st, VisitTemplate vt, SubjectMrn sm, Subject s, BookedResource br, Resource r where bv.appointmentStatus.isActive = TRUE AND bv.visitTemplate = vt.id and br.bookedVisit = bv.id and bv.study = st.id and br.resource = r.id and bv.subjectMrn = sm.id and sm.subject = s.id and s.archivalStatus IS NULL and (   (vt.visitType.name in (       'Outpatient Non CRC',       'Outpatient Off Institution',       'Inpatient Non CRC',       'Inpatient Off Institution'       ))    OR (vt.sublocation.name LIKE '%Non CRC%')    OR (vt.sublocation.name LIKE '%Off Institution%')    OR (vt.nonInstitutionNonCRC is TRUE)    OR (vt.institutionNonCRC is TRUE)) and ((:startTime between br.scheduledStartTime and br.scheduledEndTime)  or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime))";
        String filterClause = this.setOffUnitReportFilterClause(filterString, filterId);
        String sortByColumnName = "bv.name, bv.id";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortId).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("bv.name, bv.id", sortStrategy);
        Query query = this.session().createQuery("select bv.id, bv.scheduledStartTime, bv.scheduledEndTime, st.localId, st.irb, vt.name, s.firstName, s.middleName, s.lastName, sm.mrn, s.gender, s.birthdate, r.name, br.scheduledStartTime, br.scheduledEndTime, vt.visitType, vt.comment, bv.appointmentStatus from BookedVisit bv, Study st, VisitTemplate vt, SubjectMrn sm, Subject s, BookedResource br, Resource r where bv.appointmentStatus.isActive = TRUE AND bv.visitTemplate = vt.id and br.bookedVisit = bv.id and bv.study = st.id and br.resource = r.id and bv.subjectMrn = sm.id and sm.subject = s.id and s.archivalStatus IS NULL and (   (vt.visitType.name in (       'Outpatient Non CRC',       'Outpatient Off Institution',       'Inpatient Non CRC',       'Inpatient Off Institution'       ))    OR (vt.sublocation.name LIKE '%Non CRC%')    OR (vt.sublocation.name LIKE '%Off Institution%')    OR (vt.nonInstitutionNonCRC is TRUE)    OR (vt.institutionNonCRC is TRUE)) and ((:startTime between br.scheduledStartTime and br.scheduledEndTime)  or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime))" + filterClause + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList offUnitReportDTOs = Lists.newArrayList();
        ArrayList inpatientList = Lists.newArrayList();
        ArrayList outpatientList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            OffUnitReportDTO newObj = new OffUnitReportDTO();
            newObj.setBookedVisitId((Integer)row[0]);
            newObj.setScheduledStartTime((Date)row[1]);
            newObj.setScheduledEndTime((Date)row[2]);
            newObj.setLocalId((String)row[3]);
            newObj.setIrb((String)row[4]);
            newObj.setVisitName((String)row[5]);
            newObj.setFirstName(SubjectDataEncryptor.decrypt((String)row[6]));
            newObj.setMiddleName(SubjectDataEncryptor.decrypt((String)row[7]));
            newObj.setLastName(SubjectDataEncryptor.decrypt((String)row[8]));
            newObj.setMrn(SubjectDataEncryptor.decrypt((String)row[9]));
            newObj.setGenderName(((Gender)row[10]).getName());
            newObj.setBirthdate((Date)row[11]);
            newObj.setResourceName((String)row[12]);
            newObj.setResourceStartTime((Date)row[13]);
            newObj.setResourceEndTime((Date)row[14]);
            VisitType visitType = (VisitType)row[15];
            newObj.setVisitType(visitType.getName());
            newObj.setComment((String)row[16]);
            newObj.setVisitStatus(((AppointmentStatus)row[17]).getName());
            if (visitType.isOutpatient()) {
                outpatientList.add(newObj);
                continue;
            }
            inpatientList.add(newObj);
        }
        Comparator<OffUnitReportDTO> ordering = sortStrategy == SortStrategy.DESCENDING ? OffUnitComparatorDesc : OffUnitComparator;
        Collections.sort(inpatientList, ordering);
        Collections.sort(outpatientList, ordering);
        offUnitReportDTOs.addAll(inpatientList);
        offUnitReportDTOs.addAll(outpatientList);
        dto.setOffUnitReport(offUnitReportDTOs);
        return offUnitReportDTOs;
    }

    private String setOffUnitReportFilterClause(String filterString, String filterId) {
        String filterClause;
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterId)) {
            filterClause = " and vt.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterId)) {
            filterClause = " and st.localId like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterId)) {
            String encryptedName = SubjectDataEncryptor.encrypt(filterString.toUpperCase());
            filterClause = " and s.lastName = '" + encryptedName + "' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterId)) {
            filterClause = " and vt.visitType.name like '%" + filterString + "%' ";
        } else if ("5".equals(filterId)) {
            filterClause = " and st.crcFunded = false ";
        } else if ("6".equals(filterId)) {
            filterClause = " and r.resourceType like '%Nursing%' ";
        } else if ("7".equals(filterId)) {
            filterClause = " and r.resourceType like '%Nutrition%' ";
        } else if ("8".equals(filterId)) {
            filterClause = " and r.resourceType like '%Room%' ";
        } else if ("9".equals(filterId)) {
            filterClause = " and r.resourceType like '%Lab%' ";
        } else if ("10".equals(filterId)) {
            filterClause = " and r.resourceType like '%Other%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "11".equals(filterId)) {
            String encryptedMrn = SubjectDataEncryptor.encrypt(filterString.toUpperCase());
            filterClause = " and sm.mrn = '" + encryptedMrn + "' ";
        } else {
            filterClause = " ";
        }
        return filterClause;
    }

    public List<DailyOverviewReportDTO> getDailyOverviewReport(ReportDTO dto) {
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String filterString = "3".equals(filterid) || "4".equals(filterid) ? SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase()) : dto.getFilterString();
        String scheduledCheckedInOrHoldApptStatus = "(1,2,5)";
        String baseHql = "select bv, br from BookedResource br,  BookedVisit bv LEFT JOIN bv.subjectMrn sm LEFT JOIN sm.subject s WITH s.archivalStatus IS NULL where bv.appointmentStatus.isOpen = TRUE and br.bookedVisit = bv.id  and ((:startTime between br.scheduledStartTime and br.scheduledEndTime)  or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime))";
        String filterClause = this.setDailyOverviewReportFilterClause(filterid, filterString);
        Optional<SortStrategy> sortStrategyOption = SortStrategy.fromIdString(sortid);
        String orderByClause = sortStrategyOption.isPresent() ? sortStrategyOption.get().makeHqlOrderBySubClause("bv.id") : " order by bv.id ";
        Query query = this.session().createQuery("select bv, br from BookedResource br,  BookedVisit bv LEFT JOIN bv.subjectMrn sm LEFT JOIN sm.subject s WITH s.archivalStatus IS NULL where bv.appointmentStatus.isOpen = TRUE and br.bookedVisit = bv.id  and ((:startTime between br.scheduledStartTime and br.scheduledEndTime)  or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime))" + filterClause + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        ArrayList outpatientList = Lists.newArrayList();
        ArrayList inpatientList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            DailyOverviewReportDTO newObj = new DailyOverviewReportDTO();
            BookedVisit visit = (BookedVisit)row[0];
            newObj.setBookedVisitId(visit.getId());
            newObj.setScheduledStartTime(visit.getScheduledStartTime());
            newObj.setScheduledEndTime(visit.getScheduledEndTime());
            newObj.setLocalId(visit.getStudy().getLocalId());
            newObj.setIrb(visit.getStudy().getIrb());
            newObj.setVisitName(visit.getVisitTemplate().getName());
            this.populateActualOrHoldSubject(newObj, visit);
            BookedResource resource = (BookedResource)row[1];
            newObj.setResourceName(resource.getResource().getName());
            newObj.setResourceStartTime(resource.getScheduledStartTime());
            newObj.setResourceEndTime(resource.getScheduledEndTime());
            newObj.setVisitType(visit.getVisitType().getName());
            if (visit.getVisitTemplate().getInstitutionNonCRC().booleanValue() || visit.getVisitTemplate().getNonInstitutionNonCRC().booleanValue()) {
                newObj.setOffInstitution("YES");
            } else {
                newObj.setOffInstitution("NO");
            }
            newObj.setComment(visit.getComment());
            newObj.setSublocationName(visit.getVisitTemplate().getSublocation().getName());
            newObj.setVisitStatus(visit.getAppointmentStatus().getName());
            if (MiscUtil.isNonNullNonEmpty(filterString) && "5".equals(filterid)) {
                if ("yes".equalsIgnoreCase(filterString) && (visit.getVisitTemplate().getInstitutionNonCRC().booleanValue() || visit.getVisitTemplate().getNonInstitutionNonCRC().booleanValue())) {
                    if (visit.getVisitType().isOutpatient()) {
                        outpatientList.add(newObj);
                        continue;
                    }
                    inpatientList.add(newObj);
                    continue;
                }
                if (!"no".equalsIgnoreCase(filterString) || visit.getVisitTemplate().getInstitutionNonCRC().booleanValue() || visit.getVisitTemplate().getNonInstitutionNonCRC().booleanValue()) continue;
                if (visit.getVisitType().isOutpatient()) {
                    outpatientList.add(newObj);
                    continue;
                }
                inpatientList.add(newObj);
                continue;
            }
            if (visit.getVisitType().isOutpatient()) {
                outpatientList.add(newObj);
                continue;
            }
            inpatientList.add(newObj);
        }
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        Comparator<DailyOverviewReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? DailyOverviewComparator : DailyOverviewComparatorDesc;
        Collections.sort(inpatientList, ordering);
        resultList.addAll(inpatientList);
        Collections.sort(outpatientList, ordering);
        resultList.addAll(outpatientList);
        dto.setDailyOverviewReport(resultList);
        return resultList;
    }

    void populateActualOrHoldSubject(DailyOverviewReportDTO dto, BookedVisit visit) {
        SubjectMrn decryptedSubjectMrn = visit.getSubjectMrnDecrypted();
        if (decryptedSubjectMrn != null) {
            Subject decryptedSubject = visit.getSubjectMrnDecrypted().getSubject();
            dto.setFirstName(decryptedSubject.getFirstName());
            dto.setMiddleName(decryptedSubject.getMiddleName());
            dto.setLastName(decryptedSubject.getLastName());
            dto.setMrn(visit.getSubjectMrnDecrypted().getMrn());
            dto.setGenderName(decryptedSubject.getGender().getName());
            Date subDate = new Date(decryptedSubject.getBirthdate().getTime());
            String birthDateString = DateUtility.format(DateUtility.monthDayYear(), subDate);
            dto.setBirthdate(birthDateString);
        } else {
            dto.setFirstName("");
            dto.setMiddleName("");
            dto.setLastName("No Subject Assigned");
            dto.setMrn("No Subject Assigned");
            dto.setGenderName("No Subject Assigned");
            dto.setBirthdate("No Subject Assigned");
        }
    }

    private String setDailyOverviewReportFilterClause(String filterid, String filterString) {
        String filterClause = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? " and bv.study.localId like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid) ? " and bv.visitTemplate.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid) ? " and (s.lastName like '%" + filterString + "%') " : (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid) ? " and (sm.mrn like '%" + filterString + "%') " : (MiscUtil.isNonNullNonEmpty(filterString) && "6".equals(filterid) ? " and br.resource.resourceType like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "7".equals(filterid) ? " and bv.visitTemplate.sublocation.name like '%" + filterString + "%' " : " ")))));
        return filterClause;
    }

    public List<NursingAndRoomDailyOverviewReportDTO> getExportDailyOverviewReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        if (filterid != null && ("3".equals(filterid) || "4".equals(filterid))) {
            filterString = SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase());
        }
        String hql = "select distinct bv.id, bv.scheduledStartTime, bv.scheduledEndTime, st.localId, st.irb, v.name, s.firstName, s.middleName, s.lastName, sm.mrn, s.gender, s.birthdate, r.name, br.scheduledStartTime, br.scheduledEndTime, bv.visitTemplate, v.institutionNonCRC, v.nonInstitutionNonCRC, br.id, bv.comment, bv.appointmentStatus from BookedResource br join br.bookedVisit bv join bv.subjectMrn sm join sm.subject s join bv.visitTemplate v join bv.study st join br.resource r  where bv.appointmentStatus.isActive = TRUE and s.archivalStatus IS NULL and ((:startTime between br.scheduledStartTime and br.scheduledEndTime) or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) and r.resourceType in ('Room') ";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            hql = hql + " and st.localId like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            hql = hql + " and v.name like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            hql = hql + " and s.lastName like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            hql = hql + " and sm.mrn like '%" + filterString + "%' ";
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "5".equals(filterid)) {
            hql = hql + " and r.resourceType like '%" + filterString + "%' ";
        }
        hql = hql + " group by br.id ";
        if (sortid != null && sortid.length() > 0 && "1".equalsIgnoreCase(sortid)) {
            hql = hql + " order by bv.scheduledStartTime ASC ";
        }
        if (sortid != null && sortid.length() > 0 && "2".equalsIgnoreCase(sortid)) {
            hql = hql + " order by bv.scheduledStartTime DESC ";
        }
        if (sortid == null) {
            hql = hql + " order by bv.scheduledStartTime ASC ";
        }
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRow = query.list();
        ReportDAO.logHqlQuery(resultRow, query);
        ArrayList resultList = Lists.newArrayList();
        ArrayList outpatientList = Lists.newArrayList();
        for (Object[] row : resultRow) {
            NursingAndRoomDailyOverviewReportDTO newObj = new NursingAndRoomDailyOverviewReportDTO();
            newObj.setBookedVisitId((Integer)row[0]);
            newObj.setScheduledStartTime((Date)row[1]);
            newObj.setScheduledEndTime((Date)row[2]);
            newObj.setLocalId((String)row[3]);
            newObj.setIrb((String)row[4]);
            newObj.setVisitName((String)row[5]);
            newObj.setFirstName(SubjectDataEncryptor.decrypt((String)row[6]));
            newObj.setMiddleName(SubjectDataEncryptor.decrypt((String)row[7]));
            newObj.setLastName(SubjectDataEncryptor.decrypt((String)row[8]));
            newObj.setMrn(SubjectDataEncryptor.decrypt((String)row[9]));
            newObj.setGenderName(((Gender)row[10]).getName());
            if ((Date)row[11] != null) {
                Date subDate = new Date(((Date)row[11]).getTime());
                String subjectDate = DateUtility.format(DateUtility.monthDayYear(), subDate);
                newObj.setBirthdate(subjectDate);
            }
            newObj.setResourceName((String)row[12]);
            newObj.setResourceStartTime((Date)row[13]);
            newObj.setResourceEndTime((Date)row[14]);
            VisitType visitType = ((VisitTemplate)row[15]).getVisitType();
            newObj.setVisitType(visitType.getName());
            if (((Boolean)row[16]).booleanValue() || ((Boolean)row[17]).booleanValue()) {
                newObj.setOffInstitution("YES");
            } else {
                newObj.setOffInstitution("NO");
            }
            if (MiscUtil.isNonNullNonEmpty(filterString) && "5".equals(filterid)) {
                if ("yes".equalsIgnoreCase(filterString) && (((Boolean)row[16]).booleanValue() || ((Boolean)row[17]).booleanValue())) {
                    if (visitType.isOutpatient()) {
                        outpatientList.add(newObj);
                    } else {
                        resultList.add(newObj);
                    }
                } else if ("no".equalsIgnoreCase(filterString) && !((Boolean)row[16]).booleanValue() && !((Boolean)row[17]).booleanValue()) {
                    if (visitType.isOutpatient()) {
                        outpatientList.add(newObj);
                    } else {
                        resultList.add(newObj);
                    }
                }
            } else if (visitType.isOutpatient()) {
                outpatientList.add(newObj);
            } else {
                resultList.add(newObj);
            }
            newObj.setComment((String)row[19]);
            newObj.setVisitStatus(((AppointmentStatus)row[20]).getName());
        }
        Collections.sort(outpatientList, DailyOverviewComparator);
        resultList.addAll(outpatientList);
        dto.setNursingAndRoomDailyOverviewReport(resultList);
        return resultList;
    }

    public List<WeeklyPharmReportDTO> getWeeklyPharmReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        if ("3".equals(filterid)) {
            filterString = SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase());
        }
        String hql = "select st.id, st.name, st.catalystId, st.localId, st.irb, s.firstName, s.middleName, s.lastName, s.gender, sm.mrn, v.name, bv.scheduledStartTime, bv.scheduledEndTime, bv.appointmentStatus from Subject s, BookedVisit bv, Study st, SubjectMrn sm, VisitTemplate v where bv.study = st.id and bv.subjectMrn = sm.id and sm.subject = s.id and bv.visitTemplate = v.id  and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  and bv.appointmentStatus.isActive = TRUE and v.researchPharmacy = 1 and s.archivalStatus IS NULL ";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            hql = hql + " and st.localId like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            hql = hql + " and st.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            hql = hql + " and s.lastName like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            hql = hql + " and bv.scheduledStartTime like :scheduleTime ";
        } else if ("5".equals(filterid)) {
            hql = hql + " and st.crcFunded = false ";
        }
        String sortByColumnName = "st.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("st.name", sortStrategy);
        Query query = this.session().createQuery(hql + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            Timestamp timestamp = DateUtility.formatFilterByDateTime(filterString);
            query.setParameter("scheduleTime", (Object)timestamp);
        }
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            WeeklyPharmReportDTO newObj = new WeeklyPharmReportDTO();
            newObj.setStudyId((Integer)row[0]);
            newObj.setStudyName((String)row[1]);
            newObj.setCatalystId((String)row[2]);
            newObj.setLocalId((String)row[3]);
            newObj.setIrb((String)row[4]);
            newObj.setFirstName(SubjectDataEncryptor.decrypt((String)row[5]));
            newObj.setMiddleName(SubjectDataEncryptor.decrypt((String)row[6]));
            newObj.setLastName(SubjectDataEncryptor.decrypt((String)row[7]));
            newObj.setGenderName(((Gender)row[8]).getName());
            newObj.setMrn(SubjectDataEncryptor.decrypt((String)row[9]));
            newObj.setVisitName((String)row[10]);
            newObj.setScheduledStartTime((Date)row[11]);
            newObj.setScheduledEndTime((Date)row[12]);
            newObj.setAppointmentStatus(((AppointmentStatus)row[13]).getName());
            resultList.add(newObj);
        }
        Comparator<WeeklyPharmReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? WeeklyPharmComparator : WeeklyPharmComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setWeeklyPharmReport(resultList);
        return resultList;
    }

    public List<StudyVisitLocationReportDTO> getStudyVisitLocationReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String hql = "select bv.id, v.name, sl.name, bv.checkInDate, bv.checkOutDate, s.firstName, s.middleName, s.lastName, sm.mrn, s.gender, st.name, st.catalystId, st.localId, st.irb, sl.id, v.visitType.name from VisitTemplate v, BookedVisit bv, Sublocation sl, Subject s, Study st, SubjectMrn sm where bv.visitTemplate = v.id and bv.study = st.id and s.archivalStatus IS NULL and bv.subjectMrn = sm.id and sm.subject = s.id and bv.appointmentStatus.isServiced = TRUE and v.sublocation = sl.id and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            hql = hql + " and st.localId like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            hql = hql + " and v.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            hql = hql + " and sl.name like '%" + filterString + "%' ";
        } else if ("4".equals(filterid)) {
            hql = hql + " and st.crcFunded = false ";
        }
        String groupByClause = " group by bv.id ";
        hql = hql + " group by bv.id ";
        String sortByColumnName = "sl.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("sl.name", sortStrategy);
        Query query = this.session().createQuery(hql + orderByClause);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] rows : resultRows) {
            StudyVisitLocationReportDTO newObj = new StudyVisitLocationReportDTO();
            newObj.setVisitTypeId((Integer)rows[0]);
            newObj.setVisitTypeName((String)rows[1]);
            newObj.setSublocationName((String)rows[2]);
            newObj.setCheckInTime((Date)rows[3]);
            newObj.setCheckOutTime((Date)rows[4]);
            newObj.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)rows[5]));
            newObj.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)rows[6]));
            newObj.setSubjectLastName(SubjectDataEncryptor.decrypt((String)rows[7]));
            newObj.setMrn(SubjectDataEncryptor.decrypt((String)rows[8]));
            newObj.setGenderName(((Gender)rows[9]).getName());
            newObj.setStudyName((String)rows[10]);
            newObj.setCatalystId((String)rows[11]);
            newObj.setLocalId((String)rows[12]);
            newObj.setIrb((String)rows[13]);
            newObj.setVisitId((Integer)rows[14]);
            newObj.setVisitType((String)rows[15]);
            resultList.add(newObj);
        }
        Comparator<StudyVisitLocationReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? StudyVisitLocationComparatorAsc : StudyVisitLocationComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setStudyVisitLocationReport(resultList);
        return resultList;
    }

    public List<BillableResourcesReportDTO> getBillableResourcesReport(ReportDTO dto) {
        String filterClause;
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String filterString = "5".equals(filterid) ? ("yes".equalsIgnoreCase(dto.getFilterString()) ? "1" : ("no".equalsIgnoreCase(dto.getFilterString()) ? "0" : "")) : dto.getFilterString();
        String baseSql = "select r.id rid, r.name rname, bv.check_in_date, bv.check_out_date, s.first_name sfirst, s.middle_name smiddle, s.last_name slast, sm.mrn, st.industry_initiated, sl.name slname, st.name stname, st.catalyst_id, st.local_id, st.irb, pi.first_name pfirst, pi.middle_name pmiddle, pi.last_name plast, vt.name vname, vty.name, br.scheduled_start_time, br.scheduled_end_time, st.crc_funded, bv.comment, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, resource r, visit_template vt, booked_visit bv, sublocation sl, subject s, user pi, study st, subject_mrn sm, visit_type vty where br.billable = true and bv.visit_template = vt.id and vt.visit_type = vty.id and s.archival_status is NULL and bv.study = st.id and st.principal_investigator = pi.id and bv.subject_mrn = sm.id and sm.subject = s.id and vt.sublocation = sl.id and bv.appointment_status = 3 and br.booked_visit = bv.id and br.resource = r.id and ((:startTime between br.scheduled_start_time and br.scheduled_end_time) or (:endTime between br.scheduled_start_time and br.scheduled_end_time) or (br.scheduled_start_time >= :startTime and br.scheduled_end_time <= :endTime)) ";
        Map filterIdsToHqlColumns = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"1", (Object)"r.name"), Pair.pair((Object)"2", (Object)"st.name"), Pair.pair((Object)"3", (Object)"st.local_id"), Pair.pair((Object)"4", (Object)"pi.last_name")});
        boolean filterIdIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        if (filterIdIsPresent && filterIdsToHqlColumns.containsKey(filterid)) {
            String filterColumn = (String)filterIdsToHqlColumns.get(filterid);
            filterClause = " and " + filterColumn + " like '%" + filterString + "%' ";
        } else {
            filterClause = "5".equals(filterid) ? " and st.industry_initiated = true " : ("6".equals(filterid) ? " and st.crc_funded = false " : " ");
        }
        String sortByColumnName = "r.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("r.name", sortStrategy);
        String groupByClause = " group by br.id ";
        String infiniteSql = "select r.id rid, r.name rname, bv.check_in_date, bv.check_out_date, s.first_name sfirst, s.middle_name smiddle, s.last_name slast, sm.mrn, st.industry_initiated, sl.name slname, st.name stname, st.catalyst_id, st.local_id, st.irb, pi.first_name pfirst, pi.middle_name pmiddle, pi.last_name plast, vt.name vname, vty.name, br.scheduled_start_time, br.scheduled_end_time, st.crc_funded, bv.comment, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, resource r, visit_template vt, booked_visit bv, sublocation sl, subject s, user pi, study st, subject_mrn sm, visit_type vty where br.billable = true and bv.visit_template = vt.id and vt.visit_type = vty.id and s.archival_status is NULL and bv.study = st.id and st.principal_investigator = pi.id and bv.subject_mrn = sm.id and sm.subject = s.id and vt.sublocation = sl.id and bv.appointment_status = 3 and br.booked_visit = bv.id and br.resource = r.id and ((:startTime between br.scheduled_start_time and br.scheduled_end_time) or (:endTime between br.scheduled_start_time and br.scheduled_end_time) or (br.scheduled_start_time >= :startTime and br.scheduled_end_time <= :endTime)) " + filterClause + " group by br.id " + orderByClause;
        int limitChunk = 10000;
        int offset = 0;
        boolean maybeMore = true;
        ArrayList resultList = Lists.newArrayList();
        while (maybeMore) {
            String sql = infiniteSql + " limit " + 10000 + " offset " + offset;
            SQLQuery query = this.session().createSQLQuery(sql);
            ReportDAO.setStartAndEndTimeParameters(dto, (Query)query);
            List resultRows = query.list();
            ReportDAO.logHqlQuery(resultRows, (Query)query);
            if (resultRows.size() < 10000) {
                maybeMore = false;
            }
            for (Object[] row : resultRows) {
                int index = 0;
                BillableResourcesReportDTO newObj = new BillableResourcesReportDTO();
                newObj.setResourceId((Integer)row[index++]);
                newObj.setResourceName((String)row[index++]);
                newObj.setCheckInTime((Date)row[index++]);
                newObj.setCheckOutTime((Date)row[index++]);
                newObj.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[index++]));
                newObj.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[index++]));
                newObj.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[index++]));
                newObj.setMrn(SubjectDataEncryptor.decrypt((String)row[index++]));
                newObj.setIndustryInitiated((Boolean)row[index++]);
                newObj.setSublocationName((String)row[index++]);
                newObj.setStudyName((String)row[index++]);
                newObj.setCatalystId((String)row[index++]);
                newObj.setLocalId((String)row[index++]);
                newObj.setIrb((String)row[index++]);
                newObj.setPiFirstName((String)row[index++]);
                newObj.setPiMiddleName((String)row[index++]);
                newObj.setPiLastName((String)row[index++]);
                newObj.setVisitName((String)row[index++]);
                newObj.setVisitTypeName((String)row[index++]);
                newObj.setScheduledStartTime((Date)row[index++]);
                newObj.setScheduledEndTime((Date)row[index++]);
                newObj.setCrcFunded((Boolean)row[index++]);
                newObj.setBookedVisitComment((String)row[index++]);
                newObj.setResourceActivities((String)row[index++]);
                newObj.setResourceActivitiesComment((String)row[index++]);
                newObj.setResourceActivitiesQuantity((String)row[index++]);
                resultList.add(newObj);
            }
            offset += 10000;
        }
        Comparator<BillableResourcesReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? BillableResourcesComparator : BillableResourcesComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setBillableResourcesReport(resultList);
        return resultList;
    }

    public List<TransactionsReportDTO> getTransactionsReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String alQueryString = "select bv, al.performingUser, al.date    from BookedVisit bv, ActivityLog al  where al.bookedVisit = bv.id and al.appointmentOverrideReason IS NULL  and bv.subjectMrn IS NOT null and al.date >= :startTime and al.date <= :endTime ";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            alQueryString = alQueryString + " and bv.appointmentStatus.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            alQueryString = alQueryString + " and bv.cancelStatus.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            alQueryString = alQueryString + " and bv.cancelStatusReason.name like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            alQueryString = alQueryString + " and al.performingUser.lastName like '%" + filterString + "%' ";
        }
        ArrayList resultList = Lists.newArrayList();
        this.addTransactionsDtoList(alQueryString, dto, resultList);
        String bvalQueryString = alQueryString.replaceAll("ActivityLog al", "BookedVisitActivityLog al") + " and al.actionPerformed NOT LIKE 'Viewed%' and al.actionPerformed NOT LIKE 'Clicked%'";
        this.addTransactionsDtoList(bvalQueryString, dto, resultList);
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        Comparator<TransactionsReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? TransactionsComparator : TransactionsComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setTransactionsReport(resultList);
        return resultList;
    }

    public void addTransactionsDtoList(String queryString, ReportDTO dto, List<TransactionsReportDTO> resultList) {
        Query query = this.session().createQuery(queryString);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logSqlQuery(resultRows, query);
        for (Object[] row : resultRows) {
            TransactionsReportDTO newObj = this.makeTransactionsReportRowFromQueryResult(row);
            resultList.add(newObj);
        }
    }

    public TransactionsReportDTO makeTransactionsReportRowFromQueryResult(Object[] row) {
        SubjectMrn subjectMrn;
        TransactionsReportDTO newObj = new TransactionsReportDTO();
        BookedVisit bookedVisit = (BookedVisit)row[0];
        newObj.setAsrId(bookedVisit.getId());
        newObj.setAppointmentStatus(bookedVisit.getAppointmentStatus().getName());
        newObj.setAsrName("");
        if (bookedVisit.getAppointmentStatusReason() != null) {
            newObj.setAsrName(bookedVisit.getAppointmentStatusReason().getName());
        }
        newObj.setCancelStatus("");
        if (bookedVisit.getCancelStatus() != null) {
            newObj.setCancelStatus(bookedVisit.getCancelStatus().getName());
        }
        newObj.setCancelStatusReason("");
        if (bookedVisit.getCancelStatusReason() != null) {
            newObj.setCancelStatusReason(bookedVisit.getCancelStatusReason().getName());
        }
        newObj.setScheduledStartTime(bookedVisit.getScheduledStartTime());
        newObj.setScheduledEndTime(bookedVisit.getScheduledEndTime());
        String name = ((User)row[1]).getEcommonsId() + " - " + ((User)row[1]).getLastName();
        newObj.setEcommonsId(name);
        newObj.setCancelTime((Date)row[2]);
        newObj.setVisitName(bookedVisit.getVisitTemplate().getName());
        newObj.setVisitTypeName(bookedVisit.getVisitType().getName());
        Study study = bookedVisit.getStudy();
        newObj.setStudyName(study.getName());
        newObj.setCatalystId("");
        if (study.getCatalystId() != null) {
            newObj.setCatalystId(study.getCatalystId());
        }
        newObj.setLocalId(study.getLocalId());
        newObj.setIrb("");
        if (study.getIrb() != null) {
            newObj.setIrb(study.getIrb());
        }
        User investigator = study.getInvestigator();
        newObj.setPiFirstName("");
        newObj.setPiMiddleName("");
        newObj.setPiLastName("");
        if (investigator != null) {
            newObj.setPiFirstName(investigator.getFirstName());
            newObj.setPiMiddleName(investigator.getMiddleName());
            newObj.setPiLastName(investigator.getLastName());
        }
        User scheduler = study.getScheduler();
        newObj.setPsFirstName("");
        newObj.setPsMiddleName("");
        newObj.setPsLastName("");
        if (scheduler != null) {
            newObj.setPsFirstName(scheduler.getFirstName());
            newObj.setPsMiddleName(scheduler.getMiddleName());
            newObj.setPsLastName(scheduler.getLastName());
        }
        if ((subjectMrn = bookedVisit.getSubjectMrnDecrypted()) == null) {
            newObj.setSubjectFirstName("");
            newObj.setSubjectMiddleName("");
            newObj.setSubjectLastName("No Subject Assigned");
            newObj.setMrn("N/A");
        } else {
            Subject subject = subjectMrn.getSubject();
            newObj.setSubjectFirstName(subject.getFirstName());
            newObj.setSubjectMiddleName(subject.getMiddleName());
            newObj.setSubjectLastName(subject.getLastName());
            newObj.setMrn(subjectMrn.getMrn());
        }
        return newObj;
    }

    public List<DailyResourceReportDTO> getDailyResourceReport(ReportDTO dto, boolean export) {
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        boolean searchByLastName = "2".equals(filterid);
        String filterString = this.getFilterString(dto, searchByLastName);
        String baseHql = this.dailyResourceReportBaseHql(export);
        String searchClause = this.makeDailyResourceSearchClause(filterid, filterString, searchByLastName);
        String sortByColumnName = "r.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("r.name", sortStrategy);
        String hql = baseHql + " " + searchClause + " " + orderByClause;
        Query query = this.newQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        Function<Object[], DailyResourceReportDTO> toDailyResourceReportDTO = row -> {
            DailyResourceReportDTO newObj = new DailyResourceReportDTO();
            newObj.setResourceTypeId((Integer)row[0]);
            newObj.setResourceTypeName(((ResourceType)row[1]).getName());
            newObj.setResourceName((String)row[2]);
            BookedVisit bookedVisit = (BookedVisit)row[3];
            SubjectMrn subjectMrn = bookedVisit.getSubjectMrnDecrypted();
            newObj.setSubjectFirstName(subjectMrn == null ? "" : subjectMrn.getSubject().getFirstName());
            newObj.setSubjectMiddleName(subjectMrn == null ? "" : subjectMrn.getSubject().getMiddleName());
            newObj.setSubjectLastName(subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getLastName());
            newObj.setMrn(subjectMrn == null ? "No Subject Assigned" : subjectMrn.getMrn());
            newObj.setLocalId((String)row[4]);
            newObj.setIrb((String)row[5]);
            newObj.setVisitName((String)row[6]);
            newObj.setScheduledStartTime((Date)row[7]);
            newObj.setScheduledEndTime((Date)row[8]);
            newObj.setComment((String)row[9]);
            newObj.setVisitId((Integer)row[10]);
            return newObj;
        };
        List<DailyResourceReportDTO> resultList = ListUtils.enrich((List)resultRows).map(toDailyResourceReportDTO).toList();
        if (export) {
            resultList = resultList.stream().map(drrd -> new NutritionDailyResourceReportDTO((DailyResourceReportDTO)drrd)).collect(Collectors.toList());
        }
        Comparator<DailyResourceReportDTO> ordering = sortStrategy.isAscending() ? DailyResourceComparator : DailyResourceComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setDailyResourceReport(resultList);
        return resultList;
    }

    private String getFilterString(ReportDTO dto, boolean searchByLastName) {
        if (searchByLastName) {
            return SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase());
        }
        return dto.getFilterString();
    }

    String dailyResourceReportBaseHql(boolean export) {
        String desiredStatus = export ? " and bv.appointmentStatus.isHold = FALSE" : " and bv.appointmentStatus.isCancelled = FALSE";
        String restrictionExpression = " and r.resourceType = 'Nutrition' and r.name NOT LIKE '%Meal,%' and r.name NOT LIKE '%Snack%'";
        String ridRestriction = export ? restrictionExpression : "";
        String result = "select r.id, r.resourceType, r.name, bv, st.localId, st.irb, v.name, br.scheduledStartTime, br.scheduledEndTime, bv.comment, bv.id from Study st, VisitTemplate v, BookedResource br,  Resource r,  BookedVisit bv left join bv.subjectMrn sm left join sm.subject s with s.archivalStatus IS NULL where bv.study = st.id and bv.visitTemplate = v.id  and br.bookedVisit = bv.id and br.resource = r.id " + desiredStatus + " and " + "    ((:startTime between br.scheduledStartTime and br.scheduledEndTime) " + "  or (:endTime between br.scheduledStartTime and br.scheduledEndTime) " + "  or (br.scheduledStartTime >= :startTime " + " and br.scheduledEndTime <= :endTime))" + ridRestriction;
        return result;
    }

    private String makeDailyResourceSearchClause(String filterid, String filterString, boolean searchByLastName) {
        boolean filterStringIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        Map filterIdToResourceType = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"3", (Object)ResourceType.Nursing), Pair.pair((Object)"4", (Object)ResourceType.Nutrition), Pair.pair((Object)"5", (Object)ResourceType.Room), Pair.pair((Object)"6", (Object)ResourceType.Lab), Pair.pair((Object)"7", (Object)ResourceType.Other)});
        boolean searchingByResourceType = filterIdToResourceType.containsKey(filterid);
        if (filterStringIsPresent && "1".equals(filterid)) {
            return " and r.name like '%" + filterString + "%' ";
        }
        if (filterStringIsPresent && searchByLastName) {
            return " and s.lastName like '%" + filterString + "%' ";
        }
        if (searchingByResourceType) {
            String toSearchFor = ((ResourceType)filterIdToResourceType.get(filterid)).getName().toLowerCase();
            return " and r.resourceType like '%" + toSearchFor + "%' ";
        }
        if ("8".equals(filterid)) {
            return " and st.crcFunded = false ";
        }
        return " ";
    }

    public List<DailyAdmReportDTO> getDailyAdmReport(ReportDTO dto) {
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String filterString = "1".equals(filterid) || "3".equals(filterid) ? SubjectDataEncryptor.encrypt(dto.getFilterString().toUpperCase()) : dto.getFilterString();
        String hql = "select bv.id, s.firstName, s.middleName, s.lastName, s.birthdate, sm.mrn, s.gender, st.localId, st.irb, v, r.name, br.scheduledStartTime, br.scheduledEndTime, bv.comment, bv.checkInDate, bv.appointmentStatus from Subject s, Study st, VisitTemplate v, Resource r, BookedResource br, BookedVisit bv, SubjectMrn sm where bv.subjectMrn = sm.id and sm.subject = s.id and br.bookedVisit = bv.id  and br.resource = r.id and bv.study = st.id and bv.visitTemplate = v.id  and s.archivalStatus IS NULL and  bv.appointmentStatus.isActive = TRUE and ((:startTime between br.scheduledStartTime and br.scheduledEndTime)  or (:endTime between br.scheduledStartTime and br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime))";
        if (MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid)) {
            hql = hql + " and s.lastName like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid)) {
            hql = hql + " and st.localId like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            hql = hql + " and sm.mrn like '%" + filterString + "%' ";
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            hql = hql + " and r.name like '%" + filterString + "%' ";
        } else if ("5".equals(filterid)) {
            hql = hql + " and st.crcFunded = false ";
        }
        hql = hql + " order by bv.id ";
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        ArrayList inpatientList = Lists.newArrayList();
        ArrayList outpatientList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            DailyAdmReportDTO newObj = new DailyAdmReportDTO();
            newObj.setSubjectId((Integer)row[0]);
            newObj.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[1]));
            newObj.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[2]));
            newObj.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[3]));
            if ((Date)row[4] != null) {
                Date subDate = new Date(((Date)row[4]).getTime());
                String subjectdate = DateUtility.format(DateUtility.monthDayYear(), subDate);
                newObj.setBirthdate(subjectdate);
            } else {
                newObj.setBirthdate(null);
            }
            newObj.setMrn(SubjectDataEncryptor.decrypt((String)row[5]));
            newObj.setGenderName(((Gender)row[6]).getName());
            newObj.setLocalId((String)row[7]);
            newObj.setIrb((String)row[8]);
            VisitTemplate visit = (VisitTemplate)row[9];
            newObj.setVisitName(visit.getName());
            newObj.setResourceName((String)row[10]);
            newObj.setScheduledStartTime((Date)row[11]);
            newObj.setScheduledEndTime((Date)row[12]);
            newObj.setComment((String)row[13]);
            newObj.setCheckInTime((Date)row[14]);
            newObj.setVisitStatus(((AppointmentStatus)row[15]).getName());
            if (visit.getVisitType().isOutpatient()) {
                outpatientList.add(newObj);
                continue;
            }
            inpatientList.add(newObj);
        }
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        Comparator<DailyAdmReportDTO> orderingByTime = DailyAdmNameComparatorOrderingByTime;
        Comparator<DailyAdmReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? DailyAdmNameComparator : DailyAdmNameComparatorDesc;
        Collections.sort(inpatientList, ordering);
        Collections.sort(inpatientList, orderingByTime);
        resultList.addAll(inpatientList);
        Collections.sort(outpatientList, ordering);
        Collections.sort(outpatientList, orderingByTime);
        resultList.addAll(outpatientList);
        dto.setDailyAdmReport(resultList);
        return resultList;
    }

    public List<BookedResource> findBookedResourceMeal(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit and a.resource.resourceType = 'Nutrition' order by a.scheduledStartTime";
        Query query = this.session().createQuery("SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit and a.resource.resourceType = 'Nutrition' order by a.scheduledStartTime");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        List list = query.list();
        ReportDAO.logHqlQuery(list, query);
        List<BookedResource> bookedMealResources = this.filterMeals(list);
        return bookedMealResources;
    }

    public List<BookedResource> findBookedResourceRooms(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit and a.resource.resourceType = 'Room' order by a.scheduledStartTime";
        Query query = this.session().createQuery("SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit and a.resource.resourceType = 'Room' order by a.scheduledStartTime");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        List bookedRoomResources = query.list();
        ReportDAO.logHqlQuery(bookedRoomResources, query);
        return bookedRoomResources;
    }

    public List<BookedResource> filterMeals(List<BookedResource> bookedResources) {
        return ListUtils.enrich(bookedResources).filter(this::hasAllowedMealName).toList();
    }

    private Function<Predicate<BookedResource>, List<BookedResource>> applyTo(List<BookedResource> bookedResources) {
        return p -> ListUtils.enrich((List)bookedResources).filter(p).toList();
    }

    public List<MetaKitchenReportDTO> getMetaKitchenReport(ReportDTO reportDto) {
        String filterid = reportDto.getFilterId();
        String sortid = reportDto.getSortId();
        String filterString = "1".equals(filterid) || "3".equals(filterid) ? SubjectDataEncryptor.encrypt(reportDto.getFilterString().toUpperCase()) : reportDto.getFilterString();
        String findBookedResources = "SELECT b FROM BookedVisit a, BookedResource b, Resource r  WHERE a.id = b.bookedVisit and b.resource = r.id and r.resourceType IN ('Nutrition', 'Room')  and a.appointmentStatus.isActive = TRUE  and ((:startTime between b.scheduledStartTime and b.scheduledEndTime)  or (:endTime between b.scheduledStartTime and b.scheduledEndTime)  or (b.scheduledStartTime >= :startTime and b.scheduledEndTime <= :endTime)) order by b.bookedVisit ASC";
        Query query = this.session().createQuery("SELECT b FROM BookedVisit a, BookedResource b, Resource r  WHERE a.id = b.bookedVisit and b.resource = r.id and r.resourceType IN ('Nutrition', 'Room')  and a.appointmentStatus.isActive = TRUE  and ((:startTime between b.scheduledStartTime and b.scheduledEndTime)  or (:endTime between b.scheduledStartTime and b.scheduledEndTime)  or (b.scheduledStartTime >= :startTime and b.scheduledEndTime <= :endTime)) order by b.bookedVisit ASC");
        ReportDAO.setStartAndEndTimeParameters(reportDto, query);
        List bookedResources = query.list();
        ReportDAO.logHqlQuery(bookedResources, query);
        Optional<Predicate<BookedResource>> predicate = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? Optional.of(this.lastNameMatches(filterString)) : (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid) ? Optional.of(this.studyLocalIdMatches(filterString)) : (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid) ? Optional.of(this.mrnMatches(filterString)) : (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid) ? Optional.of(this.nameMatches(filterString)) : ("5".equals(filterid) ? Optional.of(this::notCrcFunded) : Optional.empty()))));
        Collection filteredBookedResources = predicate.map(this.applyTo(bookedResources)).orElse(Collections.emptyList());
        ArrayList finalList = Lists.newArrayList();
        if (filterString == null || filterString.equalsIgnoreCase("")) {
            finalList.addAll(bookedResources);
        } else {
            finalList.addAll(filteredBookedResources);
        }
        List<MetaKitchenReportDTO> resultList = this.generateMetaKitchenReports(finalList);
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        Comparator<MetaKitchenReportDTO> ordering = null;
        if (sortStrategy == SortStrategy.ASCENDING) {
            if (reportDto.getName().equalsIgnoreCase("meta_kitchen_by_time")) {
                ordering = MetaKitchenByTimeComparator;
            } else if (reportDto.getName().equalsIgnoreCase("meta_kitchen")) {
                ordering = MetaKitchenNameComparator;
            } else if (reportDto.getName().equalsIgnoreCase("meta_kitchen_flat")) {
                ordering = MetaKitchenNameComparator;
            }
        } else if (reportDto.getName().equalsIgnoreCase("meta_kitchen_by_time")) {
            ordering = MetaKitchenByTimeComparatorDesc;
        } else if (reportDto.getName().equalsIgnoreCase("meta_kitchen")) {
            ordering = MetaKitchenNameComparatorDesc;
        } else if (reportDto.getName().equalsIgnoreCase("meta_kitchen_flat")) {
            ordering = MetaKitchenNameComparatorDesc;
        }
        Collections.sort(resultList, ordering);
        reportDto.setMetaKitchenReport(resultList);
        return resultList;
    }

    private boolean notCrcFunded(BookedResource bookedResource) {
        return bookedResource.getBookedVisit().getStudy().getCrcFunded().equals(Boolean.FALSE);
    }

    private Predicate<BookedResource> nameMatches(String filterString) {
        return bookedResource -> bookedResource.getResource().getName().equalsIgnoreCase(filterString);
    }

    private Predicate<BookedResource> mrnMatches(String filterString) {
        return bookedResource -> bookedResource.getBookedVisit().getSubjectMrn().getMrn().equalsIgnoreCase(filterString);
    }

    private Predicate<BookedResource> studyLocalIdMatches(String filterString) {
        return bookedResource -> bookedResource.getBookedVisit().getStudy().getLocalId().equalsIgnoreCase(filterString);
    }

    private Predicate<BookedResource> lastNameMatches(String filterString) {
        return bookedResource -> bookedResource.getBookedVisit().getSubjectMrn().getSubject().getLastName().equalsIgnoreCase(filterString);
    }

    boolean hasAllowedMealName(BookedResource bookedResource) {
        return bookedResource.getResource().getName().startsWith("Snack") || bookedResource.getResource().getName().startsWith("Meal");
    }

    boolean mealTimeOverlapsRoomTime(Date mealStartdate, Date mealEnddate, Date roomStartdate, Date roomEnddate) {
        return mealStartdate.after(roomStartdate) && mealStartdate.before(roomEnddate) || mealStartdate.equals(roomStartdate) && mealStartdate.equals(roomEnddate) || mealStartdate.before(roomStartdate) && mealEnddate.after(roomStartdate) || mealStartdate.after(roomStartdate) && mealStartdate.before(roomEnddate) && mealEnddate.after(roomEnddate) || mealStartdate.equals(roomStartdate) && mealEnddate.before(roomEnddate) || mealStartdate.after(roomStartdate) && mealEnddate.equals(roomEnddate);
    }

    private List<MetaKitchenReportDTO> generateMetaKitchenReports(List<BookedResource> finalList) {
        ArrayList resultList = Lists.newArrayList();
        for (BookedResource bookedResource : finalList) {
            MetaKitchenReportDTO metaKitchenReportDto = new MetaKitchenReportDTO();
            SubjectMrn subjectMrn = bookedResource.getBookedVisit().getSubjectMrnDecrypted();
            String lastName = "No Subject Assigned";
            String firstName = "No Subject Assigned";
            String middleName = "No Subject Assigned";
            String subjectMrnVal = "N/A";
            String subjectBirthDate = "N/A";
            if (subjectMrn != null) {
                lastName = subjectMrn.getSubject().getLastName();
                firstName = subjectMrn.getSubject().getFirstName();
                middleName = subjectMrn.getSubject().getMiddleName();
                subjectMrnVal = subjectMrn.getMrn();
                Date subjectDate = new Date(subjectMrn.getSubject().getBirthdate().getTime());
                subjectBirthDate = DateUtility.format(DateUtility.monthDayYear(), subjectDate);
            }
            metaKitchenReportDto.setSubjectId(bookedResource.getBookedVisit().getId());
            metaKitchenReportDto.setSubjectFirstName(firstName);
            metaKitchenReportDto.setSubjectMiddleName(middleName);
            metaKitchenReportDto.setSubjectLastName(lastName);
            metaKitchenReportDto.setMrn(subjectMrnVal);
            metaKitchenReportDto.setBirthdate(subjectBirthDate);
            metaKitchenReportDto.setLocalId(bookedResource.getBookedVisit().getStudy().getLocalId());
            metaKitchenReportDto.setIrb(bookedResource.getBookedVisit().getStudy().getIrb());
            metaKitchenReportDto.setVisitName(bookedResource.getBookedVisit().getVisitTemplate().getName());
            List<BookedResource> meals = this.findBookedResourceMeal(bookedResource.getBookedVisit());
            List<BookedResource> rooms = this.findBookedResourceRooms(bookedResource.getBookedVisit());
            if (meals.isEmpty()) continue;
            String resourceName = bookedResource.getResource().getName();
            if (this.hasAllowedMealName(bookedResource)) {
                Date mealStartDate = DateUtility.parse(DateUtility.dateHourMin(), DateUtility.format(DateUtility.dateHourMin(), bookedResource.getScheduledStartTime()));
                Date mealEndDate = DateUtility.parse(DateUtility.dateHourMin(), DateUtility.format(DateUtility.dateHourMin(), bookedResource.getScheduledEndTime()));
                if (rooms.size() > 0) {
                    for (int i = 0; i < rooms.size(); ++i) {
                        Date roomEndDate;
                        Date roomStartDate = DateUtility.parse(DateUtility.dateHourMin(), DateUtility.format(DateUtility.dateHourMin(), rooms.get(i).getScheduledStartTime()));
                        if (!this.mealTimeOverlapsRoomTime(mealStartDate, mealEndDate, roomStartDate, roomEndDate = DateUtility.parse(DateUtility.dateHourMin(), DateUtility.format(DateUtility.dateHourMin(), rooms.get(i).getScheduledEndTime())))) continue;
                        metaKitchenReportDto.setRoom(rooms.get(i).getResource().getName());
                    }
                }
                metaKitchenReportDto.setResourceName(resourceName);
            }
            metaKitchenReportDto.setScheduledStartTime(bookedResource.getScheduledStartTime());
            metaKitchenReportDto.setCheckInTime(bookedResource.getBookedVisit().getScheduledStartTime());
            metaKitchenReportDto.setCheckOutTime(bookedResource.getBookedVisit().getScheduledEndTime());
            resultList.add(metaKitchenReportDto);
        }
        return resultList;
    }

    public List<DeptAndPiReportDTO> getDeptAndPiReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = "select bv.study, bv.checkInDate, bv.checkOutDate, v.name, s.firstName, s.middleName, s.lastName, sm.mrn from VisitTemplate v, BookedVisit bv, Subject s, SubjectMrn sm where bv.subjectMrn = sm.id and sm.subject = s.id and bv.visitTemplate = v.id and  bv.appointmentStatus.isCheckedOut = TRUE and s.archivalStatus IS NULL and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        String filterClause = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? " and bv.study.investigator.department.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid) ? " and bv.study.investigator.division.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid) ? " and bv.study.investigator.lastName like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid) ? " and bv.study.investigator.institution.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "5".equals(filterid) ? " and bv.study.investigator.credential.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "6".equals(filterid) ? " and bv.study.investigator.facultyRank.name like '%" + filterString + "%' " : ("7".equals(filterid) ? " and bv.study.crcFunded = false " : " "))))));
        String sortByColumnName = "bv.study.investigator.lastName";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("bv.study.investigator.lastName", sortStrategy);
        String hql = "select bv.study, bv.checkInDate, bv.checkOutDate, v.name, s.firstName, s.middleName, s.lastName, sm.mrn from VisitTemplate v, BookedVisit bv, Subject s, SubjectMrn sm where bv.subjectMrn = sm.id and sm.subject = s.id and bv.visitTemplate = v.id and  bv.appointmentStatus.isCheckedOut = TRUE and s.archivalStatus IS NULL and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            DeptAndPiReportDTO deptAndPiReportDto = new DeptAndPiReportDTO();
            Study study = (Study)row[0];
            User investigator = study.getInvestigator();
            if (investigator == null) {
                log.info((Object)("Study " + study.getId() + " contains a null PI"));
                continue;
            }
            deptAndPiReportDto.setPiId(investigator.getId());
            deptAndPiReportDto.setPiFirstName(investigator.getFirstName());
            deptAndPiReportDto.setPiMiddleName(investigator.getMiddleName());
            deptAndPiReportDto.setPiLastName(investigator.getLastName());
            if (investigator.getDepartment() != null) {
                deptAndPiReportDto.setPiDepartment(investigator.getDepartment().getName());
            } else {
                deptAndPiReportDto.setPiDepartment("");
            }
            if (investigator.getDivision() != null) {
                deptAndPiReportDto.setPiDivision(investigator.getDivision().getName());
            } else {
                deptAndPiReportDto.setPiDivision("");
            }
            if (investigator.getFacultyRank() != null) {
                deptAndPiReportDto.setPiFacultyRank(investigator.getFacultyRank().getName());
            } else {
                deptAndPiReportDto.setPiFacultyRank("");
            }
            if (investigator.getCredential() != null) {
                deptAndPiReportDto.setPiCredential(investigator.getCredential().getName());
            } else {
                deptAndPiReportDto.setPiCredential("");
            }
            deptAndPiReportDto.setPiInstitution(investigator.getInstitution().getName());
            deptAndPiReportDto.setStudyName(study.getName());
            deptAndPiReportDto.setCatalystId(ReportDAO.orEmpty(study.getCatalystId()));
            deptAndPiReportDto.setLocalId(study.getLocalId());
            deptAndPiReportDto.setIrb(ReportDAO.orEmpty(study.getIrb()));
            deptAndPiReportDto.setCheckInTime((Date)row[1]);
            deptAndPiReportDto.setCheckOutTime((Date)row[2]);
            deptAndPiReportDto.setVisitName((String)row[3]);
            deptAndPiReportDto.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[4]));
            deptAndPiReportDto.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[5]));
            deptAndPiReportDto.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[6]));
            deptAndPiReportDto.setMrn(SubjectDataEncryptor.decrypt((String)row[7]));
            resultList.add(deptAndPiReportDto);
        }
        Comparator<DeptAndPiReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? DeptAndPiComparator : DeptAndPiComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setDeptAndPiReport(resultList);
        return resultList;
    }

    public List<BillingReportDTO> getBillingReport(ReportDTO dto) {
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String filterString = "3".equals(filterid) ? ("yes".equalsIgnoreCase(dto.getFilterString()) ? "1" : null) : dto.getFilterString();
        String baseSql = "select st.id stid, st.name stname, st.catalyst_id, st.local_id, st.irb, st.industry_initiated, u.first_name ufirst, u.middle_name umiddle, u.last_name ulast, st.crc_funded, bv.comment, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC, tr.billable, r.name rname, br.scheduled_start_time brst, br.scheduled_end_time bret, bv.scheduled_start_time bvst, bv.scheduled_end_time bvet, bv.check_in_date, bv.check_out_date, sl.name slname, vt.name vtname, vty.name, s.first_name sfirst, s.last_name slast, s.middle_name smiddle, sm.mrn, s.birthdate from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, study st, user u, booked_visit bv, resource r, visit_template vt, sublocation sl, subject_mrn sm, subject s, visit_type vty where br.billable = true and bv.study = st.id and vt.sublocation = sl.id and vt.visit_type = vty.id and bv.subject_mrn = sm.id and sm.subject = s.id and bv.visit_template = vt.id and br.resource = r.id and br.booked_visit = bv.id and st.principal_investigator = u.id and bv.appointment_status = 3 and ((:startTime between bv.scheduled_start_time and bv.scheduled_end_time)  or (:endTime between bv.scheduled_start_time and bv.scheduled_end_time) or (bv.scheduled_start_time >= :startTime and bv.scheduled_end_time <= :endTime)) ";
        String filterClauseSql = !Strings.isNullOrEmpty((String)filterString) && "1".equals(filterid) ? " and st.local_id like '%" + filterString + "%' " : (!Strings.isNullOrEmpty((String)filterString) && "2".equals(filterid) ? " and st.name like '%" + filterString + "%' " : ("3".equals(filterid) ? " and st.industry_initiated = true " : (!Strings.isNullOrEmpty((String)filterString) && "4".equals(filterid) ? " and u.last_name like '%" + filterString + "%' " : ("5".equals(filterid) ? " and st.crc_funded = false " : " "))));
        String groupByClause = " group by br.id ";
        String sortByColumnNameSql = "st.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClauseSql = this.setOrderByClause("st.name", sortStrategy);
        String sql = "select st.id stid, st.name stname, st.catalyst_id, st.local_id, st.irb, st.industry_initiated, u.first_name ufirst, u.middle_name umiddle, u.last_name ulast, st.crc_funded, bv.comment, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC, tr.billable, r.name rname, br.scheduled_start_time brst, br.scheduled_end_time bret, bv.scheduled_start_time bvst, bv.scheduled_end_time bvet, bv.check_in_date, bv.check_out_date, sl.name slname, vt.name vtname, vty.name, s.first_name sfirst, s.last_name slast, s.middle_name smiddle, sm.mrn, s.birthdate from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, study st, user u, booked_visit bv, resource r, visit_template vt, sublocation sl, subject_mrn sm, subject s, visit_type vty where br.billable = true and bv.study = st.id and vt.sublocation = sl.id and vt.visit_type = vty.id and bv.subject_mrn = sm.id and sm.subject = s.id and bv.visit_template = vt.id and br.resource = r.id and br.booked_visit = bv.id and st.principal_investigator = u.id and bv.appointment_status = 3 and ((:startTime between bv.scheduled_start_time and bv.scheduled_end_time)  or (:endTime between bv.scheduled_start_time and bv.scheduled_end_time) or (bv.scheduled_start_time >= :startTime and bv.scheduled_end_time <= :endTime)) " + filterClauseSql + " group by br.id " + orderByClauseSql;
        SQLQuery querySql = this.session().createSQLQuery(sql);
        ReportDAO.setStartAndEndTimeParameters(dto, (Query)querySql);
        List resultRows = querySql.list();
        ReportDAO.logSqlQuery(resultRows, (Query)querySql);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            BillingReportDTO billingReportDto = new BillingReportDTO();
            int index = 0;
            billingReportDto.setStudyId((Integer)row[index++]);
            billingReportDto.setStudyName((String)row[index++]);
            billingReportDto.setCatalystId((String)row[index++]);
            billingReportDto.setLocalId((String)row[index++]);
            billingReportDto.setIrb((String)row[index++]);
            billingReportDto.setIndustryInitiated((Boolean)row[index++]);
            billingReportDto.setInvestigatorFirstName((String)row[index++]);
            billingReportDto.setInvestigatorMiddleName((String)row[index++]);
            billingReportDto.setInvestigatorLastName((String)row[index++]);
            billingReportDto.setCrcFunded((Boolean)row[index++]);
            billingReportDto.setBookedVisitComment((String)row[index++]);
            billingReportDto.setResourceActivities((String)row[index++]);
            billingReportDto.setResourceActivitiesComment((String)row[index++]);
            billingReportDto.setResourceActivitiesQuantity((String)row[index++]);
            billingReportDto.setBillable((Boolean)row[index++]);
            billingReportDto.setResourceName((String)row[index++]);
            billingReportDto.setCheckInTime((Date)row[index++]);
            billingReportDto.setCheckOutTime((Date)row[index++]);
            billingReportDto.setScheduledStartTime((Date)row[index++]);
            billingReportDto.setScheduledEndTime((Date)row[index++]);
            billingReportDto.setVisitCheckInTime((Date)row[index++]);
            billingReportDto.setVisitCheckOutTime((Date)row[index++]);
            billingReportDto.setSublocation((String)row[index++]);
            billingReportDto.setVisitName((String)row[index++]);
            billingReportDto.setVisitType((String)row[index++]);
            String firstName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String lastName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String middleName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String mrn = SubjectDataEncryptor.decrypt((String)row[index++]);
            billingReportDto.setSubjectFirstName(firstName);
            billingReportDto.setSubjectLastName(lastName);
            billingReportDto.setSubjectMiddleName(middleName);
            billingReportDto.setMrn(mrn);
            Date subDate = new Date(((Date)row[index++]).getTime());
            String subjectBirthDate = DateUtility.format(DateUtility.monthDayYear(), subDate);
            billingReportDto.setBirthdate(subjectBirthDate);
            resultList.add(billingReportDto);
        }
        Comparator<BillingReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? BillingComparator : BillingComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setBillingReport(resultList);
        return resultList;
    }

    public List<BillingByInvestigatorReportDTO> getBillingByInvestigatorReport(ReportDTO dto) {
        String piFirstName = dto.getPiFirstName();
        String piLastName = dto.getPiLastName();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String filterString = "5".equals(filterid) ? (this.countsAsYes(dto.getFilterString()) ? "1" : null) : dto.getFilterString();
        String baseSql = "select st.id stid, st.principal_investigator, u.first_name ufirst, u.middle_name umiddle, u.last_name ulast, st.name, st.catalyst_id, st.local_id, st.irb, st.industry_initiated, st.crc_funded, bv.id bvid, vt.name vtname, bv.check_in_date, bv.check_out_date, bv.comment, s.first_name sfirst, s.middle_name smiddle, s.last_name slast, sm.mrn, br.scheduled_start_time, br.scheduled_end_time, r.name rname, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, study st    LEFT JOIN user u ON st.principal_investigator = u.id, resource r, subject s, visit_template vt, booked_visit bv, subject_mrn sm where br.billable = true and bv.study = st.id and bv.subject_mrn = sm.id and sm.subject = s.id and bv.visit_template = vt.id and br.resource = r.id and br.booked_visit = bv.id and bv.appointment_status = 3 and ((:startTime between br.scheduled_start_time and br.scheduled_end_time)  or (:endTime between br.scheduled_start_time and br.scheduled_end_time) or (br.scheduled_start_time >= :startTime and br.scheduled_end_time <= :endTime)) ";
        String filterClause = " ";
        if (piFirstName != null && piFirstName.length() > 0) {
            filterClause = "and u.first_name like '%" + piFirstName + "%' ";
        } else if (piLastName != null && piLastName.length() > 0) {
            filterClause = "and u.last_name like '%" + piLastName + "%' ";
        }
        if (!Strings.isNullOrEmpty((String)filterString) && "1".equals(filterid)) {
            filterClause = filterClause + " and r.name like '%" + filterString + "%' ";
        } else if (!Strings.isNullOrEmpty((String)filterString) && "2".equals(filterid)) {
            filterClause = filterClause + " and st.name like '%" + filterString + "%' ";
        } else if (!Strings.isNullOrEmpty((String)filterString) && "3".equals(filterid)) {
            filterClause = filterClause + " and st.local_id like '%" + filterString + "%' ";
        } else if (!Strings.isNullOrEmpty((String)filterString) && "4".equals(filterid)) {
            filterClause = filterClause + " and u.last_name like '%" + filterString + "%' ";
        } else if ("5".equals(filterid)) {
            filterClause = filterClause + " and st.industry_initiated = true ";
        } else if ("6".equals(filterid)) {
            filterClause = filterClause + " and st.crc_funded = false ";
        }
        String sortByColumnName = "u.last_name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("u.last_name", sortStrategy);
        String groupByClause = " group by br.id ";
        String sql = "select st.id stid, st.principal_investigator, u.first_name ufirst, u.middle_name umiddle, u.last_name ulast, st.name, st.catalyst_id, st.local_id, st.irb, st.industry_initiated, st.crc_funded, bv.id bvid, vt.name vtname, bv.check_in_date, bv.check_out_date, bv.comment, s.first_name sfirst, s.middle_name smiddle, s.last_name slast, sm.mrn, br.scheduled_start_time, br.scheduled_end_time, r.name rname, group_concat(lla.name separator '; ') nameC, group_concat(obra.comment separator '; ') commentC, group_concat(cast(obra.quantity as char) separator '; ') quantityC from booked_resource br    LEFT JOIN template_resource tr ON br.template_resource = tr.id and tr.billable = true    LEFT JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id    LEFT JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id, study st    LEFT JOIN user u ON st.principal_investigator = u.id, resource r, subject s, visit_template vt, booked_visit bv, subject_mrn sm where br.billable = true and bv.study = st.id and bv.subject_mrn = sm.id and sm.subject = s.id and bv.visit_template = vt.id and br.resource = r.id and br.booked_visit = bv.id and bv.appointment_status = 3 and ((:startTime between br.scheduled_start_time and br.scheduled_end_time)  or (:endTime between br.scheduled_start_time and br.scheduled_end_time) or (br.scheduled_start_time >= :startTime and br.scheduled_end_time <= :endTime)) " + filterClause + " group by br.id " + orderByClause;
        SQLQuery query = this.session().createSQLQuery(sql);
        ReportDAO.setStartAndEndTimeParameters(dto, (Query)query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, (Query)query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            Integer studyPiFK;
            BillingByInvestigatorReportDTO billingByInvestigatorReportDto = new BillingByInvestigatorReportDTO();
            int index = 0;
            Integer studyId = (Integer)row[index++];
            if ((studyPiFK = (Integer)row[index++]) == null) {
                log.info((Object)("Study " + studyId + " contains a null PI"));
                continue;
            }
            billingByInvestigatorReportDto.setPiId(studyId);
            billingByInvestigatorReportDto.setPiFirstName((String)row[index++]);
            billingByInvestigatorReportDto.setPiMiddleName((String)row[index++]);
            billingByInvestigatorReportDto.setPiLastName((String)row[index++]);
            billingByInvestigatorReportDto.setStudyName((String)row[index++]);
            billingByInvestigatorReportDto.setCatalystId((String)row[index++]);
            billingByInvestigatorReportDto.setLocalId((String)row[index++]);
            billingByInvestigatorReportDto.setIrb((String)row[index++]);
            billingByInvestigatorReportDto.setIndustryInitiated((Boolean)row[index++]);
            billingByInvestigatorReportDto.setCrcFunded((Boolean)row[index++]);
            billingByInvestigatorReportDto.setBvId((Integer)row[index++]);
            billingByInvestigatorReportDto.setVisitName((String)row[index++]);
            billingByInvestigatorReportDto.setCheckInTime((Date)row[index++]);
            billingByInvestigatorReportDto.setCheckOutTime((Date)row[index++]);
            billingByInvestigatorReportDto.setBookedVisitComment((String)row[index++]);
            String firstName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String middleName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String lastName = SubjectDataEncryptor.decrypt((String)row[index++]);
            String mrn = SubjectDataEncryptor.decrypt((String)row[index++]);
            billingByInvestigatorReportDto.setSubjectFirstName(firstName);
            billingByInvestigatorReportDto.setSubjectMiddleName(middleName);
            billingByInvestigatorReportDto.setSubjectLastName(lastName);
            billingByInvestigatorReportDto.setMrn(mrn);
            billingByInvestigatorReportDto.setScheduledStartTime((Date)row[index++]);
            billingByInvestigatorReportDto.setScheduledEndTime((Date)row[index++]);
            billingByInvestigatorReportDto.setResourceName((String)row[index++]);
            billingByInvestigatorReportDto.setResourceActivities((String)row[index++]);
            billingByInvestigatorReportDto.setResourceActivitiesComment((String)row[index++]);
            billingByInvestigatorReportDto.setResourceActivitiesQuantity((String)row[index++]);
            resultList.add(billingByInvestigatorReportDto);
        }
        Comparator<BillingByInvestigatorReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? BillingByInvestigatorComparator : BillingByInvestigatorComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setBillingByInvestigatorReport(resultList);
        return resultList;
    }

    public List<CensusReportDTO> getCensusReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = "select asr.id, asr.name, st.name, pi.firstName, pi.middleName, pi.lastName, st.catalystId, st.localId, st.irb, bv.checkInDate, bv.checkOutDate, v.name, s.firstName, s.middleName, s.lastName, sm.mrn, v.visitType.name, st.industryInitiated, ps.firstName, ps.middleName, ps.lastName, st.id, bv.id, sl.name  FROM AppointmentStatusReason asr, Study st, User pi, User ps, BookedVisit bv, VisitTemplate v, Subject s, SubjectMrn sm, Sublocation sl  WHERE st.scheduler = ps.id and bv.checkoutStatusReason = asr.id and bv.study = st.id and s.archivalStatus IS NULL  and st.investigator = pi.id and bv.subjectMrn = sm.id and sm.subject = s.id and bv.visitTemplate = v.id and bv.appointmentStatus.isCheckedOut = TRUE  and sl.id = v.sublocation  and  (   (:startTime between bv.scheduledStartTime and bv.scheduledEndTime)   or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)   or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        String filterClause = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? " and asr.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "2".equals(filterid) ? " and pi.lastName like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid) ? " and st.localId like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid) ? " and st.name like '%" + filterString + "%' " : (MiscUtil.isNonNullNonEmpty(filterString) && "5".equals(filterid) ? " and v.name like '%" + filterString + "%' " : ("6".equals(filterid) ? " and st.crcFunded = false " : " ")))));
        String sortByColumnName = "asr.name, bv.scheduledStartTime";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("asr.name, bv.scheduledStartTime", sortStrategy);
        String hql = "select asr.id, asr.name, st.name, pi.firstName, pi.middleName, pi.lastName, st.catalystId, st.localId, st.irb, bv.checkInDate, bv.checkOutDate, v.name, s.firstName, s.middleName, s.lastName, sm.mrn, v.visitType.name, st.industryInitiated, ps.firstName, ps.middleName, ps.lastName, st.id, bv.id, sl.name  FROM AppointmentStatusReason asr, Study st, User pi, User ps, BookedVisit bv, VisitTemplate v, Subject s, SubjectMrn sm, Sublocation sl  WHERE st.scheduler = ps.id and bv.checkoutStatusReason = asr.id and bv.study = st.id and s.archivalStatus IS NULL  and st.investigator = pi.id and bv.subjectMrn = sm.id and sm.subject = s.id and bv.visitTemplate = v.id and bv.appointmentStatus.isCheckedOut = TRUE  and sl.id = v.sublocation  and  (   (:startTime between bv.scheduledStartTime and bv.scheduledEndTime)   or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)   or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            CensusReportDTO censusReportDto = new CensusReportDTO();
            censusReportDto.setAsrId((Integer)row[0]);
            censusReportDto.setAsrName((String)row[1]);
            censusReportDto.setStudyName((String)row[2]);
            censusReportDto.setPiFirstName((String)row[3]);
            censusReportDto.setPiMiddleName((String)row[4]);
            censusReportDto.setPiLastName((String)row[5]);
            censusReportDto.setCatalystId((String)row[6]);
            censusReportDto.setLocalId((String)row[7]);
            censusReportDto.setIrb((String)row[8]);
            censusReportDto.setScheduledStartTime((Date)row[9]);
            censusReportDto.setScheduledEndTime((Date)row[10]);
            censusReportDto.setVisitName((String)row[11]);
            censusReportDto.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[12]));
            censusReportDto.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[13]));
            censusReportDto.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[14]));
            censusReportDto.setMrn(SubjectDataEncryptor.decrypt((String)row[15]));
            censusReportDto.setVisitType((String)row[16]);
            censusReportDto.setIndustryInitiated((Boolean)row[17]);
            censusReportDto.setPsFirstName((String)row[18]);
            censusReportDto.setPsMiddleName((String)row[19]);
            censusReportDto.setPsLastName((String)row[20]);
            censusReportDto.setStudyId((Integer)row[21]);
            censusReportDto.setVisitId((Integer)row[22]);
            censusReportDto.setSublocation((String)row[23]);
            resultList.add(censusReportDto);
        }
        Comparator<CensusReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? CensusComparator : CensusComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setCensusReport(resultList);
        return resultList;
    }

    public List<LevelOfServiceReportDTO> getLevelOfServiceReport(ReportDTO dto) {
        String filterClause;
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = " select st.name, v.name, v.nursing, v.nutrition, v.processing, v.setup, v.visitType.name, bv.checkInDate, ap.name, bv.checkOutDate, bv.checkoutStatusReason from Study st, VisitTemplate v, BookedVisit bv, AppointmentStatus ap  where bv.study = st.id and bv.visitTemplate = v.id and  bv.appointmentStatus = ap.id and bv.appointmentStatus.isCheckedOut = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        Map filterIdsToHqlColumns = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"1", (Object)"v.nursing"), Pair.pair((Object)"2", (Object)"v.nutrition"), Pair.pair((Object)"3", (Object)"v.processing"), Pair.pair((Object)"4", (Object)"v.setup"), Pair.pair((Object)"5", (Object)"v.visitType.name"), Pair.pair((Object)"6", (Object)"ap.name"), Pair.pair((Object)"7", (Object)"bv.checkoutStatusReason.name")});
        boolean filterIdIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        if (filterIdIsPresent && filterIdsToHqlColumns.containsKey(filterid)) {
            String filterColumn = (String)filterIdsToHqlColumns.get(filterid);
            filterClause = " and " + filterColumn + " like '%" + filterString + "%' ";
        } else {
            filterClause = "8".equals(filterid) ? " and st.crcFunded = false " : " ";
        }
        String sortByColumnName = "st.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("st.name", sortStrategy);
        String hql = " select st.name, v.name, v.nursing, v.nutrition, v.processing, v.setup, v.visitType.name, bv.checkInDate, ap.name, bv.checkOutDate, bv.checkoutStatusReason from Study st, VisitTemplate v, BookedVisit bv, AppointmentStatus ap  where bv.study = st.id and bv.visitTemplate = v.id and  bv.appointmentStatus = ap.id and bv.appointmentStatus.isCheckedOut = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + orderByClause;
        Query query = this.newQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            LevelOfServiceReportDTO newObj = new LevelOfServiceReportDTO();
            newObj.setStudyName((String)row[0]);
            newObj.setVisitName((String)row[1]);
            newObj.setNursing((String)row[2]);
            newObj.setNutrition((String)row[3]);
            newObj.setProcessing((String)row[4]);
            newObj.setSetup((String)row[5]);
            newObj.setVisitType((String)row[6]);
            newObj.setCheckInDate((Date)row[7]);
            newObj.setAppointmentStatus((String)row[8]);
            newObj.setCheckOutDate((Date)row[9]);
            if (((String)row[8]).equalsIgnoreCase("Cancellation")) {
                newObj.setCheckOutReason(null);
            } else {
                newObj.setCheckOutReason((AppointmentStatusReason)row[10]);
            }
            resultList.add(newObj);
        }
        Comparator<LevelOfServiceReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? LevelOfServiceComparator : LevelOfServiceComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setLevelOfServiceReport(resultList);
        return resultList;
    }

    public List<StudySubjectVisitReportDTO> getStudySubjectVisitReport(ReportDTO dto) {
        String subjectDOB;
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String subjectLastName = !dto.getSubjectLastName().isEmpty() ? SubjectDataEncryptor.encrypt(dto.getSubjectLastName().toUpperCase()) : dto.getSubjectLastName();
        String subjectMRN = !dto.getSubjectMRN().isEmpty() ? SubjectDataEncryptor.encrypt(dto.getSubjectMRN().toUpperCase()) : dto.getSubjectMRN();
        String filterString = dto.getFilterString();
        String baseHql = " select s.lastName, s.firstName, s.middleName, sm.mrn, st.localId, v.name, ap.name, s.birthdate,  bv.scheduledStartTime, bv.scheduledEndTime from Study st, Subject s, VisitTemplate v, BookedVisit bv, SubjectMrn sm, AppointmentStatus ap  where bv.study = st.id and bv.visitTemplate = v.id and bv.subjectMrn = sm.id and sm.subject = s.id and  bv.appointmentStatus = ap.id and bv.appointmentStatus.isHold = FALSE and s.archivalStatus IS NULL";
        ArrayList filterClauses = Lists.newArrayList();
        if (!subjectLastName.isEmpty()) {
            filterClauses.add(" and s.lastName like '%" + subjectLastName + "%' ");
        }
        if (!subjectMRN.isEmpty()) {
            filterClauses.add(" and sm.mrn like '%" + subjectMRN + "%' ");
        }
        if (!(subjectDOB = dto.getSubjectDOB()).isEmpty()) {
            filterClauses.add(" and s.birthdate = :subjectDate ");
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            filterClauses.add(" and st.localId like '%" + filterString + "%' ");
        } else if (MiscUtil.isNonNullNonEmpty(filterString) && "4".equals(filterid)) {
            filterClauses.add(" and ap.name like '%" + filterString + "%' ");
        } else if ("5".equals(filterid)) {
            filterClauses.add(" and st.crcFunded = false ");
        }
        String sortByColumnName = "s.id";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("s.id", sortStrategy);
        String filterClause = Joiner.on((String)" ").join((Iterable)filterClauses);
        String hql = " select s.lastName, s.firstName, s.middleName, sm.mrn, st.localId, v.name, ap.name, s.birthdate,  bv.scheduledStartTime, bv.scheduledEndTime from Study st, Subject s, VisitTemplate v, BookedVisit bv, SubjectMrn sm, AppointmentStatus ap  where bv.study = st.id and bv.visitTemplate = v.id and bv.subjectMrn = sm.id and sm.subject = s.id and  bv.appointmentStatus = ap.id and bv.appointmentStatus.isHold = FALSE and s.archivalStatus IS NULL" + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setSubjectDateParam(query, subjectDOB);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            String birthDateString;
            StudySubjectVisitReportDTO studySubjectVisitReportDto = new StudySubjectVisitReportDTO();
            studySubjectVisitReportDto.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[0]));
            studySubjectVisitReportDto.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[1]));
            studySubjectVisitReportDto.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[2]));
            studySubjectVisitReportDto.setMrn(SubjectDataEncryptor.decrypt((String)row[3]));
            studySubjectVisitReportDto.setLocalId((String)row[4]);
            studySubjectVisitReportDto.setVisitName((String)row[5]);
            studySubjectVisitReportDto.setAppointmentStatus((String)row[6]);
            if ((Date)row[7] != null) {
                Date subDate = new Date(((Date)row[7]).getTime());
                birthDateString = DateUtility.format(DateUtility.monthDayYear(), subDate);
            } else {
                birthDateString = null;
            }
            studySubjectVisitReportDto.setDob(birthDateString);
            studySubjectVisitReportDto.setScheduledStartTime((Date)row[8]);
            studySubjectVisitReportDto.setScheduledEndTime((Date)row[9]);
            resultList.add(studySubjectVisitReportDto);
        }
        Comparator<StudySubjectVisitReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? StudySubjectVisitComparator : StudySubjectVisitComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setStudySubjectVisitReport(resultList);
        return resultList;
    }

    public List<StudyStatusChangeReportDTO> getStudyStatusChangeReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        if (MiscUtil.isNonNullNonEmpty(filterString) && "PENDING".indexOf(filterString.toUpperCase()) >= 0) {
            filterString = "IRB_PROCESS";
        }
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = " select al.changesDetailRequiredField, al.date, al.affectedStudy, al.performingUser, al.actionPerformed from ActivityLog al where   (al.actionPerformed = 'CREATE STUDY'  or (al.actionPerformed = 'UPDATE STUDY'         and al.changesDetailRequiredField like '%Study Status%')) and (al.date >= :startTime and al.date <= :endTime) ";
        String filterClause = " ";
        boolean filterStringIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        if (filterStringIsPresent && "1".equals(filterid)) {
            filterClause = " and al.affectedStudy.localId like '%" + filterString + "%' ";
        } else if (filterStringIsPresent && "2".equals(filterid)) {
            filterClause = " and al.affectedStudy.investigator.lastName like '%" + filterString + "%' ";
        } else if (filterStringIsPresent && "3".equals(filterid)) {
            filterClause = " and al.affectedStudy.studyStatus.name like '%" + filterString + "%' ";
        } else if ("4".equals(filterid)) {
            filterClause = " and al.affectedStudy.crcFunded = false ";
        }
        String sortByColumnName = "al.affectedStudy.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("al.affectedStudy.name", sortStrategy);
        String hql = " select al.changesDetailRequiredField, al.date, al.affectedStudy, al.performingUser, al.actionPerformed from ActivityLog al where   (al.actionPerformed = 'CREATE STUDY'  or (al.actionPerformed = 'UPDATE STUDY'         and al.changesDetailRequiredField like '%Study Status%')) and (al.date >= :startTime and al.date <= :endTime) " + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            String studyStatus;
            StudyStatusChangeReportDTO newObj = new StudyStatusChangeReportDTO();
            String diffs = (String)row[0];
            Study study = (Study)row[2];
            String action = (String)row[4];
            if (action.equals("CREATE STUDY")) {
                studyStatus = "PENDING";
            } else {
                studyStatus = diffs.replaceAll(".*Study Status:*\\s*", "").replaceAll(",.*", "").replaceAll("IRB_PROCESS", "PENDING");
                if (studyStatus.contains(" to ")) {
                    studyStatus = "From " + studyStatus;
                }
            }
            newObj.setStudyStatus(studyStatus);
            newObj.setDateStatusChange((Date)row[1]);
            newObj.setStudyId(study.getId());
            newObj.setStudyName(study.getName());
            newObj.setLocalId(study.getLocalId());
            if (study.getInvestigator() != null) {
                newObj.setPi(study.getInvestigator().getLastName());
            }
            User user = (User)row[3];
            newObj.setUserFirstName(user.getFirstName());
            newObj.setUserMiddleName(user.getMiddleName());
            newObj.setUserLastName(user.getLastName());
            resultList.add(newObj);
        }
        Comparator<StudyStatusChangeReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? StudyStatusChangeComparator : StudyStatusChangeComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setStudyStatusChangeReport(resultList);
        return resultList;
    }

    public List<SubjectVisitHistoryReportDTO> getSubjectVisitHistoryReport(ReportDTO dto) {
        String subjectDOB;
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String subjectLastName = !dto.getSubjectLastName().isEmpty() ? SubjectDataEncryptor.encrypt(dto.getSubjectLastName().toUpperCase()) : dto.getSubjectLastName();
        String subjectMRN = !dto.getSubjectMRN().isEmpty() ? SubjectDataEncryptor.encrypt(dto.getSubjectMRN().toUpperCase()) : dto.getSubjectMRN();
        String filterString = dto.getFilterString();
        String baseHql = " select s.lastName, s.firstName, s.middleName, sm.mrn, bv  from Subject s, BookedVisit bv, SubjectMrn sm  where bv.subjectMrn = sm.id and sm.subject = s.id  and s.archivalStatus IS NULL ";
        ArrayList filterClauses = Lists.newArrayList();
        if (!subjectLastName.isEmpty()) {
            filterClauses.add(" and s.lastName like '%" + subjectLastName + "%' ");
        }
        if (!subjectMRN.isEmpty()) {
            filterClauses.add(" and sm.mrn like '%" + subjectMRN + "%' ");
        }
        if (!(subjectDOB = dto.getSubjectDOB()).isEmpty()) {
            filterClauses.add(" and s.birthdate = :subjectDate ");
        }
        if (MiscUtil.isNonNullNonEmpty(filterString) && "3".equals(filterid)) {
            filterClauses.add(" and bv.study.localId like '%" + filterString + "%' ");
        } else if ("4".equals(filterid)) {
            filterClauses.add(" and bv.study.crcFunded = false ");
        }
        String filterClause = Joiner.on((String)" ").join((Iterable)filterClauses);
        String sortByColumnName = "s.id";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("s.id", sortStrategy);
        String hql = " select s.lastName, s.firstName, s.middleName, sm.mrn, bv  from Subject s, BookedVisit bv, SubjectMrn sm  where bv.subjectMrn = sm.id and sm.subject = s.id  and s.archivalStatus IS NULL " + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setSubjectDateParam(query, subjectDOB);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            SubjectVisitHistoryReportDTO subjectVisitHistoryReportDto = new SubjectVisitHistoryReportDTO();
            subjectVisitHistoryReportDto.setSubjectLastName(SubjectDataEncryptor.decrypt((String)row[0]));
            subjectVisitHistoryReportDto.setSubjectFirstName(SubjectDataEncryptor.decrypt((String)row[1]));
            subjectVisitHistoryReportDto.setSubjectMiddleName(SubjectDataEncryptor.decrypt((String)row[2]));
            subjectVisitHistoryReportDto.setMrn(SubjectDataEncryptor.decrypt((String)row[3]));
            BookedVisit bookedVisit = (BookedVisit)row[4];
            subjectVisitHistoryReportDto.setLocalId(bookedVisit.getStudy().getLocalId());
            subjectVisitHistoryReportDto.setVisitName(bookedVisit.getName());
            subjectVisitHistoryReportDto.setAppointmentStatus(bookedVisit.getAppointmentStatus().getName());
            subjectVisitHistoryReportDto.setScheduledStartTime(bookedVisit.getScheduledStartTime());
            subjectVisitHistoryReportDto.setScheduledEndTime(bookedVisit.getScheduledEndTime());
            subjectVisitHistoryReportDto.setCancelDate(bookedVisit.getCancelDate());
            subjectVisitHistoryReportDto.setCheckInDate(bookedVisit.getCheckInDate());
            subjectVisitHistoryReportDto.setCheckOutDate(bookedVisit.getCheckOutDate());
            if (bookedVisit.getCancelStatusReason() != null) {
                subjectVisitHistoryReportDto.setCancelStatusReason(bookedVisit.getCancelStatusReason().getName());
            }
            resultList.add(subjectVisitHistoryReportDto);
        }
        Comparator<SubjectVisitHistoryReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? SubjectVisitHistoryComparator : SubjectVisitHistoryComparatorDesc;
        Collections.sort(resultList, ordering);
        dto.setSubjectVisitHistoryReport(resultList);
        return resultList;
    }

    public List<CRCAvailabilityReportDTO> getCRCAvailabilityReport(ReportDTO reportDTO) {
        String sortId = reportDTO.getSortId();
        String hqlForAllVisits = "SELECT b.visitTemplate.id, b.visitTemplate.name, b.study.name, a.actionPerformed FROM BookedVisitActivityLog a, BookedVisit b WHERE a.bookedVisit = b.id  and a.actionPerformed in ('" + BookedVisitActivityLogStatics.OVERBOOKED.getLogString() + "', '" + BookedVisitActivityLogStatics.SCHEDULED.getLogString() + "')  " + "and  ((:startTime between b.scheduledStartTime and b.scheduledEndTime)  " + "or (:endTime between b.scheduledStartTime and b.scheduledEndTime)  " + "or (b.scheduledStartTime >= :startTime and b.scheduledEndTime <= :endTime)) ";
        String sortByColumnName = "b.visitTemplate";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortId).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("b.visitTemplate", sortStrategy);
        hqlForAllVisits = hqlForAllVisits + orderByClause;
        org.hibernate.Session session = this.session();
        Query queryForAllVisits = session.createQuery(hqlForAllVisits);
        ReportDAO.setStartAndEndTimeParameters(reportDTO, queryForAllVisits);
        List resultRowsForAllVisits = queryForAllVisits.list();
        ReportDAO.logHqlQuery(resultRowsForAllVisits, queryForAllVisits);
        ArrayList resultList = Lists.newArrayList();
        class VisitInfo {
            int visitId;
            String visitName;
            String studyName;
            int numScheduled;
            int numOverbooked;

            VisitInfo(int visitId, String visitName, String studyName) {
                this.visitId = visitId;
                this.visitName = visitName;
                this.studyName = studyName;
            }
        }
        ArrayList<VisitInfo> visitInfos = new ArrayList<VisitInfo>();
        HashMap<Integer, VisitInfo> idToVisitInfo = new HashMap<Integer, VisitInfo>();
        for (Object[] resultRow : resultRowsForAllVisits) {
            Integer visitId = (Integer)resultRow[0];
            String visitName = (String)resultRow[1];
            String studyName = (String)resultRow[2];
            String action = (String)resultRow[3];
            VisitInfo visitInfo = (VisitInfo)idToVisitInfo.get(visitId);
            if (visitInfo == null) {
                visitInfo = new VisitInfo(visitId, visitName, studyName);
                idToVisitInfo.put(visitId, visitInfo);
                visitInfos.add(visitInfo);
            }
            if (action.equals(BookedVisitActivityLogStatics.OVERBOOKED.getLogString())) {
                ++visitInfo.numOverbooked;
                continue;
            }
            if (!action.equals(BookedVisitActivityLogStatics.SCHEDULED.getLogString())) continue;
            ++visitInfo.numScheduled;
        }
        for (VisitInfo visitInfo : visitInfos) {
            CRCAvailabilityReportDTO crcAvailabilityReportDto = new CRCAvailabilityReportDTO();
            crcAvailabilityReportDto.setVisitName(visitInfo.visitName);
            crcAvailabilityReportDto.setStudyName(visitInfo.studyName);
            crcAvailabilityReportDto.setOverbook(Integer.toString(visitInfo.numOverbooked));
            crcAvailabilityReportDto.setScheduled(Integer.toString(visitInfo.numScheduled));
            resultList.add(crcAvailabilityReportDto);
        }
        reportDTO.setCrcAvailabilityReport(resultList);
        return resultList;
    }

    public List<WorkloadAndResourceResponseDTO> getResourceLevelOfServiceReport(ReportDTO dto) {
        String sortid = dto.getSortId();
        String filterid = dto.getFilterId();
        String filterString = dto.getFilterString();
        String baseHql = " select v.id as visitId, v.visitType as visitType, v.name as visitName, v.nursing as nursing, v.nutrition as nutrition, v.processing as processing, v.setup as setup, tr.duration as duration,  r.name as resourceName, s.localId as studyName from VisitTemplate v, TemplateResource tr, Resource r, Study s  where v.study = s.id and tr.visitTemplate = v.id and tr.resource = r.id ";
        List<String> filterClauses = this.setFilterClauses(filterid, filterString);
        String filterClause = Joiner.on((String)" ").join(filterClauses);
        String sortByColumnName = "v.name";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("v.name", sortStrategy);
        String hql = " select v.id as visitId, v.visitType as visitType, v.name as visitName, v.nursing as nursing, v.nutrition as nutrition, v.processing as processing, v.setup as setup, tr.duration as duration,  r.name as resourceName, s.localId as studyName from VisitTemplate v, TemplateResource tr, Resource r, Study s  where v.study = s.id and tr.visitTemplate = v.id and tr.resource = r.id " + filterClause + orderByClause;
        Query query = this.session().createQuery(hql).setResultTransformer(Transformers.aliasToBean(WorkloadAndResourceResponseDTO.class));
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        return resultRows;
    }

    private String setOrderByClause(String sortByColumnName, SortStrategy sortStrategy) {
        return sortStrategy.makeHqlOrderBySubClause(sortByColumnName);
    }

    private List<String> setFilterClauses(String filterid, String filterString) {
        boolean filterStringIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        if (filterStringIsPresent && "1".equals(filterid)) {
            return Lists.newArrayList((Object[])new String[]{" and s.localId like '%" + filterString + "%' "});
        }
        if (filterStringIsPresent && "2".equals(filterid)) {
            return Lists.newArrayList((Object[])new String[]{" and v.name like '%" + filterString + "%' "});
        }
        return Lists.newArrayList();
    }

    public List<VisitTemplateReportDTO> getVisitTemplateReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = " select s.localId, v, s.id, s.name, s.studyStatus  from VisitTemplate v, Study s where v.study = s.id";
        List<String> filterClauses = this.setFilterClauses(filterid, filterString);
        String sortByColumnName = "s.localId";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("s.localId", sortStrategy);
        String filterClause = Joiner.on((String)" ").join(filterClauses);
        String hql = " select s.localId, v, s.id, s.name, s.studyStatus  from VisitTemplate v, Study s where v.study = s.id" + filterClause + orderByClause;
        Query query = this.newQuery(hql);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        Function<Object[], VisitTemplateReportDTO> toVisitTemplateReportDTO = row -> {
            VisitTemplateReportDTO newObj = new VisitTemplateReportDTO();
            newObj.setStudyId((String)row[0]);
            VisitTemplate visitTemplate = (VisitTemplate)row[1];
            newObj.setName(visitTemplate.getName());
            newObj.setSublocation(visitTemplate.getSublocation().getName());
            newObj.setVisitType(visitTemplate.getVisitType().getName());
            newObj.setResearchPharmacy(ReportDAO.toBoolean(visitTemplate.getResearchPharmacy()));
            newObj.setInstitutionNonCRC(ReportDAO.toBoolean(visitTemplate.getInstitutionNonCRC()));
            newObj.setNonInstitutionNonCRC(ReportDAO.toBoolean(visitTemplate.getNonInstitutionNonCRC()));
            newObj.setRelativeTime(ReportDAO.toBoolean(visitTemplate.getRelativeTime()));
            newObj.setNursing(visitTemplate.getNursing());
            newObj.setNutrition(visitTemplate.getNutrition());
            newObj.setProcessing(visitTemplate.getProcessing());
            newObj.setSetup(visitTemplate.getSetup());
            newObj.setComment(visitTemplate.getComment());
            newObj.setId((Integer)row[2]);
            newObj.setStudyName((String)row[3]);
            newObj.setStudyStatus(((StudyStatus)row[4]).getName());
            return newObj;
        };
        List resultList = ListUtils.enrich((List)resultRows).map(toVisitTemplateReportDTO).toList();
        dto.setVisitTemplateReport(resultList);
        return resultList;
    }

    private static boolean toBoolean(Boolean b) {
        return b != null ? b : false;
    }

    Optional<NutritionTasksReportDTO> findAndMungeVisit(List<NutritionTasksReportDTO> resultList, Object[] row) {
        return ListUtils.enrich(resultList).find(nutritionTasksReportDto -> {
            String encryptedLastName = (String)row[4];
            String visitName = (String)row[1];
            return nutritionTasksReportDto.getVisitName().equalsIgnoreCase(visitName) && nutritionTasksReportDto.getSubjectLastName().equalsIgnoreCase(SubjectDataEncryptor.decrypt(encryptedLastName));
        });
    }

    private boolean countsAsNo(String s) {
        return "no".equalsIgnoreCase(s) || "n".equalsIgnoreCase(s);
    }

    boolean countsAsYes(String s) {
        return "yes".equalsIgnoreCase(s) || "ye".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s);
    }

    public List<VisitDurationByVisitTypeReportDTO> getVisitDurationByVisitTypeReport(ReportDTO dto) {
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String baseHql = " select st.localId, bv.id, bv.scheduledStartTime, bv.scheduledEndTime, v.visitType.name, v.name, bv.checkInDate, bv.checkOutDate   from Study st, VisitTemplate v, BookedVisit bv  where bv.appointmentStatus.isCheckedOut = TRUE and bv.study = st.id and bv.visitTemplate = v.id and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        HashSet handledFilterIds = Sets.newHashSet((Object[])new String[]{"1", "2"});
        boolean filterIdIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        String filterClause = filterIdIsPresent && handledFilterIds.contains(filterid) ? " and v.visitType.name like '%" + filterString + "%' " : " ";
        String sortByColumnName = "bv.scheduledStartTime";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("bv.scheduledStartTime", sortStrategy);
        String hql = " select st.localId, bv.id, bv.scheduledStartTime, bv.scheduledEndTime, v.visitType.name, v.name, bv.checkInDate, bv.checkOutDate   from Study st, VisitTemplate v, BookedVisit bv  where bv.appointmentStatus.isCheckedOut = TRUE and bv.study = st.id and bv.visitTemplate = v.id and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (Object[] row : resultRows) {
            VisitDurationByVisitTypeReportDTO visitDurationByVisitTypeReportDto = new VisitDurationByVisitTypeReportDTO();
            visitDurationByVisitTypeReportDto.setStudyName((String)row[0]);
            visitDurationByVisitTypeReportDto.setVisitId((Integer)row[1]);
            visitDurationByVisitTypeReportDto.setScheduledStartTime((Date)row[2]);
            visitDurationByVisitTypeReportDto.setScheduledEndTime((Date)row[3]);
            visitDurationByVisitTypeReportDto.setVisitType((String)row[4]);
            visitDurationByVisitTypeReportDto.setVisitName((String)row[5]);
            visitDurationByVisitTypeReportDto.setCheckInTime((Date)row[6]);
            visitDurationByVisitTypeReportDto.setCheckOutTime((Date)row[7]);
            resultList.add(visitDurationByVisitTypeReportDto);
        }
        dto.setVisitDurationByVisitType(resultList);
        return resultList;
    }

    public List<BookedVisitServiceLevelByVisitTypeReportDTO> getBookedVisitServiceLevelByVisitTypeReport(ReportDTO dto) {
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String hql1 = " select vt.visitType, count(vt.nursing), CONCAT('NursingLevel' , vt.nursing)  from VisitTemplate vt, BookedVisit bv  where vt.nursing IS NOT NULL and vt.nursing != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  group by vt.visitType.name, vt.nursing order by vt.visitType.name, vt.nursing";
        String hql2 = " select vt.visitType, count(vt.nutrition), CONCAT('NutritionLevel' , vt.nutrition)  from VisitTemplate vt, BookedVisit bv  where vt.nutrition IS NOT NULL and vt.nutrition != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  group by vt.visitType.name, vt.nutrition order by vt.visitType.name, vt.nutrition";
        String hql3 = " select vt.visitType, count(vt.processing), CONCAT('ProcessingLevel' , vt.processing)  from VisitTemplate vt, BookedVisit bv  where vt.processing IS NOT NULL and vt.processing != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) group by vt.visitType.name, vt.processing order by vt.visitType.name, vt.processing";
        String hql4 = " select vt.visitType, count(vt.setup), CONCAT('SetupLevel' , vt.setup)   from VisitTemplate vt, BookedVisit bv  where vt.setup IS NOT NULL and vt.setup != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) group by vt.visitType.name, vt.setup order by vt.visitType.name, vt.setup";
        Query query1 = this.newQuery(" select vt.visitType, count(vt.nursing), CONCAT('NursingLevel' , vt.nursing)  from VisitTemplate vt, BookedVisit bv  where vt.nursing IS NOT NULL and vt.nursing != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  group by vt.visitType.name, vt.nursing order by vt.visitType.name, vt.nursing");
        ReportDAO.setStartAndEndTimeParameters(dto, query1);
        List list1 = query1.list();
        ReportDAO.logHqlQuery(list1, query1);
        Query query2 = this.newQuery(" select vt.visitType, count(vt.nutrition), CONCAT('NutritionLevel' , vt.nutrition)  from VisitTemplate vt, BookedVisit bv  where vt.nutrition IS NOT NULL and vt.nutrition != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  group by vt.visitType.name, vt.nutrition order by vt.visitType.name, vt.nutrition");
        ReportDAO.setStartAndEndTimeParameters(dto, query2);
        List list2 = query2.list();
        ReportDAO.logHqlQuery(list2, query2);
        Query query3 = this.newQuery(" select vt.visitType, count(vt.processing), CONCAT('ProcessingLevel' , vt.processing)  from VisitTemplate vt, BookedVisit bv  where vt.processing IS NOT NULL and vt.processing != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) group by vt.visitType.name, vt.processing order by vt.visitType.name, vt.processing");
        ReportDAO.setStartAndEndTimeParameters(dto, query3);
        List list3 = query3.list();
        ReportDAO.logHqlQuery(list3, query3);
        Query query4 = this.newQuery(" select vt.visitType, count(vt.setup), CONCAT('SetupLevel' , vt.setup)   from VisitTemplate vt, BookedVisit bv  where vt.setup IS NOT NULL and vt.setup != ''  and bv.visitTemplate = vt.id and bv.appointmentStatus.isServiceable = TRUE and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime) or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) group by vt.visitType.name, vt.setup order by vt.visitType.name, vt.setup");
        ReportDAO.setStartAndEndTimeParameters(dto, query4);
        List list4 = query4.list();
        ReportDAO.logHqlQuery(list4, query4);
        ArrayList allResultRows = Lists.newArrayList();
        allResultRows.addAll(list1);
        allResultRows.addAll(list2);
        allResultRows.addAll(list3);
        allResultRows.addAll(list4);
        BookedVisitServiceLevelByVisitTypeReportDTO mydto = null;
        HashMap levelMap = Maps.newHashMap();
        HashMap visitTypes = Maps.newHashMap();
        for (Object row : allResultRows) {
            VisitType visitType = (VisitType)row[0];
            String visitTypeName = visitType.getName();
            Integer visitTypeId = visitType.getId();
            String count = ((Long)row[1]).toString();
            String level = (String)row[2];
            String[] mylevel = level.split("Level");
            String levelValue = mylevel[1];
            BookedVisitServiceLevelByVisitTypeReportDTO bookedVisitServiceLevelByVisitTypeReportDto = (BookedVisitServiceLevelByVisitTypeReportDTO)levelMap.get(ReportDAO.makeLevelMapKey(visitTypeId, levelValue));
            if (bookedVisitServiceLevelByVisitTypeReportDto == null) {
                mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                mydto.setVisitId(visitTypeId);
                mydto.setVisitType(visitTypeName);
                visitTypes.put(visitTypeId, "Visit" + visitTypeId);
                if ("0".equals(filterid)) {
                    if ("0".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("1".equals(filterid)) {
                    if ("1".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("2".equals(filterid)) {
                    if ("2".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("3".equals(filterid)) {
                    if ("3".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("4".equals(filterid)) {
                    if ("4".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("5".equals(filterid)) {
                    if ("5".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("6".equals(filterid)) {
                    if ("6".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else if ("7".equals(filterid)) {
                    if ("7".equalsIgnoreCase(levelValue)) {
                        levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                    }
                } else {
                    levelMap.put(ReportDAO.makeLevelMapKey(visitTypeId, levelValue), mydto);
                }
            } else {
                mydto = bookedVisitServiceLevelByVisitTypeReportDto;
            }
            if (level.contains("Nursing")) {
                mydto.setNursing(count);
                mydto.setNursinglevel("Level " + levelValue);
                mydto.setSetuplevel("Level " + levelValue);
                mydto.setNutritionlevel("Level " + levelValue);
                mydto.setProcessinglevel("Level " + levelValue);
                continue;
            }
            if (level.contains("Nutrition")) {
                mydto.setNutrition(count);
                mydto.setNutritionlevel("Level " + levelValue);
                mydto.setNursinglevel("Level " + levelValue);
                mydto.setSetuplevel("Level " + levelValue);
                mydto.setProcessinglevel("Level " + levelValue);
                continue;
            }
            if (level.contains("Processing")) {
                mydto.setProcessing(count);
                mydto.setProcessinglevel("Level " + levelValue);
                mydto.setNursinglevel("Level " + levelValue);
                mydto.setSetuplevel("Level " + levelValue);
                mydto.setNutritionlevel("Level " + levelValue);
                continue;
            }
            if (!level.contains("Setup")) continue;
            mydto.setSetup(count);
            mydto.setSetuplevel("Level " + levelValue);
            mydto.setNursinglevel("Level " + levelValue);
            mydto.setNutritionlevel("Level " + levelValue);
            mydto.setProcessinglevel("Level " + levelValue);
        }
        ArrayList visitlists = Lists.newArrayList(visitTypes.values());
        for (String visitString : visitlists) {
            String levels;
            Integer s;
            int in;
            ArrayList lists;
            if ("Visit1".equalsIgnoreCase(visitString)) {
                lists = Lists.newArrayList(levelMap.values());
                List s1 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(1)).toList();
                Collections.sort(s1, BookedVisitLevelServiceComparatorString);
                for (in = 0; in < 8; ++in) {
                    s = in;
                    mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                    if (s1.size() <= 0) continue;
                    mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                    mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitType());
                    mydto.setSetup("");
                    mydto.setNursing("");
                    mydto.setProcessing("");
                    mydto.setNutrition("");
                    mydto.setSetuplevel("Level " + s.toString());
                    mydto.setNursinglevel("Level " + s.toString());
                    mydto.setNutritionlevel("Level " + s.toString());
                    mydto.setProcessinglevel("Level " + s.toString());
                    levels = "Visit1Level" + s;
                    if (levelMap.containsKey(levels)) continue;
                    if ("0".equals(filterid)) {
                        if (s != 0) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("1".equals(filterid)) {
                        if (s != 1) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("2".equals(filterid)) {
                        if (s != 2) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("3".equals(filterid)) {
                        if (s != 3) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("4".equals(filterid)) {
                        if (s != 4) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("5".equals(filterid)) {
                        if (s != 5) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("6".equals(filterid)) {
                        if (s != 6) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("7".equals(filterid)) {
                        if (s != 7) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s1.get(0)).getVisitId() + "Level" + s, mydto);
                }
                Collections.sort(s1, BookedVisitLevelServiceComparatorString);
                continue;
            }
            if ("Visit2".equalsIgnoreCase(visitString)) {
                lists = Lists.newArrayList(levelMap.values());
                List s2 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(2)).toList();
                Collections.sort(s2, BookedVisitLevelServiceComparatorString);
                for (in = 0; in < 8; ++in) {
                    s = in;
                    mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                    if (s2.size() <= 0) continue;
                    mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                    mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitType());
                    mydto.setSetup("");
                    mydto.setNursing("");
                    mydto.setProcessing("");
                    mydto.setNutrition("");
                    mydto.setSetuplevel("Level " + s.toString());
                    mydto.setNursinglevel("Level " + s.toString());
                    mydto.setNutritionlevel("Level " + s.toString());
                    mydto.setProcessinglevel("Level " + s.toString());
                    levels = "Visit2Level" + s;
                    if (levelMap.containsKey(levels)) continue;
                    if ("0".equals(filterid)) {
                        if (s != 0) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("1".equals(filterid)) {
                        if (s != 1) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("2".equals(filterid)) {
                        if (s != 2) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("3".equals(filterid)) {
                        if (s != 3) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("4".equals(filterid)) {
                        if (s != 4) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("5".equals(filterid)) {
                        if (s != 5) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("6".equals(filterid)) {
                        if (s != 6) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("7".equals(filterid)) {
                        if (s != 7) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s2.get(0)).getVisitId() + "Level" + s, mydto);
                }
                Collections.sort(s2, BookedVisitLevelServiceComparatorString);
                continue;
            }
            if ("Visit3".equalsIgnoreCase(visitString)) {
                lists = Lists.newArrayList(levelMap.values());
                List s3 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(3)).toList();
                Collections.sort(s3, BookedVisitLevelServiceComparatorString);
                for (in = 0; in < 8; ++in) {
                    s = in;
                    mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                    if (s3.size() <= 0) continue;
                    mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                    mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitType());
                    mydto.setSetup("");
                    mydto.setNursing("");
                    mydto.setProcessing("");
                    mydto.setNutrition("");
                    mydto.setSetuplevel("Level " + s.toString());
                    mydto.setNursinglevel("Level " + s.toString());
                    mydto.setNutritionlevel("Level " + s.toString());
                    mydto.setProcessinglevel("Level " + s.toString());
                    levels = "Visit3Level" + s;
                    if (levelMap.containsKey(levels)) continue;
                    if ("0".equals(filterid)) {
                        if (s != 0) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("1".equals(filterid)) {
                        if (s != 1) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("2".equals(filterid)) {
                        if (s != 2) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("3".equals(filterid)) {
                        if (s != 3) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("4".equals(filterid)) {
                        if (s != 4) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("5".equals(filterid)) {
                        if (s != 5) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("6".equals(filterid)) {
                        if (s != 6) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("7".equals(filterid)) {
                        if (s != 7) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s3.get(0)).getVisitId() + "Level" + s, mydto);
                }
                Collections.sort(s3, BookedVisitLevelServiceComparatorString);
                continue;
            }
            if ("Visit4".equalsIgnoreCase(visitString)) {
                lists = Lists.newArrayList(levelMap.values());
                List s4 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(4)).toList();
                Collections.sort(s4, BookedVisitLevelServiceComparatorString);
                for (in = 0; in < 8; ++in) {
                    s = in;
                    mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                    if (s4.size() <= 0) continue;
                    mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                    mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitType());
                    mydto.setSetup("");
                    mydto.setNursing("");
                    mydto.setProcessing("");
                    mydto.setNutrition("");
                    mydto.setSetuplevel("Level " + s.toString());
                    mydto.setNursinglevel("Level " + s.toString());
                    mydto.setNutritionlevel("Level " + s.toString());
                    mydto.setProcessinglevel("Level " + s.toString());
                    levels = "Visit4Level" + s;
                    if (levelMap.containsKey(levels)) continue;
                    if ("0".equals(filterid)) {
                        if (s != 0) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("1".equals(filterid)) {
                        if (s != 1) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("2".equals(filterid)) {
                        if (s != 2) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("3".equals(filterid)) {
                        if (s != 3) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("4".equals(filterid)) {
                        if (s != 4) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("5".equals(filterid)) {
                        if (s != 5) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("6".equals(filterid)) {
                        if (s != 6) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("7".equals(filterid)) {
                        if (s != 7) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s4.get(0)).getVisitId() + "Level" + s, mydto);
                }
                Collections.sort(s4, BookedVisitLevelServiceComparatorString);
                continue;
            }
            if ("Visit5".equalsIgnoreCase(visitString)) {
                lists = Lists.newArrayList(levelMap.values());
                List s5 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(5)).toList();
                Collections.sort(s5, BookedVisitLevelServiceComparatorString);
                for (in = 0; in < 8; ++in) {
                    s = in;
                    mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                    if (s5.size() <= 0) continue;
                    mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                    mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitType());
                    mydto.setSetup("");
                    mydto.setNursing("");
                    mydto.setProcessing("");
                    mydto.setNutrition("");
                    mydto.setSetuplevel("Level " + s.toString());
                    mydto.setNursinglevel("Level " + s.toString());
                    mydto.setNutritionlevel("Level " + s.toString());
                    mydto.setProcessinglevel("Level " + s.toString());
                    levels = "Visit5Level" + s;
                    if (levelMap.containsKey(levels)) continue;
                    if ("0".equals(filterid)) {
                        if (s != 0) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("1".equals(filterid)) {
                        if (s != 1) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("2".equals(filterid)) {
                        if (s != 2) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("3".equals(filterid)) {
                        if (s != 3) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("4".equals(filterid)) {
                        if (s != 4) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("5".equals(filterid)) {
                        if (s != 5) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("6".equals(filterid)) {
                        if (s != 6) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    if ("7".equals(filterid)) {
                        if (s != 7) continue;
                        visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                        levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                        continue;
                    }
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s5.get(0)).getVisitId() + "Level" + s, mydto);
                }
                Collections.sort(s5, BookedVisitLevelServiceComparatorString);
                continue;
            }
            if (!"Visit6".equalsIgnoreCase(visitString)) continue;
            lists = Lists.newArrayList(levelMap.values());
            List s6 = ListUtils.enrich((List)lists).filter(ReportDAO.visitTypeIdIs(6)).toList();
            Collections.sort(s6, BookedVisitLevelServiceComparatorString);
            for (in = 0; in < 8; ++in) {
                s = in;
                mydto = new BookedVisitServiceLevelByVisitTypeReportDTO();
                if (s6.size() <= 0) continue;
                mydto.setVisitId(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                mydto.setVisitType(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitType());
                mydto.setSetup("");
                mydto.setNursing("");
                mydto.setProcessing("");
                mydto.setNutrition("");
                mydto.setSetuplevel("Level " + s.toString());
                mydto.setNursinglevel("Level " + s.toString());
                mydto.setNutritionlevel("Level " + s.toString());
                mydto.setProcessinglevel("Level " + s.toString());
                levels = "Visit6Level" + s;
                if (levelMap.containsKey(levels)) continue;
                if ("0".equals(filterid)) {
                    if (s != 0) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("1".equals(filterid)) {
                    if (s != 1) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("2".equals(filterid)) {
                    if (s != 2) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("3".equals(filterid)) {
                    if (s != 3) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("4".equals(filterid)) {
                    if (s != 4) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("5".equals(filterid)) {
                    if (s != 5) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("6".equals(filterid)) {
                    if (s != 6) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                if ("7".equals(filterid)) {
                    if (s != 7) continue;
                    visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                    levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
                    continue;
                }
                visitTypes.put(((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId(), "Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId());
                levelMap.put("Visit" + ((BookedVisitServiceLevelByVisitTypeReportDTO)s6.get(0)).getVisitId() + "Level" + s, mydto);
            }
            Collections.sort(s6, BookedVisitLevelServiceComparatorString);
        }
        ArrayList results = Lists.newArrayList(levelMap.values());
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.DESCENDING);
        Comparator<BookedVisitServiceLevelByVisitTypeReportDTO> ordering = sortStrategy == SortStrategy.ASCENDING ? BookedVisitLevelServiceComparator : BookedVisitLevelServiceComparatorDesc;
        Collections.sort(results, ordering);
        dto.setBookedVisitServiceLevelByTypeReport(results);
        return results;
    }

    public List<AncillaryOnlyByProtocolReportDTO> getAncillaryOnlyByProtocolReport(ReportDTO dto) {
        String investigatorName;
        Study study;
        AncillaryOnlyByProtocolReportDTO ancillaryOnlyByProtocolReportDto;
        String filterString = dto.getFilterString();
        String filterid = dto.getFilterId();
        String sortid = dto.getSortId();
        String hql = null;
        String hql1 = null;
        String hql2 = null;
        String finalhql = " SELECT COUNT(DISTINCT bv.id), s  FROM BookedResource br, BookedVisit bv, Study s  WHERE br.bookedVisit = bv.id and br.resource.name LIKE '%Ancillar%'  and bv.study = s.id and bv.appointmentStatus.isCheckedOut = TRUE and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        String filterClause = MiscUtil.isNonNullNonEmpty(filterString) && "1".equals(filterid) ? " and s.localId like '%" + filterString + "%' " : ("2".equals(filterid) ? " and s.crcFunded = false " : " ");
        String crcCategoryClause = " and s.crcCategory = 'A' ";
        String crcCategoryClause1 = " and s.crcCategory = 'B' ";
        String crcCategoryClause2 = " and s.crcCategory = 'D' ";
        String sortByColumnName = "s.localId";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("s.localId", sortStrategy);
        String groupByClause = " GROUP BY s.id ";
        hql = " SELECT COUNT(DISTINCT bv.id), s  FROM BookedResource br, BookedVisit bv, Study s  WHERE br.bookedVisit = bv.id and br.resource.name LIKE '%Ancillar%'  and bv.study = s.id and bv.appointmentStatus.isCheckedOut = TRUE and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + " and s.crcCategory = 'A' " + " GROUP BY s.id " + orderByClause;
        hql1 = " SELECT COUNT(DISTINCT bv.id), s  FROM BookedResource br, BookedVisit bv, Study s  WHERE br.bookedVisit = bv.id and br.resource.name LIKE '%Ancillar%'  and bv.study = s.id and bv.appointmentStatus.isCheckedOut = TRUE and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + " and s.crcCategory = 'B' " + " GROUP BY s.id " + orderByClause;
        hql2 = " SELECT COUNT(DISTINCT bv.id), s  FROM BookedResource br, BookedVisit bv, Study s  WHERE br.bookedVisit = bv.id and br.resource.name LIKE '%Ancillar%'  and bv.study = s.id and bv.appointmentStatus.isCheckedOut = TRUE and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + filterClause + " and s.crcCategory = 'D' " + " GROUP BY s.id " + orderByClause;
        org.hibernate.Session session = this.session();
        Query query = session.createQuery(hql);
        Query query1 = session.createQuery(hql1);
        Query query2 = session.createQuery(hql2);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        ReportDAO.setStartAndEndTimeParameters(dto, query1);
        ReportDAO.setStartAndEndTimeParameters(dto, query2);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        List resultRows1 = query1.list();
        ReportDAO.logHqlQuery(resultRows1, query1);
        List resultRows2 = query2.list();
        ReportDAO.logHqlQuery(resultRows2, query2);
        ArrayList resultList = Lists.newArrayList();
        int totalA = 0;
        int totalB = 0;
        int totalC = 0;
        for (Object[] row : resultRows) {
            ancillaryOnlyByProtocolReportDto = new AncillaryOnlyByProtocolReportDTO();
            ancillaryOnlyByProtocolReportDto.setCrcA(row[0].toString());
            ancillaryOnlyByProtocolReportDto.setCrcB("0");
            ancillaryOnlyByProtocolReportDto.setCrcC("0");
            ancillaryOnlyByProtocolReportDto.setTotalCRCA(totalA += Integer.parseInt(ancillaryOnlyByProtocolReportDto.getCrcA()));
            ancillaryOnlyByProtocolReportDto.setTotalCRCB(totalB);
            ancillaryOnlyByProtocolReportDto.setTotalCRCC(totalC);
            study = (Study)row[1];
            User investigator = study.getInvestigator();
            String investigatorName2 = this.assembleInvestigatorName(investigator);
            ancillaryOnlyByProtocolReportDto.setStudyId(study.getId());
            ancillaryOnlyByProtocolReportDto.setStudyName(study.getLocalId() + investigatorName2 + " - " + study.getName());
            resultList.add(ancillaryOnlyByProtocolReportDto);
        }
        for (Object[] row : resultRows1) {
            ancillaryOnlyByProtocolReportDto = new AncillaryOnlyByProtocolReportDTO();
            ancillaryOnlyByProtocolReportDto.setCrcA("0");
            ancillaryOnlyByProtocolReportDto.setCrcB(row[0].toString());
            ancillaryOnlyByProtocolReportDto.setCrcC("0");
            ancillaryOnlyByProtocolReportDto.setTotalCRCA(totalA);
            ancillaryOnlyByProtocolReportDto.setTotalCRCB(totalB += Integer.parseInt(ancillaryOnlyByProtocolReportDto.getCrcB()));
            ancillaryOnlyByProtocolReportDto.setTotalCRCC(totalC);
            study = (Study)row[1];
            ancillaryOnlyByProtocolReportDto.setStudyId(study.getId());
            investigatorName = this.assembleInvestigatorName(study.getInvestigator());
            ancillaryOnlyByProtocolReportDto.setStudyName(study.getLocalId() + investigatorName + " - " + study.getName());
            resultList.add(ancillaryOnlyByProtocolReportDto);
        }
        for (Object[] row : resultRows2) {
            ancillaryOnlyByProtocolReportDto = new AncillaryOnlyByProtocolReportDTO();
            ancillaryOnlyByProtocolReportDto.setCrcA("0");
            ancillaryOnlyByProtocolReportDto.setCrcB("0");
            ancillaryOnlyByProtocolReportDto.setCrcC(row[0].toString());
            ancillaryOnlyByProtocolReportDto.setTotalCRCA(totalA);
            ancillaryOnlyByProtocolReportDto.setTotalCRCB(totalB);
            ancillaryOnlyByProtocolReportDto.setTotalCRCC(totalC += Integer.parseInt(ancillaryOnlyByProtocolReportDto.getCrcC()));
            study = (Study)row[1];
            ancillaryOnlyByProtocolReportDto.setStudyId(study.getId());
            investigatorName = this.assembleInvestigatorName(study.getInvestigator());
            ancillaryOnlyByProtocolReportDto.setStudyName(study.getLocalId() + investigatorName + " - " + study.getName());
            resultList.add(ancillaryOnlyByProtocolReportDto);
        }
        dto.setAncillaryOnlyByProtocolReport(resultList);
        return resultList;
    }

    String assembleInvestigatorName(User user) {
        String result = " ";
        if (user != null) {
            result = "(" + user.getFirstName() + " , " + user.getLastName() + ")";
        }
        return result;
    }

    public List<VisitsFlaggedEditReportDTO> getVisitsFlaggedForEditReport(ReportDTO dto) {
        String sortid = dto.getSortId();
        String baseHql = " select bv from BookedVisit bv  where bv.appointmentStatus.isCheckedOut = TRUE and bv.subjectMrn.subject.archivalStatus IS NULL and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        String sortByColumnName = "bv.study";
        SortStrategy sortStrategy = SortStrategy.fromIdString(sortid).orElse(SortStrategy.ASCENDING);
        String orderByClause = this.setOrderByClause("bv.study", sortStrategy);
        String hql = " select bv from BookedVisit bv  where bv.appointmentStatus.isCheckedOut = TRUE and bv.subjectMrn.subject.archivalStatus IS NULL and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime) or  (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))" + orderByClause;
        Query query = this.session().createQuery(hql);
        ReportDAO.setStartAndEndTimeParameters(dto, query);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList resultList = Lists.newArrayList();
        for (BookedVisit bv : resultRows) {
            VisitsFlaggedEditReportDTO visitsFlaggedEditReportDTO = new VisitsFlaggedEditReportDTO();
            visitsFlaggedEditReportDTO.setId(bv.getStudy().getId());
            visitsFlaggedEditReportDTO.setStudyName(bv.getStudy().getName());
            visitsFlaggedEditReportDTO.setLocalId(bv.getStudy().getLocalId());
            if (bv.getStudy().getInvestigator() != null) {
                visitsFlaggedEditReportDTO.setPiName(bv.getStudy().getInvestigator().getFirstName() + " " + bv.getStudy().getInvestigator().getLastName());
            } else {
                visitsFlaggedEditReportDTO.setPiName(null);
            }
            visitsFlaggedEditReportDTO.setVisitName(bv.getVisitTemplate().getName());
            visitsFlaggedEditReportDTO.setVisitType(bv.getVisitTemplate().getVisitType().getName());
            visitsFlaggedEditReportDTO.setCheckInTime(bv.getCheckInDate());
            visitsFlaggedEditReportDTO.setCheckOutTime(bv.getCheckOutDate());
            visitsFlaggedEditReportDTO.setVaryDuration(bv.isVaryDuration());
            visitsFlaggedEditReportDTO.setOmmittedActivities(bv.isOmmittedActivities());
            SubjectMrn subjectMrn = bv.getSubjectMrnDecrypted();
            Subject subject = subjectMrn.getSubject();
            Date subDate = new Date(subject.getBirthdate().getTime());
            String birthDateString = DateUtility.format(DateUtility.monthDayYear(), subDate);
            visitsFlaggedEditReportDTO.setSubjectFirstName(subject.getFirstName());
            visitsFlaggedEditReportDTO.setSubjectMiddleName(subject.getMiddleName());
            visitsFlaggedEditReportDTO.setSubjectLastName(subject.getLastName());
            visitsFlaggedEditReportDTO.setMrn(subjectMrn.getMrn());
            visitsFlaggedEditReportDTO.setBirthdate(birthDateString);
            resultList.add(visitsFlaggedEditReportDTO);
        }
        dto.setVisitsFlaggedResult(resultList);
        return resultList;
    }

    public List<StudyDataReportResponseDTO> getStudyDataReport(Optional<String> nullableLocalId, Optional<String> nullableName, Optional<String> nullableFundingSource, Optional<StudyStatusFilter> nullableStudyStatus, Optional<String> nullableSortDirection) {
        StudyStatusFilter filter;
        String entityFlagName;
        ArrayList<StudyDataReportResponseDTO> studyDataReportResponseDTOs = new ArrayList<StudyDataReportResponseDTO>();
        String hql = "select s, min(bv.scheduledStartTime), max(bv.scheduledStartTime) from BookedVisit bv right outer join bv.study s ";
        HqlClauses.WhereBuilder whereBuilder = HqlClauses.whereBuilder().like(nullableLocalId, "s.localId").like(nullableName, "s.name");
        if (nullableStudyStatus.isPresent() && (entityFlagName = (filter = nullableStudyStatus.get()).getEntityFlagName()) != null) {
            whereBuilder = whereBuilder.isTrue("s.studyStatus." + entityFlagName);
        }
        String filterClause = whereBuilder.build();
        hql = hql + filterClause;
        SortOrderDirectionEnum sortOrderDirectionEnum = SortOrderDirectionEnum.fromDirection(nullableSortDirection).orElse(SortOrderDirectionEnum.ASCENDING);
        String orderByClause = "order by s.localId " + (Object)((Object)sortOrderDirectionEnum) + " ";
        String groupByClause = "group by s.id ";
        hql = hql + "group by s.id ";
        hql = hql + orderByClause;
        hql = hql.replaceAll("\\s+", " ");
        Query query = this.session().createQuery(hql);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        for (Object[] row : resultRows) {
            Study study = (Study)row[0];
            Date firstVisitDate = (Date)row[1];
            Date lastVisitDate = (Date)row[2];
            Set<StudyFundingSource> sfsSet = study.getStudyFundingSources();
            if (nullableFundingSource.isPresent()) {
                Integer fundingSourceId = Integer.valueOf(nullableFundingSource.get());
                Function<StudyFundingSource, Integer> sfsToIdString = sfs -> sfs.getFundingSource().getId();
                ArrayList<StudyFundingSource> sfsList = new ArrayList<StudyFundingSource>(sfsSet);
                List fundingIds = ListUtils.enrich(sfsList).map(sfsToIdString).toList();
                if (!fundingIds.contains(fundingSourceId)) continue;
            }
            study.setFirstVisitDate(firstVisitDate);
            study.setLastScheduledVisitDate(lastVisitDate);
            StudyDataReportResponseDTO studyDataReportResponseDTO = new StudyDataReportResponseDTO(study, sfsSet);
            studyDataReportResponseDTOs.add(studyDataReportResponseDTO);
        }
        return studyDataReportResponseDTOs;
    }

    HqlClauses.WhereBuilder standardTimingClause(String earlyTime, String lateTime) {
        HqlClauses.WhereBuilder timeOrClauses = HqlClauses.whereBuilder().between(":startTime", earlyTime, lateTime).between(":endTime", earlyTime, lateTime).beforeAndAfter(":startTime", earlyTime, ":endTime", lateTime);
        return timeOrClauses;
    }

    public List<CancellationsReportResponseDTO> getCancellationsReport(Optional<String> nullableLocalId, Optional<String> nullableName, Optional<String> nullableType, Optional<String> nullableReason, Optional<String> nullableNoApprove, Optional<String> nullableSortDirection, Date startTime, Date endTime) {
        String hql = "SELECT bv FROM BookedVisit bv ";
        HqlClauses.WhereBuilder timeOrClauses = this.standardTimingClause("bv.scheduledStartTime", "bv.scheduledEndTime");
        String filterClause = HqlClauses.whereBuilder().isTrue("bv.appointmentStatus.isCancelled").or(timeOrClauses).like(nullableLocalId, "bv.study.localId").like(nullableName, "bv.study.investigator.lastName").equalTo(nullableType, "bv.cancelStatus").equalTo(nullableReason, "bv.cancelStatusReason").equalTo(nullableNoApprove, "bv.study.crcFunded").build();
        SortOrderDirectionEnum sortOrderDirectionEnum = SortOrderDirectionEnum.fromDirection(nullableSortDirection).orElse(SortOrderDirectionEnum.ASCENDING);
        String orderByClause = "order by bv.appointmentStatusReason.name " + (Object)((Object)sortOrderDirectionEnum) + ", bv.scheduledStartTime ASC ";
        hql = hql + filterClause;
        hql = hql + orderByClause;
        hql = hql.replaceAll("\\s+", " ");
        Query query = this.session().createQuery(hql);
        query.setParameter("startTime", (Object)startTime);
        query.setParameter("endTime", (Object)endTime);
        List resultRows = query.list();
        ReportDAO.logHqlQuery(resultRows, query);
        ArrayList<CancellationsReportResponseDTO> cancellationsReportResponseDTOs = new ArrayList<CancellationsReportResponseDTO>();
        for (BookedVisit bookedVisit : resultRows) {
            CancellationsReportResponseDTO cancellationsReportResponseDTO = new CancellationsReportResponseDTO(bookedVisit);
            cancellationsReportResponseDTOs.add(cancellationsReportResponseDTO);
        }
        return cancellationsReportResponseDTOs;
    }

    static final Predicate<BookedVisitServiceLevelByVisitTypeReportDTO> visitTypeIdIs(int desiredTypeId) {
        return sa -> sa.getVisitId().equals(desiredTypeId);
    }

    static enum SortOrderDirectionEnum {
        ASCENDING("asc"),
        DESCENDING("desc");

        String direction;

        private SortOrderDirectionEnum(String direction) {
            this.direction = direction;
        }

        public static Optional<SortOrderDirectionEnum> fromDirection(Optional<String> optionalDirection) {
            String direction = optionalDirection.orElse(null);
            return ListUtils.enrich((Object[])SortOrderDirectionEnum.values()).find(v -> v.direction.equals(direction));
        }

        public String toString() {
            return this.direction;
        }
    }
}

