/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.util;

import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogChute
implements LogChute {
    private static final String RUNTIME_LOG_SLF4J_LOGGER = "runtime.log.logsystem.slf4j.logger";
    private Logger logger = null;

    public void init(RuntimeServices rs) throws Exception {
        String name = (String)rs.getProperty(RUNTIME_LOG_SLF4J_LOGGER);
        if (name != null) {
            this.logger = LoggerFactory.getLogger((String)name);
            this.log(0, "SLF4JLogChute using logger '" + this.logger.getName() + '\'');
        } else {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.log(0, "SLF4JLogChute using logger '" + this.logger.getClass() + '\'');
        }
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.info(message);
                break;
            }
            case -1: {
                this.logger.trace(message);
                break;
            }
            case 3: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.logger.warn(message, t);
                break;
            }
            case 1: {
                this.logger.info(message, t);
                break;
            }
            case -1: {
                this.logger.trace(message, t);
                break;
            }
            case 3: {
                this.logger.error(message, t);
                break;
            }
            default: {
                this.logger.debug(message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case -1: {
                return this.logger.isTraceEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return true;
    }
}

