/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MetaKitchenReportDTO
implements CsvAbleDTO {
    private Integer subjectId;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String birthdate;
    private String mrn;
    private String genderName;
    private String localId;
    private String irb;
    private String visitName;
    private String resourceName;
    private String room;
    private Date checkInTime;
    private Date checkOutTime;
    private Date scheduledStartTime;
    private Date scheduledEndTime;

    public Integer getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public void setGenderName(String genderName) {
        this.genderName = genderName;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    @Override
    public String toCsvHeaders() {
        return "Meal Start Date/Time,Resource Name,Room,Visit Start Date/Time,Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList, String name) {
        if (name.equals("meta_kitchen_flat")) {
            return this.toCsvRowsFlat(dtoList);
        }
        if (name.equals("meta_kitchen_by_time")) {
            return this.toCsvRowsByTime(dtoList);
        }
        return this.toCsvRows(dtoList);
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousSubjectId = -1;
        for (Object object : dtoList) {
            MetaKitchenReportDTO d = (MetaKitchenReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            if (MiscUtil.isNullOrEmpty(d.resourceName)) continue;
            int currentSubjectId = d.subjectId;
            if (currentSubjectId != previousSubjectId) {
                result.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)) + ",,,,MRN," + MiscUtil.q(d.mrn) + "\n");
                result.add(",,,,Local ID," + MiscUtil.q(d.localId) + "\n");
                result.add(",,,,DOB," + MiscUtil.q(d.birthdate) + "\n");
                result.add(this.toCsvHeaders() + "\n");
            }
            previousSubjectId = currentSubjectId;
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(d.room));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime) + " - " + MiscUtil.showDateTime(d.checkOutTime)));
            String row = Joiner.on((String)",").join((Iterable)columns);
            result.add(" \n" + row + "\n");
        }
        return result;
    }

    List<String> toCsvRowsFlat(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        String flatHeader = "Subject Name,Meal Start Date/Time,Local ID,Resource Name,MRN,DOB,Room,Visit Start Date/Time,Comment";
        result.add(flatHeader + "\n");
        for (Object object : dtoList) {
            MetaKitchenReportDTO d = (MetaKitchenReportDTO)object;
            if (MiscUtil.isNullOrEmpty(d.resourceName)) continue;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.room));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime) + " - " + MiscUtil.showDateTime(d.checkOutTime)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }

    List<String> toCsvRowsByTime(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        String header = "Meal Start Date/Time,Subject,Local ID,Resource Name,MRN,DOB,Room,Visit Start/End Time,Comment";
        result.add(header + "\n");
        for (Object object : dtoList) {
            MetaKitchenReportDTO d = (MetaKitchenReportDTO)object;
            if (MiscUtil.isNullOrEmpty(d.resourceName)) continue;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.room));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime) + " - " + MiscUtil.showDateTime(d.checkOutTime)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

