/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VisitsFlaggedEditReportDTO
extends BooleanResultDTO
implements CsvAbleDTO {
    private int id;
    private String visitType;
    private String piName;
    private String visitName;
    private String localId;
    private String studyName;
    private Date checkInTime;
    private Date checkOutTime;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String birthdate;
    private boolean varyDuration;
    private boolean ommittedActivities;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public String getPiName() {
        return this.piName;
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public boolean isVaryDuration() {
        return this.varyDuration;
    }

    public void setVaryDuration(boolean varyDuration) {
        this.varyDuration = varyDuration;
    }

    public boolean isOmmittedActivities() {
        return this.ommittedActivities;
    }

    public void setOmmittedActivities(boolean ommittedActivities) {
        this.ommittedActivities = ommittedActivities;
    }

    @Override
    public String toCsvHeaders() {
        return "Study Name,Local ID,PI Name,Subject Name,DOB,MRN,Visit Name, Visit Type, Check In, Check Out, Resource Duration Variation?,Activity Variation?";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousStudyId = -1;
        boolean firstHeader = true;
        for (Object object : dtoList) {
            VisitsFlaggedEditReportDTO d = (VisitsFlaggedEditReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentStudyId = d.id;
            if (currentStudyId != previousStudyId) {
                if (!firstHeader) {
                    result.add(" \n");
                }
                result.add(this.toCsvHeaders() + "\n");
                firstHeader = false;
            }
            previousStudyId = currentStudyId;
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.piName));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.showDateTime(d.checkInTime));
            columns.add(MiscUtil.showDateTime(d.checkOutTime));
            columns.add(MiscUtil.yesNoValue(d.varyDuration));
            columns.add(MiscUtil.yesNoValue(d.ommittedActivities));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

