/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class OverbookedResourcesResponse {
    private int id;
    private int totalCount;
    private String localId;
    private Date visitStartTime;
    private Date visitEndTime;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String conflictedTime;
    private String subjectName;
    private String resourceName;
    private String visitName;
    private static Map<String, Comparator<OverbookedResourcesResponse>> comparatorMap = Maps.newHashMap();

    public OverbookedResourcesResponse(BookedResource bookedResource, int totalCount) {
        this.id = bookedResource.getId();
        this.totalCount = totalCount;
        this.localId = bookedResource.getBookedVisit().getStudy().getLocalId();
        this.visitStartTime = bookedResource.getBookedVisit().getScheduledStartTime();
        this.visitEndTime = bookedResource.getBookedVisit().getScheduledEndTime();
        this.scheduledStartTime = bookedResource.getScheduledStartTime();
        this.scheduledEndTime = bookedResource.getScheduledEndTime();
        this.conflictedTime = bookedResource.getConflictedTime();
        SubjectMrn subjectMrn = bookedResource.getBookedVisit().getSubjectMrnDecrypted();
        this.subjectName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getFirstName() + " " + subjectMrn.getSubject().getLastName();
        this.resourceName = bookedResource.getResource().getName();
        this.visitName = bookedResource.getBookedVisit().getVisitTemplate().getName();
    }

    public String getLocalId() {
        return this.localId;
    }

    public Date getVisitStartTime() {
        return this.visitStartTime;
    }

    public Date getVisitEndTime() {
        return this.visitEndTime;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public String getConflictedTime() {
        return this.conflictedTime;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public static Comparator<OverbookedResourcesResponse> getComparator(String sortOn, String sortBy) {
        Comparator<OverbookedResourcesResponse> comparator = comparatorMap.get(sortOn);
        if (sortBy != null && sortBy.equalsIgnoreCase("desc")) {
            comparator = MiscUtil.invert(comparator);
        }
        return comparator;
    }

    static {
        comparatorMap.put("resourceName", MiscUtil.compareVia(OverbookedResourcesResponse::getResourceName));
        comparatorMap.put("visitName", MiscUtil.compareVia(OverbookedResourcesResponse::getVisitName));
        comparatorMap.put("subjectName", MiscUtil.compareVia(OverbookedResourcesResponse::getSubjectName));
        comparatorMap.put("conflictedTime", MiscUtil.compareVia(OverbookedResourcesResponse::getConflictedTime));
        comparatorMap.put("scheduledEndTime", MiscUtil.compareVia(OverbookedResourcesResponse::getScheduledEndTime));
        comparatorMap.put("scheduledStartTime", MiscUtil.compareVia(OverbookedResourcesResponse::getScheduledStartTime));
        comparatorMap.put("visitEndTime", MiscUtil.compareVia(OverbookedResourcesResponse::getVisitEndTime));
        comparatorMap.put("visitStartTime", MiscUtil.compareVia(OverbookedResourcesResponse::getVisitStartTime));
        comparatorMap.put("localId", MiscUtil.compareVia(OverbookedResourcesResponse::getLocalId));
    }
}

