/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.HasName;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;

@Entity
@Table(name="institution_role")
public class InstitutionRole
extends BaseEntity
implements Serializable,
HasName {
    private static final long serialVersionUID = -6519424469305426378L;
    private InstitutionRoleType type;
    private String description;
    private String name;

    public InstitutionRole() {
        super(null);
    }

    public static boolean isStudyStaff(InstitutionRole role) {
        return role.type == InstitutionRoleType.ROLE_STUDY_STAFF;
    }

    public InstitutionRole(Integer id, InstitutionRoleType type, String description, String name) {
        super(id);
        this.type = type;
        this.description = description;
        this.name = name;
    }

    @Column(name="type")
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    public InstitutionRoleType getType() {
        return this.type;
    }

    public void setType(InstitutionRoleType type) {
        this.type = type;
    }

    @Override
    @Column(name="name")
    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="description")
    @Basic(optional=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "InstitutionRole [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

