/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.AuthorizedDTO;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VisitTemplateReportDTO
extends AuthorizedDTO
implements CsvAbleDTO {
    private Integer id;
    private String studyId;
    private String name;
    private String shortName;
    private Boolean approved;
    private Boolean relativeTime;
    private Integer duration;
    private String nursing;
    private String nutrition;
    private String processing;
    private String setup;
    private String sublocation;
    private String comment;
    private Date createdDate;
    private String visitType;
    private Boolean institutionNonCRC;
    private Boolean nonInstitutionNonCRC;
    private Boolean researchPharmacy;
    private Integer visitToDeactivateId;
    private Integer visitToActivateId;
    private Integer deleteSelectedVisitId;
    private Boolean active;
    private String studyName;
    private String studyStatus;
    private Boolean billable;
    private int user;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getStudyId() {
        return this.studyId;
    }

    public void setStudyId(String studyId) {
        this.studyId = studyId;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public boolean isRelativeTime() {
        return this.relativeTime;
    }

    public void setRelativeTime(boolean relativeTime) {
        this.relativeTime = relativeTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getNursing() {
        return this.nursing;
    }

    public void setNursing(String nursing) {
        this.nursing = nursing;
    }

    public String getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(String nutrition) {
        this.nutrition = nutrition;
    }

    public String getProcessing() {
        return this.processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }

    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = setup;
    }

    public String getSublocation() {
        return this.sublocation;
    }

    public void setSublocation(String sublocation) {
        this.sublocation = sublocation;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public boolean isInstitutionNonCRC() {
        return this.institutionNonCRC;
    }

    public void setInstitutionNonCRC(boolean institutionNonCRC) {
        this.institutionNonCRC = institutionNonCRC;
    }

    public boolean isNonInstitutionNonCRC() {
        return this.nonInstitutionNonCRC;
    }

    public void setNonInstitutionNonCRC(boolean nonInstitutionNonCRC) {
        this.nonInstitutionNonCRC = nonInstitutionNonCRC;
    }

    public boolean isResearchPharmacy() {
        return this.researchPharmacy;
    }

    public void setResearchPharmacy(boolean researchPharmacy) {
        this.researchPharmacy = researchPharmacy;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getUser() {
        return this.user;
    }

    public void setUser(int user) {
        this.user = user;
    }

    public int getVisitToDeactivateId() {
        return this.visitToDeactivateId;
    }

    public void setVisitToDeactivateId(int visitToDeactivateId) {
        this.visitToDeactivateId = visitToDeactivateId;
    }

    public int getVisitToActivateId() {
        return this.visitToActivateId;
    }

    public void setVisitToActivateId(int visitToActivateId) {
        this.visitToActivateId = visitToActivateId;
    }

    public int getDeleteSelectedVisitId() {
        return this.deleteSelectedVisitId;
    }

    public void setDeleteSelectedVisitId(int deleteSelectedVisitId) {
        this.deleteSelectedVisitId = deleteSelectedVisitId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getStudyStatus() {
        return this.studyStatus;
    }

    public void setStudyStatus(String studyStatus) {
        this.studyStatus = studyStatus;
    }

    @Override
    public String toCsvHeaders() {
        return "Study Id,Study Name,Study Status,Visit Name,Visit Type,Sublocation,Billable Template?,Research Pharmacy?,Institution: Non CRC,Non Institution: Non CRC,Relative Time?,Nursing,Nutrition,Processing,Setup,Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            VisitTemplateReportDTO d = (VisitTemplateReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyId));
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.studyStatus));
            columns.add(MiscUtil.q(d.name));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(d.sublocation));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.billable)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.researchPharmacy)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.institutionNonCRC)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.nonInstitutionNonCRC)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.relativeTime)));
            columns.add(MiscUtil.q(d.nursing));
            columns.add(MiscUtil.q(d.nutrition));
            columns.add(MiscUtil.q(d.processing));
            columns.add(MiscUtil.q(d.setup));
            columns.add(MiscUtil.q(d.comment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }

    public Boolean getBillable() {
        return this.billable;
    }

    public void setBillable(Boolean billable) {
        this.billable = billable;
    }
}

