/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DailyOverviewReportDTO
implements CsvAbleDTO {
    protected Date scheduledStartTime;
    protected Date scheduledEndTime;
    protected Date resourceStartTime;
    protected Date resourceEndTime;
    protected String sublocationName;
    protected String localId;
    protected String irb;
    protected String visitName;
    protected String visitStatus;
    protected String visitType;
    protected String firstName;
    protected String middleName;
    protected String lastName;
    protected String mrn;
    protected String offInstitution;
    protected String genderName;
    protected String birthdate;
    protected String resourceName;
    protected Integer bookedVisitId;
    protected String comment;

    public String getOffInstitution() {
        return this.offInstitution;
    }

    public void setOffInstitution(String offInstitution) {
        this.offInstitution = offInstitution;
    }

    public Integer getBookedVisitId() {
        return this.bookedVisitId;
    }

    public void setBookedVisitId(Integer bookedVisitId) {
        this.bookedVisitId = bookedVisitId;
    }

    public Date getResourceStartTime() {
        return this.resourceStartTime;
    }

    public void setResourceStartTime(Date resourceStartTime) {
        this.resourceStartTime = resourceStartTime;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public Date getResourceEndTime() {
        return this.resourceEndTime;
    }

    public void setResourceEndTime(Date resourceEndTime) {
        this.resourceEndTime = resourceEndTime;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public void setGenderName(String genderName) {
        this.genderName = genderName;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSublocationName() {
        return this.sublocationName;
    }

    public void setSublocationName(String sublocationName) {
        this.sublocationName = sublocationName;
    }

    public String getVisitStatus() {
        return this.visitStatus;
    }

    public void setVisitStatus(String visitStatus) {
        this.visitStatus = visitStatus;
    }

    @Override
    public String toCsvHeaders() {
        return "Visit Length,Subject,MRN,Gender,Birth Date,Local ID,IRB #,Visit Name,Visit Type,Sublocation,Is part of the Visit Off Unit?,Resource Name,Start Time,End Time,Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            DailyOverviewReportDTO d = (DailyOverviewReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime) + " - " + MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.firstName, d.middleName, d.lastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.genderName));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(d.sublocationName));
            columns.add(MiscUtil.q(d.offInstitution));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.resourceStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.resourceEndTime)));
            columns.add(MiscUtil.q(d.comment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

