/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.batchSubjects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.scheduler.batchSubjects.BatchSubjects;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.dto.ExternalSubjectQueryBuilder;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.EpicSubjectDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.EpicSubjectService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.FactoryMockKey;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.AssertionErrors;

@RunWith(value=MockitoJUnitRunner.class)
public class EpicBatchTest {
    static final int NUM_SUBJECTS = 1;
    static final String site = "MGH";
    List<SubjectMrn> subjectMrnList;
    EpicSubjectDAO epicSubjectDAO = (EpicSubjectDAO)Mockito.mock(EpicSubjectDAO.class);
    EpicSubjectService epicSubjectService;
    EmpiSubjectDto empiSubjectDto;
    Key key;
    SubjectMrn subjectMrn0;
    Subject subject0;
    EmpiSubjectDto.Patient patient0;
    BatchSubjects batchSubjects;
    Subject staleSubject;
    private int UNKNOWN_OR_NOT_REPORTED_ETHNICITY = 3;

    @Test
    public void testNoChanges() throws Exception {
        this.batchSubjects.run();
        this.myVerifyNoChanges();
    }

    @Test
    public void testNullEthnicity1() throws Exception {
        Ethnicity ethnicity = new Ethnicity();
        ethnicity.setName("Unknown");
        ethnicity.setId(Integer.valueOf(3));
        this.patient0.setEthnicity(null);
        Mockito.when((Object)this.epicSubjectDAO.lookupEmpiEthnicityString(null)).thenReturn((Object)ethnicity);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("ethnicity:'CHINESE'--->'Unknown'");
    }

    @Test
    public void testNullEthnicity2() throws Exception {
        this.patient0.getEthnicity().setEthnic1(null);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("ethnicity:'CHINESE'--->'null'");
    }

    @Test
    public void testNullCountry() throws Exception {
        this.patient0.getAddress().setCountry(null);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("country:'Country0'--->'null'");
    }

    @Test
    public void testNullState() throws Exception {
        this.patient0.getAddress().setState(null);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("state:'State0'--->'null'");
    }

    @Test
    public void testNullRace1() throws Exception {
        this.patient0.setOtherPid(null);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("race:'R0'--->'null'");
    }

    @Test
    public void testNullRace2() throws Exception {
        this.patient0.getOtherPid().setRace(null);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("race:'R0'--->'null'");
    }

    @Test
    public void testPuidChanges() throws Exception {
        this.subject0.setPuid(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("puid:'Foo'--->'0'");
    }

    @Test
    public void testFirstNameChanges() throws Exception {
        this.subject0.setFirstName(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("firstName:'Foo'--->'First0'");
    }

    @Test
    public void testMiddleNameChanges() throws Exception {
        this.subject0.setMiddleName(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("middleName:'Foo'--->'MI0'");
    }

    @Test
    public void testLastNameChanges() throws Exception {
        this.subject0.setLastName(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("lastName:'Foo'--->'Last0'");
    }

    @Test
    public void testDobChanges() throws Exception {
        Date bogus = DateUtility.parse((DateFormat)DateUtility.monthDayYear(), (String)"02/1/1948");
        this.subject0.setBirthdate(bogus);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("birthdate:'1948-02-01'--->'1928-01-10'");
    }

    @Test
    public void testAddress1Changes() throws Exception {
        this.subject0.setStreetAddress1(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("streetAddress1:'Foo'--->'Address10'");
    }

    @Test
    public void testAddress2Changes() throws Exception {
        this.subject0.setStreetAddress2(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("streetAddress2:'Foo'--->'Address20'");
    }

    @Test
    public void testCityChanges() throws Exception {
        this.subject0.setCity(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("city:'Foo'--->'City0'");
    }

    @Test
    public void testZipChanges() throws Exception {
        this.subject0.setZip(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("zip:'Foo'--->'00000'");
    }

    @Test
    public void testPrimaryChanges() throws Exception {
        this.subject0.setPrimaryContactNumber(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("primaryContactNumber:'Foo'--->'(123) 456-7890'");
    }

    @Test
    public void testSecondaryChanges() throws Exception {
        this.subject0.setSecondaryContactNumber(SubjectDataEncryptor.encrypt((String)"Foo"));
        this.batchSubjects.run();
        this.myVerifyWithChangesText("secondaryContactNumber:'Foo'--->'(123) 456-7890'");
    }

    @Test
    public void testGenderChanges() throws Exception {
        this.patient0.setGender("Foo");
        this.batchSubjects.run();
        this.myVerifyWithChangesText("genderEmpi:'M'--->'Foo'");
    }

    @Test
    public void testRaceChanges() throws Exception {
        Race race2 = new Race();
        race2.setName("Foo");
        race2.setId(Integer.valueOf(2));
        this.subject0.setRace(race2);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("Race", "name", "Foo")).thenReturn((Object)race2);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("race:'Foo'--->'R0'");
    }

    @Test
    public void testEthnicityChanges() throws Exception {
        Ethnicity ethnicity2 = new Ethnicity();
        ethnicity2.setName("Foo");
        ethnicity2.setId(Integer.valueOf(2));
        Ethnicity ethnicityChinese = new Ethnicity();
        ethnicityChinese.setName("CHINESE");
        ethnicityChinese.setId(Integer.valueOf(3));
        this.subject0.setEthnicity(ethnicity2);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("Ethnicity", "name", "Foo")).thenReturn((Object)ethnicity2);
        Mockito.when((Object)this.epicSubjectDAO.lookupEmpiEthnicityString("CHINESE")).thenReturn((Object)ethnicityChinese);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("ethnicity:'Foo'--->'CHINESE'");
    }

    @Test
    public void testCountryChanges() throws Exception {
        Country country2 = new Country();
        country2.setName("Foo");
        country2.setId(Integer.valueOf(2));
        this.subject0.setCountry(country2);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("Country", "name", "Foo")).thenReturn((Object)country2);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("country:'Foo'--->'Country0'");
    }

    @Test
    public void testStateChanges() throws Exception {
        State state2 = new State();
        state2.setName("Foo");
        state2.setId(Integer.valueOf(2));
        this.subject0.setState(state2);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("State", "name", "Foo")).thenReturn((Object)state2);
        this.batchSubjects.run();
        this.myVerifyWithChangesText("state:'Foo'--->'State0'");
    }

    @Test
    public void testMrnStatusChanges() throws Exception {
        SubjectMrn subjectMrn = (SubjectMrn)this.subject0.getFirstSubjectMrn(site).get();
        subjectMrn.setStatus("S2");
        this.batchSubjects.run();
        this.myVerifyWithChangesText("mrn status:'S2'--->'S0'");
    }

    @Test
    public void testCoupleOfChanges() throws Exception {
        this.subject0.setSecondaryContactNumber(SubjectDataEncryptor.encrypt((String)"Foo"));
        SubjectMrn subjectMrn = (SubjectMrn)this.subject0.getFirstSubjectMrn(site).get();
        subjectMrn.setStatus("S2");
        this.batchSubjects.run();
        this.myVerifyWithChangesText("secondaryContactNumber:'Foo'--->'(123) 456-7890'\nmrn status:'S2'--->'S0'");
    }

    @Before
    public void setup() {
        EmpiSubjectDto.Patient patient;
        FactoryMockKey keyFactory = new FactoryMockKey();
        this.key = keyFactory.createKey();
        SubjectDataEncryptor.setEncryptionKey((Key)this.key);
        SubjectDAO subjectDAO = (SubjectDAO)Mockito.mock(SubjectDAO.class);
        this.epicSubjectDAO = (EpicSubjectDAO)Mockito.mock(EpicSubjectDAO.class);
        this.epicSubjectService = new EpicSubjectService(this.epicSubjectDAO, null);
        this.batchSubjects = (BatchSubjects)Mockito.spy((Object)new BatchSubjects(subjectDAO, this.key, this.epicSubjectService, this.epicSubjectDAO));
        this.subjectMrnList = new ArrayList<SubjectMrn>();
        SubjectMrn subjectMrn = this.setupSubject(0);
        this.subjectMrnList.add(subjectMrn);
        this.patient0 = patient = this.setupPatient(0);
        this.empiSubjectDto = (EmpiSubjectDto)Mockito.mock(EmpiSubjectDto.class);
        ArrayList patientList = Lists.newArrayList((Object[])new EmpiSubjectDto.Patient[]{patient});
        EmpiSubjectDto.Patients patients = new EmpiSubjectDto.Patients((List)patientList);
        Mockito.when((Object)this.empiSubjectDto.getPatients()).thenReturn((Object)patients);
        Mockito.when((Object)this.epicSubjectDAO.getSearchedSubjectsAsEmpiSubjectDto((ExternalSubjectQueryBuilder)Mockito.any(ExternalSubjectQueryBuilder.class), Mockito.eq((boolean)true))).thenReturn((Object)this.empiSubjectDto);
        this.subjectMrn0 = this.subjectMrnList.get(0);
        Mockito.when((Object)subjectDAO.findNumberOfSubjectMrns()).thenReturn((Object)1);
        Mockito.when((Object)subjectDAO.findAllSubjectMrns()).thenReturn(this.subjectMrnList);
        this.staleSubject = new Subject();
        this.staleSubject.setId(Integer.valueOf(2));
        State oldState = new State();
        oldState.setName("oldState");
        this.staleSubject.setState(oldState);
        Country oldCountry = new Country();
        oldCountry.setName("oldCountry");
        this.staleSubject.setCountry(oldCountry);
        Ethnicity oldEthnicity = new Ethnicity();
        oldEthnicity.setName("oldEthnicity");
        this.staleSubject.setEthnicity(oldEthnicity);
        Race race = new Race();
        race.setName("oldRace");
        this.staleSubject.setRace(race);
    }

    SubjectMrn setupSubject(int i) {
        Subject subject = new Subject();
        subject.setId(Integer.valueOf(1));
        String schedulerMrn = SubjectDataEncryptor.encrypt((String)("000" + i));
        HashSet<SubjectMrn> subjectMrnSet = new HashSet<SubjectMrn>();
        SubjectMrn subjectMrn = new SubjectMrn(subject, schedulerMrn, site, "S" + i, null);
        subjectMrnSet.add(subjectMrn);
        subject.setSubjectMrnSet(subjectMrnSet);
        subject.setFirstName("First" + i);
        subject.setLastName("Last" + i);
        subject.setMiddleName("MI" + i);
        subject.setPuid(String.valueOf(i));
        Date dobDate = DateUtility.parse((DateFormat)DateUtility.monthDayYear(), (String)("01/1" + i + "/1928"));
        subject.setBirthdate(dobDate);
        subject.setStreetAddress1("Address1" + i);
        subject.setStreetAddress2("Address2" + i);
        subject.setCity("City" + i);
        State state = new State();
        state.setName("State" + i);
        state.setId(Integer.valueOf(1));
        subject.setState(state);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("State", "name", "State" + i)).thenReturn((Object)state);
        subject.setZip("0000" + i);
        Country country = new Country();
        country.setName("Country" + i);
        country.setId(Integer.valueOf(1));
        subject.setCountry(country);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("Country", "name", "Country" + i)).thenReturn((Object)country);
        subject.setPrimaryContactNumber("(123) 456-789" + i);
        subject.setSecondaryContactNumber("(123) 456-789" + i);
        subject.setGenderEmpi("M");
        Race race = new Race();
        race.setName("R" + i);
        race.setId(Integer.valueOf(1));
        subject.setRace(race);
        Mockito.when((Object)this.batchSubjects.findEntityByFieldString("Race", "name", "R" + i)).thenReturn((Object)race);
        Ethnicity ethnicity = new Ethnicity();
        ethnicity.setName("CHINESE");
        ethnicity.setId(Integer.valueOf(1));
        subject.setEthnicity(ethnicity);
        HashMap map = Maps.newHashMap();
        map.put("CHINESE", ethnicity);
        Mockito.when((Object)this.epicSubjectDAO.loadEmpiToSchedulerEthnicityMap()).thenReturn((Object)map);
        SubjectDataEncryptor.encryptSubjectInPlace((Subject)subject);
        this.subject0 = subject;
        return subjectMrn;
    }

    EmpiSubjectDto.Patient setupPatient(int i) {
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        EmpiSubjectDto.Mrn patientMrn = new EmpiSubjectDto.Mrn(site, "000" + i, "S" + i);
        EmpiSubjectDto.Mrns mrns = new EmpiSubjectDto.Mrns();
        mrns.setMrnList((List)Lists.newArrayList((Object[])new EmpiSubjectDto.Mrn[]{patientMrn}));
        patient.setMrns(mrns);
        EmpiSubjectDto.Name name = new EmpiSubjectDto.Name("Last" + i, "First" + i, "MI" + i);
        name.setSuffix("Suffix" + i);
        patient.setName(name);
        patient.setUid(i);
        patient.setDobString("01/1" + i + "/1928");
        patient.setGender("M");
        EmpiSubjectDto.Address address = new EmpiSubjectDto.Address("Address1" + i, "Address2" + i, "City" + i, "State" + i, "0000" + i, "Country" + i);
        patient.setAddress(address);
        EmpiSubjectDto.Phone home = new EmpiSubjectDto.Phone("Home", "(123) 456-789" + i);
        EmpiSubjectDto.Phone work = new EmpiSubjectDto.Phone("Work", "(123) 456-789" + i);
        EmpiSubjectDto.Phones phones = new EmpiSubjectDto.Phones((List)Lists.newArrayList((Object[])new EmpiSubjectDto.Phone[]{home, work}));
        patient.setPhones(phones);
        EmpiSubjectDto.OtherPid otherPid = new EmpiSubjectDto.OtherPid();
        otherPid.setRace("R" + i);
        patient.setOtherPid(otherPid);
        EmpiSubjectDto.Ethnicity ethnicity = new EmpiSubjectDto.Ethnicity();
        ethnicity.setEthnic1("CHINESE");
        patient.setEthnicity(ethnicity);
        return patient;
    }

    void myVerifyNoChanges() {
    }

    void myVerifyWithChangesText(String changesText) {
        String expectedChanges = "Subject 1. Mrn 0000-MGH-S0: " + changesText + "\n";
        String encryptedChanges = SubjectDataEncryptor.encrypt((String)expectedChanges);
        ((EpicSubjectDAO)Mockito.verify((Object)this.epicSubjectDAO, (VerificationMode)Mockito.times((int)1))).logNightlyBatchDeltas(encryptedChanges);
    }

    @Test
    public void testRefreshExternalSubjectForBatchUpdate() {
        Integer id = 1;
        String site = site;
        String mrn = SubjectDataEncryptor.encrypt((String)"0000");
        Subject subject = new Subject();
        subject.setId(id);
        SubjectMrn subjectMrn = new SubjectMrn();
        subjectMrn.setSubject(subject);
        subjectMrn.setId(id);
        subjectMrn.setStatus("A");
        subjectMrn.setMrn(mrn);
        subjectMrn.setSite(site);
        subject.setSubjectMrnSet((Set)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn}));
        Mockito.when((Object)((SubjectMrn)this.epicSubjectDAO.findById(SubjectMrn.class, id))).thenReturn((Object)subjectMrn);
        ((BatchSubjects)Mockito.doReturn((Object)true).when((Object)this.batchSubjects)).sanityCheckEmpiMatchCount((EmpiSubjectDto)Mockito.refEq((Object)this.empiSubjectDto, (String[])new String[0]), (String)Mockito.eq((Object)site), (Integer)Mockito.eq((Object)id));
        ((BatchSubjects)Mockito.doReturn((Object)"something changed").when((Object)this.batchSubjects)).imposeUpon((Subject)Mockito.any(Subject.class), (EmpiSubjectDto)Mockito.any(EmpiSubjectDto.class), (String)Mockito.eq((Object)site), (SubjectMrn)Mockito.any(SubjectMrn.class));
        ((BatchSubjects)Mockito.doReturn((Object)mrn).when((Object)this.batchSubjects)).decryptMrn(mrn);
        ((EpicSubjectDAO)Mockito.doNothing().when((Object)this.epicSubjectDAO)).encryptAndSave((Subject)Mockito.refEq((Object)subject, (String[])new String[0]));
        Assert.assertTrue((boolean)this.batchSubjects.refreshExternalSubject(subjectMrn, true));
        ((BatchSubjects)Mockito.verify((Object)this.batchSubjects, (VerificationMode)Mockito.times((int)1))).sanityCheckEmpiMatchCount(this.empiSubjectDto, site, id);
        ((BatchSubjects)Mockito.verify((Object)this.batchSubjects, (VerificationMode)Mockito.times((int)1))).imposeUpon((Subject)Mockito.any(Subject.class), (EmpiSubjectDto)Mockito.any(EmpiSubjectDto.class), (String)Mockito.eq((Object)site), (SubjectMrn)Mockito.any(SubjectMrn.class));
        ((EpicSubjectDAO)Mockito.verify((Object)this.epicSubjectDAO, (VerificationMode)Mockito.times((int)1))).encryptAndSave(subject);
    }

    @Test
    public void testImposeUpon() {
        Subject subject = new Subject();
        subject.setPuid("0");
        subject.setLastName("");
        subject.setFirstName("");
        subject.setMiddleName("");
        subject.setStreetAddress1("");
        subject.setStreetAddress2("");
        subject.setCity("");
        subject.setZip("");
        subject.setPrimaryContactNumber(null);
        subject.setSecondaryContactNumber(null);
        subject.setSubjectMrnSet((Set)Sets.newHashSet());
        subject.setGenderEmpi("");
        HashSet subjectMrnSet = Sets.newHashSet();
        SubjectMrn subjectMrn = new SubjectMrn(subject, this.subjectMrn0.getMrn(), this.subjectMrn0.getSite(), this.subjectMrn0.getStatus());
        subjectMrnSet.add(subjectMrn);
        subject.setSubjectMrnSet((Set)subjectMrnSet);
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        patient.setGender("");
        patient.setName(new EmpiSubjectDto.Name("", "", ""));
        patient.setAddress(new EmpiSubjectDto.Address("", "", "", "", "", ""));
        EmpiSubjectDto empiSubjectDto = new EmpiSubjectDto((List)Lists.newArrayList((Object[])new EmpiSubjectDto.Patient[]{patient}));
        String changes = this.batchSubjects.imposeUpon(subject, empiSubjectDto, "mgh", subjectMrn);
        Assert.assertTrue((boolean)changes.isEmpty());
        EmpiSubjectDto.Name name = new EmpiSubjectDto.Name("last", "first", "mi");
        patient.setName(name);
        patient.setGender("Male");
        changes = this.batchSubjects.imposeUpon(subject, empiSubjectDto, "mgh", subjectMrn);
        AssertionErrors.assertEquals((String)"Last name not persisted", (Object)subject.getLastName(), (Object)"last");
        AssertionErrors.assertEquals((String)"First name not persisted", (Object)subject.getFirstName(), (Object)"first");
        AssertionErrors.assertEquals((String)"Middle name not persisted", (Object)subject.getMiddleName(), (Object)"mi");
        AssertionErrors.assertEquals((String)"name change", (Object)"lastName:''--->'last'\nfirstName:''--->'first'\nmiddleName:''--->'mi'\ngenderEmpi:''--->'Male'\n", (Object)changes);
        subject.setLastName("oldLast");
        subject.setFirstName("oldFirst");
        subject.setMiddleName("oldMiddle");
        patient.setGender("Female");
        changes = this.batchSubjects.imposeUpon(subject, empiSubjectDto, "mgh", subjectMrn);
        AssertionErrors.assertEquals((String)"old name change", (Object)"lastName:'oldLast'--->'last'\nfirstName:'oldFirst'--->'first'\nmiddleName:'oldMiddle'--->'mi'\ngenderEmpi:'Male'--->'Female'\n", (Object)changes);
    }

    @Test
    public void testSanityCheckEmpiMatchCount() {
        EmpiSubjectDto empiSubjectDTO = null;
        String institution = null;
        Integer id = null;
        boolean result = this.batchSubjects.sanityCheckEmpiMatchCount(empiSubjectDTO, institution, id);
        Assert.assertFalse((String)"Null empiSubjectDTO", (boolean)result);
        ArrayList<EmpiSubjectDto.Patient> patientList = new ArrayList<EmpiSubjectDto.Patient>();
        EmpiSubjectDto.Patient patient1 = new EmpiSubjectDto.Patient();
        patient1.setName(new EmpiSubjectDto.Name("Last1", "First1", "Middle1"));
        patientList.add(patient1);
        empiSubjectDTO = new EmpiSubjectDto(patientList);
        institution = "inst";
        id = 1000;
        result = this.batchSubjects.sanityCheckEmpiMatchCount(empiSubjectDTO, institution, id);
        Assert.assertTrue((String)"One patient in empiSubjectDTO", (boolean)result);
        EmpiSubjectDto.Patient patient2 = new EmpiSubjectDto.Patient();
        patient1.setName(new EmpiSubjectDto.Name("Last2", "First2", "Middle2"));
        patientList.add(patient2);
        patientList.add(patient2);
        result = this.batchSubjects.sanityCheckEmpiMatchCount(empiSubjectDTO, institution, id);
        Assert.assertFalse((String)"One patient in empiSubjectDTO", (boolean)result);
    }

    @Test
    public void testRelevantMrn() {
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        EmpiSubjectDto.Mrns mrns = new EmpiSubjectDto.Mrns();
        ArrayList<EmpiSubjectDto.Mrn> mrnList = new ArrayList<EmpiSubjectDto.Mrn>();
        String institution1 = "inst1";
        String institution2 = "inst2";
        String status = "A";
        String mrnValue = "mrn";
        EmpiSubjectDto.Mrn mrn1 = new EmpiSubjectDto.Mrn(institution1, mrnValue, status);
        EmpiSubjectDto.Mrn mrn2 = new EmpiSubjectDto.Mrn(institution2, mrnValue, status);
        mrnList.add(mrn1);
        mrnList.add(mrn2);
        mrns.setMrnList(mrnList);
        patient.setMrns(mrns);
        EmpiSubjectDto.Mrn resultMrn = this.batchSubjects.relevantMrn(patient, institution2, mrnValue);
        AssertionErrors.assertEquals((String)"mrn with matching institution", (Object)resultMrn.getSite(), (Object)institution2);
        resultMrn = this.batchSubjects.relevantMrn(patient, "myinst", mrnValue);
        Assert.assertNull((String)"no mrn with matching institution:", (Object)resultMrn);
    }

    @Test
    public void testDecryptMrn() {
        String mrn = "1000";
        String encryptedMrn = SubjectDataEncryptor.encrypt((String)mrn);
        String expectedResult = SubjectDataEncryptor.decrypt((String)encryptedMrn);
        String actualResult = this.batchSubjects.decryptMrn(encryptedMrn);
        Assert.assertEquals((String)"mrn decrypted", (Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testFindEntityByFieldString() {
        String table = "tableName";
        String column = "columnName";
        String columnValue = "columnValue";
        this.batchSubjects.findEntityByFieldString(table, column, columnValue);
        ((EpicSubjectDAO)Mockito.verify((Object)this.epicSubjectDAO, (VerificationMode)Mockito.times((int)1))).findEntityByFieldString(table, column, columnValue);
    }

    @Test
    public void testImposeCountry() {
        Country countryEntity = new Country();
        String countryString = "incomingCountry";
        countryEntity.setName(countryString);
        EmpiSubjectDto.Address address = new EmpiSubjectDto.Address(null, null, null, null, null, countryEntity.getName());
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        patient.setAddress(address);
        Country mappedCountry = new Country();
        mappedCountry.setName("mappedCountry");
        mappedCountry.setId(Integer.valueOf(2));
        StringBuilder changes = new StringBuilder();
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("Country", "name", countryString)).thenReturn(null);
        this.batchSubjects.imposeCountry(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose country - mapping failed", (Object)"oldCountry", (Object)this.staleSubject.getCountry().getName());
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("Country", "name", countryString)).thenReturn((Object)mappedCountry);
        this.batchSubjects.imposeCountry(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose country", (Object)mappedCountry.getName(), (Object)this.staleSubject.getCountry().getName());
    }

    @Test
    public void testImposeState() {
        State stateEntity = new State();
        String stateString = "incomingState";
        stateEntity.setName(stateString);
        EmpiSubjectDto.Address address = new EmpiSubjectDto.Address(null, null, null, stateEntity.getName(), null, null);
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        patient.setAddress(address);
        State mappedState = new State();
        mappedState.setName("mappedState");
        mappedState.setId(Integer.valueOf(2));
        StringBuilder changes = new StringBuilder();
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("State", "name", stateString)).thenReturn(null);
        this.batchSubjects.imposeState(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose state - mapping failed", (Object)"oldState", (Object)this.staleSubject.getState().getName());
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("State", "name", stateString)).thenReturn((Object)mappedState);
        this.batchSubjects.imposeState(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose state", (Object)mappedState.getName(), (Object)this.staleSubject.getState().getName());
    }

    @Test
    public void testImposeEthnicity() {
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        EmpiSubjectDto.Ethnicity patientEthnicity = new EmpiSubjectDto.Ethnicity();
        String newEthnicityName = "new";
        patientEthnicity.setEthnic1(newEthnicityName);
        patient.setEthnicity(patientEthnicity);
        StringBuilder changes = new StringBuilder();
        Mockito.when((Object)this.epicSubjectDAO.lookupEmpiEthnicityString(newEthnicityName)).thenReturn(null);
        this.batchSubjects.imposeEthnicity(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose ethnicity - mapping failed", (Object)"oldEthnicity", (Object)this.staleSubject.getEthnicity().getName());
        Ethnicity mappedEthnicity = new Ethnicity();
        mappedEthnicity.setName("mappedEthnicity");
        mappedEthnicity.setId(Integer.valueOf(2));
        Mockito.when((Object)this.epicSubjectDAO.lookupEmpiEthnicityString(newEthnicityName)).thenReturn((Object)mappedEthnicity);
        this.batchSubjects.imposeEthnicity(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose ethnicity", (Object)mappedEthnicity.getName(), (Object)this.staleSubject.getEthnicity().getName());
    }

    @Test
    public void testImposeRace() {
        EmpiSubjectDto.OtherPid patientOtherPid = new EmpiSubjectDto.OtherPid();
        String newRaceName = "newRace";
        patientOtherPid.setRace(newRaceName);
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        patient.setOtherPid(patientOtherPid);
        StringBuilder changes = new StringBuilder();
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("Race", "name", newRaceName)).thenReturn(null);
        this.batchSubjects.imposeRace(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose race - mapping failed", (Object)"oldRace", (Object)this.staleSubject.getRace().getName());
        Race mappedRace = new Race();
        mappedRace.setName("mappedRace");
        mappedRace.setId(Integer.valueOf(2));
        Mockito.when((Object)this.epicSubjectDAO.findEntityByFieldString("Race", "name", newRaceName)).thenReturn((Object)mappedRace);
        this.batchSubjects.imposeRace(this.staleSubject, patient, changes);
        Assert.assertEquals((String)"impose race", (Object)mappedRace.getName(), (Object)this.staleSubject.getRace().getName());
    }

    @Test
    public void testPhone() {
        String correct = "(111) 111-1111";
        AssertionErrors.assertEquals((String)"", (Object)correct, (Object)this.batchSubjects.canonicalPhoneNumber("1111111111"));
        AssertionErrors.assertEquals((String)"", (Object)correct, (Object)this.batchSubjects.canonicalPhoneNumber("111-111-1111"));
        AssertionErrors.assertEquals((String)"", (Object)correct, (Object)this.batchSubjects.canonicalPhoneNumber("11---1111-1111"));
        AssertionErrors.assertEquals((String)"", (Object)correct, (Object)correct);
    }

    public void testRelevantMrn2() {
        EmpiSubjectDto.Patient patient = new EmpiSubjectDto.Patient();
        EmpiSubjectDto.Mrns mrns = new EmpiSubjectDto.Mrns();
        ArrayList<EmpiSubjectDto.Mrn> mrnList = new ArrayList<EmpiSubjectDto.Mrn>();
        String institution = "S0";
        String status = "A";
        String status2 = "M";
        String mrnValue = "1000";
        String mrnValue1 = "1001";
        EmpiSubjectDto.Mrn mrn1 = new EmpiSubjectDto.Mrn(institution, mrnValue, status);
        EmpiSubjectDto.Mrn mrn2 = new EmpiSubjectDto.Mrn(institution, mrnValue1, status2);
        mrnList.add(mrn1);
        mrnList.add(mrn2);
        mrns.setMrnList(mrnList);
        patient.setMrns(mrns);
        SubjectMrn subjectMrn = this.setupSubject(0);
        subjectMrn.setMrn("1001");
        subjectMrn.setStatus("M");
        subjectMrn.setSite(institution);
        EmpiSubjectDto.Mrn resultMrn = this.batchSubjects.relevantMrn(patient, institution, subjectMrn.getMrn());
        AssertionErrors.assertEquals((String)"", (Object)resultMrn.getStatus(), (Object)"M");
    }
}

