/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class AncillaryOnlyByProtocolReportDTO
implements CsvAbleDTO {
    private Integer studyId;
    private String studyName;
    private String crcA;
    private String crcB;
    private String crcC;
    private int totalCRCA;
    private int totalCRCB;
    private int totalCRCC;

    public Integer getStudyId() {
        return this.studyId;
    }

    public void setStudyId(Integer studyId) {
        this.studyId = studyId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getCrcA() {
        return this.crcA;
    }

    public void setCrcA(String crcA) {
        this.crcA = crcA;
    }

    public String getCrcB() {
        return this.crcB;
    }

    public void setCrcB(String crcB) {
        this.crcB = crcB;
    }

    public String getCrcC() {
        return this.crcC;
    }

    public void setCrcC(String crcC) {
        this.crcC = crcC;
    }

    public int getTotalCRCA() {
        return this.totalCRCA;
    }

    public void setTotalCRCA(int totalCRCA) {
        this.totalCRCA = totalCRCA;
    }

    public int getTotalCRCB() {
        return this.totalCRCB;
    }

    public void setTotalCRCB(int totalCRCB) {
        this.totalCRCB = totalCRCB;
    }

    public int getTotalCRCC() {
        return this.totalCRCC;
    }

    public void setTotalCRCC(int totalCRCC) {
        this.totalCRCC = totalCRCC;
    }

    @Override
    public String toCsvHeaders() {
        return "Protocol,,Ancillary Only Visits\n,A, B, D";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        int listSize = dtoList.size();
        for (int i = 0; i < listSize; ++i) {
            Object object = dtoList.get(i);
            AncillaryOnlyByProtocolReportDTO d = (AncillaryOnlyByProtocolReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.crcA));
            columns.add(MiscUtil.q(d.crcB));
            columns.add(MiscUtil.q(d.crcC));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
            if (i != listSize - 1) continue;
            columns = Lists.newArrayList();
            columns.add(MiscUtil.q("Total"));
            columns.add(MiscUtil.q(d.totalCRCA));
            columns.add(MiscUtil.q(d.totalCRCB));
            columns.add(MiscUtil.q(d.totalCRCC));
            rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

