/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DailyAdmReportDTO
implements CsvAbleDTO {
    private Integer subjectId;
    private Integer visitTempId;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String birthdate;
    private String mrn;
    private String genderName;
    private String localId;
    private String irb;
    private String visitName;
    private String visitStatus;
    private String resourceName;
    private Date checkInTime;
    private Date checkOutTime;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String comment;

    public Integer getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public void setGenderName(String genderName) {
        this.genderName = genderName;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public Integer getVisitTempId() {
        return this.visitTempId;
    }

    public void setVisitTempId(Integer visitTempId) {
        this.visitTempId = visitTempId;
    }

    public String getVisitStatus() {
        return this.visitStatus;
    }

    public void setVisitStatus(String visitStatus) {
        this.visitStatus = visitStatus;
    }

    @Override
    public String toCsvHeaders() {
        return "Subject Name,DOB,MRN,Gender,Local ID,IRB #,Visit Name,Visit Status, Check In Time,Resource Name,Resource Start Time,Resource End Time,Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            DailyAdmReportDTO d = (DailyAdmReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.genderName));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitStatus));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime)));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.comment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

