/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.DailyResourceReportDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class NutritionDailyResourceReportDTO
extends DailyResourceReportDTO {
    public NutritionDailyResourceReportDTO(DailyResourceReportDTO uncle) {
        this.resourceTypeId = uncle.resourceTypeId;
        this.resourceTypeName = uncle.resourceTypeName;
        this.resourceName = uncle.resourceName;
        this.scheduledStartTime = uncle.scheduledStartTime;
        this.scheduledEndTime = uncle.scheduledEndTime;
        this.localId = uncle.localId;
        this.irb = uncle.irb;
        this.visitName = uncle.visitName;
        this.visitTypeName = uncle.visitTypeName;
        this.subjectFirstName = uncle.subjectFirstName;
        this.subjectMiddleName = uncle.subjectMiddleName;
        this.subjectLastName = uncle.subjectLastName;
        this.mrn = uncle.mrn;
        this.comment = uncle.comment;
        this.visitId = uncle.visitId;
    }

    @Override
    public String toCsvHeaders() {
        return "Resource Name,Subject Name,MRN,Visit ID,Visit Name,Resource Start Time,Resource End Time,Resource Usage Duration,Comment 1, Comment 2, Comment 3, Comment 4";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            NutritionDailyResourceReportDTO d = (NutritionDailyResourceReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.visitId));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.comment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

